/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.device.api;

import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.device.api.DeviceAuthService;
import org.wso2.carbon.identity.oauth2.device.dao.DeviceFlowPersistenceFactory;

public class DeviceAuthServiceImpl
implements DeviceAuthService {
    @Override
    public void generateDeviceResponse(String deviceCode, String userCode, String clientId, String scopes) throws IdentityOAuth2Exception {
        DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().insertDeviceFlowParameters(deviceCode, userCode, clientId, 600000L, 5000, scopes);
    }

    @Override
    public void setAuthenticationStatus(String userCode) throws IdentityOAuth2Exception {
        DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().setAuthenticationStatus(userCode, "USED");
    }

    @Override
    public void setCallbackUri(String clientId, String redirectURI) throws IdentityOAuth2Exception {
        DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().setCallbackURI(clientId, redirectURI);
    }

    @Override
    public String getClientId(String userCode) throws IdentityOAuth2Exception {
        return DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().getClientIdByUserCode(userCode);
    }

    @Override
    public String[] getScope(String userCode) throws IdentityOAuth2Exception {
        return DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().getScopesForUserCode(userCode);
    }

    @Override
    public String getStatus(String userCode) throws IdentityOAuth2Exception {
        return DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().getStatusForUserCode(userCode);
    }

    @Override
    public boolean validateClientInfo(String clientId) throws IdentityOAuth2Exception {
        return DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().checkClientIdExist(clientId);
    }
}

