/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

import java.util.concurrent.BlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.oauth2.dao.AccessContextTokenDO;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;

public class TokenPersistenceTask
implements Runnable {
    private static final Log log = LogFactory.getLog(TokenPersistenceTask.class);
    private BlockingDeque<AccessContextTokenDO> accessContextTokenQueue;

    public TokenPersistenceTask(BlockingDeque<AccessContextTokenDO> accessContextTokenQueue) {
        this.accessContextTokenQueue = accessContextTokenQueue;
    }

    @Override
    public void run() {
        log.debug((Object)"Access Token context persist consumer is started");
        while (true) {
            AccessContextTokenDO accessContextTokenDO = null;
            String accessToken = null;
            try {
                accessContextTokenDO = this.accessContextTokenQueue.take();
                if (accessContextTokenDO == null) continue;
                accessToken = accessContextTokenDO.getAccessToken();
                log.debug((Object)"Access Token Data persisting Task is started to run");
                OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().insertAccessToken(accessToken, accessContextTokenDO.getConsumerKey(), accessContextTokenDO.getNewAccessTokenDO(), accessContextTokenDO.getExistingAccessTokenDO(), accessContextTokenDO.getUserStoreDomain());
                continue;
            }
            catch (InterruptedException e) {
                log.error((Object)"Error occurred while getting AccessContextTokenDO instance from accessContextTokenQueue", (Throwable)e);
                continue;
            }
            catch (IdentityException e) {
                log.error((Object)("Error occurred while persisting access token :" + accessToken), (Throwable)e);
                continue;
            }
            break;
        }
    }
}

