/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.tokenprocessor.HashingPersistenceProcessor;
import org.wso2.carbon.identity.oauth.tokenprocessor.PlainTextPersistenceProcessor;
import org.wso2.carbon.identity.oauth.tokenprocessor.TokenPersistenceProcessor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.AccessContextTokenDO;
import org.wso2.carbon.identity.oauth2.dao.AuthContextTokenDO;
import org.wso2.carbon.identity.oauth2.dao.AuthPersistenceTask;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dao.TokenPersistenceTask;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.model.TokenIssuerDO;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuer;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.user.core.util.UserCoreUtil;

@Deprecated
public class TokenMgtDAO {
    private static final Log log = LogFactory.getLog(TokenMgtDAO.class);
    public static final String AUTHZ_USER = "AUTHZ_USER";
    public static final String LOWER_AUTHZ_USER = "LOWER(AUTHZ_USER)";
    private static final String UTC = "UTC";
    private static TokenPersistenceProcessor persistenceProcessor;
    private static TokenPersistenceProcessor hashingPersistenceProcessor;
    private boolean isHashDisabled = OAuth2Util.isHashDisabled();
    private static final int DEFAULT_POOL_SIZE = 0;
    private static final int DEFAULT_TOKEN_PERSIST_RETRY_COUNT = 5;
    private static final boolean DEFAULT_PERSIST_ENABLED = true;
    private static int maxPoolSize;
    private static int tokenPersistRetryCount;
    private boolean enablePersist;
    private static BlockingDeque<AccessContextTokenDO> accessContextTokenQueue;
    private static BlockingDeque<AuthContextTokenDO> authContextTokenQueue;
    private static final String IDN_OAUTH2_ACCESS_TOKEN = "IDN_OAUTH2_ACCESS_TOKEN";
    private static final String IDN_OAUTH2_AUTHORIZATION_CODE = "IDN_OAUTH2_AUTHORIZATION_CODE";
    private static final String OAUTH_TOKEN_PERSISTENCE_ENABLE = "OAuth.TokenPersistence.Enable";
    private static final String OAUTH_TOKEN_PERSISTENCE_POOLSIZE = "OAuth.TokenPersistence.PoolSize";
    private static final String OAUTH_TOKEN_PERSISTENCE_RETRY_COUNT = "OAuth.TokenPersistence.RetryCount";
    private static final String FRAMEWORK_PERSISTENCE_ENABLE = "JDBCPersistenceManager.SessionDataPersist.Enable";
    private static final String FRAMEWORK_PERSISTENCE_POOLSIZE = "JDBCPersistenceManager.SessionDataPersist.PoolSize";

    public TokenMgtDAO() {
        try {
            persistenceProcessor = OAuthServerConfiguration.getInstance().getPersistenceProcessor();
            hashingPersistenceProcessor = new HashingPersistenceProcessor();
            if (log.isDebugEnabled()) {
                log.debug((Object)("TokenPersistenceProcessor set for: " + persistenceProcessor.getClass()));
            }
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)"Error retrieving TokenPersistenceProcessor. Defaulting to PlainTextProcessor", (Throwable)((Object)e));
            persistenceProcessor = new PlainTextPersistenceProcessor();
        }
        this.enablePersist = this.isPersistenceEnabled();
        tokenPersistRetryCount = IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_RETRY_COUNT) != null ? Integer.parseInt(IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_RETRY_COUNT)) : 5;
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth Token Persistence Enabled: " + this.enablePersist));
            log.debug((Object)("OAuth Token Persistence PoolSize: " + maxPoolSize));
            log.debug((Object)("OAuth Token Persistence Retry count set to " + tokenPersistRetryCount));
        }
    }

    public void storeAuthorizationCode(String authzCode, String consumerKey, String callbackUrl, AuthzCodeDO authzCodeDO) throws IdentityOAuth2Exception {
        if (!this.enablePersist) {
            return;
        }
        if (maxPoolSize > 0) {
            authContextTokenQueue.push(new AuthContextTokenDO(authzCode, consumerKey, callbackUrl, authzCodeDO));
        } else {
            this.persistAuthorizationCode(authzCode, consumerKey, callbackUrl, authzCodeDO);
        }
    }

    public void persistAuthorizationCode(String authzCode, String consumerKey, String callbackUrl, AuthzCodeDO authzCodeDO) throws IdentityOAuth2Exception {
        if (!this.enablePersist) {
            return;
        }
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
                log.debug((Object)("Persisting authorization code (hashed): " + DigestUtils.sha256Hex((String)authzCode) + " for client: " + consumerKey + " user: " + authzCodeDO.getAuthorizedUser().toString()));
            } else {
                log.debug((Object)("Persisting authorization code for client: " + consumerKey + " user: " + authzCodeDO.getAuthorizedUser().toString()));
            }
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        String userDomain = authzCodeDO.getAuthorizedUser().getUserStoreDomain();
        String authenticatedIDP = authzCodeDO.getAuthorizedUser().getFederatedIdPName();
        if (!OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal() && authzCodeDO.getAuthorizedUser().isFederatedUser()) {
            userDomain = OAuth2Util.getFederatedUserDomain(authenticatedIDP);
        }
        try {
            prepStmt = connection.prepareStatement("INSERT INTO  IDN_OAUTH2_AUTHORIZATION_CODE (CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY_ID, CALLBACK_URL, SCOPE, AUTHZ_USER, USER_DOMAIN, TENANT_ID, TIME_CREATED, VALIDITY_PERIOD, SUBJECT_IDENTIFIER, PKCE_CODE_CHALLENGE, PKCE_CODE_CHALLENGE_METHOD, AUTHORIZATION_CODE_HASH) SELECT ?,?,ID,?,?,?,?,?,?,?,?,?,?,? FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?");
            prepStmt.setString(1, authzCodeDO.getAuthzCodeId());
            prepStmt.setString(2, persistenceProcessor.getProcessedAuthzCode(authzCode));
            prepStmt.setString(3, callbackUrl);
            prepStmt.setString(4, OAuth2Util.buildScopeString(authzCodeDO.getScope()));
            prepStmt.setString(5, authzCodeDO.getAuthorizedUser().getUserName());
            prepStmt.setString(6, OAuth2Util.getSanitizedUserStoreDomain(userDomain));
            int tenantId = OAuth2Util.getTenantId(authzCodeDO.getAuthorizedUser().getTenantDomain());
            prepStmt.setInt(7, tenantId);
            prepStmt.setTimestamp(8, authzCodeDO.getIssuedTime(), Calendar.getInstance(TimeZone.getTimeZone(UTC)));
            prepStmt.setLong(9, authzCodeDO.getValidityPeriod());
            prepStmt.setString(10, authzCodeDO.getAuthorizedUser().getAuthenticatedSubjectIdentifier());
            prepStmt.setString(11, authzCodeDO.getPkceCodeChallenge());
            prepStmt.setString(12, authzCodeDO.getPkceCodeChallengeMethod());
            prepStmt.setString(13, hashingPersistenceProcessor.getProcessedAuthzCode(authzCode));
            prepStmt.setString(14, persistenceProcessor.getProcessedClientId(consumerKey));
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error when storing the authorization code for consumer key : " + consumerKey, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
    }

    public void deactivateAuthorizationCode(String authzCode, String tokenId) throws IdentityOAuth2Exception {
        if (!this.enablePersist) {
            return;
        }
        if (maxPoolSize > 0) {
            authContextTokenQueue.push(new AuthContextTokenDO(authzCode, tokenId));
        } else {
            AuthzCodeDO authzCodeDO = new AuthzCodeDO();
            authzCodeDO.setAuthorizationCode(authzCode);
            authzCodeDO.setOauthTokenId(tokenId);
            this.deactivateAuthorizationCode(authzCodeDO);
        }
    }

    public void storeAccessToken(String accessToken, String consumerKey, AccessTokenDO accessTokenDO, Connection connection, String userStoreDomain) throws IdentityOAuth2Exception, SQLException {
        if (!this.enablePersist) {
            return;
        }
        if (accessTokenDO == null) {
            throw new IdentityOAuth2Exception("Access token data object should be available for further execution.");
        }
        if (accessTokenDO.getAuthzUser() == null) {
            throw new IdentityOAuth2Exception("Authorized user should be available for further execution.");
        }
        this.storeAccessToken(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeAccessToken(String accessToken, String consumerKey, AccessTokenDO accessTokenDO, Connection connection, String userStoreDomain, int retryAttempt) throws IdentityOAuth2Exception, SQLException {
        try {
            OAuthAppDO oAuthAppDO = OAuth2Util.getAppInformationByClientId(consumerKey);
            boolean persistAccessTokenAlias = false;
            TokenIssuerDO tokenIssuerDO = OAuthServerConfiguration.getInstance().getSupportedTokenIssuers().get(oAuthAppDO.getTokenType());
            if (tokenIssuerDO != null) {
                persistAccessTokenAlias = tokenIssuerDO.isPersistAccessTokenAlias();
            }
            if (persistAccessTokenAlias) {
                OauthTokenIssuer oauthIssuerImpl = OAuth2Util.getOAuthTokenIssuerForOAuthApp(oAuthAppDO);
                accessToken = oauthIssuerImpl.getAccessTokenHash(accessToken);
            }
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving app information for clientId: " + consumerKey, e);
        }
        catch (OAuthSystemException e) {
            if (!log.isDebugEnabled()) throw new IdentityOAuth2Exception("Error while getting access token hash.");
            if (!IdentityUtil.isTokenLoggable((String)"AccessToken")) throw new IdentityOAuth2Exception("Error while getting access token hash.");
            log.debug((Object)("Error while getting access token hash for token: " + accessToken));
            throw new IdentityOAuth2Exception("Error while getting access token hash.");
        }
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Persisting access token(hashed): " + DigestUtils.sha256Hex((String)accessToken) + " for client: " + consumerKey + " user: " + accessTokenDO.getAuthzUser().toString() + " scope: " + Arrays.toString(accessTokenDO.getScope())));
            } else {
                log.debug((Object)("Persisting access token for client: " + consumerKey + " user: " + accessTokenDO.getAuthzUser().toString() + " scope: " + Arrays.toString(accessTokenDO.getScope())));
            }
        }
        userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStoreDomain);
        String userDomain = accessTokenDO.getAuthzUser().getUserStoreDomain();
        String authenticatedIDP = accessTokenDO.getAuthzUser().getFederatedIdPName();
        PreparedStatement insertTokenPrepStmt = null;
        PreparedStatement addScopePrepStmt = null;
        if (!OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal() && accessTokenDO.getAuthzUser().isFederatedUser()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding federated domain to user store domain to user " + accessTokenDO.getAuthzUser().getAuthenticatedSubjectIdentifier()));
            }
            userDomain = OAuth2Util.getFederatedUserDomain(authenticatedIDP);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Userstore domain for user " + accessTokenDO.getAuthzUser().getAuthenticatedSubjectIdentifier() + " is :" + userDomain));
        }
        String sql = OAuth2Util.getTokenPartitionedSqlByUserStore("INSERT INTO IDN_OAUTH2_ACCESS_TOKEN (ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, USER_TYPE, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, TOKEN_BINDING_REF) SELECT ?,?,ID,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?", userDomain);
        String sqlAddScopes = OAuth2Util.getTokenPartitionedSqlByUserStore("INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_SCOPE (TOKEN_ID, TOKEN_SCOPE, TENANT_ID) VALUES (?,?,?)", userDomain);
        try {
            insertTokenPrepStmt = connection.prepareStatement(sql);
            insertTokenPrepStmt.setString(1, persistenceProcessor.getProcessedAccessTokenIdentifier(accessToken));
            if (accessTokenDO.getRefreshToken() != null) {
                insertTokenPrepStmt.setString(2, persistenceProcessor.getProcessedRefreshToken(accessTokenDO.getRefreshToken()));
            } else {
                insertTokenPrepStmt.setString(2, accessTokenDO.getRefreshToken());
            }
            insertTokenPrepStmt.setString(3, accessTokenDO.getAuthzUser().getUserName());
            int tenantId = OAuth2Util.getTenantId(accessTokenDO.getAuthzUser().getTenantDomain());
            insertTokenPrepStmt.setInt(4, tenantId);
            insertTokenPrepStmt.setString(5, OAuth2Util.getSanitizedUserStoreDomain(userDomain));
            insertTokenPrepStmt.setTimestamp(6, accessTokenDO.getIssuedTime(), Calendar.getInstance(TimeZone.getTimeZone(UTC)));
            insertTokenPrepStmt.setTimestamp(7, accessTokenDO.getRefreshTokenIssuedTime(), Calendar.getInstance(TimeZone.getTimeZone(UTC)));
            insertTokenPrepStmt.setLong(8, accessTokenDO.getValidityPeriodInMillis());
            insertTokenPrepStmt.setLong(9, accessTokenDO.getRefreshTokenValidityPeriodInMillis());
            insertTokenPrepStmt.setString(10, OAuth2Util.hashScopes(accessTokenDO.getScope()));
            insertTokenPrepStmt.setString(11, accessTokenDO.getTokenState());
            insertTokenPrepStmt.setString(12, accessTokenDO.getTokenType());
            insertTokenPrepStmt.setString(13, accessTokenDO.getTokenId());
            insertTokenPrepStmt.setString(14, accessTokenDO.getGrantType());
            insertTokenPrepStmt.setString(15, accessTokenDO.getAuthzUser().getAuthenticatedSubjectIdentifier());
            insertTokenPrepStmt.setString(16, hashingPersistenceProcessor.getProcessedAccessTokenIdentifier(accessToken));
            if (accessTokenDO.getRefreshToken() != null) {
                insertTokenPrepStmt.setString(17, hashingPersistenceProcessor.getProcessedRefreshToken(accessTokenDO.getRefreshToken()));
            } else {
                insertTokenPrepStmt.setString(17, accessTokenDO.getRefreshToken());
            }
            String tokenBindingReference = "NONE";
            if (accessTokenDO.getTokenBinding() != null) {
                tokenBindingReference = accessTokenDO.getTokenBinding().getBindingReference();
            }
            insertTokenPrepStmt.setString(18, tokenBindingReference);
            insertTokenPrepStmt.setString(19, persistenceProcessor.getProcessedClientId(consumerKey));
            insertTokenPrepStmt.execute();
            String accessTokenId = accessTokenDO.getTokenId();
            addScopePrepStmt = connection.prepareStatement(sqlAddScopes);
            if (accessTokenDO.getScope() != null && accessTokenDO.getScope().length > 0) {
                for (String scope : accessTokenDO.getScope()) {
                    addScopePrepStmt.setString(1, accessTokenId);
                    addScopePrepStmt.setString(2, scope);
                    addScopePrepStmt.setInt(3, tenantId);
                    addScopePrepStmt.execute();
                }
            }
            if (accessTokenDO.getTokenBinding() != null) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO IDN_OAUTH2_TOKEN_BINDING (TOKEN_ID, TOKEN_BINDING_TYPE, TOKEN_BINDING_REF, TOKEN_BINDING_VALUE, TENANT_ID) VALUES (?, ?, ?, ?, ?)");){
                    preparedStatement.setString(1, accessTokenId);
                    preparedStatement.setString(2, accessTokenDO.getTokenBinding().getBindingType());
                    preparedStatement.setString(3, accessTokenDO.getTokenBinding().getBindingReference());
                    preparedStatement.setString(4, accessTokenDO.getTokenBinding().getBindingValue());
                    preparedStatement.setInt(5, tenantId);
                    preparedStatement.execute();
                }
            }
            if (retryAttempt > 0) {
                log.info((Object)("Successfully recovered 'CON_APP_KEY' constraint violation with the attempt : " + retryAttempt));
            }
            IdentityDatabaseUtil.closeStatement((PreparedStatement)addScopePrepStmt);
        }
        catch (SQLIntegrityConstraintViolationException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            if (retryAttempt >= tokenPersistRetryCount) {
                log.error((Object)("'CON_APP_KEY' constrain violation retry count exceeds above the maximum count - " + tokenPersistRetryCount));
                String errorMsg = "Access Token for consumer key : " + consumerKey + ", user : " + accessTokenDO.getAuthzUser() + " and scope : " + OAuth2Util.buildScopeString(accessTokenDO.getScope()) + "already exists";
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            this.recoverFromConAppKeyConstraintViolation(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, retryAttempt + 1);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (DataTruncation e2) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Invalid request", e2);
                catch (SQLException e3) {
                    IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                    if (!StringUtils.containsIgnoreCase((String)e3.getMessage(), (String)"CON_APP_KEY")) throw new IdentityOAuth2Exception("Error when storing the access token for consumer key : " + consumerKey, e3);
                    if (retryAttempt >= tokenPersistRetryCount) {
                        log.error((Object)("'CON_APP_KEY' constrain violation retry count exceeds above the maximum count - " + tokenPersistRetryCount));
                        String errorMsg = "Access Token for consumer key : " + consumerKey + ", user : " + accessTokenDO.getAuthzUser() + " and scope : " + OAuth2Util.buildScopeString(accessTokenDO.getScope()) + "already exists";
                        throw new IdentityOAuth2Exception(errorMsg, e3);
                    }
                    this.recoverFromConAppKeyConstraintViolation(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, retryAttempt + 1);
                    return;
                }
            }
        }
        finally {
            IdentityDatabaseUtil.closeStatement(addScopePrepStmt);
            IdentityDatabaseUtil.closeStatement((PreparedStatement)insertTokenPrepStmt);
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)insertTokenPrepStmt);
        return;
    }

    public void storeAccessToken(String accessToken, String consumerKey, AccessTokenDO newAccessTokenDO, AccessTokenDO existingAccessTokenDO, String userStoreDomain) throws IdentityException {
        if (!this.enablePersist) {
            return;
        }
        userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStoreDomain);
        if (maxPoolSize > 0) {
            accessContextTokenQueue.push(new AccessContextTokenDO(accessToken, consumerKey, newAccessTokenDO, existingAccessTokenDO, userStoreDomain));
        } else {
            this.persistAccessToken(accessToken, consumerKey, newAccessTokenDO, existingAccessTokenDO, userStoreDomain);
        }
    }

    public boolean persistAccessToken(String accessToken, String consumerKey, AccessTokenDO newAccessTokenDO, AccessTokenDO existingAccessTokenDO, String userStoreDomain) throws IdentityOAuth2Exception {
        if (!this.enablePersist) {
            return false;
        }
        userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStoreDomain);
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        try {
            if (this.isHashDisabled && existingAccessTokenDO != null) {
                this.setAccessTokenState(connection, existingAccessTokenDO.getTokenId(), "EXPIRED", UUID.randomUUID().toString(), userStoreDomain);
            }
            this.storeAccessToken(accessToken, consumerKey, newAccessTokenDO, connection, userStoreDomain);
            if (newAccessTokenDO.getAuthorizationCode() != null) {
                AuthzCodeDO authzCodeDO = new AuthzCodeDO();
                authzCodeDO.setAuthorizationCode(newAccessTokenDO.getAuthorizationCode());
                authzCodeDO.setOauthTokenId(newAccessTokenDO.getTokenId());
                this.deactivateAuthorizationCode(authzCodeDO, connection);
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
            boolean authzCodeDO = true;
            return authzCodeDO;
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while persisting access token", e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public AccessTokenDO retrieveLatestAccessToken(String consumerKey, AuthenticatedUser authzUser, String userStoreDomain, String scope, boolean includeExpiredTokens) throws IdentityOAuth2Exception {
        return OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getLatestAccessToken(consumerKey, authzUser, userStoreDomain, scope, includeExpiredTokens);
    }

    public Set<AccessTokenDO> retrieveAccessTokens(String consumerKey, AuthenticatedUser userName, String userStoreDomain, boolean includeExpired) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving access tokens for client: " + consumerKey + " user: " + userName.toString()));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)userName.toString());
        String tenantDomain = userName.getTenantDomain();
        String tenantAwareUsernameWithNoUserDomain = userName.getUserName();
        String userDomain = OAuth2Util.getSanitizedUserStoreDomain(userName.getUserStoreDomain());
        userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStoreDomain);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        HashMap<String, AccessTokenDO> accessTokenDOMap = new HashMap<String, AccessTokenDO>();
        try {
            int tenantId = OAuth2Util.getTenantId(tenantDomain);
            String sql = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_STATE='ACTIVE') ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
            if (includeExpired) {
                sql = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
            }
            sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userStoreDomain);
            if (!isUsernameCaseSensitive) {
                sql = sql.replace(AUTHZ_USER, LOWER_AUTHZ_USER);
            }
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, persistenceProcessor.getProcessedClientId(consumerKey));
            if (isUsernameCaseSensitive) {
                prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain);
            } else {
                prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain.toLowerCase());
            }
            prepStmt.setInt(3, tenantId);
            prepStmt.setString(4, userDomain);
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                String accessToken = null;
                if (this.isHashDisabled) {
                    accessToken = persistenceProcessor.getPreprocessedAccessTokenIdentifier(resultSet.getString(1));
                }
                if (accessTokenDOMap.get(accessToken) == null) {
                    ServiceProvider serviceProvider;
                    String refreshToken = null;
                    if (this.isHashDisabled) {
                        refreshToken = persistenceProcessor.getPreprocessedRefreshToken(resultSet.getString(2));
                    }
                    Timestamp issuedTime = resultSet.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                    Timestamp refreshTokenIssuedTime = resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                    long validityPeriodInMillis = resultSet.getLong(5);
                    long refreshTokenValidityPeriodMillis = resultSet.getLong(6);
                    String tokenType = resultSet.getString(7);
                    String[] scope = OAuth2Util.buildScopeArray(resultSet.getString(8));
                    String tokenId = resultSet.getString(9);
                    String subjectIdentifier = resultSet.getString(10);
                    AuthenticatedUser user = new AuthenticatedUser();
                    user.setUserName(tenantAwareUsernameWithNoUserDomain);
                    user.setTenantDomain(tenantDomain);
                    user.setUserStoreDomain(userDomain);
                    try {
                        serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                    }
                    catch (IdentityApplicationManagementException e) {
                        throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                    }
                    user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                    AccessTokenDO dataDO = new AccessTokenDO(consumerKey, user, scope, issuedTime, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodMillis, tokenType);
                    dataDO.setAccessToken(accessToken);
                    dataDO.setRefreshToken(refreshToken);
                    dataDO.setTokenId(tokenId);
                    accessTokenDOMap.put(accessToken, dataDO);
                    continue;
                }
                String scope = resultSet.getString(8).trim();
                AccessTokenDO accessTokenDO = (AccessTokenDO)((Object)accessTokenDOMap.get(accessToken));
                accessTokenDO.setScope((String[])ArrayUtils.add((Object[])accessTokenDO.getScope(), (Object)scope));
            }
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'ACTIVE' access tokens for Client ID : " + consumerKey + " and User ID : " + userName;
                if (includeExpired) {
                    errorMsg = errorMsg.replace("ACTIVE", "ACTIVE or EXPIRED");
                }
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return new HashSet<AccessTokenDO>(accessTokenDOMap.values());
    }

    public AuthzCodeDO validateAuthorizationCode(String consumerKey, String authorizationKey) throws IdentityOAuth2Exception {
        AuthzCodeDO authzCodeDO;
        long validityPeriod;
        Timestamp issuedTime;
        String pkceCodeChallengeMethod;
        String pkceCodeChallenge;
        String codeId;
        String callbackUrl;
        String scopeString;
        String codeState;
        AuthenticatedUser user;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        block15: {
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
                    log.debug((Object)("Validating authorization code(hashed): " + DigestUtils.sha256Hex((String)authorizationKey) + " for client: " + consumerKey));
                } else {
                    log.debug((Object)("Validating authorization code for client: " + consumerKey));
                }
            }
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            user = null;
            codeState = null;
            String authorizedUser = null;
            String userstoreDomain = null;
            scopeString = null;
            callbackUrl = null;
            String tenantDomain = null;
            codeId = null;
            String subjectIdentifier = null;
            pkceCodeChallenge = null;
            pkceCodeChallengeMethod = null;
            issuedTime = null;
            validityPeriod = 0L;
            prepStmt = connection.prepareStatement("SELECT AUTHZ_USER, USER_DOMAIN, TENANT_ID, SCOPE, CALLBACK_URL, TIME_CREATED,VALIDITY_PERIOD, STATE, TOKEN_ID, AUTHORIZATION_CODE, CODE_ID, SUBJECT_IDENTIFIER, PKCE_CODE_CHALLENGE, PKCE_CODE_CHALLENGE_METHOD FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHORIZATION_CODE_HASH = ?");
            prepStmt.setString(1, persistenceProcessor.getProcessedClientId(consumerKey));
            prepStmt.setString(2, hashingPersistenceProcessor.getProcessedAuthzCode(authorizationKey));
            resultSet = prepStmt.executeQuery();
            if (resultSet.next()) {
                ServiceProvider serviceProvider;
                codeState = resultSet.getString(8);
                authorizedUser = resultSet.getString(1);
                userstoreDomain = resultSet.getString(2);
                int tenantId = resultSet.getInt(3);
                tenantDomain = OAuth2Util.getTenantDomain(tenantId);
                scopeString = resultSet.getString(4);
                callbackUrl = resultSet.getString(5);
                issuedTime = resultSet.getTimestamp(6, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                validityPeriod = resultSet.getLong(7);
                codeId = resultSet.getString(11);
                subjectIdentifier = resultSet.getString(12);
                pkceCodeChallenge = resultSet.getString(13);
                pkceCodeChallengeMethod = resultSet.getString(14);
                user = new AuthenticatedUser();
                user.setUserName(authorizedUser);
                user.setTenantDomain(tenantDomain);
                user.setUserStoreDomain(userstoreDomain);
                try {
                    serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                }
                catch (IdentityApplicationManagementException e) {
                    throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                }
                user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                authorizedUser = UserCoreUtil.addDomainToName((String)authorizedUser, (String)userstoreDomain);
                authorizedUser = UserCoreUtil.addTenantDomainToEntry((String)authorizedUser, (String)tenantDomain);
                if (!"ACTIVE".equals(codeState)) {
                    if (log.isDebugEnabled()) {
                        if (IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
                            log.debug((Object)("Validated authorization code(hashed): " + DigestUtils.sha256Hex((String)authorizationKey) + " for client: " + consumerKey + " is not active. So revoking the access tokens issued for the authorization code."));
                        } else {
                            log.debug((Object)("Validated authorization code for client: " + consumerKey + " is not active. So revoking the access tokens issued for the authorization code."));
                        }
                    }
                    String tokenId = resultSet.getString(9);
                    this.revokeToken(tokenId, authorizedUser);
                }
                break block15;
            }
            AuthzCodeDO authzCodeDO2 = null;
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return authzCodeDO2;
        }
        try {
            authzCodeDO = new AuthzCodeDO(user, OAuth2Util.buildScopeArray(scopeString), issuedTime, validityPeriod, callbackUrl, consumerKey, authorizationKey, codeId, codeState, pkceCodeChallenge, pkceCodeChallengeMethod);
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuth2Exception("Error when validating an authorization code", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return authzCodeDO;
    }

    public void changeAuthzCodeState(String authzCode, String newState) throws IdentityOAuth2Exception {
        if (maxPoolSize > 0) {
            authContextTokenQueue.push(new AuthContextTokenDO(authzCode));
        } else {
            this.doChangeAuthzCodeState(authzCode, newState);
        }
    }

    public void deactivateAuthorizationCode(List<AuthzCodeDO> authzCodeDOs) throws IdentityOAuth2Exception {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        if (log.isDebugEnabled()) {
            Object stringBuilder;
            if (IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
                stringBuilder = new StringBuilder();
                for (AuthzCodeDO authzCodeDO : authzCodeDOs) {
                    ((StringBuilder)stringBuilder).append("Deactivating authorization code(hashed): ").append(DigestUtils.sha256Hex((String)authzCodeDO.getAuthorizationCode())).append(" client: ").append(authzCodeDO.getConsumerKey()).append(" user: ").append(authzCodeDO.getAuthorizedUser().toString()).append("\n");
                }
                log.debug((Object)((StringBuilder)stringBuilder).toString());
            } else {
                stringBuilder = new StringBuilder();
                for (AuthzCodeDO authzCodeDO : authzCodeDOs) {
                    ((StringBuilder)stringBuilder).append("Deactivating authorization code client: ").append(authzCodeDO.getConsumerKey()).append(" user: ").append(authzCodeDO.getAuthorizedUser().toString()).append("\n");
                }
                log.debug((Object)((StringBuilder)stringBuilder).toString());
            }
        }
        try {
            prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE='INACTIVE', TOKEN_ID=? WHERE AUTHORIZATION_CODE_HASH= ?");
            for (AuthzCodeDO authzCodeDO : authzCodeDOs) {
                prepStmt.setString(1, authzCodeDO.getOauthTokenId());
                prepStmt.setString(2, hashingPersistenceProcessor.getProcessedAuthzCode(authzCodeDO.getAuthorizationCode()));
                prepStmt.addBatch();
            }
            prepStmt.executeBatch();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error when deactivating authorization code", e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
    }

    public void doChangeAuthzCodeState(String authzCode, String newState) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
                log.debug((Object)("Changing state of authorization code(hashed): " + DigestUtils.sha256Hex((String)authzCode) + " to: " + newState));
            } else {
                log.debug((Object)("Changing state of authorization code  to: " + newState));
            }
        }
        String authCodeStoreTable = IDN_OAUTH2_AUTHORIZATION_CODE;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            String sqlQuery = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE=? WHERE AUTHORIZATION_CODE_HASH=?".replace(IDN_OAUTH2_AUTHORIZATION_CODE, authCodeStoreTable);
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, newState);
            prepStmt.setString(2, hashingPersistenceProcessor.getProcessedAuthzCode(authzCode));
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while updating the state of Authorization Code : " + authzCode.toString(), e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }

    public void deactivateAuthorizationCode(AuthzCodeDO authzCodeDO) throws IdentityOAuth2Exception {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        try {
            this.deactivateAuthorizationCode(authzCodeDO, connection);
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error when deactivating authorization code", e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateAuthorizationCode(AuthzCodeDO authzCodeDO, Connection connection) throws IdentityOAuth2Exception, SQLException {
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
            log.debug((Object)("Deactivating authorization code(hashed): " + DigestUtils.sha256Hex((String)authzCodeDO.getAuthorizationCode())));
        }
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE='INACTIVE', TOKEN_ID=? WHERE AUTHORIZATION_CODE_HASH= ?");
            prepStmt.setString(1, authzCodeDO.getOauthTokenId());
            prepStmt.setString(2, hashingPersistenceProcessor.getProcessedAuthzCode(authzCodeDO.getAuthorizationCode()));
            prepStmt.executeUpdate();
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections(null, null, (PreparedStatement)prepStmt);
        }
    }

    public RefreshTokenValidationDataDO validateRefreshToken(String consumerKey, String refreshToken) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"RefreshToken")) {
                log.debug((Object)("Validating refresh token(hashed): " + DigestUtils.sha256Hex((String)refreshToken) + " client: " + consumerKey));
            } else {
                log.debug((Object)("Validating refresh token for client: " + consumerKey));
            }
        }
        RefreshTokenValidationDataDO validationDataDO = new RefreshTokenValidationDataDO();
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            String driverName = connection.getMetaData().getDriverName();
            String sql = driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC, TOKEN_STATE LIMIT 1) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : (driverName.contains("MS SQL") || driverName.contains("Microsoft") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOP 1 ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID  = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : (driverName.contains("PostgreSQL") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC LIMIT 1) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : (driverName.contains("INFORMIX") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT FIRST 1 ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT * FROM (SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID"))));
            sql = OAuth2Util.getTokenPartitionedSqlByToken(sql, refreshToken);
            if (refreshToken == null) {
                sql = sql.replace("REFRESH_TOKEN = ?", "REFRESH_TOKEN IS NULL");
            }
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, persistenceProcessor.getProcessedClientId(consumerKey));
            if (refreshToken != null) {
                prepStmt.setString(2, hashingPersistenceProcessor.getProcessedRefreshToken(refreshToken));
            }
            resultSet = prepStmt.executeQuery();
            int iterateId = 0;
            ArrayList<String> scopes = new ArrayList<String>();
            while (resultSet.next()) {
                if (iterateId == 0) {
                    ServiceProvider serviceProvider;
                    if (this.isHashDisabled) {
                        validationDataDO.setAccessToken(persistenceProcessor.getPreprocessedAccessTokenIdentifier(resultSet.getString(1)));
                    }
                    String userName = resultSet.getString(2);
                    int tenantId = resultSet.getInt(3);
                    String userDomain = resultSet.getString(4);
                    String tenantDomain = OAuth2Util.getTenantDomain(tenantId);
                    validationDataDO.setScope(OAuth2Util.buildScopeArray(resultSet.getString(5)));
                    validationDataDO.setRefreshTokenState(resultSet.getString(6));
                    validationDataDO.setIssuedTime(resultSet.getTimestamp(7, Calendar.getInstance(TimeZone.getTimeZone(UTC))));
                    validationDataDO.setValidityPeriodInMillis(resultSet.getLong(8));
                    validationDataDO.setTokenId(resultSet.getString(9));
                    validationDataDO.setGrantType(resultSet.getString(10));
                    String subjectIdentifier = resultSet.getString(11);
                    AuthenticatedUser user = new AuthenticatedUser();
                    user.setUserName(userName);
                    user.setUserStoreDomain(userDomain);
                    user.setTenantDomain(tenantDomain);
                    try {
                        serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                    }
                    catch (IdentityApplicationManagementException e) {
                        throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                    }
                    user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                    validationDataDO.setAuthorizedUser(user);
                } else {
                    scopes.add(resultSet.getString(5));
                }
                ++iterateId;
            }
            if (scopes.size() > 0 && validationDataDO != null) {
                validationDataDO.setScope((String[])ArrayUtils.addAll((Object[])validationDataDO.getScope(), (Object[])scopes.toArray(new String[scopes.size()])));
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuth2Exception("Error when validating a refresh token", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return validationDataDO;
    }

    public AccessTokenDO retrieveAccessToken(String accessTokenIdentifier, boolean includeExpired) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
            log.debug((Object)("Retrieving information of access token(hashed): " + DigestUtils.sha256Hex((String)accessTokenIdentifier)));
        }
        AccessTokenDO dataDO = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            String sql = includeExpired ? "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID WHERE ACCESS_TOKEN_HASH=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID AS TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN AS USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE AS GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT * FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH=? AND TOKEN_STATE='ACTIVE') IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
            sql = OAuth2Util.getTokenPartitionedSqlByToken(sql, accessTokenIdentifier);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, hashingPersistenceProcessor.getProcessedAccessTokenIdentifier(accessTokenIdentifier));
            resultSet = prepStmt.executeQuery();
            int iterateId = 0;
            ArrayList<String> scopes = new ArrayList<String>();
            while (resultSet.next()) {
                if (iterateId == 0) {
                    ServiceProvider serviceProvider;
                    String consumerKey = persistenceProcessor.getPreprocessedClientId(resultSet.getString(1));
                    String authorizedUser = resultSet.getString(2);
                    int tenantId = resultSet.getInt(3);
                    String tenantDomain = OAuth2Util.getTenantDomain(tenantId);
                    String userDomain = resultSet.getString(4);
                    String[] scope = OAuth2Util.buildScopeArray(resultSet.getString(5));
                    Timestamp issuedTime = resultSet.getTimestamp(6, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                    Timestamp refreshTokenIssuedTime = resultSet.getTimestamp(7, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                    long validityPeriodInMillis = resultSet.getLong(8);
                    long refreshTokenValidityPeriodMillis = resultSet.getLong(9);
                    String tokenType = resultSet.getString(10);
                    String refreshToken = resultSet.getString(11);
                    String tokenId = resultSet.getString(12);
                    String grantType = resultSet.getString(13);
                    String subjectIdentifier = resultSet.getString(14);
                    AuthenticatedUser user = new AuthenticatedUser();
                    user.setUserName(authorizedUser);
                    user.setUserStoreDomain(userDomain);
                    user.setTenantDomain(tenantDomain);
                    try {
                        serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                    }
                    catch (IdentityApplicationManagementException e) {
                        throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                    }
                    user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                    if (!OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal() && userDomain.startsWith("FEDERATED")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Federated prefix found in domain " + userDomain + "and federated users are not mapped to local users. Hence setting user to a federated user"));
                        }
                        user.setFederatedUser(true);
                    }
                    dataDO = new AccessTokenDO(consumerKey, user, scope, issuedTime, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodMillis, tokenType);
                    dataDO.setAccessToken(accessTokenIdentifier);
                    dataDO.setRefreshToken(refreshToken);
                    dataDO.setTokenId(tokenId);
                    dataDO.setGrantType(grantType);
                    dataDO.setTenantID(tenantId);
                } else {
                    scopes.add(resultSet.getString(5));
                }
                ++iterateId;
            }
            if (scopes.size() > 0 && dataDO != null) {
                dataDO.setScope((String[])ArrayUtils.addAll((Object[])dataDO.getScope(), (Object[])scopes.toArray(new String[scopes.size()])));
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuth2Exception("Error when retrieving Access Token" + e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return dataDO;
    }

    public void setAccessTokenState(Connection connection, String tokenId, String tokenState, String tokenStateId, String userStoreDomain) throws IdentityOAuth2Exception, SQLException {
        PreparedStatement prepStmt = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Changing status of access token with id: " + tokenId + " to: " + tokenState + " userStoreDomain: " + userStoreDomain));
            }
            String sql = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_ID=?";
            sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userStoreDomain);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, tokenState);
            prepStmt.setString(2, tokenStateId);
            prepStmt.setString(3, tokenId);
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error while updating Access Token with ID : " + tokenId + " to Token State : " + tokenState, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
    }

    public void revokeTokens(String[] tokens) throws IdentityOAuth2Exception {
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            this.revokeTokensIndividual(tokens);
        } else {
            this.revokeTokensBatch(tokens);
        }
    }

    public void revokeTokensBatch(String[] tokens) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String token : tokens) {
                    stringBuilder.append(DigestUtils.sha256Hex((String)token)).append(" ");
                }
                log.debug((Object)("Revoking access tokens(hashed): " + stringBuilder.toString()));
            } else {
                log.debug((Object)"Revoking access tokens in batch mode");
            }
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        if (tokens.length > 1) {
            try {
                String sqlQuery = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE ACCESS_TOKEN_HASH=?";
                ps = connection.prepareStatement(sqlQuery);
                for (String token : tokens) {
                    ps.setString(1, "REVOKED");
                    ps.setString(2, UUID.randomUUID().toString());
                    ps.setString(3, hashingPersistenceProcessor.getProcessedAccessTokenIdentifier(token));
                    ps.addBatch();
                }
                ps.executeBatch();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while revoking Access Tokens : " + Arrays.toString(tokens), e);
            }
            finally {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
            }
        }
        if (tokens.length == 1) {
            try {
                connection.setAutoCommit(true);
                String sqlQuery = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE ACCESS_TOKEN_HASH=?";
                ps = connection.prepareStatement(sqlQuery);
                ps.setString(1, "REVOKED");
                ps.setString(2, UUID.randomUUID().toString());
                ps.setString(3, hashingPersistenceProcessor.getProcessedAccessTokenIdentifier(tokens[0]));
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new IdentityOAuth2Exception("Error occurred while revoking Access Token : " + Arrays.toString(tokens), e);
            }
            finally {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
            }
        }
    }

    public void revokeTokensIndividual(String[] tokens) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String token : tokens) {
                    stringBuilder.append(DigestUtils.sha256Hex((String)token)).append(" ");
                }
                log.debug((Object)("Revoking access tokens(hashed): " + stringBuilder.toString()));
            } else {
                log.debug((Object)"Revoking access tokens in individual mode");
            }
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            for (String token : tokens) {
                String sqlQuery = OAuth2Util.getTokenPartitionedSqlByToken("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE ACCESS_TOKEN_HASH=?", token);
                ps = connection.prepareStatement(sqlQuery);
                ps.setString(1, "REVOKED");
                ps.setString(2, UUID.randomUUID().toString());
                ps.setString(3, hashingPersistenceProcessor.getProcessedAccessTokenIdentifier(token));
                int count = ps.executeUpdate();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Number of rows being updated : " + count));
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while revoking Access Token : " + Arrays.toString(tokens), e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
        }
    }

    public void revokeToken(String tokenId, String userId) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Revoking access token with id: " + tokenId + " user: " + userId));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserId("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_ID=?", userId);
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, "REVOKED");
            ps.setString(2, UUID.randomUUID().toString());
            ps.setString(3, tokenId);
            int count = ps.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of rows being updated : " + count));
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while revoking Access Token with ID : " + tokenId, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
    }

    public Set<String> getAccessTokensForUser(AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving access tokens of user: " + authenticatedUser.toString()));
        }
        String accessTokenStoreTable = IDN_OAUTH2_ACCESS_TOKEN;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> accessTokens = new HashSet<String>();
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authenticatedUser.toString());
        try {
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserId("SELECT DISTINCT ACCESS_TOKEN, USER_TYPE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE AUTHZ_USER=? AND TENANT_ID=? AND TOKEN_STATE=? AND USER_DOMAIN=?", authenticatedUser.toString());
            if (!isUsernameCaseSensitive) {
                sqlQuery = sqlQuery.replace(AUTHZ_USER, LOWER_AUTHZ_USER);
            }
            ps = connection.prepareStatement(sqlQuery);
            if (isUsernameCaseSensitive) {
                ps.setString(1, authenticatedUser.getUserName());
            } else {
                ps.setString(1, authenticatedUser.getUserName().toLowerCase());
            }
            ps.setInt(2, OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()));
            ps.setString(3, "ACTIVE");
            ps.setString(4, authenticatedUser.getUserStoreDomain());
            rs = ps.executeQuery();
            while (rs.next()) {
                if (!this.isHashDisabled) continue;
                accessTokens.add(persistenceProcessor.getPreprocessedAccessTokenIdentifier(rs.getString(1)));
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while revoking Access Token with user Name : " + authenticatedUser.getUserName() + " tenant ID : " + OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()), e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        return accessTokens;
    }

    public Set<String> getAuthorizationCodesForUser(AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving authorization codes of user: " + authenticatedUser.toString()));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> authorizationCodes = new HashSet<String>();
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authenticatedUser.toString());
        try {
            String sqlQuery = "SELECT DISTINCT AUTHORIZATION_CODE, TIME_CREATED, VALIDITY_PERIOD  FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND STATE=?";
            if (!isUsernameCaseSensitive) {
                sqlQuery = sqlQuery.replace(AUTHZ_USER, LOWER_AUTHZ_USER);
            }
            ps = connection.prepareStatement(sqlQuery);
            if (isUsernameCaseSensitive) {
                ps.setString(1, authenticatedUser.getUserName());
            } else {
                ps.setString(1, authenticatedUser.getUserName().toLowerCase());
            }
            ps.setInt(2, OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()));
            ps.setString(3, authenticatedUser.getUserStoreDomain());
            ps.setString(4, "ACTIVE");
            rs = ps.executeQuery();
            while (rs.next()) {
                long validityPeriodInMillis = rs.getLong(3);
                Timestamp timeCreated = rs.getTimestamp(2, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                long issuedTimeInMillis = timeCreated.getTime();
                if (OAuth2Util.getTimeToExpire(issuedTimeInMillis, validityPeriodInMillis) <= 1000L || !this.isHashDisabled) continue;
                authorizationCodes.add(persistenceProcessor.getPreprocessedAuthzCode(rs.getString(1)));
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while revoking Access Token with user Name : " + authenticatedUser.getUserName() + " tenant ID : " + OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()), e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        return authorizationCodes;
    }

    public Set<String> getActiveTokensForConsumerKey(String consumerKey) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving active access tokens of client: " + consumerKey));
        }
        Set<String> activeTokens = this.getActiveTokensForConsumerKey(consumerKey, IdentityUtil.getPrimaryDomainName());
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            for (Map.Entry<String, String> availableDomainMapping : availableDomainMappings.entrySet()) {
                activeTokens.addAll(this.getActiveTokensForConsumerKey(consumerKey, availableDomainMapping.getKey()));
            }
        }
        return activeTokens;
    }

    private Set<String> getActiveTokensForConsumerKey(String consumerKey, String userStoreDomain) throws IdentityOAuth2Exception {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> accessTokens = new HashSet<String>();
        try {
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserStore("SELECT ACCESS_TOKEN FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ? ) AND TOKEN_STATE=?", userStoreDomain);
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            ps.setString(2, "ACTIVE");
            rs = ps.executeQuery();
            while (rs.next()) {
                if (!this.isHashDisabled) continue;
                accessTokens.add(persistenceProcessor.getPreprocessedAccessTokenIdentifier(rs.getString(1)));
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while getting access tokens from acces token table for the application with consumer key : " + consumerKey, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        return accessTokens;
    }

    public Set<AccessTokenDO> getActiveDetailedTokensForConsumerKey(String consumerKey) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving active access tokens for client: " + consumerKey));
        }
        Set<AccessTokenDO> accessTokenDOs = this.getActiveDetailedTokensForConsumerKey(consumerKey, IdentityUtil.getPrimaryDomainName());
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            for (Map.Entry<String, String> availableDomainMapping : availableDomainMappings.entrySet()) {
                accessTokenDOs.addAll(this.getActiveDetailedTokensForConsumerKey(consumerKey, availableDomainMapping.getKey()));
            }
        }
        return accessTokenDOs;
    }

    private Set<AccessTokenDO> getActiveDetailedTokensForConsumerKey(String consumerKey, String userStoreDomain) throws IdentityOAuth2Exception {
        HashSet<AccessTokenDO> activeDetailedTokens;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, AccessTokenDO> tokenMap = new HashMap<String, AccessTokenDO>();
        try {
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserStore("SELECT IDN_OAUTH2_ACCESS_TOKEN.AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.ACCESS_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN, IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_SCOPE FROM IDN_OAUTH2_ACCESS_TOKEN LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON IDN_OAUTH2_ACCESS_TOKEN.TOKEN_ID=IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?) AND TOKEN_STATE=?", userStoreDomain);
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            ps.setString(2, "ACTIVE");
            rs = ps.executeQuery();
            while (rs.next()) {
                String token = rs.getString(2);
                if (tokenMap.containsKey(token)) {
                    AccessTokenDO tokenObj = (AccessTokenDO)((Object)tokenMap.get(token));
                    String[] previousScope = tokenObj.getScope();
                    String[] newSope = new String[tokenObj.getScope().length + 1];
                    System.arraycopy(previousScope, 0, newSope, 0, previousScope.length);
                    newSope[previousScope.length] = rs.getString(5);
                    tokenObj.setScope(newSope);
                    continue;
                }
                String authzUser = rs.getString(1);
                int tenentId = rs.getInt(3);
                String userDomain = rs.getString(4);
                String tokenSope = rs.getString(5);
                String[] scope = OAuth2Util.buildScopeArray(tokenSope);
                AuthenticatedUser user = new AuthenticatedUser();
                user.setUserName(authzUser);
                user.setTenantDomain(OAuth2Util.getTenantDomain(tenentId));
                user.setUserStoreDomain(userDomain);
                AccessTokenDO aTokenDetail = new AccessTokenDO();
                aTokenDetail.setAccessToken(token);
                aTokenDetail.setConsumerKey(consumerKey);
                aTokenDetail.setScope(scope);
                aTokenDetail.setAuthzUser(user);
                tokenMap.put(token, aTokenDetail);
            }
            activeDetailedTokens = new HashSet<AccessTokenDO>(tokenMap.values());
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while getting access tokens from acces token table for the application with consumer key : " + consumerKey, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        return activeDetailedTokens;
    }

    public Set<String> getAuthorizationCodesForConsumerKey(String consumerKey) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving authorization codes for client: " + consumerKey));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> authorizationCodes = new HashSet<String>();
        try {
            String sqlQuery = "SELECT AUTHORIZATION_CODE   FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) ";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            rs = ps.executeQuery();
            while (rs.next()) {
                if (!this.isHashDisabled) continue;
                authorizationCodes.add(persistenceProcessor.getPreprocessedAuthzCode(rs.getString(1)));
            }
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while getting authorization codes from authorization code table for the application with consumer key : " + consumerKey, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
        return authorizationCodes;
    }

    public Set<String> getActiveAuthorizationCodesForConsumerKey(String consumerKey) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving active authorization codes for client: " + consumerKey));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> authorizationCodes = new HashSet<String>();
        try {
            String sqlQuery = "SELECT AUTHORIZATION_CODE FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND STATE = ?";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            ps.setString(2, "ACTIVE");
            rs = ps.executeQuery();
            while (rs.next()) {
                if (!this.isHashDisabled) continue;
                authorizationCodes.add(persistenceProcessor.getPreprocessedAuthzCode(rs.getString(1)));
            }
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while getting authorization codes from authorization code table for the application with consumer key : " + consumerKey, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
        return authorizationCodes;
    }

    public Set<String> getAllTimeAuthorizedClientIds(AuthenticatedUser authzUser) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving all authorized clients by user: " + authzUser.toString()));
        }
        PreparedStatement ps = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        ResultSet rs = null;
        HashSet<String> distinctConsumerKeys = new HashSet<String>();
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authzUser.toString());
        String tenantDomain = authzUser.getTenantDomain();
        String tenantAwareUsernameWithNoUserDomain = authzUser.getUserName();
        String userDomain = OAuth2Util.getSanitizedUserStoreDomain(authzUser.getUserStoreDomain());
        try {
            int tenantId = OAuth2Util.getTenantId(tenantDomain);
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserId("SELECT DISTINCT CONSUMER_KEY FROM IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID WHERE AUTHZ_USER=? AND IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID=? AND IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')", authzUser.toString());
            if (!isUsernameCaseSensitive) {
                sqlQuery = sqlQuery.replace(AUTHZ_USER, LOWER_AUTHZ_USER);
            }
            ps = connection.prepareStatement(sqlQuery);
            if (isUsernameCaseSensitive) {
                ps.setString(1, tenantAwareUsernameWithNoUserDomain);
            } else {
                ps.setString(1, tenantAwareUsernameWithNoUserDomain.toLowerCase());
            }
            ps.setInt(2, tenantId);
            ps.setString(3, userDomain);
            rs = ps.executeQuery();
            while (rs.next()) {
                String consumerKey = persistenceProcessor.getPreprocessedClientId(rs.getString(1));
                distinctConsumerKeys.add(consumerKey);
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuth2Exception("Error occurred while retrieving all distinct Client IDs authorized by User ID : " + authzUser + " until now", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        if (log.isDebugEnabled()) {
            StringBuilder consumerKeys = new StringBuilder();
            for (String consumerKey : distinctConsumerKeys) {
                consumerKeys.append(consumerKey).append(" ");
            }
            log.debug((Object)("Found authorized clients " + consumerKeys.toString() + " for user: " + authzUser.toString()));
        }
        return distinctConsumerKeys;
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public String findScopeOfResource(String resourceUri) throws IdentityOAuth2Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Pair<String, Integer> findTenantAndScopeOfResource(String resourceUri) throws IdentityOAuth2Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean validateScope(Connection connection, String accessToken, String resourceUri) {
        return false;
    }

    public void invalidateAndCreateNewToken(String oldAccessTokenId, String tokenState, String consumerKey, String tokenStateId, AccessTokenDO accessTokenDO, String userStoreDomain) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Invalidating access token with id: " + oldAccessTokenId + " and creating new access token(hashed): " + DigestUtils.sha256Hex((String)accessTokenDO.getAccessToken()) + " for client: " + consumerKey + " user: " + accessTokenDO.getAuthzUser().toString() + " scope: " + Arrays.toString(accessTokenDO.getScope())));
            } else {
                log.debug((Object)("Invalidating and creating new access token for client: " + consumerKey + " user: " + accessTokenDO.getAuthzUser().toString() + " scope: " + Arrays.toString(accessTokenDO.getScope())));
            }
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        try {
            this.setAccessTokenState(connection, oldAccessTokenId, tokenState, tokenStateId, userStoreDomain);
            String newAccessToken = accessTokenDO.getAccessToken();
            this.storeAccessToken(newAccessToken, consumerKey, accessTokenDO, connection, userStoreDomain);
            this.updateTokenIdIfAutzCodeGrantType(oldAccessTokenId, accessTokenDO.getTokenId(), connection);
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            String errorMsg = "Error while regenerating access token";
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public void revokeOAuthConsentByApplicationAndUser(String username, String applicationName) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Revoking OAuth consent for application: " + applicationName + " by user: " + username));
        }
        if (username == null || applicationName == null) {
            log.error((Object)("Could not remove consent of user " + username + " for application " + applicationName));
            return;
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sql = "DELETE FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND RP_URL = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, username);
            ps.setString(2, applicationName);
            ps.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            String errorMsg = "Error deleting OAuth consent of Application " + applicationName + " and User " + username;
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    public void revokeOAuthConsentByApplicationAndUser(String username, String tenantDomain, String applicationName) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Revoking OAuth consent for application: " + applicationName + " by user: " + username + " tenant: " + tenantDomain));
        }
        if (username == null || applicationName == null) {
            log.error((Object)("Could not remove consent of user " + username + " for application " + applicationName));
            return;
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sql = "DELETE FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND TENANT_ID=? AND RP_URL = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, username);
            ps.setInt(2, IdentityTenantUtil.getTenantId((String)tenantDomain));
            ps.setString(3, applicationName);
            ps.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            String errorMsg = "Error deleting OAuth consent of Application " + applicationName + " and User " + username;
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    public void updateApproveAlwaysForAppConsentByResourceOwner(String tenantAwareUserName, String tenantDomain, String applicationName, String state) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting consent for " + state + " OAuth consent for application: " + applicationName + " by user: " + tenantAwareUserName + " tenant: " + tenantDomain));
        }
        if (tenantAwareUserName == null || applicationName == null) {
            log.error((Object)("Could not remove consent of user " + tenantAwareUserName + " for application " + applicationName));
            return;
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sql = "UPDATE IDN_OPENID_USER_RPS SET TRUSTED_ALWAYS=? WHERE USER_NAME = ? AND TENANT_ID=? AND RP_URL = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, state);
            ps.setString(2, tenantAwareUserName);
            ps.setInt(3, IdentityTenantUtil.getTenantId((String)tenantDomain));
            ps.setString(4, applicationName);
            ps.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            String errorMsg = "Error updating trusted always in a consent of Application " + applicationName + " and User " + tenantAwareUserName;
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    public Set<AccessTokenDO> getAccessTokensOfTenant(int tenantId) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving all access tokens of tenant id: " + tenantId));
        }
        Set<AccessTokenDO> accessTokenDOs = this.getAccessTokensOfTenant(tenantId, IdentityUtil.getPrimaryDomainName());
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            for (Map.Entry<String, String> availableDomainMapping : availableDomainMappings.entrySet()) {
                accessTokenDOs.addAll(this.getAccessTokensOfTenant(tenantId, availableDomainMapping.getKey()));
            }
        }
        return accessTokenDOs;
    }

    private Set<AccessTokenDO> getAccessTokensOfTenant(int tenantId, String userStoreDomain) throws IdentityOAuth2Exception {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        HashMap<String, AccessTokenDO> accessTokenDOMap = new HashMap<String, AccessTokenDO>();
        try {
            String sql = OAuth2Util.getTokenPartitionedSqlByUserStore("SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, AUTHZ_USER, ACCESS_TOKEN_TABLE.USER_DOMAIN, CONSUMER_KEY FROM (SELECT AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TENANT_ID=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID", userStoreDomain);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setInt(1, tenantId);
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                String accessToken = null;
                if (this.isHashDisabled) {
                    accessToken = persistenceProcessor.getPreprocessedAccessTokenIdentifier(resultSet.getString(1));
                }
                if (accessTokenDOMap.get(accessToken) == null) {
                    String refreshToken = null;
                    if (this.isHashDisabled) {
                        refreshToken = persistenceProcessor.getPreprocessedRefreshToken(resultSet.getString(2));
                    }
                    Timestamp issuedTime = resultSet.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                    Timestamp refreshTokenIssuedTime = resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                    long validityPeriodInMillis = resultSet.getLong(5);
                    long refreshTokenValidityPeriodMillis = resultSet.getLong(6);
                    String tokenType = resultSet.getString(7);
                    String[] scope = OAuth2Util.buildScopeArray(resultSet.getString(8));
                    String tokenId = resultSet.getString(9);
                    String authzUser = resultSet.getString(10);
                    userStoreDomain = resultSet.getString(11);
                    String consumerKey = resultSet.getString(12);
                    AuthenticatedUser user = new AuthenticatedUser();
                    user.setUserName(authzUser);
                    user.setTenantDomain(OAuth2Util.getTenantDomain(tenantId));
                    user.setUserStoreDomain(userStoreDomain);
                    AccessTokenDO dataDO = new AccessTokenDO(consumerKey, user, scope, issuedTime, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodMillis, tokenType);
                    dataDO.setAccessToken(accessToken);
                    dataDO.setRefreshToken(refreshToken);
                    dataDO.setTokenId(tokenId);
                    dataDO.setTenantID(tenantId);
                    accessTokenDOMap.put(accessToken, dataDO);
                    continue;
                }
                String scope = resultSet.getString(8).trim();
                AccessTokenDO accessTokenDO = (AccessTokenDO)((Object)accessTokenDOMap.get(accessToken));
                accessTokenDO.setScope((String[])ArrayUtils.add((Object[])accessTokenDO.getScope(), (Object)scope));
            }
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'ACTIVE or EXPIRED' access tokens for user  tenant id : " + tenantId;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return new HashSet<AccessTokenDO>(accessTokenDOMap.values());
    }

    public Set<AccessTokenDO> getAccessTokensOfUserStore(int tenantId, String userStoreDomain) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving all ACTIVE and EXPIRED access tokens of userstore: " + userStoreDomain + " tenant id: " + tenantId));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStoreDomain);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        HashMap<String, AccessTokenDO> accessTokenDOMap = new HashMap<String, AccessTokenDO>();
        try {
            String sql = OAuth2Util.getTokenPartitionedSqlByUserStore("SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, AUTHZ_USER, CONSUMER_KEY FROM (SELECT AUTHZ_USER, CONSUMER_KEY_ID, TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TENANT_ID=? AND USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID", userStoreDomain);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, userStoreDomain);
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                String accessToken = null;
                if (this.isHashDisabled) {
                    accessToken = persistenceProcessor.getPreprocessedAccessTokenIdentifier(resultSet.getString(1));
                }
                if (accessTokenDOMap.get(accessToken) == null) {
                    String refreshToken = null;
                    if (this.isHashDisabled) {
                        refreshToken = persistenceProcessor.getPreprocessedRefreshToken(resultSet.getString(2));
                    }
                    Timestamp issuedTime = resultSet.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                    Timestamp refreshTokenIssuedTime = resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                    long validityPeriodInMillis = resultSet.getLong(5);
                    long refreshTokenValidityPeriodMillis = resultSet.getLong(6);
                    String tokenType = resultSet.getString(7);
                    String[] scope = OAuth2Util.buildScopeArray(resultSet.getString(8));
                    String tokenId = resultSet.getString(9);
                    String authzUser = resultSet.getString(10);
                    String consumerKey = resultSet.getString(11);
                    AuthenticatedUser user = new AuthenticatedUser();
                    user.setUserName(authzUser);
                    user.setTenantDomain(OAuth2Util.getTenantDomain(tenantId));
                    user.setUserStoreDomain(userStoreDomain);
                    AccessTokenDO dataDO = new AccessTokenDO(consumerKey, user, scope, issuedTime, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodMillis, tokenType);
                    dataDO.setAccessToken(accessToken);
                    dataDO.setRefreshToken(refreshToken);
                    dataDO.setTokenId(tokenId);
                    dataDO.setTenantID(tenantId);
                    accessTokenDOMap.put(accessToken, dataDO);
                    continue;
                }
                String scope = resultSet.getString(8).trim();
                AccessTokenDO accessTokenDO = (AccessTokenDO)((Object)accessTokenDOMap.get(accessToken));
                accessTokenDO.setScope((String[])ArrayUtils.add((Object[])accessTokenDO.getScope(), (Object)scope));
            }
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'ACTIVE or EXPIRED' access tokens for user in store domain : " + userStoreDomain + " and tenant id : " + tenantId;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return new HashSet<AccessTokenDO>(accessTokenDOMap.values());
    }

    public void renameUserStoreDomainInAccessTokenTable(int tenantId, String currentUserStoreDomain, String newUserStoreDomain) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Renaming userstore domain: " + currentUserStoreDomain + " as: " + newUserStoreDomain + " tenant id: " + tenantId + " in IDN_OAUTH2_ACCESS_TOKEN table"));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        currentUserStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(currentUserStoreDomain);
        newUserStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(newUserStoreDomain);
        try {
            String sqlQuery = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET USER_DOMAIN=? WHERE TENANT_ID=? AND USER_DOMAIN=?";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, newUserStoreDomain);
            ps.setInt(2, tenantId);
            ps.setString(3, currentUserStoreDomain);
            int count = ps.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of rows being updated : " + count));
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while renaming user store : " + currentUserStoreDomain + " in tenant :" + tenantId, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    public List<AuthzCodeDO> getLatestAuthorizationCodesOfTenant(int tenantId) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving latest authorization codes of tenant id: " + tenantId));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<AuthzCodeDO> latestAuthzCodes = new ArrayList<AuthzCodeDO>();
        try {
            String sqlQuery = "SELECT CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY, IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER, IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE, TIME_CREATED, VALIDITY_PERIOD, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL, IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN FROM (SELECT AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, SCOPE, MAX(TIME_CREATED) TIMES FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TENANT_ID=? group by AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, SCOPE) AUTHZ_SELECTED JOIN IDN_OAUTH2_AUTHORIZATION_CODE ON AUTHZ_SELECTED.AUTHZ_USER=IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER AND AUTHZ_SELECTED.CONSUMER_KEY_ID=IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID AND AUTHZ_SELECTED.TIMES=IDN_OAUTH2_AUTHORIZATION_CODE.TIME_CREATED AND AUTHZ_SELECTED.USER_DOMAIN=IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN AND AUTHZ_SELECTED.SCOPE=IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID = ID WHERE STATE='ACTIVE'";
            ps = connection.prepareStatement(sqlQuery);
            ps.setInt(1, tenantId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String authzCodeId = rs.getString(1);
                String authzCode = rs.getString(2);
                String consumerKey = rs.getString(3);
                String authzUser = rs.getString(4);
                String[] scope = OAuth2Util.buildScopeArray(rs.getString(5));
                Timestamp issuedTime = rs.getTimestamp(6, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                long validityPeriodInMillis = rs.getLong(7);
                String callbackUrl = rs.getString(8);
                String userStoreDomain = rs.getString(9);
                AuthenticatedUser user = new AuthenticatedUser();
                user.setUserName(authzUser);
                user.setUserStoreDomain(userStoreDomain);
                user.setTenantDomain(OAuth2Util.getTenantDomain(tenantId));
                latestAuthzCodes.add(new AuthzCodeDO(user, scope, issuedTime, validityPeriodInMillis, callbackUrl, consumerKey, authzCode, authzCodeId));
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while retrieving latest authorization codes of tenant :" + tenantId, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        return latestAuthzCodes;
    }

    public List<AuthzCodeDO> getLatestAuthorizationCodesOfUserStore(int tenantId, String userStorDomain) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving latest authorization codes of userstore: " + userStorDomain + " tenant id: " + tenantId));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        String userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStorDomain);
        ArrayList<AuthzCodeDO> latestAuthzCodes = new ArrayList<AuthzCodeDO>();
        try {
            String sqlQuery = "SELECT CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY, IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER, IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE, TIME_CREATED, VALIDITY_PERIOD, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL FROM (SELECT AUTHZ_USER, CONSUMER_KEY_ID, SCOPE, MAX(TIME_CREATED) TIMES FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TENANT_ID=? AND USER_DOMAIN=? group by AUTHZ_USER, CONSUMER_KEY_ID, SCOPE) AUTHZ_SELECTED JOIN IDN_OAUTH2_AUTHORIZATION_CODE ON AUTHZ_SELECTED.AUTHZ_USER=IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER AND AUTHZ_SELECTED.CONSUMER_KEY_ID=IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID AND AUTHZ_SELECTED.TIMES=IDN_OAUTH2_AUTHORIZATION_CODE.TIME_CREATED AND AUTHZ_SELECTED.SCOPE=IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID = ID WHERE STATE='ACTIVE'";
            ps = connection.prepareStatement(sqlQuery);
            ps.setInt(1, tenantId);
            ps.setString(2, userStoreDomain);
            rs = ps.executeQuery();
            while (rs.next()) {
                String authzCodeId = rs.getString(1);
                String authzCode = rs.getString(2);
                String consumerKey = rs.getString(3);
                String authzUser = rs.getString(4);
                String[] scope = OAuth2Util.buildScopeArray(rs.getString(5));
                Timestamp issuedTime = rs.getTimestamp(6, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                long validityPeriodInMillis = rs.getLong(7);
                String callbackUrl = rs.getString(8);
                AuthenticatedUser user = new AuthenticatedUser();
                user.setUserName(authzUser);
                user.setUserStoreDomain(userStoreDomain);
                user.setTenantDomain(OAuth2Util.getTenantDomain(tenantId));
                latestAuthzCodes.add(new AuthzCodeDO(user, scope, issuedTime, validityPeriodInMillis, callbackUrl, consumerKey, authzCode, authzCodeId));
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while retrieving latest authorization codes of user store : " + userStoreDomain + " in tenant :" + tenantId, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        return latestAuthzCodes;
    }

    public void renameUserStoreDomainInAuthorizationCodeTable(int tenantId, String currentUserStoreDomain, String newUserStoreDomain) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Renaming userstore domain: " + currentUserStoreDomain + " as: " + newUserStoreDomain + " tenant id: " + tenantId + " in IDN_OAUTH2_AUTHORIZATION_CODE table"));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        currentUserStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(currentUserStoreDomain);
        newUserStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(newUserStoreDomain);
        try {
            String sqlQuery = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET USER_DOMAIN=? WHERE TENANT_ID=? AND USER_DOMAIN=?";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, newUserStoreDomain);
            ps.setInt(2, tenantId);
            ps.setString(3, currentUserStoreDomain);
            int count = ps.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of rows being updated : " + count));
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while renaming user store : " + currentUserStoreDomain + "in tenant :" + tenantId, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    public String getCodeIdByAuthorizationCode(String authzCode) throws IdentityOAuth2Exception {
        String string;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        block6: {
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Retrieving id of authorization code(hashed): " + DigestUtils.sha256Hex((String)authzCode)));
            }
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            String sql = "SELECT CODE_ID FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE AUTHORIZATION_CODE_HASH = ?";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, hashingPersistenceProcessor.getProcessedAuthzCode(authzCode));
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block6;
            String string2 = resultSet.getString("CODE_ID");
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'Code ID' for authorization code : " + authzCode;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return string;
    }

    public String getAuthzCodeByCodeId(String codeId) throws IdentityOAuth2Exception {
        String string;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving authorization code by code id: " + codeId));
            }
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            String sql = "SELECT AUTHORIZATION_CODE FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CODE_ID = ?";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, codeId);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block6;
            String string2 = resultSet.getString("AUTHORIZATION_CODE");
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'Authorization Code' for authorization code : " + codeId;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return string;
    }

    public String getTokenIdByToken(String token) throws IdentityOAuth2Exception {
        String tokenId;
        block2: {
            Map.Entry<String, String> availableDomainMapping;
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Retrieving id of access token(hashed): " + DigestUtils.sha256Hex((String)token)));
            }
            if ((tokenId = this.getTokenIdByToken(token, IdentityUtil.getPrimaryDomainName())) != null || !OAuth2Util.checkAccessTokenPartitioningEnabled() || !OAuth2Util.checkUserNameAssertionEnabled()) break block2;
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            Iterator<Map.Entry<String, String>> iterator = availableDomainMappings.entrySet().iterator();
            while (iterator.hasNext() && (tokenId = this.getTokenIdByToken(token, (availableDomainMapping = iterator.next()).getKey())) == null) {
            }
        }
        return tokenId;
    }

    private String getTokenIdByToken(String token, String userStoreDomain) throws IdentityOAuth2Exception {
        String string;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        block5: {
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            String sql = OAuth2Util.getTokenPartitionedSqlByUserStore("SELECT TOKEN_ID FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH = ?", userStoreDomain);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, hashingPersistenceProcessor.getProcessedAccessTokenIdentifier(token));
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block5;
            String string2 = resultSet.getString("TOKEN_ID");
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'Token ID' for token : " + token;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return string;
    }

    public String getTokenByTokenId(String tokenId) throws IdentityOAuth2Exception {
        String token;
        block2: {
            Map.Entry<String, String> availableDomainMapping;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving access token by token id: " + tokenId));
            }
            if ((token = this.getTokenByTokenId(tokenId, IdentityUtil.getPrimaryDomainName())) != null || !OAuth2Util.checkAccessTokenPartitioningEnabled() || !OAuth2Util.checkUserNameAssertionEnabled()) break block2;
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            Iterator<Map.Entry<String, String>> iterator = availableDomainMappings.entrySet().iterator();
            while (iterator.hasNext() && (token = this.getTokenByTokenId(tokenId, (availableDomainMapping = iterator.next()).getKey())) == null) {
            }
        }
        return token;
    }

    private String getTokenByTokenId(String tokenId, String userStoreDomain) throws IdentityOAuth2Exception {
        String string;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        block5: {
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            String sql = OAuth2Util.getTokenPartitionedSqlByUserStore("SELECT ACCESS_TOKEN FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ?", userStoreDomain);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, tokenId);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block5;
            String string2 = resultSet.getString("ACCESS_TOKEN");
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'Access Token' for token id : " + tokenId;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTokenIdIfAutzCodeGrantType(String oldAccessTokenId, String newAccessTokenId, Connection connection) throws IdentityOAuth2Exception, SQLException {
        if (log.isDebugEnabled()) {
            log.info((Object)("Updating access token reference of authorization code issued for access token id: " + oldAccessTokenId + " by new access token id:" + newAccessTokenId));
        }
        PreparedStatement prepStmt = null;
        try {
            String updateNewTokenAgaintAuthzCodeSql = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET TOKEN_ID=? WHERE TOKEN_ID=?";
            prepStmt = connection.prepareStatement(updateNewTokenAgaintAuthzCodeSql);
            prepStmt.setString(1, newAccessTokenId);
            prepStmt.setString(2, oldAccessTokenId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeStatement(prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
    }

    @Deprecated
    public Set<String> getBindingsOfScopeByScopeName(String scopeName) throws IdentityOAuth2Exception {
        HashSet<String> bindingsStringBuilder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving bindings of scope: " + scopeName));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> bindings = new HashSet<String>();
        try {
            String sql = connection.getMetaData().getDriverName().contains("Oracle") ? "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ?" : "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, scopeName);
            rs = ps.executeQuery();
            while (rs.next()) {
                String binding = rs.getString("SCOPE_BINDING");
                if (binding.isEmpty()) continue;
                bindings.add(binding);
            }
            if (log.isDebugEnabled()) {
                bindingsStringBuilder = new StringBuilder();
                for (String binding : bindings) {
                    ((StringBuilder)((Object)bindingsStringBuilder)).append(binding).append(" ");
                }
                log.debug((Object)("Binding for scope: " + scopeName + " found: " + ((StringBuilder)((Object)bindingsStringBuilder)).toString()));
            }
            bindingsStringBuilder = bindings;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error getting roles of scope - " + scopeName;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        return bindingsStringBuilder;
    }

    public Set<String> getBindingsOfScopeByScopeName(String scopeName, int tenantId) throws IdentityOAuth2Exception {
        HashSet<String> bindingStringBuilder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving bindings of scope: " + scopeName + " tenant id: " + tenantId));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> bindings = new HashSet<String>();
        try {
            String sql = connection.getMetaData().getDriverName().contains("Oracle") ? "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ? AND TENANT_ID = ?" : "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ? AND TENANT_ID = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, scopeName);
            ps.setInt(2, tenantId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String binding = rs.getString("SCOPE_BINDING");
                if (binding.isEmpty()) continue;
                bindings.add(binding);
            }
            if (log.isDebugEnabled()) {
                bindingStringBuilder = new StringBuilder();
                for (String binding : bindings) {
                    ((StringBuilder)((Object)bindingStringBuilder)).append(binding).append(" ");
                }
                log.debug((Object)("Binding for scope: " + scopeName + " found: " + ((StringBuilder)((Object)bindingStringBuilder)).toString() + " tenant id: " + tenantId));
            }
            bindingStringBuilder = bindings;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error getting bindings of scope - " + scopeName;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        return bindingStringBuilder;
    }

    public void updateAppAndRevokeTokensAndAuthzCodes(String consumerKey, Properties properties, String[] authorizationCodes, String[] accessTokens) throws IdentityOAuth2Exception, IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating state of client: " + consumerKey + " and revoking all access tokens and authorization codes."));
        }
        if (!properties.containsKey("action")) {
            throw new IdentityOAuth2Exception("Invalid operation.");
        }
        String action = properties.getProperty("action");
        Connection connection = null;
        PreparedStatement updateStateStatement = null;
        PreparedStatement revokeActiveTokensStatement = null;
        PreparedStatement deactivateActiveCodesStatement = null;
        try {
            String sqlQuery;
            connection = IdentityDatabaseUtil.getDBConnection();
            if ("revoke".equals(action)) {
                if (!properties.containsKey("new_state")) {
                    throw new IdentityOAuth2Exception("New App State is not specified.");
                }
                String newAppState = properties.getProperty("new_state");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Changing the state of the client: " + consumerKey + " to " + newAppState + " state."));
                }
                updateStateStatement = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_STATE=? WHERE CONSUMER_KEY=?");
                updateStateStatement.setString(1, newAppState);
                updateStateStatement.setString(2, consumerKey);
                updateStateStatement.execute();
            } else if ("regenerate".equals(action)) {
                if (!properties.containsKey("new_secretKey")) {
                    throw new IdentityOAuth2Exception("New Consumer Secret is not specified.");
                }
                String[] newSecretKey = properties.getProperty("new_secretKey");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Regenerating the client secret of: " + consumerKey));
                }
                updateStateStatement = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET CONSUMER_SECRET=? WHERE CONSUMER_KEY=?");
                updateStateStatement.setString(1, persistenceProcessor.getProcessedClientSecret((String)newSecretKey));
                updateStateStatement.setString(2, persistenceProcessor.getProcessedClientId(consumerKey));
                updateStateStatement.execute();
            }
            if (ArrayUtils.isNotEmpty((Object[])accessTokens)) {
                if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
                    for (String token : accessTokens) {
                        String sqlQuery2 = OAuth2Util.getTokenPartitionedSqlByToken("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND TOKEN_STATE=?", token);
                        revokeActiveTokensStatement = connection.prepareStatement(sqlQuery2);
                        revokeActiveTokensStatement.setString(1, "REVOKED");
                        revokeActiveTokensStatement.setString(2, UUID.randomUUID().toString());
                        revokeActiveTokensStatement.setString(3, consumerKey);
                        int count = revokeActiveTokensStatement.executeUpdate();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Number of rows being updated : " + count));
                    }
                } else {
                    sqlQuery = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND TOKEN_STATE=?";
                    revokeActiveTokensStatement = connection.prepareStatement(sqlQuery);
                    revokeActiveTokensStatement.setString(1, "REVOKED");
                    revokeActiveTokensStatement.setString(2, UUID.randomUUID().toString());
                    revokeActiveTokensStatement.setString(3, consumerKey);
                    revokeActiveTokensStatement.setString(4, "ACTIVE");
                    revokeActiveTokensStatement.execute();
                }
            }
            sqlQuery = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE=? WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?)";
            deactivateActiveCodesStatement = connection.prepareStatement(sqlQuery);
            deactivateActiveCodesStatement.setString(1, "REVOKED");
            deactivateActiveCodesStatement.setString(2, consumerKey);
            deactivateActiveCodesStatement.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityApplicationManagementException("Error while executing the SQL statement.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(updateStateStatement);
                IdentityDatabaseUtil.closeStatement(revokeActiveTokensStatement);
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, deactivateActiveCodesStatement);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)updateStateStatement);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)revokeActiveTokensStatement);
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)deactivateActiveCodesStatement);
    }

    private void recoverFromConAppKeyConstraintViolation(String accessToken, String consumerKey, AccessTokenDO accessTokenDO, Connection connection, String userStoreDomain, int retryAttempt) throws IdentityOAuth2Exception, SQLException {
        log.warn((Object)("Retry attempt to recover 'CON_APP_KEY' constraint violation : " + retryAttempt));
        AccessTokenDO latestNonActiveToken = this.retrieveLatestToken(connection, consumerKey, accessTokenDO.getAuthzUser(), userStoreDomain, OAuth2Util.buildScopeString(accessTokenDO.getScope()), false);
        AccessTokenDO latestActiveToken = this.retrieveLatestToken(connection, consumerKey, accessTokenDO.getAuthzUser(), userStoreDomain, OAuth2Util.buildScopeString(accessTokenDO.getScope()), true);
        if (latestActiveToken != null) {
            if (latestNonActiveToken == null || latestActiveToken.getIssuedTime().after(latestNonActiveToken.getIssuedTime())) {
                if (maxPoolSize == 0) {
                    accessTokenDO.setTokenId(latestActiveToken.getTokenId());
                    accessTokenDO.setAccessToken(latestActiveToken.getAccessToken());
                    accessTokenDO.setRefreshToken(latestActiveToken.getRefreshToken());
                    accessTokenDO.setIssuedTime(latestActiveToken.getIssuedTime());
                    accessTokenDO.setRefreshTokenIssuedTime(latestActiveToken.getRefreshTokenIssuedTime());
                    accessTokenDO.setValidityPeriodInMillis(latestActiveToken.getValidityPeriodInMillis());
                    accessTokenDO.setRefreshTokenValidityPeriodInMillis(latestActiveToken.getRefreshTokenValidityPeriodInMillis());
                    accessTokenDO.setTokenType(latestActiveToken.getTokenType());
                    log.info((Object)("Successfully recovered 'CON_APP_KEY' constraint violation with the attempt : " + retryAttempt));
                } else {
                    this.setAccessTokenState(connection, latestActiveToken.getTokenId(), "INACTIVE", UUID.randomUUID().toString(), userStoreDomain);
                    accessTokenDO.setIssuedTime(new Timestamp(new Date().getTime()));
                    this.storeAccessToken(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, retryAttempt);
                }
            } else {
                this.setAccessTokenState(connection, latestActiveToken.getTokenId(), "INACTIVE", UUID.randomUUID().toString(), userStoreDomain);
                accessTokenDO.setIssuedTime(new Timestamp(new Date().getTime()));
                this.storeAccessToken(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, retryAttempt);
            }
        } else {
            accessTokenDO.setIssuedTime(new Timestamp(new Date().getTime()));
            this.storeAccessToken(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, retryAttempt);
        }
    }

    public List<AccessTokenDO> retrieveLatestAccessTokens(String consumerKey, AuthenticatedUser authzUser, String userStoreDomain, String scope, boolean includeExpiredTokens, int limit) throws IdentityOAuth2Exception {
        return OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getLatestAccessTokens(consumerKey, authzUser, userStoreDomain, scope, includeExpiredTokens, limit);
    }

    public AccessTokenDO retrieveLatestToken(Connection connection, String consumerKey, AuthenticatedUser authzUser, String userStoreDomain, String scope, boolean active) throws IdentityOAuth2Exception {
        AccessTokenDO accessTokenDO;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving latest " + (active ? " active" : " non active") + " access token for user: " + authzUser.toString() + " client: " + consumerKey + " scope: " + scope));
        }
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authzUser.toString());
        String tenantDomain = authzUser.getTenantDomain();
        int tenantId = OAuth2Util.getTenantId(tenantDomain);
        String tenantAwareUsernameWithNoUserDomain = authzUser.getUserName();
        String userDomain = !OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal() && authzUser.isFederatedUser() ? OAuth2Util.getFederatedUserDomain(authzUser.getFederatedIdPName()) : OAuth2Util.getSanitizedUserStoreDomain(authzUser.getUserStoreDomain());
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            String hashedScope;
            String driverName = connection.getMetaData().getDriverName();
            String sql = active ? (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID =(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY" : (driverName.contains("MS SQL") || driverName.contains("Microsoft") ? "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC" : (driverName.contains("PostgreSQL") ? "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 " : (driverName.contains("Informix") ? "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN " : "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 "))))) : (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID =(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY" : (driverName.contains("MS SQL") || driverName.contains("Microsoft") ? "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC" : (driverName.contains("PostgreSQL") ? "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 " : (driverName.contains("Informix") ? "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN " : "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ")))));
            sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userDomain);
            if (!isUsernameCaseSensitive) {
                sql = sql.replace(AUTHZ_USER, LOWER_AUTHZ_USER);
            }
            if ((hashedScope = OAuth2Util.hashScopes(scope)) == null) {
                sql = sql.replace("TOKEN_SCOPE_HASH=?", "TOKEN_SCOPE_HASH IS NULL");
            }
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, persistenceProcessor.getProcessedClientId(consumerKey));
            if (isUsernameCaseSensitive) {
                prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain);
            } else {
                prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain.toLowerCase());
            }
            prepStmt.setInt(3, tenantId);
            prepStmt.setString(4, userDomain);
            if (hashedScope != null) {
                prepStmt.setString(5, hashedScope);
            }
            resultSet = prepStmt.executeQuery();
            AccessTokenDO accessTokenDO2 = null;
            if (resultSet.next()) {
                ServiceProvider serviceProvider;
                String accessToken = null;
                if (this.isHashDisabled) {
                    accessToken = persistenceProcessor.getPreprocessedAccessTokenIdentifier(resultSet.getString(1));
                }
                String refreshToken = null;
                if (resultSet.getString(2) != null && this.isHashDisabled) {
                    refreshToken = persistenceProcessor.getPreprocessedRefreshToken(resultSet.getString(2));
                }
                long issuedTime = resultSet.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone(UTC))).getTime();
                long refreshTokenIssuedTime = resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone(UTC))).getTime();
                long validityPeriodInMillis = resultSet.getLong(5);
                long refreshTokenValidityPeriodInMillis = resultSet.getLong(6);
                String userType = resultSet.getString(7);
                String tokenId = resultSet.getString(8);
                String subjectIdentifier = resultSet.getString(9);
                AuthenticatedUser user = new AuthenticatedUser();
                user.setUserName(tenantAwareUsernameWithNoUserDomain);
                user.setTenantDomain(tenantDomain);
                user.setUserStoreDomain(userDomain);
                try {
                    serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                }
                catch (IdentityApplicationManagementException e) {
                    throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                }
                user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                accessTokenDO2 = new AccessTokenDO(consumerKey, user, OAuth2Util.buildScopeArray(scope), new Timestamp(issuedTime), new Timestamp(refreshTokenIssuedTime), validityPeriodInMillis, refreshTokenValidityPeriodInMillis, userType);
                accessTokenDO2.setAccessToken(accessToken);
                accessTokenDO2.setRefreshToken(refreshToken);
                accessTokenDO2.setTokenId(tokenId);
            }
            accessTokenDO = accessTokenDO2;
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String errorMsg = "Error occurred while trying to retrieve latest 'ACTIVE' access token for Client ID : " + consumerKey + ", User ID : " + authzUser + " and  Scope : " + scope;
                if (!active) {
                    errorMsg = errorMsg.replace("ACTIVE", "NON ACTIVE");
                }
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections(null, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return accessTokenDO;
    }

    public void revokeSaaSTokensOfOtherTenants(String consumerKey, int tenantId) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Revoking access tokens of client: " + consumerKey + " tenant id: " + tenantId + " issued for other tenants"));
        }
        if (consumerKey == null) {
            log.error((Object)("Couldn't revoke token for tenant ID: " + tenantId + " because of null consumer key"));
            return;
        }
        this.revokeSaaSTokensOfOtherTenants(consumerKey, IdentityUtil.getPrimaryDomainName(), tenantId);
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            for (Map.Entry<String, String> availableDomainMapping : availableDomainMappings.entrySet()) {
                this.revokeSaaSTokensOfOtherTenants(consumerKey, availableDomainMapping.getKey(), tenantId);
            }
        }
    }

    public void revokeSaaSTokensOfOtherTenants(String consumerKey, String userStoreDomain, int tenantId) throws IdentityOAuth2Exception {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sql = OAuth2Util.getTokenPartitionedSqlByUserStore("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_STATE=? AND CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ? ) AND TENANT_ID != ? ", userStoreDomain);
            ps = connection.prepareStatement(sql);
            ps.setString(1, "REVOKED");
            ps.setString(2, UUID.randomUUID().toString());
            ps.setString(3, "ACTIVE");
            ps.setString(4, consumerKey);
            ps.setInt(5, tenantId);
            ps.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error revoking access tokens for client ID: " + consumerKey + " and tenant ID: " + tenantId;
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
    }

    private boolean isPersistenceEnabled() {
        boolean enablePersist = true;
        if (IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_ENABLE) != null) {
            enablePersist = Boolean.parseBoolean(IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_ENABLE));
        } else if (IdentityUtil.getProperty((String)FRAMEWORK_PERSISTENCE_ENABLE) != null) {
            enablePersist = Boolean.parseBoolean(IdentityUtil.getProperty((String)FRAMEWORK_PERSISTENCE_ENABLE));
        }
        return enablePersist;
    }

    private static int getTokenPersistPoolSize() {
        int maxPoolSize = 0;
        try {
            String maxPoolSizeConfigValue = IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_POOLSIZE);
            if (StringUtils.isNotBlank((String)maxPoolSizeConfigValue)) {
                maxPoolSize = Integer.parseInt(maxPoolSizeConfigValue);
            } else {
                maxPoolSizeConfigValue = IdentityUtil.getProperty((String)FRAMEWORK_PERSISTENCE_POOLSIZE);
                if (StringUtils.isNotBlank((String)maxPoolSizeConfigValue)) {
                    maxPoolSize = Integer.parseInt(maxPoolSizeConfigValue);
                }
            }
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while parsing OAuth Token Persistence PoolSize", (Throwable)e);
            }
            log.warn((Object)("OAuth Token Persistence Pool size is not configured. Using default value: " + maxPoolSize));
        }
        return maxPoolSize;
    }

    static {
        accessContextTokenQueue = new LinkedBlockingDeque<AccessContextTokenDO>();
        authContextTokenQueue = new LinkedBlockingDeque<AuthContextTokenDO>();
        maxPoolSize = TokenMgtDAO.getTokenPersistPoolSize();
        if (maxPoolSize > 0) {
            int i;
            log.info((Object)("Thread pool size for OAuth Token persistent consumer : " + maxPoolSize));
            ExecutorService threadPool = Executors.newFixedThreadPool(maxPoolSize);
            for (i = 0; i < maxPoolSize; ++i) {
                threadPool.execute(new TokenPersistenceTask(accessContextTokenQueue));
            }
            threadPool = Executors.newFixedThreadPool(maxPoolSize);
            for (i = 0; i < maxPoolSize; ++i) {
                threadPool.execute(new AuthPersistenceTask(authContextTokenQueue));
            }
        }
    }
}

