/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.AbstractOAuthDAO;
import org.wso2.carbon.identity.oauth2.dao.TokenManagementDAO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class TokenManagementDAOImpl
extends AbstractOAuthDAO
implements TokenManagementDAO {
    private static final Log log = LogFactory.getLog(TokenManagementDAOImpl.class);
    public static final String AUTHZ_USER = "AUTHZ_USER";
    public static final String LOWER_AUTHZ_USER = "LOWER(AUTHZ_USER)";
    private static final String UTC = "UTC";
    private boolean isHashDisabled = OAuth2Util.isHashDisabled();
    private static final String IDN_OAUTH2_ACCESS_TOKEN = "IDN_OAUTH2_ACCESS_TOKEN";

    @Override
    public RefreshTokenValidationDataDO validateRefreshToken(String consumerKey, String refreshToken) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"RefreshToken")) {
                log.debug((Object)("Validating refresh token(hashed): " + DigestUtils.sha256Hex((String)refreshToken) + " client: " + consumerKey));
            } else {
                log.debug((Object)("Validating refresh token for client: " + consumerKey));
            }
        }
        RefreshTokenValidationDataDO validationDataDO = new RefreshTokenValidationDataDO();
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            String driverName = connection.getMetaData().getDriverName();
            String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM ( SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC, TOKEN_STATE LIMIT 1) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM ( SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID" : (driverName.contains("MS SQL") || driverName.contains("Microsoft") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT TOP 1 ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID  = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID" : (driverName.contains("PostgreSQL") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC LIMIT 1) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID" : (driverName.contains("INFORMIX") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT FIRST 1 ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID" : "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT * FROM (SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID"))))) : (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC, TOKEN_STATE LIMIT 1) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : (driverName.contains("MS SQL") || driverName.contains("Microsoft") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOP 1 ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID  = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : (driverName.contains("PostgreSQL") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC LIMIT 1) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : (driverName.contains("INFORMIX") ? "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT FIRST 1 ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT * FROM (SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID")))));
            sql = OAuth2Util.getTokenPartitionedSqlByToken(sql, refreshToken);
            if (refreshToken == null) {
                sql = sql.replace("REFRESH_TOKEN = ?", "REFRESH_TOKEN IS NULL");
            }
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, this.getPersistenceProcessor().getProcessedClientId(consumerKey));
            if (refreshToken != null) {
                prepStmt.setString(2, this.getHashingPersistenceProcessor().getProcessedRefreshToken(refreshToken));
            }
            resultSet = prepStmt.executeQuery();
            int iterateId = 0;
            ArrayList<String> scopes = new ArrayList<String>();
            while (resultSet.next()) {
                if (iterateId == 0) {
                    if (this.isHashDisabled) {
                        validationDataDO.setAccessToken(this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(resultSet.getString(1)));
                    } else {
                        validationDataDO.setAccessToken(resultSet.getString(1));
                    }
                    String userName = resultSet.getString(2);
                    int tenantId = resultSet.getInt(3);
                    String userDomain = resultSet.getString(4);
                    String tenantDomain = OAuth2Util.getTenantDomain(tenantId);
                    validationDataDO.setScope(OAuth2Util.buildScopeArray(resultSet.getString(5)));
                    validationDataDO.setRefreshTokenState(resultSet.getString(6));
                    validationDataDO.setIssuedTime(resultSet.getTimestamp(7, Calendar.getInstance(TimeZone.getTimeZone(UTC))));
                    validationDataDO.setValidityPeriodInMillis(resultSet.getLong(8));
                    validationDataDO.setTokenId(resultSet.getString(9));
                    validationDataDO.setGrantType(resultSet.getString(10));
                    String subjectIdentifier = resultSet.getString(11);
                    validationDataDO.setTokenBindingReference(resultSet.getString(12));
                    String authenticatedIDP = null;
                    if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                        authenticatedIDP = resultSet.getString(13);
                    }
                    AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(userName, userDomain, tenantDomain, authenticatedIDP);
                    user.setAuthenticatedSubjectIdentifier(subjectIdentifier);
                    validationDataDO.setAuthorizedUser(user);
                } else {
                    scopes.add(resultSet.getString(5));
                }
                ++iterateId;
            }
            if (scopes.size() > 0 && validationDataDO != null) {
                validationDataDO.setScope((String[])ArrayUtils.addAll((Object[])validationDataDO.getScope(), (Object[])scopes.toArray(new String[scopes.size()])));
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuth2Exception("Error when validating a refresh token", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return validationDataDO;
    }

    @Override
    public AccessTokenDO getRefreshToken(String refreshToken) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"RefreshToken")) {
            log.debug((Object)("Validating refresh token(hashed): " + DigestUtils.sha256Hex((String)refreshToken)));
        }
        AccessTokenDO validationDataDO = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, ACCESS_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP.NAME FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID AS TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN AS USER_DOMAIN,TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE,REFRESH_TOKEN, ACCESS_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE AS GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID FROM (SELECT * FROM IDN_OAUTH2_ACCESS_TOKEN WHERE REFRESH_TOKEN_HASH = ? AND TOKEN_STATE='ACTIVE') IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP.ID = IDP_ID" : "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, ACCESS_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID AS TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN AS USER_DOMAIN,TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE,REFRESH_TOKEN, ACCESS_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE AS GRANT_TYPE, SUBJECT_IDENTIFIER FROM (SELECT * FROM IDN_OAUTH2_ACCESS_TOKEN WHERE REFRESH_TOKEN_HASH = ? AND TOKEN_STATE='ACTIVE') IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
        try {
            sql = OAuth2Util.getTokenPartitionedSqlByToken(sql, refreshToken);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, this.getHashingPersistenceProcessor().getProcessedRefreshToken(refreshToken));
            resultSet = prepStmt.executeQuery();
            int iterateId = 0;
            ArrayList<String> scopes = new ArrayList<String>();
            while (resultSet.next()) {
                if (iterateId == 0) {
                    ServiceProvider serviceProvider;
                    String consumerKey = this.getPersistenceProcessor().getPreprocessedClientId(resultSet.getString(1));
                    String authorizedUser = resultSet.getString(2);
                    int tenantId = resultSet.getInt(3);
                    String tenantDomain = OAuth2Util.getTenantDomain(tenantId);
                    String userDomain = resultSet.getString(4);
                    String[] scope = OAuth2Util.buildScopeArray(resultSet.getString(5));
                    Timestamp accessTokenIssuedTime = resultSet.getTimestamp(6, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                    Timestamp refreshTokenIssuedTime = resultSet.getTimestamp(7, Calendar.getInstance(TimeZone.getTimeZone(UTC)));
                    long validityPeriodInMillis = resultSet.getLong(8);
                    long refreshTokenValidityPeriodMillis = resultSet.getLong(9);
                    String tokenType = resultSet.getString(10);
                    String accessTokenIdentifier = resultSet.getString(11);
                    String tokenId = resultSet.getString(12);
                    String grantType = resultSet.getString(13);
                    String subjectIdentifier = resultSet.getString(14);
                    String authenticatedIDP = null;
                    if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                        authenticatedIDP = resultSet.getString(15);
                    }
                    AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(authorizedUser, userDomain, tenantDomain, authenticatedIDP);
                    try {
                        serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                    }
                    catch (IdentityApplicationManagementException e) {
                        throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                    }
                    user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                    validationDataDO = new AccessTokenDO(consumerKey, user, scope, accessTokenIssuedTime, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodMillis, tokenType);
                    validationDataDO.setAccessToken(accessTokenIdentifier);
                    validationDataDO.setTokenId(tokenId);
                    validationDataDO.setGrantType(grantType);
                    validationDataDO.setTenantID(tenantId);
                } else {
                    scopes.add(resultSet.getString(5));
                }
                ++iterateId;
            }
            if (scopes.size() > 0 && validationDataDO != null) {
                validationDataDO.setScope((String[])ArrayUtils.addAll((Object[])validationDataDO.getScope(), (Object[])scopes.toArray(new String[scopes.size()])));
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuth2Exception("Error while retrieving Refresh Token", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return validationDataDO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Pair<String, Integer> findTenantAndScopeOfResource(String resourceUri) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving tenant and scope for resource: " + resourceUri));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            String sql = connection.getMetaData().getDriverName().contains("Oracle") ? "SELECT SCOPES.NAME, SCOPES.TENANT_ID FROM IDN_OAUTH2_SCOPE SCOPES, IDN_OAUTH2_RESOURCE_SCOPE SCOPERESOURCES WHERE RESOURCE_PATH = ? AND SCOPERESOURCES.SCOPE_ID = SCOPES.SCOPE_ID" : "SELECT SCOPES.NAME, SCOPES.TENANT_ID FROM IDN_OAUTH2_SCOPE AS SCOPES, IDN_OAUTH2_RESOURCE_SCOPE AS SCOPERESOURCES WHERE RESOURCE_PATH = ? AND SCOPERESOURCES.SCOPE_ID = SCOPES.SCOPE_ID";
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                ps.setString(1, resourceUri);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        String scopeName = rs.getString("NAME");
                        int tenantId = rs.getInt("TENANT_ID");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found tenant id: " + tenantId + " and scope: " + scopeName + " for resource: " + resourceUri));
                        }
                        Pair pair = Pair.of((Object)scopeName, (Object)tenantId);
                        return pair;
                    }
                }
            }
            Pair<String, Integer> pair = null;
            return pair;
        }
        catch (SQLException e) {
            String errorMsg = "Error getting scopes for resource - " + resourceUri;
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
    }

    public void revokeOAuthConsentByApplicationAndUser(String username, String applicationName) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Revoking OAuth consent for application: " + applicationName + " by user: " + username));
        }
        if (username == null || applicationName == null) {
            log.error((Object)("Could not remove consent of user " + username + " for application " + applicationName));
            return;
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sql = "DELETE FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND RP_URL = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, username);
            ps.setString(2, applicationName);
            ps.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            String errorMsg = "Error deleting OAuth consent of Application " + applicationName + " and User " + username;
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    @Override
    public void revokeOAuthConsentByApplicationAndUser(String username, String tenantDomain, String applicationName) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Revoking OAuth consent for application: " + applicationName + " by user: " + username + " tenant: " + tenantDomain));
        }
        if (username == null || applicationName == null) {
            log.error((Object)("Could not remove consent of user " + username + " for application " + applicationName));
            return;
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sql = "DELETE FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND TENANT_ID=? AND RP_URL = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, username);
            ps.setInt(2, IdentityTenantUtil.getTenantId((String)tenantDomain));
            ps.setString(3, applicationName);
            ps.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            String errorMsg = "Error deleting OAuth consent of Application " + applicationName + " and User " + username;
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    @Override
    public void updateApproveAlwaysForAppConsentByResourceOwner(String tenantAwareUserName, String tenantDomain, String applicationName, String state) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting consent for " + state + " OAuth consent for application: " + applicationName + " by user: " + tenantAwareUserName + " tenant: " + tenantDomain));
        }
        if (tenantAwareUserName == null || applicationName == null) {
            log.error((Object)("Could not remove consent of user " + tenantAwareUserName + " for application " + applicationName));
            return;
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sql = "UPDATE IDN_OPENID_USER_RPS SET TRUSTED_ALWAYS=? WHERE USER_NAME = ? AND TENANT_ID=? AND RP_URL = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, state);
            ps.setString(2, tenantAwareUserName);
            ps.setInt(3, IdentityTenantUtil.getTenantId((String)tenantDomain));
            ps.setString(4, applicationName);
            ps.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            String errorMsg = "Error updating trusted always in a consent of Application " + applicationName + " and User " + tenantAwareUserName;
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    @Override
    public void updateAppAndRevokeTokensAndAuthzCodes(String consumerKey, Properties properties, String[] authorizationCodes, String[] accessTokens) throws IdentityOAuth2Exception, IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating state of client: " + consumerKey + " and revoking all access tokens and authorization codes."));
        }
        if (!properties.containsKey("action")) {
            throw new IdentityOAuth2Exception("Invalid operation.");
        }
        String action = properties.getProperty("action");
        Connection connection = null;
        PreparedStatement updateStateStatement = null;
        PreparedStatement revokeActiveTokensStatement = null;
        PreparedStatement deactivateActiveCodesStatement = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
            if ("revoke".equals(action)) {
                if (!properties.containsKey("new_state")) {
                    throw new IdentityOAuth2Exception("New App State is not specified.");
                }
                String newAppState = properties.getProperty("new_state");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Changing the state of the client: " + consumerKey + " to " + newAppState + " state."));
                }
                updateStateStatement = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_STATE=? WHERE CONSUMER_KEY=?");
                updateStateStatement.setString(1, newAppState);
                updateStateStatement.setString(2, consumerKey);
                updateStateStatement.execute();
            } else if ("regenerate".equals(action)) {
                if (!properties.containsKey("new_secretKey")) {
                    throw new IdentityOAuth2Exception("New Consumer Secret is not specified.");
                }
                String[] newSecretKey = properties.getProperty("new_secretKey");
                if (properties.containsKey("new_state")) {
                    updateStateStatement = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET CONSUMER_SECRET=?, APP_STATE=? WHERE CONSUMER_KEY=?");
                    updateStateStatement.setString(1, this.getPersistenceProcessor().getProcessedClientSecret((String)newSecretKey));
                    updateStateStatement.setString(2, properties.getProperty("new_state"));
                    updateStateStatement.setString(3, consumerKey);
                } else {
                    updateStateStatement = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET CONSUMER_SECRET=? WHERE CONSUMER_KEY=?");
                    updateStateStatement.setString(1, this.getPersistenceProcessor().getProcessedClientSecret((String)newSecretKey));
                    updateStateStatement.setString(2, consumerKey);
                }
                updateStateStatement.execute();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Regenerating the client secret of: " + consumerKey));
                }
            }
            if (ArrayUtils.isNotEmpty((Object[])accessTokens)) {
                if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
                    for (String token : accessTokens) {
                        String sqlQuery = OAuth2Util.getTokenPartitionedSqlByToken("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND TOKEN_STATE=?", token);
                        revokeActiveTokensStatement = connection.prepareStatement(sqlQuery);
                        revokeActiveTokensStatement.setString(1, "REVOKED");
                        revokeActiveTokensStatement.setString(2, UUID.randomUUID().toString());
                        revokeActiveTokensStatement.setString(3, consumerKey);
                        int count = revokeActiveTokensStatement.executeUpdate();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Number of rows being updated : " + count));
                    }
                } else {
                    revokeActiveTokensStatement = connection.prepareStatement("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND TOKEN_STATE=?");
                    revokeActiveTokensStatement.setString(1, "REVOKED");
                    revokeActiveTokensStatement.setString(2, UUID.randomUUID().toString());
                    revokeActiveTokensStatement.setString(3, consumerKey);
                    revokeActiveTokensStatement.setString(4, "ACTIVE");
                    revokeActiveTokensStatement.execute();
                }
            }
            String sqlQuery = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE=? WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?)";
            deactivateActiveCodesStatement = connection.prepareStatement(sqlQuery);
            deactivateActiveCodesStatement.setString(1, "REVOKED");
            deactivateActiveCodesStatement.setString(2, consumerKey);
            deactivateActiveCodesStatement.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityApplicationManagementException("Error while executing the SQL statement.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(updateStateStatement);
                IdentityDatabaseUtil.closeStatement(revokeActiveTokensStatement);
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, deactivateActiveCodesStatement);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)updateStateStatement);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)revokeActiveTokensStatement);
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)deactivateActiveCodesStatement);
    }

    @Override
    public void revokeSaaSTokensOfOtherTenants(String consumerKey, int tenantId) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Revoking access tokens of client: " + consumerKey + " tenant id: " + tenantId + " issued for other tenants"));
        }
        if (consumerKey == null) {
            log.error((Object)("Couldn't revoke token for tenant ID: " + tenantId + " because of null consumer key"));
            return;
        }
        this.revokeSaaSTokensOfOtherTenants(consumerKey, IdentityUtil.getPrimaryDomainName(), tenantId);
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            for (Map.Entry<String, String> availableDomainMapping : availableDomainMappings.entrySet()) {
                this.revokeSaaSTokensOfOtherTenants(consumerKey, availableDomainMapping.getKey(), tenantId);
            }
        }
    }

    @Override
    public void revokeSaaSTokensOfOtherTenants(String consumerKey, String userStoreDomain, int tenantId) throws IdentityOAuth2Exception {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sql = OAuth2Util.getTokenPartitionedSqlByUserStore("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_STATE=? AND CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ? ) AND TENANT_ID != ? ", userStoreDomain);
            ps = connection.prepareStatement(sql);
            ps.setString(1, "REVOKED");
            ps.setString(2, UUID.randomUUID().toString());
            ps.setString(3, "ACTIVE");
            ps.setString(4, consumerKey);
            ps.setInt(5, tenantId);
            ps.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error revoking access tokens for client ID: " + consumerKey + "and tenant ID:" + tenantId;
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
    }

    @Override
    public Set<String> getAllTimeAuthorizedClientIds(AuthenticatedUser authzUser) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving all authorized clients by user: " + authzUser.toString()));
        }
        PreparedStatement ps = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        ResultSet rs = null;
        HashSet<String> distinctConsumerKeys = new HashSet<String>();
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authzUser.toString());
        String tenantDomain = authzUser.getTenantDomain();
        String tenantAwareUsernameWithNoUserDomain = authzUser.getUserName();
        String userDomain = OAuth2Util.getSanitizedUserStoreDomain(authzUser.getUserStoreDomain());
        try {
            int tenantId = OAuth2Util.getTenantId(tenantDomain);
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserId("SELECT DISTINCT CONSUMER_KEY FROM IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID WHERE AUTHZ_USER=? AND IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID=? AND IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')", authzUser.toString());
            if (!isUsernameCaseSensitive) {
                sqlQuery = sqlQuery.replace(AUTHZ_USER, LOWER_AUTHZ_USER);
            }
            ps = connection.prepareStatement(sqlQuery);
            if (isUsernameCaseSensitive) {
                ps.setString(1, tenantAwareUsernameWithNoUserDomain);
            } else {
                ps.setString(1, tenantAwareUsernameWithNoUserDomain.toLowerCase());
            }
            ps.setInt(2, tenantId);
            ps.setString(3, userDomain);
            rs = ps.executeQuery();
            while (rs.next()) {
                String consumerKey = this.getPersistenceProcessor().getPreprocessedClientId(rs.getString(1));
                distinctConsumerKeys.add(consumerKey);
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuth2Exception("Error occurred while retrieving all distinct Client IDs authorized by User ID : " + authzUser + " until now", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        if (log.isDebugEnabled()) {
            StringBuilder consumerKeys = new StringBuilder();
            for (String consumerKey : distinctConsumerKeys) {
                consumerKeys.append(consumerKey).append(" ");
            }
            log.debug((Object)("Found authorized clients " + consumerKeys.toString() + " for user: " + authzUser.toString()));
        }
        return distinctConsumerKeys;
    }
}

