/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

public class SQLQueries {
    public static final String STORE_AUTHORIZATION_CODE = "INSERT INTO  IDN_OAUTH2_AUTHORIZATION_CODE (CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY_ID, CALLBACK_URL, SCOPE, AUTHZ_USER, USER_DOMAIN, TENANT_ID, TIME_CREATED, VALIDITY_PERIOD, SUBJECT_IDENTIFIER, AUTHORIZATION_CODE_HASH) SELECT ?,?,ID,?,?,?,?,?,?,?,?,? FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
    public static final String STORE_AUTHORIZATION_CODE_WITH_PKCE = "INSERT INTO  IDN_OAUTH2_AUTHORIZATION_CODE (CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY_ID, CALLBACK_URL, SCOPE, AUTHZ_USER, USER_DOMAIN, TENANT_ID, TIME_CREATED, VALIDITY_PERIOD, SUBJECT_IDENTIFIER, PKCE_CODE_CHALLENGE, PKCE_CODE_CHALLENGE_METHOD, AUTHORIZATION_CODE_HASH) SELECT ?,?,ID,?,?,?,?,?,?,?,?,?,?,? FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
    public static final String STORE_AUTHORIZATION_CODE_WITH_PKCE_IDP_NAME = "INSERT INTO  IDN_OAUTH2_AUTHORIZATION_CODE (CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY_ID, CALLBACK_URL, SCOPE, AUTHZ_USER, USER_DOMAIN, TENANT_ID, TIME_CREATED, VALIDITY_PERIOD, SUBJECT_IDENTIFIER, PKCE_CODE_CHALLENGE, PKCE_CODE_CHALLENGE_METHOD, AUTHORIZATION_CODE_HASH, IDP_ID) SELECT ?,?,IDN_OAUTH_CONSUMER_APPS.ID,?,?,?,?,?,?,?,?,?,?,?,IDP.ID FROM IDN_OAUTH_CONSUMER_APPS, IDP WHERE CONSUMER_KEY=? AND IDP.NAME=? AND IDP.TENANT_ID=?";
    public static final String VALIDATE_AUTHZ_CODE = "SELECT AUTHZ_USER, USER_DOMAIN, TENANT_ID, SCOPE, CALLBACK_URL, TIME_CREATED,VALIDITY_PERIOD, STATE, TOKEN_ID, AUTHORIZATION_CODE, CODE_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHORIZATION_CODE_HASH = ?";
    public static final String VALIDATE_AUTHZ_CODE_WITH_PKCE = "SELECT AUTHZ_USER, USER_DOMAIN, TENANT_ID, SCOPE, CALLBACK_URL, TIME_CREATED,VALIDITY_PERIOD, STATE, TOKEN_ID, AUTHORIZATION_CODE, CODE_ID, SUBJECT_IDENTIFIER, PKCE_CODE_CHALLENGE, PKCE_CODE_CHALLENGE_METHOD FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHORIZATION_CODE_HASH = ?";
    public static final String VALIDATE_AUTHZ_CODE_WITH_PKCE_IDP_NAME = "SELECT AUTHZ_USER, USER_DOMAIN, IDN_OAUTH2_AUTHORIZATION_CODE.TENANT_ID, SCOPE, CALLBACK_URL, TIME_CREATED,VALIDITY_PERIOD, STATE, TOKEN_ID, AUTHORIZATION_CODE, CODE_ID, SUBJECT_IDENTIFIER, PKCE_CODE_CHALLENGE, PKCE_CODE_CHALLENGE_METHOD, IDP.NAME FROM IDN_OAUTH2_AUTHORIZATION_CODE INNER JOIN IDP ON IDP_ID=IDP.ID AND IDN_OAUTH2_AUTHORIZATION_CODE.TENANT_ID=IDP.TENANT_ID WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHORIZATION_CODE_HASH = ?";
    public static final String RETRIEVE_CODE_ID_BY_AUTHORIZATION_CODE = "SELECT CODE_ID FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE AUTHORIZATION_CODE_HASH = ?";
    public static final String RETRIEVE_AUTHZ_CODE_BY_CODE_ID = "SELECT AUTHORIZATION_CODE FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CODE_ID = ?";
    public static final String RETRIEVE_TOKEN_ID_BY_TOKEN = "SELECT TOKEN_ID FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH = ?";
    public static final String RETRIEVE_TOKEN_BY_TOKEN_ID = "SELECT ACCESS_TOKEN FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ?";
    public static final String UPDATE_TOKEN_AGAINST_AUTHZ_CODE = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET TOKEN_ID=? WHERE AUTHORIZATION_CODE=?";
    public static final String GET_ACCESS_TOKEN_BY_AUTHZ_CODE = "SELECT AUTHORIZATION_CODE FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TOKEN_ID=?";
    public static final String UPDATE_NEW_TOKEN_AGAINST_AUTHZ_CODE = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET TOKEN_ID=? WHERE TOKEN_ID=?";
    public static final String DEACTIVATE_AUTHZ_CODE = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE='INACTIVE' WHERE AUTHORIZATION_CODE= ?";
    public static final String EXPIRE_AUTHZ_CODE = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE='EXPIRED' WHERE AUTHORIZATION_CODE= ?";
    public static final String DEACTIVATE_AUTHZ_CODE_AND_INSERT_CURRENT_TOKEN = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE='INACTIVE', TOKEN_ID=? WHERE AUTHORIZATION_CODE_HASH= ?";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_ORACLE = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD,TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_ORACLE = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD,TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_MYSQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC LIMIT 1";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_MYSQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC LIMIT 1";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_DB2SQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_DB2SQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_MSSQL = "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WITH (NOLOCK) WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_MSSQL = "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WITH (NOLOCK) WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_POSTGRESQL = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 ";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_POSTGRESQL = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 ";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_INFORMIX = "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC) TOKEN ";
    public static final String RETRIEVE_LATEST_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_INFORMIX = "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN ";
    public static final String RETRIEVE_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_STATE='ACTIVE') ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_IDP_NAME = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID)) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACTIVE_EXPIRED_ACCESS_TOKEN_BY_CLIENT_ID_USER = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACTIVE_EXPIRED_ACCESS_TOKEN_BY_CLIENT_ID_USER_IDP_NAME = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED') AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID)) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACTIVE_ACCESS_TOKEN = "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID AS TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN AS USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE AS GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT * FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH=? AND TOKEN_STATE='ACTIVE') IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACTIVE_ACCESS_TOKEN_IDP_NAME = "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT TOKEN_ID, CONSUMER_KEY,  AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID AS TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN AS USER_DOMAIN,TIME_CREATED,REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE AS GRANT_TYPE,SUBJECT_IDENTIFIER, IDN_OAUTH2_ACCESS_TOKEN.IDP_ID AS IDP_ID, TOKEN_BINDING_REF FROM (SELECT * FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH=? AND TOKEN_STATE='ACTIVE') IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID = IDP.ID";
    public static final String RETRIEVE_ACTIVE_EXPIRED_ACCESS_TOKEN = "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID WHERE ACCESS_TOKEN_HASH=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACTIVE_EXPIRED_ACCESS_TOKEN_IDP_NAME = "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE, SUBJECT_IDENTIFIER, IDN_OAUTH2_ACCESS_TOKEN.IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID WHERE ACCESS_TOKEN_HASH=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID = IDP.ID";
    public static final String UPDATE_TOKEN_STATE = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_ID=?";
    @Deprecated
    public static final String UPDATE_TOKE_STATE = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_ID=?";
    public static final String REVOKE_ACCESS_TOKEN_BY_TOKEN_ID = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_ID=?";
    public static final String REVOKE_ACCESS_TOKEN = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE ACCESS_TOKEN_HASH=?";
    public static final String REVOKE_APP_ACCESS_TOKEN = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND TOKEN_STATE=?";
    public static final String REVOKE_REFRESH_TOKEN = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE REFRESH_TOKEN=?";
    public static final String GET_ACCESS_TOKENS_BY_BINDING_REFERENCE = "SELECT ACCESS_TOKEN, CONSUMER_KEY, TOKEN_SCOPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE FROM (SELECT ACCESS_TOKEN, CONSUMER_KEY_ID, TOKEN_ID, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN_VALIDITY_PERIOD FROM IDN_OAUTH2_ACCESS_TOKEN WHERE AUTHZ_USER = ? AND TENANT_ID = ? AND USER_DOMAIN = ? AND TOKEN_BINDING_REF = ? AND (TOKEN_STATE = 'ACTIVE' OR TOKEN_STATE = 'EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String GET_ACCESS_TOKEN_BY_AUTHZUSER = "SELECT DISTINCT ACCESS_TOKEN, USER_TYPE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE AUTHZ_USER=? AND TENANT_ID=? AND TOKEN_STATE=? AND USER_DOMAIN=?";
    public static final String GET_OPEN_ID_ACCESS_TOKEN_DATA_BY_AUTHZUSER = "SELECT DISTINCT ACCESS_TOKEN, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, CONSUMER_KEY, GRANT_TYPE FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, GRANT_TYPE, CONSUMER_KEY_ID, TOKEN_ID, TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD FROM IDN_OAUTH2_ACCESS_TOKEN WHERE AUTHZ_USER=? AND TENANT_ID=? AND TOKEN_STATE=? AND USER_DOMAIN=?) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID WHERE TOKEN_SCOPE=?";
    public static final String GET_ACCESS_TOKENS_FOR_CONSUMER_KEY = "SELECT ACCESS_TOKEN FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ? ) AND TOKEN_STATE=?";
    public static final String GET_ACTIVE_DETAILS_FOR_CONSUMER_KEY = "SELECT IDN_OAUTH2_ACCESS_TOKEN.AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.ACCESS_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN, IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_SCOPE FROM IDN_OAUTH2_ACCESS_TOKEN LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON IDN_OAUTH2_ACCESS_TOKEN.TOKEN_ID=IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?) AND TOKEN_STATE=?";
    public static final String GET_ACTIVE_DETAILS_FOR_CONSUMER_KEY_IDP_NAME = "SELECT IDN_OAUTH2_ACCESS_TOKEN.AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.ACCESS_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN, IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_SCOPE, IDP.NAME FROM IDN_OAUTH2_ACCESS_TOKEN LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON IDN_OAUTH2_ACCESS_TOKEN.TOKEN_ID=IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID  JOIN  IDP ON IDN_OAUTH2_ACCESS_TOKEN.IDP_ID=IDP.ID WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?) AND TOKEN_STATE=?";
    public static final String GET_AUTHORIZATION_CODES_FOR_CONSUMER_KEY = "SELECT AUTHORIZATION_CODE   FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) ";
    public static final String GET_ACTIVE_AUTHORIZATION_CODES_FOR_CONSUMER_KEY = "SELECT AUTHORIZATION_CODE FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND STATE = ?";
    public static final String UPDATE_AUTHORIZATION_CODE_STATE_FOR_CONSUMER_KEY = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE=? WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?)";
    public static final String UPDATE_AUTHORIZATION_CODE_STATE = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE=? WHERE AUTHORIZATION_CODE_HASH=?";
    public static final String GET_AUTHORIZATION_CODES_BY_AUTHZUSER = "SELECT DISTINCT AUTHORIZATION_CODE, TIME_CREATED, VALIDITY_PERIOD  FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND STATE=?";
    public static final String GET_OPEN_ID_AUTHORIZATION_CODE_DATA_BY_AUTHZUSER = "SELECT DISTINCT AUTHORIZATION_CODE, TIME_CREATED, VALIDITY_PERIOD, CODE_ID, SCOPE, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL, CONSUMER_KEY FROM IDN_OAUTH2_AUTHORIZATION_CODE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID=IDN_OAUTH_CONSUMER_APPS.ID WHERE AUTHZ_USER=? AND IDN_OAUTH2_AUTHORIZATION_CODE.TENANT_ID=? AND IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN=? AND STATE=? AND SCOPE LIKE '%openid%'";
    public static final String GET_DISTINCT_APPS_AUTHORIZED_BY_USER_ALL_TIME = "SELECT DISTINCT CONSUMER_KEY FROM IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID WHERE AUTHZ_USER=? AND IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID=? AND IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_MYSQL = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC, TOKEN_STATE LIMIT 1) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_IDP_NAME_MYSQL = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM ( SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC, TOKEN_STATE LIMIT 1) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_DB2SQL = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_IDP_NAME_DB2SQL = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM ( SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_ORACLE = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT * FROM (SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_IDP_NAME_ORACLE = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT * FROM (SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_MSSQL = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOP 1 ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID  = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_IDP_NAME_MSSQL = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT TOP 1 ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID  = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_POSTGRESQL = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC LIMIT 1) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_IDP_NAME_POSTGRESQL = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC LIMIT 1) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_INFORMIX = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM ( SELECT FIRST 1 ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_ACCESS_TOKEN_VALIDATION_DATA_IDP_NAME_INFORMIX = "SELECT ACCESS_TOKEN, AUTHZ_USER, ACCESS_TOKEN_SELECTED.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, ACCESS_TOKEN_SELECTED.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT FIRST 1 ACCESS_TOKEN, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TOKEN_STATE, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND REFRESH_TOKEN_HASH = ? ORDER BY TIME_CREATED DESC) ACCESS_TOKEN_SELECTED LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_SELECTED.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID=IDP.ID";
    public static final String RETRIEVE_OLD_TOKEN_BY_TOKEN_HASH = "SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH = ?";
    public static final String RETRIEVE_OLD_TOKEN_BY_TOKEN_HASH_WITH_IDP_NAME = "SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, IDP_ID  FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH = ?";
    public static final String INSERT_OAUTH2_ACCESS_TOKEN = "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN (ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, USER_TYPE, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, TOKEN_BINDING_REF) SELECT ?,?,ID,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
    public static final String INSERT_OAUTH2_ACCESS_TOKEN_WITH_IDP_NAME = "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN (ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, USER_TYPE, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH,IDP_ID, TOKEN_BINDING_REF) SELECT ?,?,IDN_OAUTH_CONSUMER_APPS.ID,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,IDP.ID,? FROM IDN_OAUTH_CONSUMER_APPS, IDP WHERE CONSUMER_KEY=? AND IDP.NAME=? AND IDP.TENANT_ID=?";
    public static final String INSERT_OAUTH2_TOKEN_SCOPE = "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_SCOPE (TOKEN_ID, TOKEN_SCOPE, TENANT_ID) VALUES (?,?,?)";
    public static final String INSERT_OAUTH2_CODE_SCOPE = "INSERT INTO IDN_OAUTH2_AUTHZ_CODE_SCOPE (CODE_ID, SCOPE, TENANT_ID) VALUES (?,?,?)";
    public static final String GET_OAUTH2_CODE_SCOPE = "SELECT SCOPE FROM IDN_OAUTH2_AUTHZ_CODE_SCOPE WHERE CODE_ID=? AND TENANT_ID=?";
    public static final String STORE_OLD_TOKEN_IN_AUDIT = "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_AUDIT (TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, INVALIDATED_TIME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    public static final String STORE_OLD_TOKEN_IN_AUDIT_WITH_IDP_NAME = "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_AUDIT (TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, INVALIDATED_TIME, IDP_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    public static final String RETRIEVE_AND_STORE_IN_AUDIT = "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_AUDIT (TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, INVALIDATED_TIME) SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, ? FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ?";
    public static final String RETRIEVE_AND_STORE_IN_AUDIT_WITH_IDP_NAME = "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_AUDIT (TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, INVALIDATED_TIME, IDP_ID) SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, ?, IDP_ID FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ?";
    public static final String DELETE_OLD_TOKEN_BY_ID = "DELETE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ?";
    public static final String DELETE_ACCESS_TOKEN = "DELETE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN = ? ";
    public static final String REVOKE_SAAS_TOKENS_OF_OTHER_TENANTS = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_STATE=? AND CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ? ) AND TENANT_ID != ? ";
    public static final String DELETE_USER_RPS = "DELETE FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND RP_URL = ?";
    public static final String DELETE_USER_RPS_IN_TENANT = "DELETE FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND TENANT_ID=? AND RP_URL = ?";
    public static final String UPDATE_TRUSTED_ALWAYS_IDN_OPENID_USER_RPS = "UPDATE IDN_OPENID_USER_RPS SET TRUSTED_ALWAYS=? WHERE USER_NAME = ? AND TENANT_ID=? AND RP_URL = ?";
    public static final String RENAME_USER_STORE_IN_ACCESS_TOKENS_TABLE = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET USER_DOMAIN=? WHERE TENANT_ID=? AND USER_DOMAIN=?";
    public static final String RENAME_USER_STORE_IN_AUTHORIZATION_CODES_TABLE = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET USER_DOMAIN=? WHERE TENANT_ID=? AND USER_DOMAIN=?";
    public static final String LIST_ALL_TOKENS_IN_TENANT = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, AUTHZ_USER, ACCESS_TOKEN_TABLE.USER_DOMAIN, CONSUMER_KEY FROM (SELECT AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TENANT_ID=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String LIST_ALL_TOKENS_IN_TENANT_IDP_NAME = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, AUTHZ_USER, ACCESS_TOKEN_TABLE.USER_DOMAIN, CONSUMER_KEY, IDP.NAME FROM (SELECT AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, IDP_ID FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TENANT_ID=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH_CONSUMER_APPS.ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP.ID=IDP_ID";
    public static final String LIST_ALL_TOKENS_IN_USER_STORE = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, AUTHZ_USER, CONSUMER_KEY FROM (SELECT AUTHZ_USER, CONSUMER_KEY_ID, TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TENANT_ID=? AND USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String LIST_ALL_TOKENS_IN_USER_STORE_IDP_NAME = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, AUTHZ_USER, CONSUMER_KEY, IDP.NAME FROM (SELECT AUTHZ_USER, CONSUMER_KEY_ID, TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, IDP_ID FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TENANT_ID=? AND USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH_CONSUMER_APPS.ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP.ID=IDP_ID";
    public static final String LIST_LATEST_AUTHZ_CODES_IN_USER_DOMAIN = "SELECT CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY, IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER, IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE, TIME_CREATED, VALIDITY_PERIOD, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL FROM (SELECT AUTHZ_USER, CONSUMER_KEY_ID, SCOPE, MAX(TIME_CREATED) TIMES FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TENANT_ID=? AND USER_DOMAIN=? group by AUTHZ_USER, CONSUMER_KEY_ID, SCOPE) AUTHZ_SELECTED JOIN IDN_OAUTH2_AUTHORIZATION_CODE ON AUTHZ_SELECTED.AUTHZ_USER=IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER AND AUTHZ_SELECTED.CONSUMER_KEY_ID=IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID AND AUTHZ_SELECTED.TIMES=IDN_OAUTH2_AUTHORIZATION_CODE.TIME_CREATED AND AUTHZ_SELECTED.SCOPE=IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID = ID WHERE STATE='ACTIVE'";
    public static final String LIST_LATEST_AUTHZ_CODES_IN_USER_DOMAIN_IDP_NAME = "SELECT CODE_ID, AUTHORIZATION_CODE,CONSUMER_KEY, IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER, IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE, TIME_CREATED, VALIDITY_PERIOD, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL, IDP.NAME FROM (SELECT AUTHZ_USER, CONSUMER_KEY_ID, SCOPE, MAX(TIME_CREATED) TIMES, IDP_ID FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TENANT_ID=? AND USER_DOMAIN=? GROUP BY AUTHZ_USER, CONSUMER_KEY_ID, SCOPE, IDP_ID) AUTHZ_SELECTED JOIN IDN_OAUTH2_AUTHORIZATION_CODE ON AUTHZ_SELECTED.AUTHZ_USER=IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER AND AUTHZ_SELECTED.CONSUMER_KEY_ID=IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID AND AUTHZ_SELECTED.TIMES=IDN_OAUTH2_AUTHORIZATION_CODE.TIME_CREATED AND AUTHZ_SELECTED.SCOPE=IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID = IDN_OAUTH_CONSUMER_APPS.ID JOIN IDP ON IDN_OAUTH2_AUTHORIZATION_CODE.IDP_ID = IDP.ID WHERE STATE='ACTIVE'";
    public static final String LIST_LATEST_AUTHZ_CODES_IN_TENANT = "SELECT CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY, IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER, IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE, TIME_CREATED, VALIDITY_PERIOD, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL, IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN FROM (SELECT AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, SCOPE, MAX(TIME_CREATED) TIMES FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TENANT_ID=? group by AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, SCOPE) AUTHZ_SELECTED JOIN IDN_OAUTH2_AUTHORIZATION_CODE ON AUTHZ_SELECTED.AUTHZ_USER=IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER AND AUTHZ_SELECTED.CONSUMER_KEY_ID=IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID AND AUTHZ_SELECTED.TIMES=IDN_OAUTH2_AUTHORIZATION_CODE.TIME_CREATED AND AUTHZ_SELECTED.USER_DOMAIN=IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN AND AUTHZ_SELECTED.SCOPE=IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID = ID WHERE STATE='ACTIVE'";
    public static final String LIST_LATEST_AUTHZ_CODES_IN_TENANT_IDP_NAME = "SELECT CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY, IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER, IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE, TIME_CREATED, VALIDITY_PERIOD, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL, IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN, IDP.NAME FROM (SELECT AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, SCOPE, MAX(TIME_CREATED) TIMES, IDP_ID FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TENANT_ID=? GROUP BY AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, SCOPE, IDP_ID) AUTHZ_SELECTED JOIN IDN_OAUTH2_AUTHORIZATION_CODE ON AUTHZ_SELECTED.AUTHZ_USER=IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER AND AUTHZ_SELECTED.CONSUMER_KEY_ID=IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID AND AUTHZ_SELECTED.TIMES=IDN_OAUTH2_AUTHORIZATION_CODE.TIME_CREATED AND AUTHZ_SELECTED.USER_DOMAIN=IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN AND AUTHZ_SELECTED.SCOPE=IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID = IDN_OAUTH_CONSUMER_APPS.ID JOIN IDP ON IDN_OAUTH2_AUTHORIZATION_CODE.IDP_ID = IDP.ID WHERE STATE='ACTIVE'";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_MYSQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID =(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC LIMIT 1";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_MYSQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID =(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC LIMIT 1";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_ORACLE = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_ORACLE = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_DB2SQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_DB2SQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_MSSQL = "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_MSSQL = "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_POSTGRESQL = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 ";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_POSTGRESQL = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 ";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_INFORMIX = "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN ";
    public static final String RETRIEVE_LATEST_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_INFORMIX = "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN ";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_MYSQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID =(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC LIMIT 1";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_MYSQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID =(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC LIMIT 1";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_ORACLE = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_ORACLE = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_DB2SQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_DB2SQL = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_MSSQL = "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_MSSQL = "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_POSTGRESQL = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 ";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_POSTGRESQL = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 ";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_INFORMIX = "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN ";
    public static final String RETRIEVE_LATEST_NON_ACTIVE_ACCESS_TOKEN_BY_CLIENT_ID_USER_SCOPE_IDP_NAME_INFORMIX = "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN ";
    public static final String ADD_SCOPE = "INSERT INTO IDN_OAUTH2_SCOPE (NAME, DISPLAY_NAME, DESCRIPTION, TENANT_ID, SCOPE_TYPE) VALUES(?,?,?,?,?)";
    public static final String ADD_SCOPE_BINDING = "INSERT INTO IDN_OAUTH2_SCOPE_BINDING (SCOPE_ID, SCOPE_BINDING, BINDING_TYPE) VALUES(?,?,?)";
    public static final String UPDATE_SCOPE = "UPDATE IDN_OAUTH2_SCOPE SET DISPLAY_NAME=?, DESCRIPTION=? WHERE SCOPE_ID=? ";
    public static final String RETRIEVE_ALL_SCOPES = "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING ,SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=?";
    public static final String RETRIEVE_ALL_OAUTH2_SCOPES = "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING ,SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPES.SCOPE_TYPE=?";
    public static final String RETRIEVE_SCOPES_BY_BINDING_TYPE = "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPEBINDINGS.BINDING_TYPE=? AND SCOPES.SCOPE_TYPE=?";
    public static final String RETRIEVE_ALL_SCOPES_ORACLE = "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING, SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=?";
    public static final String RETRIEVE_ALL_OAUTH2_SCOPES_ORACLE = "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING, SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPES.SCOPE_TYPE=?";
    public static final String RETRIEVE_SCOPES_ORACLE_BY_BINDING_TYPE = "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPEBINDINGS.BINDING_TYPE=? AND SCOPES.SCOPE_TYPE=?";
    public static final String RETRIEVE_REQUESTED_OAUTH2_SCOPES = "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING, SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPES.SCOPE_TYPE=? AND SCOPES.NAME IN (?)";
    public static final String RETRIEVE_REQUESTED_ALL_SCOPES_WITHOUT_SCOPE_TYPE = "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING, SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPES.NAME IN (?)";
    public static final String RETRIEVE_SCOPES_WITH_PAGINATION_MYSQL = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id; LIMIT :limit; OFFSET :offset;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_SCOPES_WITH_PAGINATION_ORACLE = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id; AND ROWNUM <= :limit;) FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID = SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_SCOPES_WITH_PAGINATION_DB2SQL = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id; FETCH FIRST :limit; ROWS ONLY) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_SCOPES_WITH_PAGINATION_MSSQL = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT TOP (:limit;) SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID = SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_SCOPES_WITH_PAGINATION_POSTGRESQL = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id; LIMIT :limit;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_SCOPES_WITH_PAGINATION_INFORMIX = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT FIRST :limit; * FROM  (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id;) RESULT) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_ALL_SCOPES_WITH_PAGINATION_MYSQL = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id; LIMIT :limit; OFFSET :offset;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_ALL_SCOPES_WITH_PAGINATION_ORACLE = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE SCOPES WHERE SCOPES.TENANT_ID = :tenant_id; AND ROWNUM <= :limit;) FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID = SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_ALL_SCOPES_WITH_PAGINATION_DB2SQL = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id; FETCH FIRST :limit; ROWS ONLY) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_ALL_SCOPES_WITH_PAGINATION_MSSQL = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT TOP (:limit;) SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID = SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_ALL_SCOPES_WITH_PAGINATION_POSTGRESQL = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id; LIMIT :limit;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_ALL_SCOPES_WITH_PAGINATION_INFORMIX = "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT FIRST :limit; * FROM  (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id;) RESULT) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID";
    public static final String RETRIEVE_SCOPE_BY_NAME = "SELECT SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING,SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME=? AND SCOPES.TENANT_ID=? AND SCOPES.SCOPE_TYPE=?";
    public static final String RETRIEVE_SCOPE_BY_NAME_ORACLE = "SELECT SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING, SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME=? AND SCOPES.TENANT_ID=? AND SCOPES.SCOPE_TYPE=?";
    public static final String RETRIEVE_SCOPE_ID_BY_NAME = "SELECT SCOPE_ID FROM IDN_OAUTH2_SCOPE WHERE NAME=? AND TENANT_ID=? AND SCOPE_TYPE=?";
    public static final String RETRIEVE_SCOPE_ID_BY_NAME_WITHOUT_SCOPE_TYPE = "SELECT SCOPE_ID FROM IDN_OAUTH2_SCOPE WHERE NAME=? AND TENANT_ID=?";
    public static final String DELETE_SCOPE_BY_NAME = "DELETE FROM IDN_OAUTH2_SCOPE WHERE NAME = ? AND TENANT_ID = ? AND SCOPE_TYPE=?";
    public static final String DELETE_BINDINGS_OF_SCOPE = "DELETE FROM IDN_OAUTH2_SCOPE_BINDING WHERE SCOPE_ID = ?";
    public static final String RETRIEVE_SCOPE_NAME_FOR_RESOURCE = "SELECT SCOPES.NAME FROM IDN_OAUTH2_SCOPE AS SCOPES, IDN_OAUTH2_RESOURCE_SCOPE AS SCOPERESOURCES WHERE RESOURCE_PATH = ? AND SCOPERESOURCES.SCOPE_ID = SCOPES.SCOPE_ID";
    public static final String RETRIEVE_SCOPE_NAME_FOR_RESOURCE_ORACLE = "SELECT SCOPES.NAME FROM IDN_OAUTH2_SCOPE SCOPES, IDN_OAUTH2_RESOURCE_SCOPE SCOPERESOURCES WHERE RESOURCE_PATH = ? AND SCOPERESOURCES.SCOPE_ID = SCOPES.SCOPE_ID";
    public static final String RETRIEVE_SCOPE_WITH_TENANT_FOR_RESOURCE = "SELECT SCOPES.NAME, SCOPES.TENANT_ID FROM IDN_OAUTH2_SCOPE AS SCOPES, IDN_OAUTH2_RESOURCE_SCOPE AS SCOPERESOURCES WHERE RESOURCE_PATH = ? AND SCOPERESOURCES.SCOPE_ID = SCOPES.SCOPE_ID";
    public static final String RETRIEVE_SCOPE_WITH_TENANT_FOR_RESOURCE_ORACLE = "SELECT SCOPES.NAME, SCOPES.TENANT_ID FROM IDN_OAUTH2_SCOPE SCOPES, IDN_OAUTH2_RESOURCE_SCOPE SCOPERESOURCES WHERE RESOURCE_PATH = ? AND SCOPERESOURCES.SCOPE_ID = SCOPES.SCOPE_ID";
    public static final String RETRIEVE_BINDINGS_OF_SCOPE = "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ?";
    public static final String RETRIEVE_BINDINGS_OF_SCOPE_ORACLE = "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ?";
    public static final String RETRIEVE_BINDINGS_OF_SCOPE_FOR_TENANT = "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ? AND TENANT_ID = ?";
    public static final String RETRIEVE_BINDINGS_OF_SCOPE_FOR_TENANT_ORACLE = "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ? AND TENANT_ID = ?";
    public static final String RETRIEVE_REFRESH_TOKEN = "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, ACCESS_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID AS TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN AS USER_DOMAIN,TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE,REFRESH_TOKEN, ACCESS_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE AS GRANT_TYPE, SUBJECT_IDENTIFIER FROM (SELECT * FROM IDN_OAUTH2_ACCESS_TOKEN WHERE REFRESH_TOKEN_HASH = ? AND TOKEN_STATE='ACTIVE') IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
    public static final String RETRIEVE_REFRESH_TOKEN_WITH_IDP_NAME = "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, ACCESS_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, IDP.NAME FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID AS TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN AS USER_DOMAIN,TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE,REFRESH_TOKEN, ACCESS_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE AS GRANT_TYPE, SUBJECT_IDENTIFIER, IDP_ID FROM (SELECT * FROM IDN_OAUTH2_ACCESS_TOKEN WHERE REFRESH_TOKEN_HASH = ? AND TOKEN_STATE='ACTIVE') IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP.ID = IDP_ID";
    public static final String RETRIEVE_TOKEN_BINDING_BY_TOKEN_ID = "SELECT TOKEN_BINDING_TYPE, TOKEN_BINDING_REF, TOKEN_BINDING_VALUE FROM IDN_OAUTH2_TOKEN_BINDING WHERE TOKEN_ID = ?";
    public static final String RETRIEVE_TOKEN_BINDING_REF_EXISTS = "SELECT COUNT(*) AS TOTAL FROM IDN_OAUTH2_TOKEN_BINDING WHERE TOKEN_BINDING_REF = ?";
    public static final String STORE_TOKEN_BINDING = "INSERT INTO IDN_OAUTH2_TOKEN_BINDING (TOKEN_ID, TOKEN_BINDING_TYPE, TOKEN_BINDING_REF, TOKEN_BINDING_VALUE, TENANT_ID) VALUES (?, ?, ?, ?, ?)";
    public static final String DELETE_TOKEN_BINDING_BY_TOKEN_ID = "DELETE FROM IDN_OAUTH2_TOKEN_BINDING WHERE TOKEN_ID = ?";
    public static final String RETRIEVE_TOKEN_BINDING_REFERENCE_TOKEN_ID = "SELECT TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ? AND TENANT_ID = ?";
    public static final String RETRIEVE_AUTHZ_USER_BY_TOKEN_BINDING_REFERENCE = "SELECT ACCESS_TOKEN FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ?";
    public static final String GET_ACCESS_TOKENS_AND_TOKEN_IDS_FOR_CONSUMER_KEY = "SELECT DISTINCT ACCESS_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, TIME_CREATED, VALIDITY_PERIOD FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, GRANT_TYPE, CONSUMER_KEY_ID, TOKEN_ID, TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ? ) AND TOKEN_STATE=?) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID WHERE TOKEN_SCOPE=?";
    public static final String GET_DETAILED_ACTIVE_AUTHORIZATION_CODES_FOR_CONSUMER_KEY = "SELECT AUTHORIZATION_CODE, CODE_ID, TIME_CREATED, VALIDITY_PERIOD, SCOPE FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND STATE = ? AND SCOPE LIKE '%openid%'";

    private SQLQueries() {
    }
}

