/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.OldAccessTokenDO;

public class OldTokensCleanDAO {
    private static final Log log = LogFactory.getLog(OldTokensCleanDAO.class);

    public void cleanupTokenByTokenId(String tokenId, Connection connection) throws SQLException {
        try {
            connection.setAutoCommit(false);
            if (OAuthServerConfiguration.getInstance().useRetainOldAccessTokens()) {
                String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_AUDIT (TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, INVALIDATED_TIME, IDP_ID) SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, ?, IDP_ID FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ?" : "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_AUDIT (TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, INVALIDATED_TIME) SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, ? FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ?";
                PreparedStatement prepStmt = connection.prepareStatement(sql);
                prepStmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                prepStmt.setString(2, tokenId);
                prepStmt.executeUpdate();
            }
            this.removeTokenFromMainTable(tokenId, connection);
            connection.commit();
        }
        catch (SQLException e) {
            connection.rollback();
            log.error((Object)"SQL error occurred while cleanup token by tokenId", (Throwable)e);
        }
    }

    public void cleanupTokenByTokenValue(String token, Connection connection) throws SQLException {
        OldAccessTokenDO oldAccessTokenObject = new OldAccessTokenDO();
        String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, IDP_ID  FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH = ?" : "SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH = ?";
        PreparedStatement prepStmt = connection.prepareStatement(sql);
        prepStmt.setString(1, token);
        ResultSet resultSet = prepStmt.executeQuery();
        if (resultSet.next()) {
            oldAccessTokenObject.setTokenId(resultSet.getString(1));
            oldAccessTokenObject.setAccessToken(resultSet.getString(2));
            oldAccessTokenObject.setRefreshToken(resultSet.getString(3));
            oldAccessTokenObject.setConsumerKeyId(resultSet.getInt(4));
            oldAccessTokenObject.setAuthzUser(resultSet.getString(5));
            oldAccessTokenObject.setTenantId(resultSet.getInt(6));
            oldAccessTokenObject.setUserDomain(resultSet.getString(7));
            oldAccessTokenObject.setUserType(resultSet.getString(8));
            oldAccessTokenObject.setGrantType(resultSet.getString(9));
            oldAccessTokenObject.setTimeCreated(resultSet.getTimestamp(10));
            oldAccessTokenObject.setRefreshTokenTimeCreated(resultSet.getTimestamp(11));
            oldAccessTokenObject.setValdityPeriod(resultSet.getLong(12));
            oldAccessTokenObject.setRefreshTokenValidityPeriod(resultSet.getLong(13));
            oldAccessTokenObject.setTokenScopeHash(resultSet.getString(14));
            oldAccessTokenObject.setTokenState(resultSet.getString(15));
            oldAccessTokenObject.setTokenStateId(resultSet.getString(16));
            oldAccessTokenObject.setSubjectIdentifier(resultSet.getString(17));
            oldAccessTokenObject.setAccessTokenHash(resultSet.getString(18));
            oldAccessTokenObject.setRefreshTokenHash(resultSet.getString(19));
            if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                oldAccessTokenObject.setIdpId(resultSet.getInt(20));
            }
        }
        if (OAuthServerConfiguration.getInstance().useRetainOldAccessTokens()) {
            this.saveTokenInAuditTable(oldAccessTokenObject, connection);
        }
        this.removeTokenFromMainTable(oldAccessTokenObject.getTokenId(), connection);
    }

    private void saveTokenInAuditTable(OldAccessTokenDO oldAccessTokenDAO, Connection connection) throws SQLException {
        String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_AUDIT (TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, INVALIDATED_TIME, IDP_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)" : "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_AUDIT (TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, USER_TYPE, GRANT_TYPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, TOKEN_STATE_ID, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, INVALIDATED_TIME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement insertintoaudittable = connection.prepareStatement(sql);
        insertintoaudittable.setString(1, oldAccessTokenDAO.getTokenId());
        insertintoaudittable.setString(2, oldAccessTokenDAO.getAccessToken());
        insertintoaudittable.setString(3, oldAccessTokenDAO.getRefreshToken());
        insertintoaudittable.setInt(4, oldAccessTokenDAO.getConsumerKeyId());
        insertintoaudittable.setString(5, oldAccessTokenDAO.getAuthzUserValue());
        insertintoaudittable.setInt(6, oldAccessTokenDAO.getTenantId());
        insertintoaudittable.setString(7, oldAccessTokenDAO.getUserDomain());
        insertintoaudittable.setString(8, oldAccessTokenDAO.getUserType());
        insertintoaudittable.setString(9, oldAccessTokenDAO.getGrantType());
        insertintoaudittable.setTimestamp(10, oldAccessTokenDAO.getTimeCreated());
        insertintoaudittable.setTimestamp(11, oldAccessTokenDAO.getRefreshTokenTimeCreated());
        insertintoaudittable.setLong(12, oldAccessTokenDAO.getValdityPeriod());
        insertintoaudittable.setLong(13, oldAccessTokenDAO.getRefreshTokenValidityPeriod());
        insertintoaudittable.setString(14, oldAccessTokenDAO.getTokenScopeHash());
        insertintoaudittable.setString(15, oldAccessTokenDAO.getTokenState());
        insertintoaudittable.setString(16, oldAccessTokenDAO.getTokenStateId());
        insertintoaudittable.setString(17, oldAccessTokenDAO.getSubjectIdentifier());
        insertintoaudittable.setString(18, oldAccessTokenDAO.getAccessTokenHash());
        insertintoaudittable.setString(19, oldAccessTokenDAO.getRefreshTokenHash());
        insertintoaudittable.setTimestamp(20, new Timestamp(System.currentTimeMillis()));
        if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
            insertintoaudittable.setInt(21, oldAccessTokenDAO.getIdpId());
        }
        insertintoaudittable.execute();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully saved old access token in audit table. Token ID: " + oldAccessTokenDAO.getTokenId()));
        }
    }

    private void removeTokenFromMainTable(String oldAccessTokenID, Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        try {
            PreparedStatement deletefromaccesstokentable = connection.prepareStatement("DELETE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ?");
            deletefromaccesstokentable.setString(1, oldAccessTokenID);
            deletefromaccesstokentable.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully old access token deleted from access token table. Token ID: " + oldAccessTokenID));
            }
            connection.commit();
        }
        catch (SQLException e) {
            connection.rollback();
            log.error((Object)"SQL error occurred while remove token from main table", (Throwable)e);
        }
    }

    public void cleanupTokensInBatch(List<String> oldTokens, Connection connection) throws SQLException {
        for (String token : oldTokens) {
            this.cleanupTokenByTokenValue(token, connection);
        }
    }
}

