/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeServerException;
import org.wso2.carbon.identity.oauth2.Oauth2ScopeConstants;
import org.wso2.carbon.identity.oauth2.bean.Scope;
import org.wso2.carbon.identity.oauth2.bean.ScopeBinding;
import org.wso2.carbon.identity.oauth2.dao.OAuthScopeDAO;
import org.wso2.carbon.identity.oauth2.util.NamedPreparedStatement;
import org.wso2.carbon.identity.oauth2.util.Oauth2ScopeUtils;
import org.wso2.carbon.utils.DBUtils;

public class OAuthScopeDAOImpl
implements OAuthScopeDAO {
    private static final Log log = LogFactory.getLog(OAuthScopeDAOImpl.class);

    @Override
    public void addScope(Scope scope, int tenantID) throws IdentityOAuth2ScopeException {
        if (scope == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Scope is not defined");
            }
            throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_BAD_REQUEST_SCOPE_NAME_NOT_SPECIFIED, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding scope :" + scope.getName()));
        }
        try (Connection conn = IdentityDatabaseUtil.getDBConnection();){
            try {
                this.addScope(scope, conn, tenantID);
                IdentityDatabaseUtil.commitTransaction((Connection)conn);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)conn);
                String msg = "SQL error occurred while creating scope :" + scope.getName();
                throw new IdentityOAuth2ScopeServerException(msg, e1);
            }
        }
        catch (SQLException e) {
            String msg = "Error occurred while creating scope :" + scope.getName();
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Scope> getAllScopes(int tenantID) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get all scopes for tenantId  :" + tenantID));
        }
        HashSet scopes = new HashSet();
        HashMap<Integer, Scope> scopeMap = new HashMap<Integer, Scope>();
        try (Connection conn = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            String sql = conn.getMetaData().getDriverName().contains("Oracle") ? "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING, SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPES.SCOPE_TYPE=?" : "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING ,SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPES.SCOPE_TYPE=?";
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setInt(1, tenantID);
                ps.setString(2, "OAUTH2");
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        int scopeID = rs.getInt(1);
                        String name = rs.getString(2);
                        String displayName = rs.getString(3);
                        String description = rs.getString(4);
                        String binding = rs.getString(5);
                        String bindingType = rs.getString(6);
                        if (scopeMap.containsKey(scopeID) && scopeMap.get(scopeID) != null) {
                            ((Scope)scopeMap.get(scopeID)).setName(name);
                            ((Scope)scopeMap.get(scopeID)).setDescription(description);
                            ((Scope)scopeMap.get(scopeID)).setDisplayName(displayName);
                            if (binding == null) continue;
                            ((Scope)scopeMap.get(scopeID)).addScopeBinding(bindingType, binding);
                            continue;
                        }
                        scopeMap.put(scopeID, new Scope(name, displayName, new ArrayList<ScopeBinding>(), description));
                        if (binding == null) continue;
                        ((Scope)scopeMap.get(scopeID)).addScopeBinding(bindingType, binding);
                    }
                }
            }
            for (Map.Entry entry : scopeMap.entrySet()) {
                scopes.add(entry.getValue());
            }
            HashSet hashSet = scopes;
            return hashSet;
        }
        catch (SQLException e) {
            String msg = "Error occurred while getting all OAUTH2 scopes in tenant :" + tenantID;
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    @Override
    public Set<Scope> getAllScopes(int tenantID, Boolean includeOIDCScopes) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get all scopes for tenantId  :" + tenantID + " including OIDC scope: " + includeOIDCScopes));
        }
        if (includeOIDCScopes.booleanValue()) {
            return this.getAllScopesIncludingOIDCScopes(tenantID);
        }
        return this.getAllScopes(tenantID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<Scope> getAllScopesIncludingOIDCScopes(int tenantID) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get all scopes including OAUTH2 and OIDC scopes for tenantId  :" + tenantID));
        }
        HashSet scopes = new HashSet();
        HashMap<Integer, Scope> scopeMap = new HashMap<Integer, Scope>();
        try (Connection conn = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            String sql = conn.getMetaData().getDriverName().contains("Oracle") ? "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING, SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=?" : "SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING ,SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=?";
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setInt(1, tenantID);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        int scopeID = rs.getInt(1);
                        String name = rs.getString(2);
                        String displayName = rs.getString(3);
                        String description = rs.getString(4);
                        String binding = rs.getString(5);
                        String bindingType = rs.getString(6);
                        if (scopeMap.containsKey(scopeID) && scopeMap.get(scopeID) != null) {
                            ((Scope)scopeMap.get(scopeID)).setName(name);
                            ((Scope)scopeMap.get(scopeID)).setDescription(description);
                            ((Scope)scopeMap.get(scopeID)).setDisplayName(displayName);
                            if (binding == null) continue;
                            ((Scope)scopeMap.get(scopeID)).addScopeBinding(bindingType, binding);
                            continue;
                        }
                        scopeMap.put(scopeID, new Scope(name, displayName, new ArrayList<ScopeBinding>(), description));
                        if (binding == null) continue;
                        ((Scope)scopeMap.get(scopeID)).addScopeBinding(bindingType, binding);
                    }
                }
            }
            for (Map.Entry entry : scopeMap.entrySet()) {
                scopes.add(entry.getValue());
            }
            HashSet hashSet = scopes;
            return hashSet;
        }
        catch (SQLException e) {
            String msg = "Error occurred while getting all scopes in tenant :" + tenantID;
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Scope> getRequestedScopesOnly(int tenantID, Boolean includeOIDCScopes, String requestedScopes) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Get requested scopes for scopes: %s for tenantId: %s with includeOIDCScopes: %s", requestedScopes, tenantID, includeOIDCScopes));
        }
        String sql = includeOIDCScopes != false ? String.format("SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING, SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPES.NAME IN (?)", new Object[0]) : String.format("SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING, SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPES.SCOPE_TYPE=? AND SCOPES.NAME IN (?)", new Object[0]);
        List<String> requestedScopeList = Arrays.asList(requestedScopes.split("\\s+"));
        String sqlIN = requestedScopeList.stream().map(x -> String.valueOf(x)).collect(Collectors.joining("', '", "('", "')"));
        sql = sql.replace("(?)", sqlIN);
        HashSet scopes = new HashSet();
        HashMap<Integer, Scope> scopeMap = new HashMap<Integer, Scope>();
        try (Connection conn = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setInt(1, tenantID);
                if (!includeOIDCScopes.booleanValue()) {
                    ps.setString(2, "OAUTH2");
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        int scopeID = rs.getInt(1);
                        String name = rs.getString(2);
                        String displayName = rs.getString(3);
                        String description = rs.getString(4);
                        String binding = rs.getString(5);
                        String bindingType = rs.getString(6);
                        if (scopeMap.containsKey(scopeID) && scopeMap.get(scopeID) != null) {
                            ((Scope)scopeMap.get(scopeID)).setName(name);
                            ((Scope)scopeMap.get(scopeID)).setDescription(description);
                            ((Scope)scopeMap.get(scopeID)).setDisplayName(displayName);
                            if (binding == null) continue;
                            ((Scope)scopeMap.get(scopeID)).addScopeBinding(bindingType, binding);
                            continue;
                        }
                        scopeMap.put(scopeID, new Scope(name, displayName, new ArrayList<ScopeBinding>(), description));
                        if (binding == null) continue;
                        ((Scope)scopeMap.get(scopeID)).addScopeBinding(bindingType, binding);
                    }
                }
            }
            for (Map.Entry entry : scopeMap.entrySet()) {
                scopes.add(entry.getValue());
            }
            HashSet hashSet = scopes;
            return hashSet;
        }
        catch (SQLException e) {
            String msg = "Error occurred while getting requested scopes in tenant :" + tenantID;
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Scope> getScopes(int tenantID, String bindingType) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get scopes for tenantId  :" + tenantID + " and bindingType: " + bindingType));
        }
        HashSet scopes = new HashSet();
        HashMap<Integer, Scope> scopeMap = new HashMap<Integer, Scope>();
        try (Connection conn = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement ps = conn.prepareStatement("SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.TENANT_ID=? AND SCOPEBINDINGS.BINDING_TYPE=? AND SCOPES.SCOPE_TYPE=?");){
                ps.setInt(1, tenantID);
                ps.setString(2, bindingType);
                ps.setString(3, "OAUTH2");
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        int scopeID = rs.getInt(1);
                        String name = rs.getString(2);
                        String displayName = rs.getString(3);
                        String description = rs.getString(4);
                        String binding = rs.getString(5);
                        if (scopeMap.containsKey(scopeID) && scopeMap.get(scopeID) != null) {
                            ((Scope)scopeMap.get(scopeID)).setName(name);
                            ((Scope)scopeMap.get(scopeID)).setDescription(description);
                            ((Scope)scopeMap.get(scopeID)).setDisplayName(displayName);
                            if (binding == null) continue;
                            ((Scope)scopeMap.get(scopeID)).addScopeBinding(bindingType, binding);
                            continue;
                        }
                        scopeMap.put(scopeID, new Scope(name, displayName, new ArrayList<ScopeBinding>(), description));
                        if (binding == null) continue;
                        ((Scope)scopeMap.get(scopeID)).addScopeBinding(bindingType, binding);
                    }
                }
            }
            for (Map.Entry entry : scopeMap.entrySet()) {
                scopes.add(entry.getValue());
            }
            HashSet hashSet = scopes;
            return hashSet;
        }
        catch (SQLException e) {
            String msg = "Error occurred while getting all scopes ";
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    @Override
    public Set<Scope> getScopesWithPagination(Integer offset, Integer limit, int tenantID) throws IdentityOAuth2ScopeServerException {
        return this.getScopesWithPagination(offset, limit, tenantID, false);
    }

    private NamedPreparedStatement getPreparedStatementForGetScopesWithPagination(Integer offset, Integer limit, int tenantID, Connection conn) throws SQLException {
        String driverName = conn.getMetaData().getDriverName();
        String query = driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id; LIMIT :limit; OFFSET :offset;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID" : (conn.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id; FETCH FIRST :limit; ROWS ONLY) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID" : (driverName.contains("MS SQL") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT TOP (:limit;) SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID = SCOPEBINDINGS.SCOPE_ID" : (driverName.contains("Microsoft") || driverName.contains("microsoft") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT TOP (:limit;) SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID = SCOPEBINDINGS.SCOPE_ID" : (driverName.contains("PostgreSQL") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id; LIMIT :limit;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID" : (driverName.contains("Informix") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT FIRST :limit; * FROM  (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id;) RESULT) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID" : "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE SCOPES WHERE SCOPES.SCOPE_TYPE = :scope_type; AND SCOPES.TENANT_ID = :tenant_id; AND ROWNUM <= :limit;) FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID = SCOPEBINDINGS.SCOPE_ID")))));
        NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(conn, query);
        namedPreparedStatement.setString("scope_type", "OAUTH2");
        namedPreparedStatement.setInt("tenant_id", tenantID);
        namedPreparedStatement.setInt("offset", offset);
        namedPreparedStatement.setInt("limit", limit);
        return namedPreparedStatement;
    }

    private NamedPreparedStatement getPreparedStatementForGetAllScopesWithPagination(Integer offset, Integer limit, int tenantID, Connection conn) throws SQLException {
        String driverName = conn.getMetaData().getDriverName();
        String query = driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id; LIMIT :limit; OFFSET :offset;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID" : (conn.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id; FETCH FIRST :limit; ROWS ONLY) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID" : (driverName.contains("MS SQL") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT TOP (:limit;) SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID = SCOPEBINDINGS.SCOPE_ID" : (driverName.contains("Microsoft") || driverName.contains("microsoft") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT TOP (:limit;) SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID = SCOPEBINDINGS.SCOPE_ID" : (driverName.contains("PostgreSQL") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id; LIMIT :limit;) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID" : (driverName.contains("Informix") ? "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT FIRST :limit; * FROM  (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE AS SCOPES WHERE SCOPES.TENANT_ID = :tenant_id;) RESULT) AS FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID" : "SELECT FILTEREDSCOPES.SCOPE_ID, FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING FROM (SELECT SCOPES.SCOPE_ID, SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION FROM IDN_OAUTH2_SCOPE SCOPES WHERE SCOPES.TENANT_ID = :tenant_id; AND ROWNUM <= :limit;) FILTEREDSCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON FILTEREDSCOPES.SCOPE_ID = SCOPEBINDINGS.SCOPE_ID")))));
        NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(conn, query);
        namedPreparedStatement.setInt("tenant_id", tenantID);
        namedPreparedStatement.setInt("offset", offset);
        namedPreparedStatement.setInt("limit", limit);
        return namedPreparedStatement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Scope> getScopesWithPagination(Integer offset, Integer limit, int tenantID, Boolean includeOIDCScopes) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get all scopes with pagination for tenantId  :" + tenantID + " including OIDC scope: " + includeOIDCScopes));
        }
        HashSet scopes = new HashSet();
        HashMap<Integer, Scope> scopeMap = new HashMap<Integer, Scope>();
        try (Connection conn = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            NamedPreparedStatement namedPreparedStatement = includeOIDCScopes != false ? this.getPreparedStatementForGetAllScopesWithPagination(offset, limit, tenantID, conn) : this.getPreparedStatementForGetScopesWithPagination(offset, limit, tenantID, conn);
            try (PreparedStatement preparedStatement = namedPreparedStatement.getPreparedStatement();
                 ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    int scopeID = rs.getInt(1);
                    String name = rs.getString(2);
                    String displayName = rs.getString(3);
                    String description = rs.getString(4);
                    final String binding = rs.getString(5);
                    if (scopeMap.containsKey(scopeID) && scopeMap.get(scopeID) != null) {
                        ((Scope)scopeMap.get(scopeID)).setName(name);
                        ((Scope)scopeMap.get(scopeID)).setDescription(description);
                        ((Scope)scopeMap.get(scopeID)).setDisplayName(displayName);
                        if (binding == null) continue;
                        if (((Scope)scopeMap.get(scopeID)).getBindings() != null) {
                            ((Scope)scopeMap.get(scopeID)).addBinding(binding);
                            continue;
                        }
                        ((Scope)scopeMap.get(scopeID)).setBindings((List<String>)new ArrayList<String>(){
                            {
                                this.add(binding);
                            }
                        });
                        continue;
                    }
                    scopeMap.put(scopeID, new Scope(name, displayName, description, new ArrayList<String>()));
                    if (binding == null) continue;
                    ((Scope)scopeMap.get(scopeID)).addBinding(binding);
                }
            }
            for (Map.Entry entry : scopeMap.entrySet()) {
                scopes.add(entry.getValue());
            }
            HashSet hashSet = scopes;
            return hashSet;
        }
        catch (SQLException e) {
            String msg = "Error occurred while getting all scopes with pagination ";
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Scope getScopeByName(String name, int tenantID) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get scope by name called for scope name:" + name));
        }
        Scope scope = null;
        try (Connection conn = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            String sql = conn.getMetaData().getDriverName().contains("Oracle") ? "SELECT SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING, SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME=? AND SCOPES.TENANT_ID=? AND SCOPES.SCOPE_TYPE=?" : "SELECT SCOPES.NAME, SCOPES.DISPLAY_NAME, SCOPES.DESCRIPTION, SCOPEBINDINGS.SCOPE_BINDING,SCOPEBINDINGS.BINDING_TYPE FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME=? AND SCOPES.TENANT_ID=? AND SCOPES.SCOPE_TYPE=?";
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, name);
                ps.setInt(2, tenantID);
                ps.setString(3, "OAUTH2");
                try (ResultSet rs = ps.executeQuery();){
                    String description = null;
                    String displayName = null;
                    while (rs.next()) {
                        String bindingType;
                        if (StringUtils.isBlank(description)) {
                            description = rs.getString(3);
                        }
                        if (StringUtils.isBlank(displayName)) {
                            displayName = rs.getString(2);
                        }
                        if ((bindingType = rs.getString(5)) == null) {
                            bindingType = "DEFAULT";
                        }
                        if (scope == null) {
                            scope = new Scope(name, displayName, new ArrayList<ScopeBinding>(), description);
                        }
                        scope.addScopeBinding(bindingType, rs.getString(4));
                    }
                }
            }
            Scope scope2 = scope;
            return scope2;
        }
        catch (SQLException e) {
            String msg = "Error occurred while getting scope by ID ";
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    @Override
    public boolean isScopeExists(String scopeName, int tenantID) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Is scope exists called for scope:" + scopeName));
        }
        boolean isScopeExists = false;
        int scopeID = this.getScopeIDByName(scopeName, tenantID);
        if (scopeID != -1) {
            isScopeExists = true;
        }
        return isScopeExists;
    }

    @Override
    public boolean isScopeExists(String scopeName, int tenantID, Boolean includeOIDCScopes) throws IdentityOAuth2ScopeServerException {
        if (includeOIDCScopes.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check scope exists regardless of scope type for scope:" + scopeName));
            }
            boolean isScopeExists = false;
            int scopeID = this.getScopeIDByNameWithoutScopeType(scopeName, tenantID);
            if (scopeID != -1) {
                isScopeExists = true;
            }
            return isScopeExists;
        }
        return this.isScopeExists(scopeName, tenantID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getScopeIDByName(String scopeName, int tenantID) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get scope ID by name called for scope name:" + scopeName));
        }
        try (Connection conn = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            int n = this.getScopeId(scopeName, tenantID, conn);
            return n;
        }
        catch (SQLException e) {
            String msg = "Error occurred while getting scope ID by name ";
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    private int getScopeId(String scopeName, int tenantID, Connection conn) throws SQLException {
        int scopeID = -1;
        try (PreparedStatement ps = conn.prepareStatement("SELECT SCOPE_ID FROM IDN_OAUTH2_SCOPE WHERE NAME=? AND TENANT_ID=? AND SCOPE_TYPE=?");){
            ps.setString(1, scopeName);
            ps.setInt(2, tenantID);
            ps.setString(3, "OAUTH2");
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    scopeID = rs.getInt(1);
                }
            }
        }
        return scopeID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getScopeIDByNameWithoutScopeType(String scopeName, int tenantID) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get scope ID regardless of scope type, for scope name: " + scopeName));
        }
        int scopeID = -1;
        try (Connection conn = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement ps = conn.prepareStatement("SELECT SCOPE_ID FROM IDN_OAUTH2_SCOPE WHERE NAME=? AND TENANT_ID=?");){
                ps.setString(1, scopeName);
                ps.setInt(2, tenantID);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        scopeID = rs.getInt(1);
                    }
                }
            }
            int n = scopeID;
            return n;
        }
        catch (SQLException e) {
            String msg = "Error occurred while getting scope ID by name.";
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    @Override
    public void deleteScopeByName(String name, int tenantID) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delete scope by name for scope name:" + name));
        }
        try (Connection conn = IdentityDatabaseUtil.getDBConnection();){
            try {
                this.deleteScope(name, tenantID, conn);
                IdentityDatabaseUtil.commitTransaction((Connection)conn);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)conn);
                String msg = "Error occurred while deleting scopes ";
                throw new IdentityOAuth2ScopeServerException(msg, e1);
            }
        }
        catch (SQLException e) {
            String msg = "Error occurred while deleting scopes ";
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    @Override
    public void updateScopeByName(Scope updatedScope, int tenantID) throws IdentityOAuth2ScopeServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Update scope by name for scope name:" + updatedScope.getName()));
        }
        try (Connection conn = IdentityDatabaseUtil.getDBConnection();){
            try {
                int scopeId = this.getScopeId(updatedScope.getName(), tenantID, conn);
                if (scopeId != -1) {
                    this.updateScopeDetails(updatedScope, conn, scopeId);
                    this.deleteBindings(scopeId, conn);
                    this.addScopeBinding(updatedScope, conn, scopeId);
                    IdentityDatabaseUtil.commitTransaction((Connection)conn);
                }
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)conn);
                String msg = "Error occurred while updating scope by ID ";
                throw new IdentityOAuth2ScopeServerException(msg, e1);
            }
        }
        catch (SQLException e) {
            String msg = "Error occurred while updating scope by ID ";
            throw new IdentityOAuth2ScopeServerException(msg, e);
        }
    }

    private void addScope(Scope scope, Connection conn, int tenantID) throws SQLException {
        if (scope != null) {
            Throwable throwable;
            ResultSet rs;
            int scopeID = 0;
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            try (PreparedStatement ps = conn.prepareStatement("INSERT INTO IDN_OAUTH2_SCOPE (NAME, DISPLAY_NAME, DESCRIPTION, TENANT_ID, SCOPE_TYPE) VALUES(?,?,?,?,?)", new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"SCOPE_ID")});){
                ps.setString(1, scope.getName());
                ps.setString(2, scope.getDisplayName());
                ps.setString(3, scope.getDescription());
                ps.setInt(4, tenantID);
                ps.setString(5, "OAUTH2");
                ps.execute();
                rs = ps.getGeneratedKeys();
                throwable = null;
                try {
                    if (rs.next()) {
                        scopeID = rs.getInt(1);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            if (scopeID == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"JDBC Driver did not return the scope id, executing Select operation");
                }
                ps = conn.prepareStatement("SELECT SCOPE_ID FROM IDN_OAUTH2_SCOPE WHERE NAME=? AND TENANT_ID=? AND SCOPE_TYPE=?");
                var7_7 = null;
                try {
                    ps.setString(1, scope.getName());
                    ps.setInt(2, tenantID);
                    ps.setString(3, "OAUTH2");
                    rs = ps.executeQuery();
                    throwable = null;
                    try {
                        if (rs.next()) {
                            scopeID = rs.getInt(1);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    var7_7 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (ps != null) {
                        if (var7_7 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable7) {
                                var7_7.addSuppressed(throwable7);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            this.addScopeBinding(scope, conn, scopeID);
        }
    }

    private void addScopeBinding(Scope scope, Connection conn, int scopeID) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("INSERT INTO IDN_OAUTH2_SCOPE_BINDING (SCOPE_ID, SCOPE_BINDING, BINDING_TYPE) VALUES(?,?,?)");){
            List<ScopeBinding> scopeBindings = scope.getScopeBindings();
            for (ScopeBinding scopeBinding : scopeBindings) {
                String bindingType = scopeBinding.getBindingType();
                for (String binding : scopeBinding.getBindings()) {
                    ps.setInt(1, scopeID);
                    ps.setString(2, binding);
                    ps.setString(3, bindingType);
                    ps.addBatch();
                }
            }
            ps.executeBatch();
        }
    }

    private void deleteScope(String scopeName, int tenantID, Connection conn) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("DELETE FROM IDN_OAUTH2_SCOPE WHERE NAME = ? AND TENANT_ID = ? AND SCOPE_TYPE=?");){
            ps.setString(1, scopeName);
            ps.setInt(2, tenantID);
            ps.setString(3, "OAUTH2");
            ps.execute();
        }
    }

    private void deleteBindings(int scopeId, Connection conn) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OIDC claim mapping exists for the scope ID: " + scopeId + ", hence delete only the bindings of the scope"));
        }
        try (PreparedStatement ps = conn.prepareStatement("DELETE FROM IDN_OAUTH2_SCOPE_BINDING WHERE SCOPE_ID = ?");){
            ps.setInt(1, scopeId);
            ps.execute();
        }
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public String findScopeOfResource(String resourceUri) throws IdentityOAuth2Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean validateScope(Connection connection, String accessToken, String resourceUri) {
        return false;
    }

    @Override
    public Set<String> getBindingsOfScopeByScopeName(String scopeName, int tenantId) throws IdentityOAuth2Exception {
        HashSet<String> bindingStringBuilder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving bindings of scope: " + scopeName + " tenant id: " + tenantId));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> bindings = new HashSet<String>();
        try {
            String sql = connection.getMetaData().getDriverName().contains("Oracle") ? "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ? AND TENANT_ID = ?" : "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ? AND TENANT_ID = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, scopeName);
            ps.setInt(2, tenantId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String binding = rs.getString("SCOPE_BINDING");
                if (!StringUtils.isNotEmpty((String)binding)) continue;
                bindings.add(binding);
            }
            if (log.isDebugEnabled()) {
                bindingStringBuilder = new StringBuilder();
                for (String binding : bindings) {
                    ((StringBuilder)((Object)bindingStringBuilder)).append(binding).append(" ");
                }
                log.debug((Object)("Binding for scope: " + scopeName + " found: " + ((StringBuilder)((Object)bindingStringBuilder)).toString() + " tenant id: " + tenantId));
            }
            bindingStringBuilder = bindings;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error getting bindings of scope - " + scopeName;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        return bindingStringBuilder;
    }

    @Deprecated
    public Set<String> getBindingsOfScopeByScopeName(String scopeName) throws IdentityOAuth2Exception {
        HashSet<String> bindingsStringBuilder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving bindings of scope: " + scopeName));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> bindings = new HashSet<String>();
        try {
            String sql = connection.getMetaData().getDriverName().contains("Oracle") ? "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ?" : "SELECT SCOPEBINDINGS.SCOPE_BINDING FROM IDN_OAUTH2_SCOPE AS SCOPES LEFT JOIN IDN_OAUTH2_SCOPE_BINDING AS SCOPEBINDINGS ON SCOPES.SCOPE_ID=SCOPEBINDINGS.SCOPE_ID WHERE SCOPES.NAME = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, scopeName);
            rs = ps.executeQuery();
            while (rs.next()) {
                String binding = rs.getString("SCOPE_BINDING");
                if (!StringUtils.isNotBlank((String)binding)) continue;
                bindings.add(binding);
            }
            if (log.isDebugEnabled()) {
                bindingsStringBuilder = new StringBuilder();
                for (String binding : bindings) {
                    ((StringBuilder)((Object)bindingsStringBuilder)).append(binding).append(" ");
                }
                log.debug((Object)("Binding for scope: " + scopeName + " found: " + ((StringBuilder)((Object)bindingsStringBuilder)).toString()));
            }
            bindingsStringBuilder = bindings;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error getting roles of scope - " + scopeName;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        return bindingsStringBuilder;
    }

    public void updateScopeDetails(Scope updatedScope, Connection conn, int scopeId) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("UPDATE IDN_OAUTH2_SCOPE SET DISPLAY_NAME=?, DESCRIPTION=? WHERE SCOPE_ID=? ");){
            ps.setString(1, updatedScope.getDisplayName());
            ps.setString(2, updatedScope.getDescription());
            ps.setInt(3, scopeId);
            ps.execute();
        }
    }
}

