/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.AbstractOAuthDAO;
import org.wso2.carbon.identity.oauth2.dao.AuthorizationCodeDAO;
import org.wso2.carbon.identity.oauth2.dao.AuthorizationCodeValidationResult;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2TokenUtil;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class AuthorizationCodeDAOImpl
extends AbstractOAuthDAO
implements AuthorizationCodeDAO {
    private static final Log log = LogFactory.getLog(AuthorizationCodeDAOImpl.class);
    private static final String IDN_OAUTH2_AUTHORIZATION_CODE = "IDN_OAUTH2_AUTHORIZATION_CODE";
    private boolean isHashDisabled = OAuth2Util.isHashDisabled();

    @Override
    public void insertAuthorizationCode(String authzCode, String consumerKey, String callbackUrl, AuthzCodeDO authzCodeDO) throws IdentityOAuth2Exception {
        if (!this.isPersistenceEnabled()) {
            return;
        }
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
                log.debug((Object)("Persisting authorization code (hashed): " + DigestUtils.sha256Hex((String)authzCode) + " for client: " + consumerKey + " user: " + authzCodeDO.getAuthorizedUser().toString()));
            } else {
                log.debug((Object)("Persisting authorization code for client: " + consumerKey + " user: " + authzCodeDO.getAuthorizedUser().toString()));
            }
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        String userDomain = OAuth2Util.getUserStoreDomain(authzCodeDO.getAuthorizedUser());
        String authenticatedIDP = OAuth2Util.getAuthenticatedIDP(authzCodeDO.getAuthorizedUser());
        try {
            String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "INSERT INTO  IDN_OAUTH2_AUTHORIZATION_CODE (CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY_ID, CALLBACK_URL, SCOPE, AUTHZ_USER, USER_DOMAIN, TENANT_ID, TIME_CREATED, VALIDITY_PERIOD, SUBJECT_IDENTIFIER, PKCE_CODE_CHALLENGE, PKCE_CODE_CHALLENGE_METHOD, AUTHORIZATION_CODE_HASH, IDP_ID) SELECT ?,?,IDN_OAUTH_CONSUMER_APPS.ID,?,?,?,?,?,?,?,?,?,?,?,IDP.ID FROM IDN_OAUTH_CONSUMER_APPS, IDP WHERE CONSUMER_KEY=? AND IDP.NAME=? AND IDP.TENANT_ID=?" : "INSERT INTO  IDN_OAUTH2_AUTHORIZATION_CODE (CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY_ID, CALLBACK_URL, SCOPE, AUTHZ_USER, USER_DOMAIN, TENANT_ID, TIME_CREATED, VALIDITY_PERIOD, SUBJECT_IDENTIFIER, PKCE_CODE_CHALLENGE, PKCE_CODE_CHALLENGE_METHOD, AUTHORIZATION_CODE_HASH) SELECT ?,?,ID,?,?,?,?,?,?,?,?,?,?,? FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, authzCodeDO.getAuthzCodeId());
            prepStmt.setString(2, this.getPersistenceProcessor().getProcessedAuthzCode(authzCode));
            prepStmt.setString(3, callbackUrl);
            prepStmt.setString(4, "");
            prepStmt.setString(5, authzCodeDO.getAuthorizedUser().getUserName());
            prepStmt.setString(6, userDomain);
            int tenantId = OAuth2Util.getTenantId(authzCodeDO.getAuthorizedUser().getTenantDomain());
            prepStmt.setInt(7, tenantId);
            prepStmt.setTimestamp(8, authzCodeDO.getIssuedTime(), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            prepStmt.setLong(9, authzCodeDO.getValidityPeriod());
            prepStmt.setString(10, authzCodeDO.getAuthorizedUser().getAuthenticatedSubjectIdentifier());
            prepStmt.setString(11, authzCodeDO.getPkceCodeChallenge());
            prepStmt.setString(12, authzCodeDO.getPkceCodeChallengeMethod());
            prepStmt.setString(13, this.getHashingPersistenceProcessor().getProcessedAuthzCode(authzCode));
            prepStmt.setString(14, this.getPersistenceProcessor().getProcessedClientId(consumerKey));
            if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                prepStmt.setString(15, authenticatedIDP);
                prepStmt.setInt(16, tenantId);
            }
            prepStmt.execute();
            this.addAuthorizationCodeScopes(authzCodeDO, connection, tenantId);
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error when storing the authorization code for consumer key : " + consumerKey, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }

    @Override
    public void deactivateAuthorizationCodes(List<AuthzCodeDO> authzCodeDOs) throws IdentityOAuth2Exception {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        if (log.isDebugEnabled()) {
            Object stringBuilder;
            if (IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
                stringBuilder = new StringBuilder();
                for (AuthzCodeDO authzCodeDO : authzCodeDOs) {
                    ((StringBuilder)stringBuilder).append("Deactivating authorization code(hashed): ").append(DigestUtils.sha256Hex((String)authzCodeDO.getAuthorizationCode())).append(" client: ").append(authzCodeDO.getConsumerKey()).append(" user: ").append(authzCodeDO.getAuthorizedUser().toString()).append("\n");
                }
                log.debug((Object)((StringBuilder)stringBuilder).toString());
            } else {
                stringBuilder = new StringBuilder();
                for (AuthzCodeDO authzCodeDO : authzCodeDOs) {
                    ((StringBuilder)stringBuilder).append("Deactivating authorization code client: ").append(authzCodeDO.getConsumerKey()).append(" user: ").append(authzCodeDO.getAuthorizedUser().toString()).append("\n");
                }
                log.debug((Object)((StringBuilder)stringBuilder).toString());
            }
        }
        try {
            prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE='INACTIVE', TOKEN_ID=? WHERE AUTHORIZATION_CODE_HASH= ?");
            for (AuthzCodeDO authzCodeDO : authzCodeDOs) {
                prepStmt.setString(1, authzCodeDO.getOauthTokenId());
                prepStmt.setString(2, this.getHashingPersistenceProcessor().getProcessedAuthzCode(authzCodeDO.getAuthorizationCode()));
                prepStmt.addBatch();
            }
            prepStmt.executeBatch();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
            OAuth2TokenUtil.postRevokeCodes(authzCodeDOs, "INACTIVE");
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error when deactivating authorization code", e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
    }

    @Override
    public AuthorizationCodeValidationResult validateAuthorizationCode(String consumerKey, String authorizationKey) throws IdentityOAuth2Exception {
        AuthorizationCodeValidationResult authorizationCodeValidationResult;
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
                log.debug((Object)("Validating authorization code(hashed): " + DigestUtils.sha256Hex((String)authorizationKey) + " for client: " + consumerKey));
            } else {
                log.debug((Object)("Validating authorization code for client: " + consumerKey));
            }
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        AuthorizationCodeValidationResult result = null;
        try {
            AuthenticatedUser user = null;
            String codeState = null;
            String authorizedUser = null;
            String userstoreDomain = null;
            String scopeString = null;
            String callbackUrl = null;
            String tenantDomain = null;
            String codeId = null;
            String subjectIdentifier = null;
            String pkceCodeChallenge = null;
            String pkceCodeChallengeMethod = null;
            Timestamp issuedTime = null;
            long validityPeriod = 0L;
            String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT AUTHZ_USER, USER_DOMAIN, IDN_OAUTH2_AUTHORIZATION_CODE.TENANT_ID, SCOPE, CALLBACK_URL, TIME_CREATED,VALIDITY_PERIOD, STATE, TOKEN_ID, AUTHORIZATION_CODE, CODE_ID, SUBJECT_IDENTIFIER, PKCE_CODE_CHALLENGE, PKCE_CODE_CHALLENGE_METHOD, IDP.NAME FROM IDN_OAUTH2_AUTHORIZATION_CODE INNER JOIN IDP ON IDP_ID=IDP.ID AND IDN_OAUTH2_AUTHORIZATION_CODE.TENANT_ID=IDP.TENANT_ID WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHORIZATION_CODE_HASH = ?" : "SELECT AUTHZ_USER, USER_DOMAIN, TENANT_ID, SCOPE, CALLBACK_URL, TIME_CREATED,VALIDITY_PERIOD, STATE, TOKEN_ID, AUTHORIZATION_CODE, CODE_ID, SUBJECT_IDENTIFIER, PKCE_CODE_CHALLENGE, PKCE_CODE_CHALLENGE_METHOD FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHORIZATION_CODE_HASH = ?";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, this.getPersistenceProcessor().getProcessedClientId(consumerKey));
            prepStmt.setString(2, this.getHashingPersistenceProcessor().getProcessedAuthzCode(authorizationKey));
            resultSet = prepStmt.executeQuery();
            if (resultSet.next()) {
                ServiceProvider serviceProvider;
                codeState = resultSet.getString(8);
                authorizedUser = resultSet.getString(1);
                userstoreDomain = resultSet.getString(2);
                int tenantId = resultSet.getInt(3);
                tenantDomain = OAuth2Util.getTenantDomain(tenantId);
                scopeString = resultSet.getString(4);
                callbackUrl = resultSet.getString(5);
                issuedTime = resultSet.getTimestamp(6, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                validityPeriod = resultSet.getLong(7);
                codeId = resultSet.getString(11);
                subjectIdentifier = resultSet.getString(12);
                pkceCodeChallenge = resultSet.getString(13);
                pkceCodeChallengeMethod = resultSet.getString(14);
                String authenticatedIDP = null;
                if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                    authenticatedIDP = resultSet.getString(15);
                }
                user = OAuth2Util.createAuthenticatedUser(authorizedUser, userstoreDomain, tenantDomain, authenticatedIDP);
                try {
                    serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                }
                catch (IdentityApplicationManagementException e) {
                    throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                }
                user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                String tokenId = resultSet.getString(9);
                String tokenBindingReference = "NONE";
                if (StringUtils.isNotBlank((String)tokenId)) {
                    tokenBindingReference = this.getTokenBindingReference(connection, tokenId, tenantId);
                }
                if (StringUtils.isBlank((String)scopeString)) {
                    List<String> scopes = this.getAuthorizationCodeScopes(connection, codeId, tenantId);
                    scopeString = OAuth2Util.buildScopeString(scopes.toArray(new String[0]));
                }
                AuthzCodeDO codeDo = this.createAuthzCodeDo(consumerKey, authorizationKey, user, codeState, scopeString, callbackUrl, codeId, pkceCodeChallenge, pkceCodeChallengeMethod, issuedTime, validityPeriod, tokenBindingReference);
                result = new AuthorizationCodeValidationResult(codeDo, tokenId);
            }
            authorizationCodeValidationResult = result;
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuth2Exception("Error when validating an authorization code", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return authorizationCodeValidationResult;
    }

    private String getTokenBindingReference(Connection connection, String tokenId, int tenantId) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ? AND TENANT_ID = ?");){
            preparedStatement.setString(1, tokenId);
            preparedStatement.setInt(2, tenantId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    String string = resultSet.getString("TOKEN_BINDING_REF");
                    return string;
                }
            }
        }
        return "NONE";
    }

    @Override
    public void updateAuthorizationCodeState(String authzCode, String newState) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
                log.debug((Object)("Changing state of authorization code(hashed): " + DigestUtils.sha256Hex((String)authzCode) + " to: " + newState));
            } else {
                log.debug((Object)("Changing state of authorization code  to: " + newState));
            }
        }
        String authCodeStoreTable = IDN_OAUTH2_AUTHORIZATION_CODE;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            String sqlQuery = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE=? WHERE AUTHORIZATION_CODE_HASH=?".replace(IDN_OAUTH2_AUTHORIZATION_CODE, authCodeStoreTable);
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, newState);
            prepStmt.setString(2, this.getHashingPersistenceProcessor().getProcessedAuthzCode(authzCode));
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
            OAuth2TokenUtil.postRevokeCode(authzCode, newState, null);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while updating the state of Authorization Code : " + authzCode.toString(), e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }

    @Override
    public void deactivateAuthorizationCode(AuthzCodeDO authzCodeDO) throws IdentityOAuth2Exception {
        if (!this.isPersistenceEnabled()) {
            return;
        }
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
            log.debug((Object)("Deactivating authorization code(hashed): " + DigestUtils.sha256Hex((String)authzCodeDO.getAuthorizationCode())));
        }
        PreparedStatement prepStmt = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        try {
            prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET STATE='INACTIVE', TOKEN_ID=? WHERE AUTHORIZATION_CODE_HASH= ?");
            prepStmt.setString(1, authzCodeDO.getOauthTokenId());
            prepStmt.setString(2, this.getHashingPersistenceProcessor().getProcessedAuthzCode(authzCodeDO.getAuthorizationCode()));
            prepStmt.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
            OAuth2TokenUtil.postRevokeCode(authzCodeDO.getAuthzCodeId(), "INACTIVE", authzCodeDO.getOauthTokenId());
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error when deactivating authorization code", e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
    }

    @Override
    public Set<String> getAuthorizationCodesByUser(AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving authorization codes of user: " + authenticatedUser.toString()));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> authorizationCodes = new HashSet<String>();
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authenticatedUser.toString());
        try {
            String sqlQuery = "SELECT DISTINCT AUTHORIZATION_CODE, TIME_CREATED, VALIDITY_PERIOD  FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND STATE=?";
            if (!isUsernameCaseSensitive) {
                sqlQuery = sqlQuery.replace("AUTHZ_USER", "LOWER(AUTHZ_USER)");
            }
            ps = connection.prepareStatement(sqlQuery);
            if (isUsernameCaseSensitive) {
                ps.setString(1, authenticatedUser.getUserName());
            } else {
                ps.setString(1, authenticatedUser.getUserName().toLowerCase());
            }
            ps.setInt(2, OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()));
            ps.setString(3, authenticatedUser.getUserStoreDomain());
            ps.setString(4, "ACTIVE");
            rs = ps.executeQuery();
            while (rs.next()) {
                long validityPeriodInMillis = rs.getLong(3);
                Timestamp timeCreated = rs.getTimestamp(2, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                long issuedTimeInMillis = timeCreated.getTime();
                if (OAuth2Util.calculateValidityInMillis(issuedTimeInMillis, validityPeriodInMillis) <= 1000L || !this.isHashDisabled) continue;
                authorizationCodes.add(this.getPersistenceProcessor().getPreprocessedAuthzCode(rs.getString(1)));
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while revoking Access Token with user Name : " + authenticatedUser.getUserName() + " tenant ID : " + OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()), e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        return authorizationCodes;
    }

    @Override
    public List<AuthzCodeDO> getAuthorizationCodesByUserForOpenidScope(AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving authorization codes of user: " + authenticatedUser.toString()));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<AuthzCodeDO> authorizationCodes = new ArrayList<AuthzCodeDO>();
        String authzUser = authenticatedUser.getUserName();
        String tenantDomain = authenticatedUser.getTenantDomain();
        String userStoreDomain = authenticatedUser.getUserStoreDomain();
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authenticatedUser.toString());
        try {
            String sqlQuery = "SELECT DISTINCT AUTHORIZATION_CODE, TIME_CREATED, VALIDITY_PERIOD, CODE_ID, SCOPE, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL, CONSUMER_KEY FROM IDN_OAUTH2_AUTHORIZATION_CODE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID=IDN_OAUTH_CONSUMER_APPS.ID WHERE AUTHZ_USER=? AND IDN_OAUTH2_AUTHORIZATION_CODE.TENANT_ID=? AND IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN=? AND STATE=? AND SCOPE LIKE '%openid%'";
            if (!isUsernameCaseSensitive) {
                sqlQuery = sqlQuery.replace("AUTHZ_USER", "LOWER(AUTHZ_USER)");
            }
            ps = connection.prepareStatement(sqlQuery);
            if (isUsernameCaseSensitive) {
                ps.setString(1, authzUser);
            } else {
                ps.setString(1, authzUser.toLowerCase());
            }
            ps.setInt(2, OAuth2Util.getTenantId(tenantDomain));
            ps.setString(3, userStoreDomain);
            ps.setString(4, "ACTIVE");
            rs = ps.executeQuery();
            while (rs.next()) {
                long validityPeriodInMillis = rs.getLong(3);
                Timestamp timeCreated = rs.getTimestamp(2, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                long issuedTimeInMillis = timeCreated.getTime();
                String authorizationCode = rs.getString(1);
                String authzCodeId = rs.getString(4);
                String[] scope = OAuth2Util.buildScopeArray(rs.getString(5));
                String callbackUrl = rs.getString(6);
                String consumerKey = rs.getString(7);
                AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(authzUser, userStoreDomain, tenantDomain);
                user.setUserName(authzUser);
                user.setUserStoreDomain(userStoreDomain);
                user.setTenantDomain(tenantDomain);
                if (!this.isAuthorizationCodeIssuedForOpenidScope(scope) || OAuth2Util.getTimeToExpire(issuedTimeInMillis, validityPeriodInMillis) <= 0L || !this.isHashDisabled) continue;
                authorizationCodes.add(new AuthzCodeDO(user, scope, timeCreated, validityPeriodInMillis, callbackUrl, consumerKey, authorizationCode, authzCodeId));
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while revoking authorization code with username : " + authenticatedUser.getUserName() + " tenant ID : " + OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()), e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        return authorizationCodes;
    }

    @Override
    public Set<String> getAuthorizationCodesByConsumerKey(String consumerKey) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving authorization codes for client: " + consumerKey));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> authorizationCodes = new HashSet<String>();
        try {
            String sqlQuery = "SELECT AUTHORIZATION_CODE   FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) ";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            rs = ps.executeQuery();
            while (rs.next()) {
                if (!this.isHashDisabled) continue;
                authorizationCodes.add(this.getPersistenceProcessor().getPreprocessedAuthzCode(rs.getString(1)));
            }
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while getting authorization codes from authorization code table for the application with consumer key : " + consumerKey, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
        return authorizationCodes;
    }

    @Override
    public Set<String> getActiveAuthorizationCodesByConsumerKey(String consumerKey) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving active authorization codes for client: " + consumerKey));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> authorizationCodes = new HashSet<String>();
        try {
            String sqlQuery = "SELECT AUTHORIZATION_CODE FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND STATE = ?";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            ps.setString(2, "ACTIVE");
            rs = ps.executeQuery();
            while (rs.next()) {
                if (!this.isHashDisabled) continue;
                authorizationCodes.add(this.getPersistenceProcessor().getPreprocessedAuthzCode(rs.getString(1)));
            }
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while getting authorization codes from authorization code table for the application with consumer key : " + consumerKey, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
        return authorizationCodes;
    }

    @Override
    public List<AuthzCodeDO> getLatestAuthorizationCodesByTenant(int tenantId) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving latest authorization codes of tenant id: " + tenantId));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<AuthzCodeDO> latestAuthzCodes = new ArrayList<AuthzCodeDO>();
        try {
            String sqlQuery = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY, IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER, IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE, TIME_CREATED, VALIDITY_PERIOD, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL, IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN, IDP.NAME FROM (SELECT AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, SCOPE, MAX(TIME_CREATED) TIMES, IDP_ID FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TENANT_ID=? GROUP BY AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, SCOPE, IDP_ID) AUTHZ_SELECTED JOIN IDN_OAUTH2_AUTHORIZATION_CODE ON AUTHZ_SELECTED.AUTHZ_USER=IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER AND AUTHZ_SELECTED.CONSUMER_KEY_ID=IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID AND AUTHZ_SELECTED.TIMES=IDN_OAUTH2_AUTHORIZATION_CODE.TIME_CREATED AND AUTHZ_SELECTED.USER_DOMAIN=IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN AND AUTHZ_SELECTED.SCOPE=IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID = IDN_OAUTH_CONSUMER_APPS.ID JOIN IDP ON IDN_OAUTH2_AUTHORIZATION_CODE.IDP_ID = IDP.ID WHERE STATE='ACTIVE'" : "SELECT CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY, IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER, IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE, TIME_CREATED, VALIDITY_PERIOD, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL, IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN FROM (SELECT AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, SCOPE, MAX(TIME_CREATED) TIMES FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TENANT_ID=? group by AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, SCOPE) AUTHZ_SELECTED JOIN IDN_OAUTH2_AUTHORIZATION_CODE ON AUTHZ_SELECTED.AUTHZ_USER=IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER AND AUTHZ_SELECTED.CONSUMER_KEY_ID=IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID AND AUTHZ_SELECTED.TIMES=IDN_OAUTH2_AUTHORIZATION_CODE.TIME_CREATED AND AUTHZ_SELECTED.USER_DOMAIN=IDN_OAUTH2_AUTHORIZATION_CODE.USER_DOMAIN AND AUTHZ_SELECTED.SCOPE=IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID = ID WHERE STATE='ACTIVE'";
            ps = connection.prepareStatement(sqlQuery);
            ps.setInt(1, tenantId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String authzCodeId = rs.getString(1);
                String authzCode = rs.getString(2);
                String consumerKey = rs.getString(3);
                String authzUser = rs.getString(4);
                Object[] scope = OAuth2Util.buildScopeArray(rs.getString(5));
                Timestamp issuedTime = rs.getTimestamp(6, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                long validityPeriodInMillis = rs.getLong(7);
                String callbackUrl = rs.getString(8);
                String userStoreDomain = rs.getString(9);
                String authenticatedIDP = null;
                if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                    authenticatedIDP = rs.getString(10);
                }
                AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(authzUser, userStoreDomain, OAuth2Util.getTenantDomain(tenantId), authenticatedIDP);
                user.setUserName(authzUser);
                user.setUserStoreDomain(userStoreDomain);
                user.setTenantDomain(OAuth2Util.getTenantDomain(tenantId));
                if (ArrayUtils.isEmpty((Object[])scope)) {
                    List<String> authorizationCodeScopes = this.getAuthorizationCodeScopes(connection, authzCodeId, tenantId);
                    scope = authorizationCodeScopes.toArray(new String[0]);
                }
                latestAuthzCodes.add(new AuthzCodeDO(user, (String[])scope, issuedTime, validityPeriodInMillis, callbackUrl, consumerKey, authzCode, authzCodeId));
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while retrieving latest authorization codes of tenant :" + tenantId, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        return latestAuthzCodes;
    }

    @Override
    public List<AuthzCodeDO> getLatestAuthorizationCodesByUserStore(int tenantId, String userStorDomain) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving latest authorization codes of userstore: " + userStorDomain + " tenant id: " + tenantId));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        String userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStorDomain);
        ArrayList<AuthzCodeDO> latestAuthzCodes = new ArrayList<AuthzCodeDO>();
        try {
            String sqlQuery = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT CODE_ID, AUTHORIZATION_CODE,CONSUMER_KEY, IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER, IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE, TIME_CREATED, VALIDITY_PERIOD, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL, IDP.NAME FROM (SELECT AUTHZ_USER, CONSUMER_KEY_ID, SCOPE, MAX(TIME_CREATED) TIMES, IDP_ID FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TENANT_ID=? AND USER_DOMAIN=? GROUP BY AUTHZ_USER, CONSUMER_KEY_ID, SCOPE, IDP_ID) AUTHZ_SELECTED JOIN IDN_OAUTH2_AUTHORIZATION_CODE ON AUTHZ_SELECTED.AUTHZ_USER=IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER AND AUTHZ_SELECTED.CONSUMER_KEY_ID=IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID AND AUTHZ_SELECTED.TIMES=IDN_OAUTH2_AUTHORIZATION_CODE.TIME_CREATED AND AUTHZ_SELECTED.SCOPE=IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID = IDN_OAUTH_CONSUMER_APPS.ID JOIN IDP ON IDN_OAUTH2_AUTHORIZATION_CODE.IDP_ID = IDP.ID WHERE STATE='ACTIVE'" : "SELECT CODE_ID, AUTHORIZATION_CODE, CONSUMER_KEY, IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER, IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE, TIME_CREATED, VALIDITY_PERIOD, IDN_OAUTH2_AUTHORIZATION_CODE.CALLBACK_URL FROM (SELECT AUTHZ_USER, CONSUMER_KEY_ID, SCOPE, MAX(TIME_CREATED) TIMES FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE TENANT_ID=? AND USER_DOMAIN=? group by AUTHZ_USER, CONSUMER_KEY_ID, SCOPE) AUTHZ_SELECTED JOIN IDN_OAUTH2_AUTHORIZATION_CODE ON AUTHZ_SELECTED.AUTHZ_USER=IDN_OAUTH2_AUTHORIZATION_CODE.AUTHZ_USER AND AUTHZ_SELECTED.CONSUMER_KEY_ID=IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID AND AUTHZ_SELECTED.TIMES=IDN_OAUTH2_AUTHORIZATION_CODE.TIME_CREATED AND AUTHZ_SELECTED.SCOPE=IDN_OAUTH2_AUTHORIZATION_CODE.SCOPE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY_ID = ID WHERE STATE='ACTIVE'";
            ps = connection.prepareStatement(sqlQuery);
            ps.setInt(1, tenantId);
            ps.setString(2, userStoreDomain);
            rs = ps.executeQuery();
            while (rs.next()) {
                String authzCodeId = rs.getString(1);
                String authzCode = rs.getString(2);
                String consumerKey = rs.getString(3);
                String authzUser = rs.getString(4);
                Object[] scope = OAuth2Util.buildScopeArray(rs.getString(5));
                Timestamp issuedTime = rs.getTimestamp(6, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                long validityPeriodInMillis = rs.getLong(7);
                String callbackUrl = rs.getString(8);
                String authenticatedIDP = null;
                if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                    authenticatedIDP = rs.getString(9);
                }
                AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(authzUser, userStoreDomain, OAuth2Util.getTenantDomain(tenantId), authenticatedIDP);
                if (ArrayUtils.isEmpty((Object[])scope)) {
                    List<String> scopes = this.getAuthorizationCodeScopes(connection, authzCodeId, tenantId);
                    scope = scopes.toArray(new String[0]);
                }
                latestAuthzCodes.add(new AuthzCodeDO(user, (String[])scope, issuedTime, validityPeriodInMillis, callbackUrl, consumerKey, authzCode, authzCodeId));
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while retrieving latest authorization codes of user store : " + userStoreDomain + " in tenant :" + tenantId, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        return latestAuthzCodes;
    }

    @Override
    public void updateUserStoreDomain(int tenantId, String currentUserStoreDomain, String newUserStoreDomain) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Renaming userstore domain: " + currentUserStoreDomain + " as: " + newUserStoreDomain + " tenant id: " + tenantId + " in IDN_OAUTH2_AUTHORIZATION_CODE table"));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        currentUserStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(currentUserStoreDomain);
        newUserStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(newUserStoreDomain);
        try {
            String sqlQuery = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET USER_DOMAIN=? WHERE TENANT_ID=? AND USER_DOMAIN=?";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, newUserStoreDomain);
            ps.setInt(2, tenantId);
            ps.setString(3, currentUserStoreDomain);
            int count = ps.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of rows being updated : " + count));
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while renaming user store : " + currentUserStoreDomain + "in tenant :" + tenantId, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    private void addAuthorizationCodeScopes(AuthzCodeDO authzCodeDO, Connection connection, int tenantId) throws SQLException {
        try (PreparedStatement addScopePrepStmt = connection.prepareStatement("INSERT INTO IDN_OAUTH2_AUTHZ_CODE_SCOPE (CODE_ID, SCOPE, TENANT_ID) VALUES (?,?,?)");){
            String authzCodeId = authzCodeDO.getAuthzCodeId();
            if (authzCodeDO.getScope() != null && authzCodeDO.getScope().length > 0) {
                for (String scope : authzCodeDO.getScope()) {
                    addScopePrepStmt.setString(1, authzCodeId);
                    addScopePrepStmt.setString(2, scope);
                    addScopePrepStmt.setInt(3, tenantId);
                    addScopePrepStmt.addBatch();
                }
            }
            addScopePrepStmt.executeBatch();
        }
    }

    private List<String> getAuthorizationCodeScopes(Connection connection, String codeId, int tenantId) throws SQLException {
        ArrayList<String> scopes = new ArrayList<String>();
        try (PreparedStatement scopePrepStmt = connection.prepareStatement("SELECT SCOPE FROM IDN_OAUTH2_AUTHZ_CODE_SCOPE WHERE CODE_ID=? AND TENANT_ID=?");){
            scopePrepStmt.setString(1, codeId);
            scopePrepStmt.setInt(2, tenantId);
            try (ResultSet scopesResultSet = scopePrepStmt.executeQuery();){
                while (scopesResultSet.next()) {
                    String scope = scopesResultSet.getString(1);
                    scopes.add(scope);
                }
            }
        }
        return scopes;
    }

    private String getAuthorizationCodeByCodeId(String codeId) throws IdentityOAuth2Exception {
        String string;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving authorization code by code id: " + codeId));
            }
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            String sql = "SELECT AUTHORIZATION_CODE FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CODE_ID = ?";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, codeId);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block6;
            String string2 = resultSet.getString("AUTHORIZATION_CODE");
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'Authorization Code' for authorization code : " + codeId;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return string;
    }

    @Override
    public String getCodeIdByAuthorizationCode(String authzCode) throws IdentityOAuth2Exception {
        String string;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        block6: {
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Retrieving id of authorization code(hashed): " + DigestUtils.sha256Hex((String)authzCode)));
            }
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            String sql = "SELECT CODE_ID FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE AUTHORIZATION_CODE_HASH = ?";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, this.getHashingPersistenceProcessor().getProcessedAuthzCode(authzCode));
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block6;
            String string2 = resultSet.getString("CODE_ID");
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'Code ID' for authorization code : " + authzCode;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return string;
    }

    private AuthzCodeDO createAuthzCodeDo(String consumerKey, String authorizationKey, AuthenticatedUser user, String codeState, String scopeString, String callbackUrl, String codeId, String pkceCodeChallenge, String pkceCodeChallengeMethod, Timestamp issuedTime, long validityPeriod, String tokenBindingReference) {
        return new AuthzCodeDO(user, OAuth2Util.buildScopeArray(scopeString), issuedTime, validityPeriod, callbackUrl, consumerKey, authorizationKey, codeId, codeState, pkceCodeChallenge, pkceCodeChallengeMethod, tokenBindingReference);
    }

    private boolean isActiveAuthzCodeIssuedForOidcFlow(String[] scope, long issuedTimeInMillis, long validityPeriodInMillis) {
        return this.isAuthorizationCodeIssuedForOpenidScope(scope) && OAuth2Util.getTimeToExpire(issuedTimeInMillis, validityPeriodInMillis) > 0L;
    }

    @Override
    public Set<AuthzCodeDO> getAuthorizationCodeDOSetByConsumerKeyForOpenidScope(String consumerKey) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving active authorization code data objects for client: " + consumerKey));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<AuthzCodeDO> authzCodeDOs = new HashSet<AuthzCodeDO>();
        String sqlQuery = "SELECT AUTHORIZATION_CODE, CODE_ID, TIME_CREATED, VALIDITY_PERIOD, SCOPE FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND STATE = ? AND SCOPE LIKE '%openid%'";
        try {
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            ps.setString(2, "ACTIVE");
            rs = ps.executeQuery();
            while (rs.next()) {
                AuthzCodeDO authzCodeDO = new AuthzCodeDO();
                String authzCode = this.getPersistenceProcessor().getPreprocessedAuthzCode(rs.getString(1));
                String codeId = rs.getString(2);
                Timestamp timeCreated = rs.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                long issuedTimeInMillis = timeCreated.getTime();
                long validityPeriodInMillis = rs.getLong(4);
                String[] scope = OAuth2Util.buildScopeArray(rs.getString(5));
                authzCodeDO.setAuthorizationCode(authzCode);
                authzCodeDO.setAuthzCodeId(codeId);
                if (!this.isActiveAuthzCodeIssuedForOidcFlow(scope, issuedTimeInMillis, validityPeriodInMillis) || !this.isHashDisabled) continue;
                authzCodeDOs.add(authzCodeDO);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollBack((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while getting authorization codes and code ids from authorization code table for the application with consumer key : " + consumerKey, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        return authzCodeDOs;
    }

    private boolean isAuthorizationCodeIssuedForOpenidScope(String[] scopes) {
        if (ArrayUtils.isNotEmpty((Object[])scopes)) {
            return Arrays.asList(scopes).contains("openid");
        }
        return false;
    }
}

