/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

import java.util.concurrent.BlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.AuthContextTokenDO;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;

public class AuthPersistenceTask
implements Runnable {
    private static final Log log = LogFactory.getLog(AuthPersistenceTask.class);
    private BlockingDeque<AuthContextTokenDO> authContextTokenQueue;

    public AuthPersistenceTask(BlockingDeque<AuthContextTokenDO> authContextTokenQueue) {
        this.authContextTokenQueue = authContextTokenQueue;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Auth Token context persist consumer is started");
        }
        while (true) {
            try {
                while (true) {
                    AuthContextTokenDO authContextTokenDO;
                    if ((authContextTokenDO = this.authContextTokenQueue.take()) == null) {
                        continue;
                    }
                    if (authContextTokenDO.getAuthzCodeDO() == null && authContextTokenDO.getTokenId() == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Auth Token Data removing Task is started to run");
                        }
                        OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().updateAuthorizationCodeState(authContextTokenDO.getAuthzCode(), "EXPIRED");
                        continue;
                    }
                    if (authContextTokenDO.getAuthzCodeDO() == null && authContextTokenDO.getTokenId() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Auth Code Deactivating Task is started to run");
                        }
                        AuthzCodeDO authzCodeDO = new AuthzCodeDO();
                        authzCodeDO.setAuthorizationCode(authContextTokenDO.getAuthzCode());
                        authzCodeDO.setOauthTokenId(authContextTokenDO.getTokenId());
                        OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().deactivateAuthorizationCode(authzCodeDO);
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Auth Token Data persisting Task is started to run");
                    }
                    OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().insertAuthorizationCode(authContextTokenDO.getAuthzCode(), authContextTokenDO.getConsumerKey(), authContextTokenDO.getCallbackUrl(), authContextTokenDO.getAuthzCodeDO());
                }
            }
            catch (InterruptedException | IdentityOAuth2Exception e) {
                log.error((Object)"Error when executing AuthPersistenceTask", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

