/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.util.JdbcUtils;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.AbstractOAuthDAO;
import org.wso2.carbon.identity.oauth2.dao.AccessTokenDAO;
import org.wso2.carbon.identity.oauth2.dao.OldTokensCleanDAO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuer;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinding;
import org.wso2.carbon.identity.oauth2.util.OAuth2TokenUtil;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class AccessTokenDAOImpl
extends AbstractOAuthDAO
implements AccessTokenDAO {
    private static final String OAUTH_TOKEN_PERSISTENCE_RETRY_COUNT = "OAuth.TokenPersistence.RetryCount";
    private static final int DEFAULT_TOKEN_PERSIST_RETRY_COUNT = 5;
    private static final String IDN_OAUTH2_ACCESS_TOKEN = "IDN_OAUTH2_ACCESS_TOKEN";
    private boolean isTokenCleanupFeatureEnabled = OAuthServerConfiguration.getInstance().isTokenCleanupEnabled();
    private static final Log log = LogFactory.getLog(AccessTokenDAOImpl.class);
    OldTokensCleanDAO oldTokenCleanupObject = new OldTokensCleanDAO();

    @Override
    public void insertAccessToken(String accessToken, String consumerKey, AccessTokenDO accessTokenDO, String userStoreDomain) throws IdentityOAuth2Exception {
        try (Connection connection = this.getConnection();){
            this.insertAccessToken(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain);
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error while inserting access token.", e);
        }
    }

    private void insertAccessToken(String accessToken, String consumerKey, AccessTokenDO accessTokenDO, Connection connection, String userStoreDomain) throws IdentityOAuth2Exception {
        this.insertAccessToken(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertAccessToken(String accessToken, String consumerKey, AccessTokenDO accessTokenDO, Connection connection, String userStoreDomain, int retryAttemptCounter) throws IdentityOAuth2Exception {
        if (!this.isPersistenceEnabled()) {
            return;
        }
        if (accessTokenDO == null) {
            throw new IdentityOAuth2Exception("Access token data object should be available for further execution.");
        }
        if (accessTokenDO.getAuthzUser() == null) {
            throw new IdentityOAuth2Exception("Authorized user should be available for further execution.");
        }
        String accessTokenHash = accessToken;
        try {
            OauthTokenIssuer oauthTokenIssuer = OAuth2Util.getOAuthTokenIssuerForOAuthApp(consumerKey);
            if (oauthTokenIssuer.usePersistedAccessTokenAlias()) {
                accessTokenHash = oauthTokenIssuer.getAccessTokenHash(accessToken);
            }
        }
        catch (OAuthSystemException e) {
            if (!log.isDebugEnabled()) throw new IdentityOAuth2Exception("Error while getting access token hash.");
            if (!IdentityUtil.isTokenLoggable((String)"AccessToken")) throw new IdentityOAuth2Exception("Error while getting access token hash.");
            log.debug((Object)("Error while getting access token hash for token(hashed): " + DigestUtils.sha256Hex((String)accessTokenHash)));
            throw new IdentityOAuth2Exception("Error while getting access token hash.");
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving oauth issuer for the app with clientId: " + consumerKey, e);
        }
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Persisting access token(hashed): " + DigestUtils.sha256Hex((String)accessTokenHash) + " for client: " + consumerKey + " user: " + accessTokenDO.getAuthzUser().toString() + " scope: " + Arrays.toString(accessTokenDO.getScope())));
            } else {
                log.debug((Object)("Persisting access token for client: " + consumerKey + " user: " + accessTokenDO.getAuthzUser().toString() + " scope: " + Arrays.toString(accessTokenDO.getScope())));
            }
        }
        userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStoreDomain);
        String userDomain = OAuth2Util.getUserStoreDomain(accessTokenDO.getAuthzUser());
        String authenticatedIDP = OAuth2Util.getAuthenticatedIDP(accessTokenDO.getAuthzUser());
        PreparedStatement insertTokenPrepStmt = null;
        PreparedStatement addScopePrepStmt = null;
        if (log.isDebugEnabled()) {
            String username = this.isFederatedUser(accessTokenDO) ? accessTokenDO.getAuthzUser().getAuthenticatedSubjectIdentifier() : accessTokenDO.getAuthzUser().toFullQualifiedUsername();
            log.debug((Object)("Userstore domain for user: " + username + " is " + userDomain));
        }
        String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN (ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, USER_TYPE, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH,IDP_ID, TOKEN_BINDING_REF) SELECT ?,?,IDN_OAUTH_CONSUMER_APPS.ID,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,IDP.ID,? FROM IDN_OAUTH_CONSUMER_APPS, IDP WHERE CONSUMER_KEY=? AND IDP.NAME=? AND IDP.TENANT_ID=?" : "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN (ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY_ID, AUTHZ_USER, TENANT_ID, USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_SCOPE_HASH, TOKEN_STATE, USER_TYPE, TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH, TOKEN_BINDING_REF) SELECT ?,?,ID,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
        sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userDomain);
        String sqlAddScopes = OAuth2Util.getTokenPartitionedSqlByUserStore("INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_SCOPE (TOKEN_ID, TOKEN_SCOPE, TENANT_ID) VALUES (?,?,?)", userDomain);
        try {
            insertTokenPrepStmt = connection.prepareStatement(sql);
            insertTokenPrepStmt.setString(1, this.getPersistenceProcessor().getProcessedAccessTokenIdentifier(accessTokenHash));
            if (accessTokenDO.getRefreshToken() != null) {
                insertTokenPrepStmt.setString(2, this.getPersistenceProcessor().getProcessedRefreshToken(accessTokenDO.getRefreshToken()));
            } else {
                insertTokenPrepStmt.setString(2, accessTokenDO.getRefreshToken());
            }
            insertTokenPrepStmt.setString(3, accessTokenDO.getAuthzUser().getUserName());
            int tenantId = OAuth2Util.getTenantId(accessTokenDO.getAuthzUser().getTenantDomain());
            insertTokenPrepStmt.setInt(4, tenantId);
            insertTokenPrepStmt.setString(5, OAuth2Util.getSanitizedUserStoreDomain(userDomain));
            insertTokenPrepStmt.setTimestamp(6, accessTokenDO.getIssuedTime(), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            insertTokenPrepStmt.setTimestamp(7, accessTokenDO.getRefreshTokenIssuedTime(), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            insertTokenPrepStmt.setLong(8, accessTokenDO.getValidityPeriodInMillis());
            insertTokenPrepStmt.setLong(9, accessTokenDO.getRefreshTokenValidityPeriodInMillis());
            insertTokenPrepStmt.setString(10, OAuth2Util.hashScopes(accessTokenDO.getScope()));
            insertTokenPrepStmt.setString(11, accessTokenDO.getTokenState());
            insertTokenPrepStmt.setString(12, accessTokenDO.getTokenType());
            insertTokenPrepStmt.setString(13, accessTokenDO.getTokenId());
            insertTokenPrepStmt.setString(14, accessTokenDO.getGrantType());
            insertTokenPrepStmt.setString(15, accessTokenDO.getAuthzUser().getAuthenticatedSubjectIdentifier());
            insertTokenPrepStmt.setString(16, this.getHashingPersistenceProcessor().getProcessedAccessTokenIdentifier(accessTokenHash));
            if (accessTokenDO.getRefreshToken() != null) {
                insertTokenPrepStmt.setString(17, this.getHashingPersistenceProcessor().getProcessedRefreshToken(accessTokenDO.getRefreshToken()));
            } else {
                insertTokenPrepStmt.setString(17, accessTokenDO.getRefreshToken());
            }
            boolean tokenBindingAvailable = this.isTokenBindingAvailable(accessTokenDO.getTokenBinding());
            if (tokenBindingAvailable) {
                insertTokenPrepStmt.setString(18, accessTokenDO.getTokenBinding().getBindingReference());
            } else {
                insertTokenPrepStmt.setString(18, "NONE");
            }
            insertTokenPrepStmt.setString(19, this.getPersistenceProcessor().getProcessedClientId(consumerKey));
            if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                insertTokenPrepStmt.setString(20, authenticatedIDP);
                insertTokenPrepStmt.setInt(21, tenantId);
            }
            insertTokenPrepStmt.execute();
            String accessTokenId = accessTokenDO.getTokenId();
            addScopePrepStmt = connection.prepareStatement(sqlAddScopes);
            if (accessTokenDO.getScope() != null && accessTokenDO.getScope().length > 0) {
                for (String scope : accessTokenDO.getScope()) {
                    addScopePrepStmt.setString(1, accessTokenId);
                    addScopePrepStmt.setString(2, scope);
                    addScopePrepStmt.setInt(3, tenantId);
                    addScopePrepStmt.execute();
                }
            }
            if (tokenBindingAvailable) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO IDN_OAUTH2_TOKEN_BINDING (TOKEN_ID, TOKEN_BINDING_TYPE, TOKEN_BINDING_REF, TOKEN_BINDING_VALUE, TENANT_ID) VALUES (?, ?, ?, ?, ?)");){
                    preparedStatement.setString(1, accessTokenId);
                    preparedStatement.setString(2, accessTokenDO.getTokenBinding().getBindingType());
                    preparedStatement.setString(3, accessTokenDO.getTokenBinding().getBindingReference());
                    preparedStatement.setString(4, accessTokenDO.getTokenBinding().getBindingValue());
                    preparedStatement.setInt(5, tenantId);
                    preparedStatement.execute();
                }
            }
            if (retryAttemptCounter > 0) {
                log.info((Object)("Successfully recovered 'CON_APP_KEY' constraint violation with the attempt : " + retryAttemptCounter));
            }
            IdentityDatabaseUtil.closeStatement((PreparedStatement)addScopePrepStmt);
        }
        catch (SQLIntegrityConstraintViolationException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            if (retryAttemptCounter >= this.getTokenPersistRetryCount()) {
                log.error((Object)("'CON_APP_KEY' constrain violation retry count exceeds above the maximum count - " + this.getTokenPersistRetryCount()));
                String errorMsg = "Access Token for consumer key : " + consumerKey + ", user : " + accessTokenDO.getAuthzUser() + " and scope : " + OAuth2Util.buildScopeString(accessTokenDO.getScope()) + "already exists";
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            this.recoverFromConAppKeyConstraintViolation(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, retryAttemptCounter + 1);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (DataTruncation e2) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Invalid request", e2);
                catch (SQLException e3) {
                    IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                    if (!StringUtils.containsIgnoreCase((String)e3.getMessage(), (String)"CON_APP_KEY")) throw new IdentityOAuth2Exception("Error when storing the access token for consumer key : " + consumerKey, e3);
                    if (retryAttemptCounter >= this.getTokenPersistRetryCount()) {
                        log.error((Object)("'CON_APP_KEY' constrain violation retry count exceeds above the maximum count - " + this.getTokenPersistRetryCount()));
                        String errorMsg = "Access Token for consumer key : " + consumerKey + ", user : " + accessTokenDO.getAuthzUser() + " and scope : " + OAuth2Util.buildScopeString(accessTokenDO.getScope()) + "already exists";
                        throw new IdentityOAuth2Exception(errorMsg, e3);
                    }
                    this.recoverFromConAppKeyConstraintViolation(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, retryAttemptCounter + 1);
                    return;
                }
            }
        }
        finally {
            IdentityDatabaseUtil.closeStatement(addScopePrepStmt);
            IdentityDatabaseUtil.closeStatement((PreparedStatement)insertTokenPrepStmt);
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)insertTokenPrepStmt);
        return;
    }

    @Override
    public boolean insertAccessToken(String accessToken, String consumerKey, AccessTokenDO newAccessTokenDO, AccessTokenDO existingAccessTokenDO, String rawUserStoreDomain) throws IdentityOAuth2Exception {
        if (!this.isPersistenceEnabled()) {
            return false;
        }
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Persisting access token(hashed): " + DigestUtils.sha256Hex((String)accessToken) + " for client: " + consumerKey + " user: " + newAccessTokenDO.getAuthzUser().toString() + " scope: " + Arrays.toString(newAccessTokenDO.getScope())));
            } else {
                log.debug((Object)("Persisting access token for client: " + consumerKey + " user: " + newAccessTokenDO.getAuthzUser().toString() + " scope: " + Arrays.toString(newAccessTokenDO.getScope())));
            }
        }
        String userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(rawUserStoreDomain);
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        try {
            if (existingAccessTokenDO != null) {
                this.updateAccessTokenState(connection, existingAccessTokenDO.getTokenId(), "EXPIRED", UUID.randomUUID().toString(), userStoreDomain);
            }
            this.insertAccessToken(accessToken, consumerKey, newAccessTokenDO, connection, userStoreDomain);
            if (this.isTokenCleanupFeatureEnabled && existingAccessTokenDO != null) {
                this.oldTokenCleanupObject.cleanupTokenByTokenId(existingAccessTokenDO.getTokenId(), connection);
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while persisting access token", e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    @Override
    public AccessTokenDO getLatestAccessToken(String consumerKey, AuthenticatedUser authzUser, String userStoreDomain, String scope, boolean includeExpiredTokens) throws IdentityOAuth2Exception {
        return this.getLatestAccessToken(consumerKey, authzUser, userStoreDomain, scope, "NONE", includeExpiredTokens);
    }

    @Override
    public AccessTokenDO getLatestAccessToken(String consumerKey, AuthenticatedUser authzUser, String userStoreDomain, String scope, String tokenBindingReference, boolean includeExpiredTokens) throws IdentityOAuth2Exception {
        AccessTokenDO accessTokenDO;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        block21: {
            String hashedScope;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving latest access token for client: " + consumerKey + " user: " + authzUser.toString() + " scope: " + scope));
            }
            boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authzUser.toString());
            String tenantDomain = authzUser.getTenantDomain();
            int tenantId = OAuth2Util.getTenantId(tenantDomain);
            String tenantAwareUsernameWithNoUserDomain = authzUser.getUserName();
            String userDomain = OAuth2Util.getUserStoreDomain(authzUser);
            String authenticatedIDP = OAuth2Util.getAuthenticatedIDP(authzUser);
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            String driverName = connection.getMetaData().getDriverName();
            String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY" : (driverName.contains("MS SQL") ? "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WITH (NOLOCK) WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC" : (driverName.contains("Microsoft") ? "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WITH (NOLOCK) WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC" : (driverName.contains("PostgreSQL") ? "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 " : (driverName.contains("Informix") ? "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN " : "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD,TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ")))))) : (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY" : (driverName.contains("MS SQL") ? "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WITH (NOLOCK) WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC" : (driverName.contains("Microsoft") ? "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WITH (NOLOCK) WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC" : (driverName.contains("PostgreSQL") ? "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 " : (driverName.contains("Informix") ? "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC) TOKEN " : "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD,TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 "))))));
            if (!includeExpiredTokens) {
                sql = sql.replace("TOKEN_SCOPE_HASH=?", "TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE'");
            }
            sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userDomain);
            if (!isUsernameCaseSensitive) {
                sql = sql.replace("AUTHZ_USER", "LOWER(AUTHZ_USER)");
            }
            if ((hashedScope = OAuth2Util.hashScopes(scope)) == null) {
                sql = sql.replace("TOKEN_SCOPE_HASH=?", "TOKEN_SCOPE_HASH IS NULL");
            }
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, this.getPersistenceProcessor().getProcessedClientId(consumerKey));
            if (isUsernameCaseSensitive) {
                prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain);
            } else {
                prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain.toLowerCase());
            }
            prepStmt.setInt(3, tenantId);
            prepStmt.setString(4, userDomain);
            if (hashedScope != null) {
                prepStmt.setString(5, hashedScope);
            }
            prepStmt.setString(6, tokenBindingReference);
            if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                prepStmt.setString(7, authenticatedIDP);
            }
            if (!(resultSet = prepStmt.executeQuery()).next()) break block21;
            boolean returnToken = false;
            String tokenState = resultSet.getString(7);
            if (includeExpiredTokens) {
                if ("ACTIVE".equals(tokenState) || "EXPIRED".equals(tokenState)) {
                    returnToken = true;
                }
            } else if ("ACTIVE".equals(tokenState)) {
                returnToken = true;
            }
            if (!returnToken) break block21;
            String accessToken = this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(resultSet.getString(1));
            String refreshToken = null;
            if (resultSet.getString(2) != null) {
                refreshToken = this.getPersistenceProcessor().getPreprocessedRefreshToken(resultSet.getString(2));
            }
            long issuedTime = resultSet.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone("UTC"))).getTime();
            long refreshTokenIssuedTime = resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone("UTC"))).getTime();
            long validityPeriodInMillis = resultSet.getLong(5);
            long refreshTokenValidityPeriodInMillis = resultSet.getLong(6);
            String userType = resultSet.getString(8);
            String tokenId = resultSet.getString(9);
            String subjectIdentifier = resultSet.getString(10);
            AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(tenantAwareUsernameWithNoUserDomain, userDomain, tenantDomain, authenticatedIDP);
            user.setAuthenticatedSubjectIdentifier(subjectIdentifier);
            AccessTokenDO accessTokenDO2 = new AccessTokenDO(consumerKey, user, OAuth2Util.buildScopeArray(scope), new Timestamp(issuedTime), new Timestamp(refreshTokenIssuedTime), validityPeriodInMillis, refreshTokenValidityPeriodInMillis, userType);
            accessTokenDO2.setAccessToken(accessToken);
            accessTokenDO2.setRefreshToken(refreshToken);
            accessTokenDO2.setTokenState(tokenState);
            accessTokenDO2.setTokenId(tokenId);
            if (StringUtils.isNotBlank((String)tokenBindingReference) && !"NONE".equals(tokenBindingReference)) {
                this.setTokenBindingToAccessTokenDO(accessTokenDO2, connection, tokenId);
            }
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Retrieved latest access token(hashed): " + DigestUtils.sha256Hex((String)accessToken) + " for client: " + consumerKey + " user: " + authzUser.toString() + " scope: " + scope + " token binding reference: " + tokenBindingReference));
            }
            AccessTokenDO accessTokenDO3 = accessTokenDO2;
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return accessTokenDO3;
        }
        try {
            accessTokenDO = null;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while trying to retrieve latest 'ACTIVE' access token for Client ID : " + consumerKey + ", User ID : " + authzUser + " and  Scope : " + scope;
                if (includeExpiredTokens) {
                    errorMsg = errorMsg.replace("ACTIVE", "ACTIVE or EXPIRED");
                }
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return accessTokenDO;
    }

    private AccessTokenDO getLatestAccessTokenByState(Connection connection, String consumerKey, AuthenticatedUser authzUser, String userStoreDomain, String scope, boolean active) throws IdentityOAuth2Exception, SQLException {
        AccessTokenDO accessTokenDO;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving latest " + (active ? " active" : " non active") + " access token for user: " + authzUser.toString() + " client: " + consumerKey + " scope: " + scope));
        }
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authzUser.toString());
        String tenantDomain = authzUser.getTenantDomain();
        int tenantId = OAuth2Util.getTenantId(tenantDomain);
        String tenantAwareUsernameWithNoUserDomain = authzUser.getUserName();
        String userDomain = OAuth2Util.getUserStoreDomain(authzUser);
        String authenticatedIDP = OAuth2Util.getAuthenticatedIDP(authzUser);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            String hashedScope;
            String driverName = connection.getMetaData().getDriverName();
            String sql = active ? (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID =(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY" : (driverName.contains("MS SQL") || driverName.contains("Microsoft") ? "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC" : (driverName.contains("PostgreSQL") ? "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 " : (driverName.contains("Informix") ? "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN " : "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 "))))) : (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID =(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY" : (driverName.contains("MS SQL") || driverName.contains("Microsoft") ? "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC" : (driverName.contains("PostgreSQL") ? "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 " : (driverName.contains("Informix") ? "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN " : "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE' ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ")))))) : (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID =(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY" : (driverName.contains("MS SQL") || driverName.contains("Microsoft") ? "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC" : (driverName.contains("PostgreSQL") ? "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 " : (driverName.contains("Informix") ? "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN " : "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 "))))) : (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID =(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY" : (driverName.contains("MS SQL") || driverName.contains("Microsoft") ? "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC" : (driverName.contains("PostgreSQL") ? "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 " : (driverName.contains("Informix") ? "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC) TOKEN " : "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_STATE!='ACTIVE' ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 "))))));
            sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userDomain);
            if (!isUsernameCaseSensitive) {
                sql = sql.replace("AUTHZ_USER", "LOWER(AUTHZ_USER)");
            }
            if ((hashedScope = OAuth2Util.hashScopes(scope)) == null) {
                sql = sql.replace("TOKEN_SCOPE_HASH=?", "TOKEN_SCOPE_HASH IS NULL");
            }
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, this.getPersistenceProcessor().getProcessedClientId(consumerKey));
            if (isUsernameCaseSensitive) {
                prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain);
            } else {
                prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain.toLowerCase());
            }
            prepStmt.setInt(3, tenantId);
            prepStmt.setString(4, userDomain);
            if (hashedScope != null) {
                prepStmt.setString(5, hashedScope);
            }
            if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                prepStmt.setString(6, authenticatedIDP);
            }
            resultSet = prepStmt.executeQuery();
            AccessTokenDO accessTokenDO2 = null;
            if (resultSet.next()) {
                ServiceProvider serviceProvider;
                String accessToken = this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(resultSet.getString(1));
                String refreshToken = null;
                if (resultSet.getString(2) != null) {
                    refreshToken = this.getPersistenceProcessor().getPreprocessedRefreshToken(resultSet.getString(2));
                }
                long issuedTime = resultSet.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone("UTC"))).getTime();
                long refreshTokenIssuedTime = resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone("UTC"))).getTime();
                long validityPeriodInMillis = resultSet.getLong(5);
                long refreshTokenValidityPeriodInMillis = resultSet.getLong(6);
                String userType = resultSet.getString(7);
                String tokenId = resultSet.getString(8);
                String subjectIdentifier = resultSet.getString(9);
                AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(tenantAwareUsernameWithNoUserDomain, userDomain, tenantDomain, authenticatedIDP);
                try {
                    serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                }
                catch (IdentityApplicationManagementException e) {
                    throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                }
                user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                accessTokenDO2 = new AccessTokenDO(consumerKey, user, OAuth2Util.buildScopeArray(scope), new Timestamp(issuedTime), new Timestamp(refreshTokenIssuedTime), validityPeriodInMillis, refreshTokenValidityPeriodInMillis, userType);
                accessTokenDO2.setAccessToken(accessToken);
                accessTokenDO2.setRefreshToken(refreshToken);
                accessTokenDO2.setTokenId(tokenId);
            }
            accessTokenDO = accessTokenDO2;
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String errorMsg = "Error occurred while trying to retrieve latest 'ACTIVE' access token for Client ID : " + consumerKey + ", User ID : " + authzUser + " and  Scope : " + scope;
                if (!active) {
                    errorMsg = errorMsg.replace("ACTIVE", "NON ACTIVE");
                }
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections(null, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return accessTokenDO;
    }

    @Override
    public Set<AccessTokenDO> getAccessTokens(String consumerKey, AuthenticatedUser userName, String userStoreDomain, boolean includeExpired) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving access tokens for client: " + consumerKey + " user: " + userName.toString()));
        }
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)userName.toString());
        String tenantDomain = userName.getTenantDomain();
        String tenantAwareUsernameWithNoUserDomain = userName.getUserName();
        String userDomain = OAuth2Util.getUserStoreDomain(userName);
        userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStoreDomain);
        String authenticatedIDP = OAuth2Util.getAuthenticatedIDP(userName);
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        HashMap<String, AccessTokenDO> accessTokenDOMap = new HashMap<String, AccessTokenDO>();
        try {
            int tenantId = OAuth2Util.getTenantId(tenantDomain);
            String sql = includeExpired ? (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED') AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID)) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID") : (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_STATE='ACTIVE' AND IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID)) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID" : "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_STATE='ACTIVE') ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID");
            sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userStoreDomain);
            if (!isUsernameCaseSensitive) {
                sql = sql.replace("AUTHZ_USER", "LOWER(AUTHZ_USER)");
            }
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, this.getPersistenceProcessor().getProcessedClientId(consumerKey));
            if (isUsernameCaseSensitive) {
                prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain);
            } else {
                prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain.toLowerCase());
            }
            prepStmt.setInt(3, tenantId);
            prepStmt.setString(4, userDomain);
            if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                prepStmt.setString(5, authenticatedIDP);
            }
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                String accessToken = this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(resultSet.getString(1));
                if (accessTokenDOMap.get(accessToken) == null) {
                    ServiceProvider serviceProvider;
                    String refreshToken = this.getPersistenceProcessor().getPreprocessedRefreshToken(resultSet.getString(2));
                    Timestamp issuedTime = resultSet.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    Timestamp refreshTokenIssuedTime = resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    long validityPeriodInMillis = resultSet.getLong(5);
                    long refreshTokenValidityPeriodMillis = resultSet.getLong(6);
                    String tokenType = resultSet.getString(7);
                    String[] scope = OAuth2Util.buildScopeArray(resultSet.getString(8));
                    String tokenId = resultSet.getString(9);
                    String subjectIdentifier = resultSet.getString(10);
                    String tokenBindingReference = resultSet.getString(11);
                    AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(tenantAwareUsernameWithNoUserDomain, userDomain, tenantDomain, authenticatedIDP);
                    try {
                        serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                    }
                    catch (IdentityApplicationManagementException e) {
                        throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                    }
                    user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                    AccessTokenDO dataDO = new AccessTokenDO(consumerKey, user, scope, issuedTime, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodMillis, tokenType);
                    dataDO.setAccessToken(accessToken);
                    dataDO.setRefreshToken(refreshToken);
                    dataDO.setTokenId(tokenId);
                    if (StringUtils.isNotBlank((String)tokenBindingReference) && !"NONE".equals(tokenBindingReference)) {
                        this.setTokenBindingToAccessTokenDO(dataDO, connection, tokenId);
                    }
                    accessTokenDOMap.put(accessToken, dataDO);
                    continue;
                }
                String scope = resultSet.getString(8).trim();
                AccessTokenDO accessTokenDO = (AccessTokenDO)((Object)accessTokenDOMap.get(accessToken));
                accessTokenDO.setScope((String[])ArrayUtils.add((Object[])accessTokenDO.getScope(), (Object)scope));
            }
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'ACTIVE' access tokens for Client ID : " + consumerKey + " and User ID : " + userName;
                if (includeExpired) {
                    errorMsg = errorMsg.replace("ACTIVE", "ACTIVE or EXPIRED");
                }
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return new HashSet<AccessTokenDO>(accessTokenDOMap.values());
    }

    @Override
    public AccessTokenDO getAccessToken(String accessTokenIdentifier, boolean includeExpired) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
            log.debug((Object)("Retrieving information of access token(hashed): " + DigestUtils.sha256Hex((String)accessTokenIdentifier)));
        }
        AccessTokenDO dataDO = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            String sql = includeExpired ? (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE, SUBJECT_IDENTIFIER, IDN_OAUTH2_ACCESS_TOKEN.IDP_ID, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID WHERE ACCESS_TOKEN_HASH=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID = IDP.ID" : "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID WHERE ACCESS_TOKEN_HASH=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID") : (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF, IDP.NAME FROM (SELECT TOKEN_ID, CONSUMER_KEY,  AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID AS TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN AS USER_DOMAIN,TIME_CREATED,REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE AS GRANT_TYPE,SUBJECT_IDENTIFIER, IDN_OAUTH2_ACCESS_TOKEN.IDP_ID AS IDP_ID, TOKEN_BINDING_REF FROM (SELECT * FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH=? AND TOKEN_STATE='ACTIVE') IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP_ID = IDP.ID" : "SELECT CONSUMER_KEY, AUTHZ_USER, ACCESS_TOKEN_TABLE.TENANT_ID, USER_DOMAIN, TOKEN_SCOPE, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT TOKEN_ID, CONSUMER_KEY, AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID AS TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN AS USER_DOMAIN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.GRANT_TYPE AS GRANT_TYPE, SUBJECT_IDENTIFIER, TOKEN_BINDING_REF FROM (SELECT * FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH=? AND TOKEN_STATE='ACTIVE') IDN_OAUTH2_ACCESS_TOKEN JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID");
            sql = OAuth2Util.getTokenPartitionedSqlByToken(sql, accessTokenIdentifier);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, this.getHashingPersistenceProcessor().getProcessedAccessTokenIdentifier(accessTokenIdentifier));
            resultSet = prepStmt.executeQuery();
            int iterateId = 0;
            ArrayList<String> scopes = new ArrayList<String>();
            while (resultSet.next()) {
                if (iterateId == 0) {
                    ServiceProvider serviceProvider;
                    String consumerKey = this.getPersistenceProcessor().getPreprocessedClientId(resultSet.getString(1));
                    String authorizedUser = resultSet.getString(2);
                    int tenantId = resultSet.getInt(3);
                    String tenantDomain = OAuth2Util.getTenantDomain(tenantId);
                    String userDomain = resultSet.getString(4);
                    String[] scope = OAuth2Util.buildScopeArray(resultSet.getString(5));
                    Timestamp issuedTime = resultSet.getTimestamp(6, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    Timestamp refreshTokenIssuedTime = resultSet.getTimestamp(7, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    long validityPeriodInMillis = resultSet.getLong(8);
                    long refreshTokenValidityPeriodMillis = resultSet.getLong(9);
                    String tokenType = resultSet.getString(10);
                    String refreshToken = resultSet.getString(11);
                    String tokenId = resultSet.getString(12);
                    String grantType = resultSet.getString(13);
                    String subjectIdentifier = resultSet.getString(14);
                    String authenticatedIDP = null;
                    String tokenBindingReference = resultSet.getString(15);
                    if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                        authenticatedIDP = resultSet.getString(16);
                    }
                    AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(authorizedUser, userDomain, tenantDomain, authenticatedIDP);
                    try {
                        serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                    }
                    catch (IdentityApplicationManagementException e) {
                        throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                    }
                    user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                    dataDO = new AccessTokenDO(consumerKey, user, scope, issuedTime, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodMillis, tokenType);
                    dataDO.setAccessToken(accessTokenIdentifier);
                    dataDO.setRefreshToken(refreshToken);
                    dataDO.setTokenId(tokenId);
                    dataDO.setGrantType(grantType);
                    dataDO.setTenantID(tenantId);
                    if (StringUtils.isNotBlank((String)tokenBindingReference) && !"NONE".equals(tokenBindingReference)) {
                        this.setTokenBindingToAccessTokenDO(dataDO, connection, tokenId);
                    }
                } else {
                    scopes.add(resultSet.getString(5));
                }
                ++iterateId;
            }
            if (scopes.size() > 0 && dataDO != null) {
                dataDO.setScope((String[])ArrayUtils.addAll((Object[])dataDO.getScope(), (Object[])scopes.toArray(new String[scopes.size()])));
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuth2Exception("Error when retrieving Access Token" + e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return dataDO;
    }

    private void setTokenBindingToAccessTokenDO(AccessTokenDO dataDO, Connection connection, String tokenId) throws SQLException {
        try (PreparedStatement tokenBindingPreparedStatement = connection.prepareStatement("SELECT TOKEN_BINDING_TYPE, TOKEN_BINDING_REF, TOKEN_BINDING_VALUE FROM IDN_OAUTH2_TOKEN_BINDING WHERE TOKEN_ID = ?");){
            tokenBindingPreparedStatement.setString(1, tokenId);
            try (ResultSet tokenBindingResultSet = tokenBindingPreparedStatement.executeQuery();){
                if (tokenBindingResultSet.next()) {
                    TokenBinding tokenBinding = new TokenBinding();
                    tokenBinding.setBindingType(tokenBindingResultSet.getString("TOKEN_BINDING_TYPE"));
                    tokenBinding.setBindingReference(tokenBindingResultSet.getString("TOKEN_BINDING_REF"));
                    tokenBinding.setBindingValue(tokenBindingResultSet.getString("TOKEN_BINDING_VALUE"));
                    dataDO.setTokenBinding(tokenBinding);
                }
            }
        }
    }

    @Override
    public void updateAccessTokenState(String tokenId, String tokenState) throws IdentityOAuth2Exception {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            if (log.isDebugEnabled()) {
                log.debug((Object)("Changing status of access token with id: " + tokenId + " to: " + tokenState));
            }
            String sql = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_ID=?";
            try (PreparedStatement prepStmt = connection.prepareStatement(sql);){
                prepStmt.setString(1, tokenState);
                prepStmt.setString(2, UUID.randomUUID().toString());
                prepStmt.setString(3, tokenId);
                prepStmt.executeUpdate();
                OAuth2TokenUtil.postUpdateAccessToken(tokenId, tokenState);
                if (this.isTokenCleanupFeatureEnabled && !"ACTIVE".equals(tokenState)) {
                    this.oldTokenCleanupObject.cleanupTokenByTokenId(tokenId, connection);
                }
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error while updating Access Token with ID : " + tokenId + " to Token State : " + tokenState, e);
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error while closing connection after updating Access Token with ID : " + tokenId + " to Token State : " + tokenState, e);
        }
    }

    private void updateAccessTokenState(Connection connection, String tokenId, String tokenState, String tokenStateId, String userStoreDomain) throws IdentityOAuth2Exception, SQLException {
        PreparedStatement prepStmt = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Changing status of access token with id: " + tokenId + " to: " + tokenState + " userStoreDomain: " + userStoreDomain));
            }
            String sql = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_ID=?";
            sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userStoreDomain);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, tokenState);
            prepStmt.setString(2, tokenStateId);
            prepStmt.setString(3, tokenId);
            prepStmt.executeUpdate();
            OAuth2TokenUtil.postUpdateAccessToken(tokenId, tokenState);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error while updating Access Token with ID : " + tokenId + " to Token State : " + tokenState, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
    }

    @Override
    public void revokeAccessTokens(String[] tokens) throws IdentityOAuth2Exception {
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            this.revokeAccessTokensIndividually(tokens);
        } else {
            this.revokeAccessTokensInBatch(tokens);
        }
    }

    @Override
    public void revokeAccessTokens(String[] tokens, boolean isHashedToken) throws IdentityOAuth2Exception {
        if (isHashedToken) {
            if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
                this.revokeAccessTokensIndividually(tokens, true);
            } else {
                this.revokeAccessTokensInBatch(tokens, true);
            }
        } else {
            this.revokeAccessTokens(tokens);
        }
    }

    @Override
    public void revokeAccessTokensInBatch(String[] tokens) throws IdentityOAuth2Exception {
        this.revokeAccessTokensInBatch(tokens, false);
    }

    @Override
    public void revokeAccessTokensInBatch(String[] tokens, boolean isHashedToken) throws IdentityOAuth2Exception {
        if (ArrayUtils.isEmpty((Object[])tokens)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No tokens to revoke in batch mode. Therefore not continuing further in revocation.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String token : tokens) {
                    stringBuilder.append(DigestUtils.sha256Hex((String)token)).append(" ");
                }
                log.debug((Object)("Revoking access tokens(hashed): " + stringBuilder.toString()));
            } else {
                log.debug((Object)"Revoking access tokens in batch mode");
            }
        }
        String accessTokenStoreTable = IDN_OAUTH2_ACCESS_TOKEN;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        if (tokens.length > 1) {
            block21: {
                try {
                    ArrayList<String> oldTokens = new ArrayList<String>();
                    String sqlQuery = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE ACCESS_TOKEN_HASH=?".replace(IDN_OAUTH2_ACCESS_TOKEN, accessTokenStoreTable);
                    ps = connection.prepareStatement(sqlQuery);
                    for (String token : tokens) {
                        ps.setString(1, "REVOKED");
                        ps.setString(2, UUID.randomUUID().toString());
                        if (isHashedToken) {
                            ps.setString(3, token);
                        } else {
                            ps.setString(3, this.getHashingPersistenceProcessor().getProcessedAccessTokenIdentifier(token));
                        }
                        ps.addBatch();
                        oldTokens.add(this.getHashingPersistenceProcessor().getProcessedAccessTokenIdentifier(token));
                    }
                    ps.executeBatch();
                    IdentityDatabaseUtil.commitTransaction((Connection)connection);
                    OAuth2TokenUtil.postUpdateAccessTokens(Arrays.asList(tokens), "REVOKED");
                    if (!this.isTokenCleanupFeatureEnabled) break block21;
                    this.oldTokenCleanupObject.cleanupTokensInBatch(oldTokens, connection);
                }
                catch (SQLException e) {
                    try {
                        IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                        throw new IdentityOAuth2Exception("Error occurred while revoking Access Tokens : " + Arrays.toString(tokens), e);
                    }
                    catch (Throwable throwable) {
                        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                        throw throwable;
                    }
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
        if (tokens.length == 1) {
            block22: {
                try {
                    connection.setAutoCommit(true);
                    String sqlQuery = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE ACCESS_TOKEN_HASH=?".replace(IDN_OAUTH2_ACCESS_TOKEN, accessTokenStoreTable);
                    ps = connection.prepareStatement(sqlQuery);
                    ps.setString(1, "REVOKED");
                    ps.setString(2, UUID.randomUUID().toString());
                    if (isHashedToken) {
                        ps.setString(3, tokens[0]);
                    } else {
                        ps.setString(3, this.getHashingPersistenceProcessor().getProcessedAccessTokenIdentifier(tokens[0]));
                    }
                    ps.executeUpdate();
                    OAuth2TokenUtil.postUpdateAccessTokens(Arrays.asList(tokens), "REVOKED");
                    if (!this.isTokenCleanupFeatureEnabled) break block22;
                    this.oldTokenCleanupObject.cleanupTokenByTokenValue(this.getHashingPersistenceProcessor().getProcessedAccessTokenIdentifier(tokens[0]), connection);
                }
                catch (SQLException e) {
                    try {
                        throw new IdentityOAuth2Exception("Error occurred while revoking Access Token : " + Arrays.toString(tokens), e);
                    }
                    catch (Throwable throwable) {
                        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                        throw throwable;
                    }
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    @Override
    public void revokeAccessTokensIndividually(String[] tokens) throws IdentityOAuth2Exception {
        this.revokeAccessTokensIndividually(tokens, false);
    }

    @Override
    public void revokeAccessTokensIndividually(String[] tokens, boolean isHashedToken) throws IdentityOAuth2Exception {
        ArrayList<String> accessTokenId = new ArrayList<String>();
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String token : tokens) {
                    stringBuilder.append(DigestUtils.sha256Hex((String)token)).append(" ");
                }
                log.debug((Object)("Revoking access tokens(hashed): " + stringBuilder.toString()));
            } else {
                log.debug((Object)"Revoking access tokens in individual mode");
            }
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            for (String token : tokens) {
                String sqlQuery = OAuth2Util.getTokenPartitionedSqlByToken("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE ACCESS_TOKEN_HASH=?", token);
                ps = connection.prepareStatement(sqlQuery);
                ps.setString(1, "REVOKED");
                ps.setString(2, UUID.randomUUID().toString());
                if (isHashedToken) {
                    ps.setString(3, token);
                } else {
                    ps.setString(3, this.getHashingPersistenceProcessor().getProcessedAccessTokenIdentifier(token));
                }
                int count = ps.executeUpdate();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Number of rows being updated : " + count));
                }
                accessTokenId.add(this.getTokenIdByAccessToken(token));
            }
            if (accessTokenId.size() > 0) {
                OAuth2TokenUtil.postUpdateAccessTokens(accessTokenId, "REVOKED");
            }
            if (this.isTokenCleanupFeatureEnabled) {
                for (String token : tokens) {
                    this.oldTokenCleanupObject.cleanupTokenByTokenValue(this.getHashingPersistenceProcessor().getProcessedAccessTokenIdentifier(token), connection);
                }
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while revoking Access Token : " + Arrays.toString(tokens), e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
    }

    @Override
    public void revokeAccessToken(String tokenId, String userId) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Revoking access token with id: " + tokenId + " user: " + userId));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserId("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_STATE=?, TOKEN_STATE_ID=? WHERE TOKEN_ID=?", userId);
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, "REVOKED");
            ps.setString(2, UUID.randomUUID().toString());
            ps.setString(3, tokenId);
            int count = ps.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of rows being updated : " + count));
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
            OAuth2TokenUtil.postUpdateAccessToken(tokenId, "REVOKED");
            if (this.isTokenCleanupFeatureEnabled && tokenId != null) {
                this.oldTokenCleanupObject.cleanupTokenByTokenId(tokenId, connection);
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while revoking Access Token with ID : " + tokenId, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
    }

    @Override
    public Set<String> getAccessTokensByUser(AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving access tokens of user: " + authenticatedUser.toString()));
        }
        String accessTokenStoreTable = IDN_OAUTH2_ACCESS_TOKEN;
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authenticatedUser.toString());
        boolean isIdTokenIssuedForClientCredentialsGrant = this.isIdTokenIssuedForApplicationTokens();
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        HashSet<String> accessTokens = new HashSet<String>();
        try {
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserId("SELECT DISTINCT ACCESS_TOKEN, USER_TYPE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE AUTHZ_USER=? AND TENANT_ID=? AND TOKEN_STATE=? AND USER_DOMAIN=?", authenticatedUser.toString());
            if (!isUsernameCaseSensitive) {
                sqlQuery = sqlQuery.replace("AUTHZ_USER", "LOWER(AUTHZ_USER)");
            }
            ps = connection.prepareStatement(sqlQuery);
            if (isUsernameCaseSensitive) {
                ps.setString(1, authenticatedUser.getUserName());
            } else {
                ps.setString(1, authenticatedUser.getUserName().toLowerCase());
            }
            ps.setInt(2, OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()));
            ps.setString(3, "ACTIVE");
            ps.setString(4, authenticatedUser.getUserStoreDomain());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String accessToken = this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(rs.getString(1));
                String tokenUserType = rs.getString(2);
                if (this.isApplicationUserToken(tokenUserType)) {
                    accessTokens.add(accessToken);
                    continue;
                }
                if (!isIdTokenIssuedForClientCredentialsGrant) continue;
                accessTokens.add(accessToken);
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while revoking Access Token with user Name : " + authenticatedUser.getUserName() + " tenant ID : " + OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()), e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        return accessTokens;
    }

    @Override
    public Set<AccessTokenDO> getAccessTokensByUserForOpenidScope(AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        HashSet<AccessTokenDO> accessTokens;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving access tokens of user: " + authenticatedUser.toString()));
        }
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authenticatedUser.toString());
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserId("SELECT DISTINCT ACCESS_TOKEN, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD, CONSUMER_KEY, GRANT_TYPE FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, GRANT_TYPE, CONSUMER_KEY_ID, TOKEN_ID, TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD FROM IDN_OAUTH2_ACCESS_TOKEN WHERE AUTHZ_USER=? AND TENANT_ID=? AND TOKEN_STATE=? AND USER_DOMAIN=?) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID WHERE TOKEN_SCOPE=?", authenticatedUser.toString());
            if (!isUsernameCaseSensitive) {
                sqlQuery = sqlQuery.replace("AUTHZ_USER", "LOWER(AUTHZ_USER)");
            }
            ps = connection.prepareStatement(sqlQuery);
            if (isUsernameCaseSensitive) {
                ps.setString(1, authenticatedUser.getUserName());
            } else {
                ps.setString(1, authenticatedUser.getUserName().toLowerCase());
            }
            ps.setInt(2, OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()));
            ps.setString(3, "ACTIVE");
            ps.setString(4, authenticatedUser.getUserStoreDomain());
            ps.setString(5, "openid");
            ResultSet rs = ps.executeQuery();
            Map<String, AccessTokenDO> tokenMap = this.getAccessTokenDOMapFromResultSet(authenticatedUser, rs);
            connection.commit();
            accessTokens = new HashSet<AccessTokenDO>(tokenMap.values());
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollBack((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while revoking access token with username : " + authenticatedUser.getUserName() + " tenant ID : " + OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()), e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        return accessTokens;
    }

    private Map<String, AccessTokenDO> getAccessTokenDOMapFromResultSet(AuthenticatedUser authenticatedUser, ResultSet rs) throws SQLException, IdentityOAuth2Exception {
        HashMap<String, AccessTokenDO> tokenMap = new HashMap<String, AccessTokenDO>();
        while (rs.next()) {
            String accessToken = this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(rs.getString(1));
            String refreshToken = this.getPersistenceProcessor().getPreprocessedRefreshToken(rs.getString(2));
            String tokenId = rs.getString(3);
            Timestamp timeCreated = rs.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            long issuedTimeInMillis = timeCreated.getTime();
            long validityPeriodInMillis = rs.getLong(5);
            Timestamp refreshTokenTimeCreated = rs.getTimestamp(6, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            long refreshTokenValidityPeriodInMillis = rs.getLong(7);
            String consumerKey = rs.getString(8);
            String grantType = rs.getString(9);
            AccessTokenDO accessTokenDO = new AccessTokenDO();
            accessTokenDO.setAuthzUser(authenticatedUser);
            accessTokenDO.setTenantID(OAuth2Util.getTenantId(authenticatedUser.getTenantDomain()));
            accessTokenDO.setAccessToken(accessToken);
            accessTokenDO.setRefreshToken(refreshToken);
            accessTokenDO.setTokenId(tokenId);
            accessTokenDO.setTokenState("ACTIVE");
            accessTokenDO.setIssuedTime(timeCreated);
            accessTokenDO.setValidityPeriodInMillis(validityPeriodInMillis);
            accessTokenDO.setRefreshTokenIssuedTime(refreshTokenTimeCreated);
            accessTokenDO.setRefreshTokenValidityPeriodInMillis(refreshTokenValidityPeriodInMillis);
            accessTokenDO.setConsumerKey(consumerKey);
            accessTokenDO.setGrantType(grantType);
            if (this.isAccessTokenExpired(issuedTimeInMillis, validityPeriodInMillis)) continue;
            tokenMap.put(accessToken, accessTokenDO);
        }
        return tokenMap;
    }

    private boolean isIdTokenIssuedForApplicationTokens() {
        return !OAuthServerConfiguration.getInstance().getIdTokenNotAllowedGrantTypesSet().contains("client_credentials");
    }

    private boolean isApplicationUserToken(String tokenUserType) {
        return "APPLICATION_USER".equals(tokenUserType);
    }

    @Override
    public Set<String> getActiveTokensByConsumerKey(String consumerKey) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving active access tokens of client: " + consumerKey));
        }
        Set<String> activeTokens = this.getActiveAccessTokensByConsumerKey(consumerKey, IdentityUtil.getPrimaryDomainName());
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            for (Map.Entry<String, String> availableDomainMapping : availableDomainMappings.entrySet()) {
                activeTokens.addAll(this.getActiveAccessTokensByConsumerKey(consumerKey, availableDomainMapping.getKey()));
            }
        }
        return activeTokens;
    }

    private Set<String> getActiveAccessTokensByConsumerKey(String consumerKey, String userStoreDomain) throws IdentityOAuth2Exception {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> accessTokens = new HashSet<String>();
        try {
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserStore("SELECT ACCESS_TOKEN FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ? ) AND TOKEN_STATE=?", userStoreDomain);
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            ps.setString(2, "ACTIVE");
            rs = ps.executeQuery();
            while (rs.next()) {
                accessTokens.add(this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(rs.getString(1)));
            }
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while getting access tokens from acces token table for the application with consumer key : " + consumerKey, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        return accessTokens;
    }

    @Override
    public Set<AccessTokenDO> getActiveAcessTokenDataByConsumerKey(String consumerKey) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving active access tokens for client: " + consumerKey));
        }
        Set<AccessTokenDO> accessTokenDOs = this.getActiveAcessTokenDataByConsumerKey(consumerKey, IdentityUtil.getPrimaryDomainName());
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            for (Map.Entry<String, String> availableDomainMapping : availableDomainMappings.entrySet()) {
                accessTokenDOs.addAll(this.getActiveAcessTokenDataByConsumerKey(consumerKey, availableDomainMapping.getKey()));
            }
        }
        return accessTokenDOs;
    }

    private Set<AccessTokenDO> getActiveAcessTokenDataByConsumerKey(String consumerKey, String userStoreDomain) throws IdentityOAuth2Exception {
        HashSet<AccessTokenDO> activeDetailedTokens;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, AccessTokenDO> tokenMap = new HashMap<String, AccessTokenDO>();
        try {
            String sqlQuery = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT IDN_OAUTH2_ACCESS_TOKEN.AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.ACCESS_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN, IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_SCOPE, IDP.NAME FROM IDN_OAUTH2_ACCESS_TOKEN LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON IDN_OAUTH2_ACCESS_TOKEN.TOKEN_ID=IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID  JOIN  IDP ON IDN_OAUTH2_ACCESS_TOKEN.IDP_ID=IDP.ID WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?) AND TOKEN_STATE=?" : "SELECT IDN_OAUTH2_ACCESS_TOKEN.AUTHZ_USER, IDN_OAUTH2_ACCESS_TOKEN.ACCESS_TOKEN, IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID, IDN_OAUTH2_ACCESS_TOKEN.USER_DOMAIN, IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_SCOPE FROM IDN_OAUTH2_ACCESS_TOKEN LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON IDN_OAUTH2_ACCESS_TOKEN.TOKEN_ID=IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?) AND TOKEN_STATE=?";
            sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserStore(sqlQuery, userStoreDomain);
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            ps.setString(2, "ACTIVE");
            rs = ps.executeQuery();
            while (rs.next()) {
                String token = rs.getString(2);
                if (tokenMap.containsKey(token)) {
                    AccessTokenDO tokenObj = (AccessTokenDO)((Object)tokenMap.get(token));
                    String[] previousScope = tokenObj.getScope();
                    String[] newSope = new String[tokenObj.getScope().length + 1];
                    System.arraycopy(previousScope, 0, newSope, 0, previousScope.length);
                    newSope[previousScope.length] = rs.getString(5);
                    tokenObj.setScope(newSope);
                    continue;
                }
                String authzUser = rs.getString(1);
                int tenentId = rs.getInt(3);
                String userDomain = rs.getString(4);
                String tokenSope = rs.getString(5);
                String authenticatedIDP = null;
                if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                    authenticatedIDP = rs.getString(6);
                }
                String[] scope = OAuth2Util.buildScopeArray(tokenSope);
                AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(authzUser, userDomain, OAuth2Util.getTenantDomain(tenentId), authenticatedIDP);
                AccessTokenDO aTokenDetail = new AccessTokenDO();
                aTokenDetail.setAccessToken(token);
                aTokenDetail.setConsumerKey(consumerKey);
                aTokenDetail.setScope(scope);
                aTokenDetail.setAuthzUser(user);
                tokenMap.put(token, aTokenDetail);
            }
            activeDetailedTokens = new HashSet<AccessTokenDO>(tokenMap.values());
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while getting access tokens from acces token table for the application with consumer key : " + consumerKey, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        return activeDetailedTokens;
    }

    @Override
    public void invalidateAndCreateNewAccessToken(String oldAccessTokenId, String tokenState, String consumerKey, String tokenStateId, AccessTokenDO accessTokenDO, String userStoreDomain) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Invalidating access token with id: " + oldAccessTokenId + " and creating new access token(hashed): " + DigestUtils.sha256Hex((String)accessTokenDO.getAccessToken()) + " for client: " + consumerKey + " user: " + accessTokenDO.getAuthzUser().toString() + " scope: " + Arrays.toString(accessTokenDO.getScope())));
            } else {
                log.debug((Object)("Invalidating and creating new access token for client: " + consumerKey + " user: " + accessTokenDO.getAuthzUser().toString() + " scope: " + Arrays.toString(accessTokenDO.getScope())));
            }
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        try {
            this.updateAccessTokenState(connection, oldAccessTokenId, tokenState, tokenStateId, userStoreDomain);
            String newAccessToken = accessTokenDO.getAccessToken();
            this.insertAccessToken(newAccessToken, consumerKey, accessTokenDO, connection, userStoreDomain);
            this.updateTokenIdIfAutzCodeGrantType(oldAccessTokenId, accessTokenDO.getTokenId(), connection);
            OAuth2TokenUtil.postRefreshAccessToken(oldAccessTokenId, accessTokenDO.getTokenId(), tokenState);
            if (this.isTokenCleanupFeatureEnabled && oldAccessTokenId != null) {
                this.oldTokenCleanupObject.cleanupTokenByTokenId(oldAccessTokenId, connection);
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            String errorMsg = "Error while regenerating access token";
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    @Override
    public Set<AccessTokenDO> getAccessTokensByTenant(int tenantId) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving all access tokens of tenant id: " + tenantId));
        }
        Set<AccessTokenDO> accessTokenDOs = this.getAccessTokensByTenant(tenantId, IdentityUtil.getPrimaryDomainName());
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            for (Map.Entry<String, String> availableDomainMapping : availableDomainMappings.entrySet()) {
                accessTokenDOs.addAll(this.getAccessTokensByTenant(tenantId, availableDomainMapping.getKey()));
            }
        }
        return accessTokenDOs;
    }

    private Set<AccessTokenDO> getAccessTokensByTenant(int tenantId, String userStoreDomain) throws IdentityOAuth2Exception {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        HashMap<String, AccessTokenDO> accessTokenDOMap = new HashMap<String, AccessTokenDO>();
        try {
            String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, AUTHZ_USER, ACCESS_TOKEN_TABLE.USER_DOMAIN, CONSUMER_KEY, IDP.NAME FROM (SELECT AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, IDP_ID FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TENANT_ID=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH_CONSUMER_APPS.ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP.ID=IDP_ID" : "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, AUTHZ_USER, ACCESS_TOKEN_TABLE.USER_DOMAIN, CONSUMER_KEY FROM (SELECT AUTHZ_USER, USER_DOMAIN, CONSUMER_KEY_ID, TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TENANT_ID=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
            sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userStoreDomain);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setInt(1, tenantId);
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                String accessToken = this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(resultSet.getString(1));
                if (accessTokenDOMap.get(accessToken) == null) {
                    String refreshToken = this.getPersistenceProcessor().getPreprocessedRefreshToken(resultSet.getString(2));
                    Timestamp issuedTime = resultSet.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    Timestamp refreshTokenIssuedTime = resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    long validityPeriodInMillis = resultSet.getLong(5);
                    long refreshTokenValidityPeriodMillis = resultSet.getLong(6);
                    String tokenType = resultSet.getString(7);
                    String[] scope = OAuth2Util.buildScopeArray(resultSet.getString(8));
                    String tokenId = resultSet.getString(9);
                    String authzUser = resultSet.getString(10);
                    userStoreDomain = resultSet.getString(11);
                    String consumerKey = resultSet.getString(12);
                    String authenticatedIDP = null;
                    if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                        authenticatedIDP = resultSet.getString(13);
                    }
                    AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(authzUser, userStoreDomain, OAuth2Util.getTenantDomain(tenantId), authenticatedIDP);
                    AccessTokenDO dataDO = new AccessTokenDO(consumerKey, user, scope, issuedTime, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodMillis, tokenType);
                    dataDO.setAccessToken(accessToken);
                    dataDO.setRefreshToken(refreshToken);
                    dataDO.setTokenId(tokenId);
                    dataDO.setTenantID(tenantId);
                    accessTokenDOMap.put(accessToken, dataDO);
                    continue;
                }
                String scope = resultSet.getString(8).trim();
                AccessTokenDO accessTokenDO = (AccessTokenDO)((Object)accessTokenDOMap.get(accessToken));
                accessTokenDO.setScope((String[])ArrayUtils.add((Object[])accessTokenDO.getScope(), (Object)scope));
            }
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'ACTIVE or EXPIRED' access tokens for user  tenant id : " + tenantId;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return new HashSet<AccessTokenDO>(accessTokenDOMap.values());
    }

    @Override
    public Set<AccessTokenDO> getAccessTokensOfUserStore(int tenantId, String userStoreDomain) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving all ACTIVE and EXPIRED access tokens of userstore: " + userStoreDomain + " tenant id: " + tenantId));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStoreDomain);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        HashMap<String, AccessTokenDO> accessTokenDOMap = new HashMap<String, AccessTokenDO>();
        try {
            String sql = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, AUTHZ_USER, CONSUMER_KEY, IDP.NAME FROM (SELECT AUTHZ_USER, CONSUMER_KEY_ID, TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, IDP_ID FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TENANT_ID=? AND USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON IDN_OAUTH_CONSUMER_APPS.ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID JOIN IDP ON IDP.ID=IDP_ID" : "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE, TOKEN_SCOPE, ACCESS_TOKEN_TABLE.TOKEN_ID, AUTHZ_USER, CONSUMER_KEY FROM (SELECT AUTHZ_USER, CONSUMER_KEY_ID, TOKEN_ID, ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TENANT_ID=? AND USER_DOMAIN=? AND (TOKEN_STATE='ACTIVE' OR TOKEN_STATE='EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID";
            sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userStoreDomain);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, userStoreDomain);
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                String accessToken = this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(resultSet.getString(1));
                if (accessTokenDOMap.get(accessToken) == null) {
                    String refreshToken = this.getPersistenceProcessor().getPreprocessedRefreshToken(resultSet.getString(2));
                    Timestamp issuedTime = resultSet.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    Timestamp refreshTokenIssuedTime = resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    long validityPeriodInMillis = resultSet.getLong(5);
                    long refreshTokenValidityPeriodMillis = resultSet.getLong(6);
                    String tokenType = resultSet.getString(7);
                    String[] scope = OAuth2Util.buildScopeArray(resultSet.getString(8));
                    String tokenId = resultSet.getString(9);
                    String authzUser = resultSet.getString(10);
                    String consumerKey = resultSet.getString(11);
                    String authenticatedIDP = null;
                    if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                        authenticatedIDP = resultSet.getString(12);
                    }
                    AuthenticatedUser user = OAuth2Util.createAuthenticatedUser(authzUser, userStoreDomain, OAuth2Util.getTenantDomain(tenantId), authenticatedIDP);
                    AccessTokenDO dataDO = new AccessTokenDO(consumerKey, user, scope, issuedTime, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodMillis, tokenType);
                    dataDO.setAccessToken(accessToken);
                    dataDO.setRefreshToken(refreshToken);
                    dataDO.setTokenId(tokenId);
                    dataDO.setTenantID(tenantId);
                    accessTokenDOMap.put(accessToken, dataDO);
                    continue;
                }
                String scope = resultSet.getString(8).trim();
                AccessTokenDO accessTokenDO = (AccessTokenDO)((Object)accessTokenDOMap.get(accessToken));
                accessTokenDO.setScope((String[])ArrayUtils.add((Object[])accessTokenDO.getScope(), (Object)scope));
            }
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'ACTIVE or EXPIRED' access tokens for user in store domain : " + userStoreDomain + " and tenant id : " + tenantId;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return new HashSet<AccessTokenDO>(accessTokenDOMap.values());
    }

    @Override
    public void updateUserStoreDomain(int tenantId, String currentUserStoreDomain, String newUserStoreDomain) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Renaming userstore domain: " + currentUserStoreDomain + " as: " + newUserStoreDomain + " tenant id: " + tenantId + " in IDN_OAUTH2_ACCESS_TOKEN table"));
        }
        currentUserStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(currentUserStoreDomain);
        newUserStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(newUserStoreDomain);
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        try {
            String sqlQuery = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET USER_DOMAIN=? WHERE TENANT_ID=? AND USER_DOMAIN=?";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, newUserStoreDomain);
            ps.setInt(2, tenantId);
            ps.setString(3, currentUserStoreDomain);
            int count = ps.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of rows being updated : " + count));
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error occurred while renaming user store : " + currentUserStoreDomain + " in tenant :" + tenantId, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
        }
    }

    @Override
    public String getTokenIdByAccessToken(String token) throws IdentityOAuth2Exception {
        String tokenId;
        block2: {
            Map.Entry<String, String> availableDomainMapping;
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Retrieving id of access token(hashed): " + DigestUtils.sha256Hex((String)token)));
            }
            if ((tokenId = this.getTokenIdByAccessToken(token, IdentityUtil.getPrimaryDomainName())) != null || !OAuth2Util.checkAccessTokenPartitioningEnabled() || !OAuth2Util.checkUserNameAssertionEnabled()) break block2;
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            Iterator<Map.Entry<String, String>> iterator = availableDomainMappings.entrySet().iterator();
            while (iterator.hasNext() && (tokenId = this.getTokenIdByAccessToken(token, (availableDomainMapping = iterator.next()).getKey())) == null) {
            }
        }
        return tokenId;
    }

    private String getTokenIdByAccessToken(String token, String userStoreDomain) throws IdentityOAuth2Exception {
        String string;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        block5: {
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            String sql = OAuth2Util.getTokenPartitionedSqlByUserStore("SELECT TOKEN_ID FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN_HASH = ?", userStoreDomain);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, this.getHashingPersistenceProcessor().getProcessedAccessTokenIdentifier(token));
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block5;
            String string2 = resultSet.getString("TOKEN_ID");
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'Token ID' for token : " + token;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return string;
    }

    @Override
    public String getAccessTokenByTokenId(String tokenId) throws IdentityOAuth2Exception {
        String token;
        block2: {
            Map.Entry<String, String> availableDomainMapping;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving access token by token id: " + tokenId));
            }
            if ((token = this.getAccessTokenByTokenId(tokenId, IdentityUtil.getPrimaryDomainName())) != null || !OAuth2Util.checkAccessTokenPartitioningEnabled() || !OAuth2Util.checkUserNameAssertionEnabled()) break block2;
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            Iterator<Map.Entry<String, String>> iterator = availableDomainMappings.entrySet().iterator();
            while (iterator.hasNext() && (token = this.getAccessTokenByTokenId(tokenId, (availableDomainMapping = iterator.next()).getKey())) == null) {
            }
        }
        return token;
    }

    private String getAccessTokenByTokenId(String tokenId, String userStoreDomain) throws IdentityOAuth2Exception {
        String string;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        block5: {
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            String sql = OAuth2Util.getTokenPartitionedSqlByUserStore("SELECT ACCESS_TOKEN FROM IDN_OAUTH2_ACCESS_TOKEN WHERE TOKEN_ID = ?", userStoreDomain);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, tokenId);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block5;
            String string2 = resultSet.getString("ACCESS_TOKEN");
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving 'Access Token' for token id : " + tokenId;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return string;
    }

    private void updateTokenIdIfAutzCodeGrantType(String oldAccessTokenId, String newAccessTokenId, Connection connection) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.info((Object)("Updating access token reference of authorization code issued for access token id: " + oldAccessTokenId + " by new access token id:" + newAccessTokenId));
        }
        PreparedStatement prepStmt = null;
        try {
            String updateNewTokenAgaintAuthzCodeSql = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET TOKEN_ID=? WHERE TOKEN_ID=?";
            prepStmt = connection.prepareStatement(updateNewTokenAgaintAuthzCodeSql);
            prepStmt.setString(1, newAccessTokenId);
            prepStmt.setString(2, oldAccessTokenId);
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuth2Exception("Error while updating Access Token against authorization code for access token with ID : " + oldAccessTokenId, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
    }

    private void recoverFromConAppKeyConstraintViolation(String accessToken, String consumerKey, AccessTokenDO accessTokenDO, Connection connection, String userStoreDomain, int retryAttemptCounter) throws IdentityOAuth2Exception {
        try {
            connection.setAutoCommit(false);
            log.warn((Object)("Retry attempt to recover 'CON_APP_KEY' constraint violation : " + retryAttemptCounter));
            AccessTokenDO latestNonActiveToken = this.getLatestAccessTokenByState(connection, consumerKey, accessTokenDO.getAuthzUser(), userStoreDomain, OAuth2Util.buildScopeString(accessTokenDO.getScope()), false);
            AccessTokenDO latestActiveToken = this.getLatestAccessTokenByState(connection, consumerKey, accessTokenDO.getAuthzUser(), userStoreDomain, OAuth2Util.buildScopeString(accessTokenDO.getScope()), true);
            OauthTokenIssuer oauthTokenIssuer = OAuth2Util.getOAuthTokenIssuerForOAuthApp(consumerKey);
            if (latestActiveToken != null) {
                OAuthTokenReqMessageContext tokReqMsgCtx = OAuth2Util.getTokenRequestContext();
                if (oauthTokenIssuer.renewAccessTokenPerRequest(tokReqMsgCtx)) {
                    this.updateAccessTokenState(connection, latestActiveToken.getTokenId(), "EXPIRED", UUID.randomUUID().toString(), userStoreDomain);
                    accessTokenDO.setIssuedTime(new Timestamp(new Date().getTime()));
                    this.insertAccessToken(accessTokenDO.getAccessToken(), consumerKey, accessTokenDO, connection, userStoreDomain, retryAttemptCounter);
                } else if (OAuth2Util.getAccessTokenExpireMillis(latestActiveToken) != 0L && (latestNonActiveToken == null || latestActiveToken.getIssuedTime().after(latestNonActiveToken.getIssuedTime()))) {
                    accessTokenDO.setTokenId(latestActiveToken.getTokenId());
                    accessTokenDO.setAccessToken(latestActiveToken.getAccessToken());
                    accessTokenDO.setRefreshToken(latestActiveToken.getRefreshToken());
                    accessTokenDO.setIssuedTime(latestActiveToken.getIssuedTime());
                    accessTokenDO.setRefreshTokenIssuedTime(latestActiveToken.getRefreshTokenIssuedTime());
                    accessTokenDO.setValidityPeriodInMillis(latestActiveToken.getValidityPeriodInMillis());
                    accessTokenDO.setRefreshTokenValidityPeriodInMillis(latestActiveToken.getRefreshTokenValidityPeriodInMillis());
                    accessTokenDO.setTokenType(latestActiveToken.getTokenType());
                    log.info((Object)("Successfully recovered 'CON_APP_KEY' constraint violation with the attempt : " + retryAttemptCounter));
                } else if (OAuth2Util.getAccessTokenExpireMillis(latestActiveToken) != 0L) {
                    this.updateAccessTokenState(connection, latestActiveToken.getTokenId(), "EXPIRED", UUID.randomUUID().toString(), userStoreDomain);
                    accessTokenDO.setIssuedTime(new Timestamp(new Date().getTime()));
                    this.insertAccessToken(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, retryAttemptCounter);
                } else {
                    this.updateAccessTokenState(connection, latestActiveToken.getTokenId(), "INACTIVE", UUID.randomUUID().toString(), userStoreDomain);
                    accessTokenDO.setIssuedTime(new Timestamp(new Date().getTime()));
                    this.insertAccessToken(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, retryAttemptCounter);
                }
            } else {
                accessTokenDO.setIssuedTime(new Timestamp(new Date().getTime()));
                this.insertAccessToken(accessToken, consumerKey, accessTokenDO, connection, userStoreDomain, retryAttemptCounter);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e1) {
                throw new IdentityOAuth2Exception("An rolling back transactions error occurred while trying to recover 'CON_APP_KEY' constraint violation. ", e1);
            }
            String errorMsg = "SQL error occurred while trying to recover 'CON_APP_KEY' constraint violation.";
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving oauth issuer for the app with clientId: " + consumerKey + ".", e);
        }
    }

    private int getTokenPersistRetryCount() {
        int tokenPersistRetryCount = 5;
        if (IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_RETRY_COUNT) != null) {
            tokenPersistRetryCount = Integer.parseInt(IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_RETRY_COUNT));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth Token Persistence Retry count set to " + tokenPersistRetryCount));
        }
        return tokenPersistRetryCount;
    }

    @Deprecated
    public AccessTokenDO getAccessTokenDOfromTokenIdentifier(String accessTokenIdentifier) throws IdentityOAuth2Exception {
        return OAuth2Util.getAccessTokenDOfromTokenIdentifier(accessTokenIdentifier);
    }

    @Override
    public List<AccessTokenDO> getLatestAccessTokens(String consumerKey, AuthenticatedUser authzUser, String userStoreDomain, String scope, boolean includeExpiredTokens, int limit) throws IdentityOAuth2Exception {
        return this.getLatestAccessTokens(consumerKey, authzUser, userStoreDomain, scope, "NONE", includeExpiredTokens, limit);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AccessTokenDO> getLatestAccessTokens(String consumerKey, AuthenticatedUser authzUser, String userStoreDomain, String scope, String tokenBindingReference, boolean includeExpiredTokens, int limit) throws IdentityOAuth2Exception {
        block38: {
            if (AccessTokenDAOImpl.log.isDebugEnabled()) {
                AccessTokenDAOImpl.log.debug((Object)("Retrieving " + (includeExpiredTokens != false ? " active" : " all ") + " latest " + limit + " access token for user: " + authzUser.toString() + " client: " + consumerKey + " scope: " + scope));
            }
            if (authzUser == null) {
                throw new IdentityOAuth2Exception("Invalid user information for given consumerKey: " + consumerKey);
            }
            isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authzUser.toString());
            tenantDomain = authzUser.getTenantDomain();
            tenantId = OAuth2Util.getTenantId(tenantDomain);
            tenantAwareUsernameWithNoUserDomain = authzUser.getUserName();
            userStoreDomain = OAuth2Util.getSanitizedUserStoreDomain(userStoreDomain);
            userDomain = OAuth2Util.getUserStoreDomain(authzUser);
            authenticatedIDP = OAuth2Util.getAuthenticatedIDP(authzUser);
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            sqlAltered = false;
            try {
                block37: {
                    block39: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        driverName = connection.getMetaData().getDriverName();
                                        if (!OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) break block39;
                                        if (!driverName.contains("MySQL") && !driverName.contains("MariaDB") && !driverName.contains("H2")) break block40;
                                        sql = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC LIMIT 1";
                                        break block37;
                                    }
                                    if (!connection.getMetaData().getDatabaseProductName().contains("DB2")) break block41;
                                    sql = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID= (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY";
                                    break block37;
                                }
                                if (!driverName.contains("MS SQL")) break block42;
                                sql = "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WITH (NOLOCK) WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC";
                                break block37;
                            }
                            if (!driverName.contains("Microsoft")) break block43;
                            sql = "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WITH (NOLOCK) WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC";
                            break block37;
                        }
                        if (driverName.contains("PostgreSQL")) {
                            sql = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 ";
                            break block37;
                        } else if (driverName.contains("Informix")) {
                            sql = "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) TOKEN ";
                            break block37;
                        } else {
                            sql = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD,TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? AND IDP_ID=(SELECT ID FROM IDP WHERE NAME =? AND TENANT_ID=IDN_OAUTH2_ACCESS_TOKEN.TENANT_ID) ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ";
                            sql = sql.replace("ROWNUM < 2", "ROWNUM < " + Integer.toString(limit + 1));
                            sqlAltered = true;
                        }
                        break block37;
                    }
                    if (driverName.contains("MySQL") || driverName.contains("MariaDB") || driverName.contains("H2")) {
                        sql = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC LIMIT 1";
                    } else if (connection.getMetaData().getDatabaseProductName().contains("DB2")) {
                        sql = "SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY";
                    } else if (driverName.contains("MS SQL")) {
                        sql = "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WITH (NOLOCK) WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC";
                    } else if (driverName.contains("Microsoft")) {
                        sql = "SELECT TOP 1 ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WITH (NOLOCK) WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC";
                    } else if (driverName.contains("PostgreSQL")) {
                        sql = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC) TOKEN LIMIT 1 ";
                    } else if (driverName.contains("Informix")) {
                        sql = "SELECT FIRST 1 * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID = (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC) TOKEN ";
                    } else {
                        sql = "SELECT * FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD,TOKEN_STATE, USER_TYPE, TOKEN_ID, SUBJECT_IDENTIFIER FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID=(SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?) AND AUTHZ_USER=? AND TENANT_ID=? AND USER_DOMAIN=? AND TOKEN_SCOPE_HASH=? AND TOKEN_BINDING_REF = ? ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2 ";
                        sql = sql.replace("ROWNUM < 2", "ROWNUM < " + Integer.toString(limit + 1));
                        sqlAltered = true;
                    }
                }
                if (!includeExpiredTokens) {
                    sql = sql.replace("TOKEN_SCOPE_HASH=?", "TOKEN_SCOPE_HASH=? AND TOKEN_STATE='ACTIVE'");
                }
                if (!sqlAltered) {
                    sql = sql.replace("LIMIT 1", "LIMIT " + Integer.toString(limit));
                }
                sql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userStoreDomain);
                if (!isUsernameCaseSensitive) {
                    sql = sql.replace("AUTHZ_USER", "LOWER(AUTHZ_USER)");
                }
                if ((hashedScope = OAuth2Util.hashScopes(scope)) == null) {
                    sql = sql.replace("TOKEN_SCOPE_HASH=?", "TOKEN_SCOPE_HASH IS NULL");
                }
                prepStmt = connection.prepareStatement(sql);
                prepStmt.setString(1, this.getPersistenceProcessor().getProcessedClientId(consumerKey));
                if (isUsernameCaseSensitive) {
                    prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain);
                } else {
                    prepStmt.setString(2, tenantAwareUsernameWithNoUserDomain.toLowerCase());
                }
                prepStmt.setInt(3, tenantId);
                prepStmt.setString(4, userDomain);
                if (hashedScope != null) {
                    prepStmt.setString(5, hashedScope);
                }
                prepStmt.setString(6, tokenBindingReference);
                if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                    prepStmt.setString(7, authenticatedIDP);
                }
                resultSet = prepStmt.executeQuery();
                latestIssuedTime = new Date().getTime();
                accessTokenDOs = new ArrayList<AccessTokenDO>();
                iterationCount = 0;
lbl94:
                // 2 sources

                while (resultSet.next()) {
                    block44: {
                        issuedTime = resultSet.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone("UTC"))).getTime();
                        if (iterationCount == 0) {
                            latestIssuedTime = issuedTime;
                        }
                        if (latestIssuedTime != issuedTime) break block44;
                        tokenState = resultSet.getString(7);
                        accessToken = this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(resultSet.getString(1));
                        refreshToken = null;
                        if (resultSet.getString(2) != null) {
                            refreshToken = this.getPersistenceProcessor().getPreprocessedRefreshToken(resultSet.getString(2));
                        }
                        refreshTokenIssuedTime = resultSet.getTimestamp(4, Calendar.getInstance(TimeZone.getTimeZone("UTC"))).getTime();
                        validityPeriodInMillis = resultSet.getLong(5);
                        refreshTokenValidityPeriodInMillis = resultSet.getLong(6);
                        userType = resultSet.getString(8);
                        tokenId = resultSet.getString(9);
                        subjectIdentifier = resultSet.getString(10);
                        user = OAuth2Util.createAuthenticatedUser(tenantAwareUsernameWithNoUserDomain, userDomain, tenantDomain, authenticatedIDP);
                        try {
                            serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", tenantDomain);
                        }
                        catch (IdentityApplicationManagementException e) {
                            throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + consumerKey, e);
                        }
                        user.setAuthenticatedSubjectIdentifier(subjectIdentifier, serviceProvider);
                        accessTokenDO = new AccessTokenDO(consumerKey, user, OAuth2Util.buildScopeArray(scope), new Timestamp(issuedTime), new Timestamp(refreshTokenIssuedTime), validityPeriodInMillis, refreshTokenValidityPeriodInMillis, userType);
                        accessTokenDO.setAccessToken(accessToken);
                        accessTokenDO.setRefreshToken(refreshToken);
                        accessTokenDO.setTokenState(tokenState);
                        accessTokenDO.setTokenId(tokenId);
                        accessTokenDOs.add(accessTokenDO);
                        ** GOTO lbl-1000
                    }
                    var27_27 = accessTokenDOs;
                    break block38;
                }
                ** GOTO lbl143
            }
            catch (SQLException e) {
                try {
                    errorMsg = "Error occurred while trying to retrieve latest 'ACTIVE' access token for Client ID : " + consumerKey + ", User ID : " + authzUser + " and  Scope : " + scope;
                    if (includeExpiredTokens) {
                        errorMsg = errorMsg.replace("ACTIVE", "ACTIVE or EXPIRED");
                    }
                    throw new IdentityOAuth2Exception(errorMsg, e);
                }
                catch (Throwable var42_40) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                    throw var42_40;
                }
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return var27_27;
lbl-1000:
        // 1 sources

        {
            ++iterationCount;
            ** GOTO lbl94
lbl143:
            // 1 sources

            var25_26 = accessTokenDOs;
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return var25_26;
    }

    private boolean isFederatedUser(AccessTokenDO accessTokenDO) {
        return !OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal() && accessTokenDO.getAuthzUser().isFederatedUser();
    }

    private boolean isTokenBindingAvailable(TokenBinding tokenBinding) {
        return tokenBinding != null && StringUtils.isNotBlank((String)tokenBinding.getBindingType()) && StringUtils.isNotBlank((String)tokenBinding.getBindingReference()) && StringUtils.isNotBlank((String)tokenBinding.getBindingValue());
    }

    @Override
    public Set<AccessTokenDO> getActiveTokenSetWithTokenIdByConsumerKeyForOpenidScope(String consumerKey) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving active access token set with token id of client: " + consumerKey));
        }
        Set<AccessTokenDO> activeAccessTokenDOSet = this.getActiveAccessTokenSetByConsumerKeyForOpenidScope(consumerKey, IdentityUtil.getPrimaryDomainName());
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
            for (Map.Entry<String, String> availableDomainMapping : availableDomainMappings.entrySet()) {
                activeAccessTokenDOSet.addAll(this.getActiveAccessTokenSetByConsumerKeyForOpenidScope(consumerKey, availableDomainMapping.getKey()));
            }
        }
        return activeAccessTokenDOSet;
    }

    private Set<AccessTokenDO> getActiveAccessTokenSetByConsumerKeyForOpenidScope(String consumerKey, String userStoreDomain) throws IdentityOAuth2Exception {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<AccessTokenDO> accessTokens = new HashSet<AccessTokenDO>();
        try {
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserStore("SELECT DISTINCT ACCESS_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, TIME_CREATED, VALIDITY_PERIOD FROM (SELECT ACCESS_TOKEN, REFRESH_TOKEN, GRANT_TYPE, CONSUMER_KEY_ID, TOKEN_ID, TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_TIME_CREATED, REFRESH_TOKEN_VALIDITY_PERIOD FROM IDN_OAUTH2_ACCESS_TOKEN WHERE CONSUMER_KEY_ID IN (SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ? ) AND TOKEN_STATE=?) ACCESS_TOKEN_TABLE LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID WHERE TOKEN_SCOPE=?", userStoreDomain);
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            ps.setString(2, "ACTIVE");
            ps.setString(3, "openid");
            rs = ps.executeQuery();
            while (rs.next()) {
                long validityPeriodInMillis;
                String accessToken = this.getPersistenceProcessor().getPreprocessedAccessTokenIdentifier(rs.getString(1));
                String tokenId = rs.getString(2);
                Timestamp timeCreated = rs.getTimestamp(3, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                long issuedTimeInMillis = timeCreated.getTime();
                if (this.isAccessTokenExpired(issuedTimeInMillis, validityPeriodInMillis = rs.getLong(4))) continue;
                AccessTokenDO accessTokenDO = new AccessTokenDO();
                accessTokenDO.setAccessToken(accessToken);
                accessTokenDO.setTokenId(tokenId);
                accessTokens.add(accessTokenDO);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollBack((Connection)connection);
                throw new IdentityOAuth2Exception("Error occurred while getting access tokens from access token table for the application with consumer key : " + consumerKey, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)ps);
        return accessTokens;
    }

    private boolean isAccessTokenExpired(long issuedTimeInMillis, long validityPeriodMillis) {
        return OAuth2Util.getTimeToExpire(issuedTimeInMillis, validityPeriodMillis) < 0L;
    }

    @Override
    public Set<AccessTokenDO> getAccessTokensByBindingRef(AuthenticatedUser user, String bindingRef) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving active access tokens issued to user, " + user.getUserName() + " with binding reference " + bindingRef));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            String sqlQuery = OAuth2Util.getTokenPartitionedSqlByUserId("SELECT ACCESS_TOKEN, CONSUMER_KEY, TOKEN_SCOPE, REFRESH_TOKEN, ACCESS_TOKEN_TABLE.TOKEN_ID, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, REFRESH_TOKEN_VALIDITY_PERIOD, USER_TYPE FROM (SELECT ACCESS_TOKEN, CONSUMER_KEY_ID, TOKEN_ID, REFRESH_TOKEN, TIME_CREATED, REFRESH_TOKEN_TIME_CREATED, VALIDITY_PERIOD, USER_TYPE, REFRESH_TOKEN_VALIDITY_PERIOD FROM IDN_OAUTH2_ACCESS_TOKEN WHERE AUTHZ_USER = ? AND TENANT_ID = ? AND USER_DOMAIN = ? AND TOKEN_BINDING_REF = ? AND (TOKEN_STATE = 'ACTIVE' OR TOKEN_STATE = 'EXPIRED')) ACCESS_TOKEN_TABLE JOIN IDN_OAUTH_CONSUMER_APPS ON ID = CONSUMER_KEY_ID LEFT JOIN IDN_OAUTH2_ACCESS_TOKEN_SCOPE ON ACCESS_TOKEN_TABLE.TOKEN_ID = IDN_OAUTH2_ACCESS_TOKEN_SCOPE.TOKEN_ID", user.getUserName());
            int tenantId = OAuth2Util.getTenantId(user.getTenantDomain());
            HashMap tokenMap = new HashMap();
            jdbcTemplate.executeQuery(sqlQuery, (resultSet, i) -> {
                String token = resultSet.getString("ACCESS_TOKEN");
                AccessTokenDO accessTokenDO = new AccessTokenDO();
                if (tokenMap.containsKey(token)) {
                    AccessTokenDO tokenObj = (AccessTokenDO)((Object)((Object)tokenMap.get(token)));
                    String[] previousScope = tokenObj.getScope();
                    String[] newSope = new String[tokenObj.getScope().length + 1];
                    System.arraycopy(previousScope, 0, newSope, 0, previousScope.length);
                    newSope[previousScope.length] = resultSet.getString(2);
                    tokenObj.setScope(newSope);
                } else {
                    String consumerKey = resultSet.getString("CONSUMER_KEY");
                    String tokenScope = resultSet.getString("TOKEN_SCOPE");
                    String refreshToken = resultSet.getString("REFRESH_TOKEN");
                    String tokenId = resultSet.getString("TOKEN_ID");
                    Timestamp issuedTime = resultSet.getTimestamp("TIME_CREATED", Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    Timestamp refreshTokenIssuedTime = resultSet.getTimestamp("REFRESH_TOKEN_TIME_CREATED", Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    long validityPeriodInMillis = resultSet.getLong("VALIDITY_PERIOD");
                    long refreshTokenValidityPeriodMillis = resultSet.getLong("REFRESH_TOKEN_VALIDITY_PERIOD");
                    String tokenType = resultSet.getString("USER_TYPE");
                    String[] scope = OAuth2Util.buildScopeArray(tokenScope);
                    accessTokenDO.setAccessToken(token);
                    accessTokenDO.setConsumerKey(consumerKey);
                    accessTokenDO.setScope(scope);
                    accessTokenDO.setAuthzUser(user);
                    accessTokenDO.setTenantID(tenantId);
                    accessTokenDO.setRefreshToken(refreshToken);
                    accessTokenDO.setTokenId(tokenId);
                    accessTokenDO.setIssuedTime(issuedTime);
                    accessTokenDO.setRefreshTokenIssuedTime(refreshTokenIssuedTime);
                    accessTokenDO.setValidityPeriod(validityPeriodInMillis);
                    accessTokenDO.setRefreshTokenValidityPeriod(refreshTokenValidityPeriodMillis);
                    accessTokenDO.setTokenType(tokenType);
                    tokenMap.put(token, accessTokenDO);
                }
                return null;
            }, preparedStatement -> {
                preparedStatement.setString(1, user.getUserName());
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, user.getUserStoreDomain());
                preparedStatement.setString(4, bindingRef);
            });
            return new HashSet<AccessTokenDO>(tokenMap.values());
        }
        catch (DataAccessException e) {
            throw new IdentityOAuth2Exception("Error occurred while retrieving access tokens.", e);
        }
    }
}

