/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.tokenprocessor.HashingPersistenceProcessor;
import org.wso2.carbon.identity.oauth.tokenprocessor.PlainTextPersistenceProcessor;
import org.wso2.carbon.identity.oauth.tokenprocessor.TokenPersistenceProcessor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;

abstract class AbstractOAuthDAO {
    private static final Log log = LogFactory.getLog(AbstractOAuthDAO.class);
    private static final boolean DEFAULT_PERSIST_ENABLED = true;
    private static final String OAUTH_TOKEN_PERSISTENCE_ENABLE = "OAuth.TokenPersistence.Enable";
    private static final String FRAMEWORK_PERSISTENCE_ENABLE = "JDBCPersistenceManager.SessionDataPersist.Enable";
    protected static final String UTC = "UTC";
    protected static final String AUTHZ_USER = "AUTHZ_USER";
    protected static final String LOWER_AUTHZ_USER = "LOWER(AUTHZ_USER)";
    private TokenPersistenceProcessor persistenceProcessor = this.createPersistenceProcessor();
    private TokenPersistenceProcessor hashingPersistenceProcessor = new HashingPersistenceProcessor();

    protected TokenPersistenceProcessor getPersistenceProcessor() {
        return this.persistenceProcessor;
    }

    protected TokenPersistenceProcessor getHashingPersistenceProcessor() {
        return this.hashingPersistenceProcessor;
    }

    protected TokenPersistenceProcessor createPersistenceProcessor() {
        try {
            return OAuthServerConfiguration.getInstance().getPersistenceProcessor();
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)"Error retrieving TokenPersistenceProcessor. Defaulting to PlainTextProcessor", (Throwable)((Object)e));
            return new PlainTextPersistenceProcessor();
        }
    }

    protected boolean isPersistenceEnabled() {
        if (IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_ENABLE) != null) {
            return Boolean.parseBoolean(IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_ENABLE));
        }
        if (IdentityUtil.getProperty((String)FRAMEWORK_PERSISTENCE_ENABLE) != null) {
            return Boolean.parseBoolean(IdentityUtil.getProperty((String)FRAMEWORK_PERSISTENCE_ENABLE));
        }
        return true;
    }

    protected Connection getConnection() {
        return IdentityDatabaseUtil.getDBConnection();
    }
}

