/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.client.authentication;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.bean.OAuthClientAuthnContext;
import org.wso2.carbon.identity.oauth2.client.authentication.AbstractOAuthClientAuthenticator;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class PublicClientAuthenticator
extends AbstractOAuthClientAuthenticator {
    public static final String PUBLIC_CLIENT_AUTHENTICATOR = "PublicClientAuthenticator";
    private static final Log log = LogFactory.getLog(PublicClientAuthenticator.class);

    public int getPriority() {
        return 200;
    }

    @Override
    public boolean authenticateClient(HttpServletRequest request, Map<String, List> bodyParams, OAuthClientAuthnContext oAuthClientAuthnContext) {
        return true;
    }

    @Override
    public boolean canAuthenticate(HttpServletRequest request, Map<String, List> bodyParams, OAuthClientAuthnContext context) {
        String clientId = this.getClientId(request, bodyParams, context);
        try {
            if (this.isClientIdExistsAsParams(bodyParams)) {
                if (this.canBypassClientCredentials(context.getClientId())) {
                    if (clientId != null) {
                        context.setClientId(clientId);
                    }
                    return true;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The Application (Service Provider) with client ID : " + clientId + " has not enabled the option \"Allow authentication without the client secret\" and no valid Authorization Header exists in the request."));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Application with the given client ID " + clientId + " is not found"));
            }
        }
        catch (InvalidOAuthClientException e) {
            log.error((Object)("Error in retrieving an Application (Service Provider) with client ID : " + clientId), (Throwable)e);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)("Error in Application (Service Provider) with client ID : " + clientId), (Throwable)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"The Client ID is not present in the request.");
        }
        return false;
    }

    public String getName() {
        return PUBLIC_CLIENT_AUTHENTICATOR;
    }

    @Override
    public String getClientId(HttpServletRequest request, Map<String, List> bodyParams, OAuthClientAuthnContext oAuthClientAuthnContext) {
        if (StringUtils.isBlank((String)oAuthClientAuthnContext.getClientId())) {
            this.setClientCredentialsFromParam(bodyParams, oAuthClientAuthnContext);
        }
        return oAuthClientAuthnContext.getClientId();
    }

    private boolean canBypassClientCredentials(String clientId) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        return OAuth2Util.getAppInformationByClientId(clientId).isBypassClientCredentials();
    }

    private boolean isClientIdExistsAsParams(Map<String, List> contentParam) {
        Map<String, String> stringContent = this.getBodyParameters(contentParam);
        return StringUtils.isNotEmpty((String)stringContent.get("client_id"));
    }

    private void setClientCredentialsFromParam(Map<String, List> params, OAuthClientAuthnContext context) {
        Map<String, String> stringContent = this.getBodyParameters(params);
        context.setClientId(stringContent.get("client_id"));
    }
}

