/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.client.authentication;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth2.bean.OAuthClientAuthnContext;
import org.wso2.carbon.identity.oauth2.client.authentication.OAuthClientAuthenticator;
import org.wso2.carbon.identity.oauth2.client.authentication.OAuthClientAuthnException;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;

public class OAuthClientAuthnService {
    private static final Log log = LogFactory.getLog(OAuthClientAuthnService.class);

    public List<OAuthClientAuthenticator> getClientAuthenticators() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving registered OAuth client authenticator list.");
        }
        return OAuth2ServiceComponentHolder.getAuthenticationHandlers();
    }

    public OAuthClientAuthnContext authenticateClient(HttpServletRequest request, Map<String, List> bodyContentParams) {
        OAuthClientAuthnContext oAuthClientAuthnContext = new OAuthClientAuthnContext();
        this.executeClientAuthenticators(request, oAuthClientAuthnContext, bodyContentParams);
        this.failOnMultipleAuthenticators(oAuthClientAuthnContext);
        return oAuthClientAuthnContext;
    }

    private void executeAuthenticator(OAuthClientAuthenticator oAuthClientAuthenticator, OAuthClientAuthnContext oAuthClientAuthnContext, HttpServletRequest request, Map<String, List> bodyContentMap) {
        if (this.isAuthenticatorDisabled(oAuthClientAuthenticator)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authenticator " + oAuthClientAuthenticator.getName() + " is disabled. Hence not evaluating"));
            }
            return;
        }
        if (this.canAuthenticate(oAuthClientAuthenticator, oAuthClientAuthnContext, request, bodyContentMap)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(oAuthClientAuthenticator.getName() + " authenticator can handle incoming request."));
            }
            if (oAuthClientAuthnContext.isPreviousAuthenticatorEngaged()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Previously an authenticator is evaluated. Hence authenticator " + oAuthClientAuthenticator.getName() + " is not evaluating"));
                }
                this.addAuthenticatorToContext(oAuthClientAuthenticator, oAuthClientAuthnContext);
                return;
            }
            this.addAuthenticatorToContext(oAuthClientAuthenticator, oAuthClientAuthnContext);
            try {
                oAuthClientAuthnContext.setClientId(oAuthClientAuthenticator.getClientId(request, bodyContentMap, oAuthClientAuthnContext));
                this.authenticateClient(oAuthClientAuthenticator, oAuthClientAuthnContext, request, bodyContentMap);
            }
            catch (OAuthClientAuthnException e) {
                this.handleClientAuthnException(oAuthClientAuthenticator, oAuthClientAuthnContext, e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(oAuthClientAuthenticator.getName() + " authenticator cannot handle this request."));
        }
    }

    private void failOnMultipleAuthenticators(OAuthClientAuthnContext oAuthClientAuthnContext) {
        if (oAuthClientAuthnContext.isMultipleAuthenticatorsEngaged()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(oAuthClientAuthnContext.getExecutedAuthenticators().size() + " Authenticators were executed previously. Hence failing client authentication"));
            }
            this.setErrorToContext("invalid_request", "The client MUST NOT use more than one authentication method in each", oAuthClientAuthnContext);
        }
    }

    private void executeClientAuthenticators(HttpServletRequest request, OAuthClientAuthnContext oAuthClientAuthnContext, Map<String, List> bodyContentMap) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executing OAuth client authenticators.");
        }
        this.getClientAuthenticators().forEach(oAuthClientAuthenticator -> this.executeAuthenticator((OAuthClientAuthenticator)oAuthClientAuthenticator, oAuthClientAuthnContext, request, bodyContentMap));
    }

    private void setErrorToContext(String errorCode, String errorMessage, OAuthClientAuthnContext oAuthClientAuthnContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting error to client authentication context : Error code : " + errorCode + ", Error message : " + errorMessage));
        }
        oAuthClientAuthnContext.setAuthenticated(false);
        oAuthClientAuthnContext.setErrorCode(errorCode);
        oAuthClientAuthnContext.setErrorMessage(errorMessage);
    }

    private boolean isAuthenticatorDisabled(OAuthClientAuthenticator oAuthClientAuthenticator) {
        return !oAuthClientAuthenticator.isEnabled();
    }

    private void handleClientAuthnException(OAuthClientAuthenticator oAuthClientAuthenticator, OAuthClientAuthnContext oAuthClientAuthnContext, OAuthClientAuthnException e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Error while evaluating client authenticator : " + oAuthClientAuthenticator.getName()), (Throwable)((Object)e));
        }
        this.setErrorToContext(e.getErrorCode(), e.getMessage(), oAuthClientAuthnContext);
    }

    private void authenticateClient(OAuthClientAuthenticator oAuthClientAuthenticator, OAuthClientAuthnContext oAuthClientAuthnContext, HttpServletRequest request, Map<String, List> bodyContentMap) throws OAuthClientAuthnException {
        boolean isAuthenticated = oAuthClientAuthenticator.authenticateClient(request, bodyContentMap, oAuthClientAuthnContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication result from OAuth client authenticator " + oAuthClientAuthenticator.getName() + " is : " + isAuthenticated));
        }
        oAuthClientAuthnContext.setAuthenticated(isAuthenticated);
        if (!isAuthenticated) {
            this.setErrorToContext("invalid_client", "Client credentials are invalid.", oAuthClientAuthnContext);
        }
    }

    private void addAuthenticatorToContext(OAuthClientAuthenticator oAuthClientAuthenticator, OAuthClientAuthnContext oAuthClientAuthnContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authenticator " + oAuthClientAuthenticator.getName() + " can authenticate the client request.  Hence trying to evaluate authentication"));
        }
        oAuthClientAuthnContext.addAuthenticator(oAuthClientAuthenticator.getName());
    }

    private boolean canAuthenticate(OAuthClientAuthenticator oAuthClientAuthenticator, OAuthClientAuthnContext oAuthClientAuthnContext, HttpServletRequest request, Map<String, List> bodyContentMap) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Evaluating canAuthenticate of authenticator : " + oAuthClientAuthenticator.getName()));
        }
        return oAuthClientAuthenticator.canAuthenticate(request, bodyContentMap, oAuthClientAuthnContext);
    }
}

