/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.client.authentication;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.bean.OAuthClientAuthnContext;
import org.wso2.carbon.identity.oauth2.client.authentication.AbstractOAuthClientAuthenticator;
import org.wso2.carbon.identity.oauth2.client.authentication.OAuthClientAuthnException;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class BasicAuthClientAuthenticator
extends AbstractOAuthClientAuthenticator {
    private static final Log log = LogFactory.getLog(BasicAuthClientAuthenticator.class);
    private static final String CREDENTIAL_SEPARATOR = ":";
    private static final String SIMPLE_CASE_AUTHORIZATION_HEADER = "authorization";
    private static final String BASIC_PREFIX = "Basic";
    private static final int CREDENTIAL_LENGTH = 2;

    public int getPriority() {
        return 100;
    }

    @Override
    public boolean authenticateClient(HttpServletRequest request, Map<String, List> bodyParams, OAuthClientAuthnContext oAuthClientAuthnContext) throws OAuthClientAuthnException {
        this.validateAuthenticationInfo(request, bodyParams);
        if (StringUtils.isEmpty((String)oAuthClientAuthnContext.getClientId())) {
            oAuthClientAuthnContext.setClientId(this.getClientId(request, bodyParams, oAuthClientAuthnContext));
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authenticating client : " + oAuthClientAuthnContext.getClientId() + " with client secret."));
            }
            return OAuth2Util.authenticateClient(oAuthClientAuthnContext.getClientId(), (String)oAuthClientAuthnContext.getParameter("client_secret"));
        }
        catch (IdentityOAuthAdminException e) {
            throw new OAuthClientAuthnException("invalid_client", "Error while authenticating client", (Throwable)((Object)e));
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            throw new OAuthClientAuthnException("invalid_client", "Invalid Client : " + oAuthClientAuthnContext.getClientId(), (Throwable)e);
        }
    }

    private void validateAuthenticationInfo(HttpServletRequest request, Map<String, List> contentMap) throws OAuthClientAuthnException {
        if (this.isBasicAuthorizationHeaderExists(request)) {
            if (log.isErrorEnabled()) {
                log.debug((Object)"Authorization header exists. Hence validating whether body params also present");
            }
            this.validateDuplicatedBasicAuthInfo(request, contentMap);
        }
    }

    @Override
    public boolean canAuthenticate(HttpServletRequest request, Map<String, List> bodyParams, OAuthClientAuthnContext context) {
        if (this.isBasicAuthorizationHeaderExists(request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Basic auth credentials exists as Authorization header. Hence returning true.");
            }
            return true;
        }
        if (this.isClientCredentialsExistsAsParams(bodyParams)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Basic auth credentials present as body params. Hence returning true");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Client id and secret neither present as Authorization header nor as body params. Hence returning false");
        }
        return false;
    }

    public String getName() {
        return "BasicOAuthClientCredAuthenticator";
    }

    @Override
    public String getClientId(HttpServletRequest request, Map<String, List> bodyParams, OAuthClientAuthnContext oAuthClientAuthnContext) throws OAuthClientAuthnException {
        if (this.isBasicAuthorizationHeaderExists(request)) {
            this.validateDuplicatedBasicAuthInfo(request, bodyParams);
            String[] credentials = BasicAuthClientAuthenticator.extractCredentialsFromAuthzHeader(this.getAuthorizationHeader(request), oAuthClientAuthnContext);
            oAuthClientAuthnContext.setClientId(credentials[0]);
            oAuthClientAuthnContext.addParameter("client_secret", credentials[1]);
        } else {
            this.setClientCredentialsFromParam(bodyParams, oAuthClientAuthnContext);
        }
        return oAuthClientAuthnContext.getClientId();
    }

    protected void validateDuplicatedBasicAuthInfo(HttpServletRequest request, Map<String, List> bodyParams) throws OAuthClientAuthnException {
        if (this.isClientCredentialsExistsAsParams(bodyParams)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Client Id and Client Secret found in request body and Authorization header. Credentials should be sent in either request body or Authorization header, not both");
            }
            throw new OAuthClientAuthnException("Request body and headers contain authorization information", "invalid_request");
        }
    }

    protected boolean isBasicAuthorizationHeaderExists(HttpServletRequest request) {
        String authorizationHeader = this.getAuthorizationHeader(request);
        return StringUtils.isNotEmpty((String)authorizationHeader) && authorizationHeader.toUpperCase().startsWith(BASIC_PREFIX.toUpperCase());
    }

    protected String getAuthorizationHeader(HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (StringUtils.isEmpty((String)authorizationHeader)) {
            authorizationHeader = request.getHeader(SIMPLE_CASE_AUTHORIZATION_HEADER);
        }
        return authorizationHeader;
    }

    protected boolean isClientCredentialsExistsAsParams(Map<String, List> contentParam) {
        Map<String, String> stringContent = this.getBodyParameters(contentParam);
        return StringUtils.isNotEmpty((String)stringContent.get("client_id")) && StringUtils.isNotEmpty((String)stringContent.get("client_secret"));
    }

    protected static String[] extractCredentialsFromAuthzHeader(String authorizationHeader, OAuthClientAuthnContext oAuthClientAuthnContext) throws OAuthClientAuthnException {
        byte[] decodedBytes;
        String userNamePassword;
        String[] credentials;
        String[] splitValues = authorizationHeader.trim().split(" ");
        if (splitValues.length == 2 && (credentials = (userNamePassword = new String(decodedBytes = Base64Utils.decode((String)splitValues[1].trim()), Charsets.UTF_8)).split(CREDENTIAL_SEPARATOR)).length == 2) {
            return credentials;
        }
        String errMsg = "Error decoding authorization header. Space delimited \"<authMethod> <base64Hash>\" format violated.";
        throw new OAuthClientAuthnException(errMsg, "invalid_client");
    }

    protected void setClientCredentialsFromParam(Map<String, List> bodyParams, OAuthClientAuthnContext context) {
        Map<String, String> stringContent = this.getBodyParameters(bodyParams);
        context.setClientId(stringContent.get("client_id"));
        context.addParameter("client_secret", stringContent.get("client_secret"));
    }
}

