/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.oauth2.bean.ScopeBinding;

public class Scope
implements Serializable {
    private String name;
    private String displayName;
    private String description;
    private List<ScopeBinding> scopeBindings = new ArrayList<ScopeBinding>();

    public Scope(String name, String displayName, String description) {
        this.name = name;
        this.description = description;
        this.displayName = displayName;
    }

    @Deprecated
    public Scope(String name, String displayName, String description, List<String> bindings) {
        this.name = name;
        this.description = description;
        this.displayName = displayName;
        this.addScopeBindings("DEFAULT", bindings);
    }

    public Scope(String name, String displayName, List<ScopeBinding> scopeBindings, String description) {
        this.name = name;
        this.description = description;
        this.displayName = displayName;
        this.scopeBindings = scopeBindings;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public List<String> getBindings() {
        if (this.scopeBindings == null) {
            return Collections.emptyList();
        }
        for (ScopeBinding scopeBinding : this.scopeBindings) {
            if (!"DEFAULT".equalsIgnoreCase(scopeBinding.getBindingType())) continue;
            return scopeBinding.getBindings();
        }
        return Collections.emptyList();
    }

    @Deprecated
    public void setBindings(List<String> bindings) {
        this.setDefaultScopeBinding(bindings);
    }

    @Deprecated
    public void addBindings(List<String> bindings) {
        this.addScopeBindings("DEFAULT", bindings);
    }

    public void addScopeBindings(String bindingType, List<String> bindings) {
        boolean bindingTypeExists = false;
        for (ScopeBinding scopeBinding : this.scopeBindings) {
            if (!bindingType.equalsIgnoreCase(scopeBinding.getBindingType())) continue;
            bindingTypeExists = true;
            scopeBinding.getBindings().addAll(bindings);
        }
        if (!bindingTypeExists) {
            ScopeBinding scopeBinding = new ScopeBinding(bindingType, bindings);
            this.scopeBindings.add(scopeBinding);
        }
    }

    public void addScopeBinding(String bindingType, String binding) {
        if (StringUtils.isBlank((String)bindingType)) {
            return;
        }
        boolean bindingTypeExists = false;
        for (ScopeBinding scopeBinding : this.scopeBindings) {
            if (!bindingType.equalsIgnoreCase(scopeBinding.getBindingType())) continue;
            bindingTypeExists = true;
            if (!StringUtils.isNotBlank((String)binding) || scopeBinding.getBindings().contains(binding)) continue;
            scopeBinding.getBindings().add(binding);
        }
        if (!bindingTypeExists) {
            ScopeBinding scopeBinding;
            ArrayList<String> bindings = new ArrayList<String>();
            if (StringUtils.isNotBlank((String)binding)) {
                bindings.add(binding);
            }
            scopeBinding = new ScopeBinding(bindingType, bindings);
            this.scopeBindings.add(scopeBinding);
        }
    }

    @Deprecated
    public void addBinding(String binding) {
        this.addScopeBinding("DEFAULT", binding);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ScopeBinding> getScopeBindings() {
        return this.scopeBindings;
    }

    public void setScopeBindings(List<ScopeBinding> scopeBindings) {
        this.scopeBindings = scopeBindings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Scope {\n");
        sb.append("  name: ").append(this.name).append("\n");
        sb.append("  displayName: ").append(this.displayName).append("\n");
        sb.append("  description: ").append(this.description).append("\n");
        sb.append("  scopeBindings: ").append(this.scopeBindings).append("\n");
        sb.append("}\n");
        return sb.toString();
    }

    private void setDefaultScopeBinding(List<String> bindings) {
        ScopeBinding scopeBinding = new ScopeBinding("DEFAULT", bindings);
        ArrayList<ScopeBinding> scopeBindings = new ArrayList<ScopeBinding>();
        scopeBindings.add(scopeBinding);
        this.setScopeBindings(scopeBindings);
    }
}

