/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.authz.handlers.util;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.cache.CacheEntry;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.OAuth2Service;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.bean.OAuthClientAuthnContext;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationResponseDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuer;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.openidconnect.IDTokenBuilder;

public class ResponseTypeHandlerUtil {
    public static final int SECOND_TO_MILLISECONDS_FACTOR = 1000;
    private static final Log log = LogFactory.getLog(ResponseTypeHandlerUtil.class);
    private static boolean isHashDisabled = OAuth2Util.isHashDisabled();

    public static void triggerPreListeners(OAuthAuthzReqMessageContext oauthAuthzMsgCtx) {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            try {
                oAuthEventInterceptorProxy.onPreTokenIssue(oauthAuthzMsgCtx, paramMap);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Oauth pre token issue listener is triggered.");
                }
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)"Oauth pre token issue listener ", (Throwable)((Object)e));
            }
        }
    }

    public static void triggerPostListeners(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, AccessTokenDO tokenDO, OAuth2AuthorizeRespDTO respDTO) {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            try {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                oAuthEventInterceptorProxy.onPostTokenIssue(oauthAuthzMsgCtx, tokenDO, respDTO, paramMap);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Oauth post token issue listener is triggered.");
                }
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)"Oauth post token issue listener ", (Throwable)((Object)e));
            }
        }
    }

    public static AccessTokenDO generateAccessToken(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, boolean cacheEnabled) throws IdentityOAuth2Exception {
        OauthTokenIssuer oauthTokenIssuer;
        String consumerKey = oauthAuthzMsgCtx.getAuthorizationReqDTO().getConsumerKey();
        try {
            oauthTokenIssuer = OAuth2Util.getOAuthTokenIssuerForOAuthApp(consumerKey);
        }
        catch (InvalidOAuthClientException e) {
            String errorMsg = "Error when instantiating the OAuthIssuer for service provider app with client Id: " + consumerKey + ". Defaulting to OAuthIssuerImpl";
            log.error((Object)errorMsg, (Throwable)e);
            oauthTokenIssuer = OAuthServerConfiguration.getInstance().getIdentityOauthTokenIssuer();
        }
        return ResponseTypeHandlerUtil.generateAccessToken(oauthAuthzMsgCtx, cacheEnabled, oauthTokenIssuer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessTokenDO generateAccessToken(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, boolean cacheEnabled, OauthTokenIssuer oauthIssuerImpl) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        String scope = OAuth2Util.buildScopeString(oauthAuthzMsgCtx.getApprovedScope());
        String consumerKey = authorizationReqDTO.getConsumerKey();
        String authorizedUser = authorizationReqDTO.getUser().toString();
        String string = (consumerKey + ":" + authorizedUser + ":" + scope).intern();
        synchronized (string) {
            AccessTokenDO existingTokenBean = ResponseTypeHandlerUtil.getExistingToken(oauthAuthzMsgCtx, cacheEnabled);
            if (ResponseTypeHandlerUtil.isNotRenewAccessTokenPerRequest(oauthIssuerImpl, oauthAuthzMsgCtx)) {
                if (existingTokenBean != null) {
                    if (OAuthServerConfiguration.getInstance().isTokenRenewalPerRequestEnabled()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("RenewTokenPerRequest configuration active. Proceeding to revoke any existing active tokens for client Id: " + consumerKey + ", user: " + authorizedUser + " and scope: " + scope + "."));
                        }
                        ResponseTypeHandlerUtil.revokeExistingToken(existingTokenBean.getConsumerKey(), existingTokenBean.getAccessToken());
                        existingTokenBean = null;
                    }
                    if (ResponseTypeHandlerUtil.isAccessTokenValid(existingTokenBean)) {
                        return existingTokenBean;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No active access token found for client Id: " + consumerKey + ", user: " + authorizedUser + " and scope: " + scope + ". Therefore issuing new token"));
                }
            }
            return ResponseTypeHandlerUtil.generateNewAccessToken(oauthAuthzMsgCtx, existingTokenBean, oauthIssuerImpl, cacheEnabled);
        }
    }

    public static AuthzCodeDO generateAuthorizationCode(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, boolean cacheEnabled) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        String consumerKey = authorizationReqDTO.getConsumerKey();
        try {
            OauthTokenIssuer oauthTokenIssuer = OAuth2Util.getOAuthTokenIssuerForOAuthApp(consumerKey);
            return ResponseTypeHandlerUtil.generateAuthorizationCode(oauthAuthzMsgCtx, cacheEnabled, oauthTokenIssuer);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving oauth issuer for the app with clientId: " + consumerKey, e);
        }
    }

    public static AuthzCodeDO generateAuthorizationCode(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, boolean cacheEnabled, OauthTokenIssuer oauthIssuerImpl) throws IdentityOAuth2Exception {
        String authorizationCode;
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        String codeId = UUID.randomUUID().toString();
        Timestamp timestamp = new Timestamp(new Date().getTime());
        long validityPeriod = OAuthServerConfiguration.getInstance().getAuthorizationCodeValidityPeriodInSeconds();
        long callbackValidityPeriod = oauthAuthzMsgCtx.getValidityPeriod();
        if (callbackValidityPeriod != -1L && callbackValidityPeriod > 0L) {
            validityPeriod = callbackValidityPeriod;
        }
        oauthAuthzMsgCtx.setValidityPeriod(validityPeriod *= 1000L);
        oauthAuthzMsgCtx.setAuthorizationCodeValidityPeriod(validityPeriod);
        oauthAuthzMsgCtx.setCodeIssuedTime(timestamp.getTime());
        if (authorizationReqDTO.getUser() != null && authorizationReqDTO.getUser().isFederatedUser()) {
            authorizationReqDTO.getUser().setTenantDomain(authorizationReqDTO.getTenantDomain());
        }
        try {
            authorizationCode = oauthIssuerImpl.authorizationCode(oauthAuthzMsgCtx);
        }
        catch (OAuthSystemException e) {
            throw new IdentityOAuth2Exception(e.getMessage(), e);
        }
        AuthzCodeDO authzCodeDO = new AuthzCodeDO(authorizationReqDTO.getUser(), oauthAuthzMsgCtx.getApprovedScope(), timestamp, validityPeriod, authorizationReqDTO.getCallbackUrl(), authorizationReqDTO.getConsumerKey(), authorizationCode, codeId, authorizationReqDTO.getPkceCodeChallenge(), authorizationReqDTO.getPkceCodeChallengeMethod());
        OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().insertAuthorizationCode(authorizationCode, authorizationReqDTO.getConsumerKey(), authorizationReqDTO.getCallbackUrl(), authzCodeDO);
        if (cacheEnabled) {
            String cacheKeyString = OAuth2Util.buildCacheKeyStringForAuthzCode(authorizationReqDTO.getConsumerKey(), authorizationCode);
            OAuthCache.getInstance().addToCache(new OAuthCacheKey(cacheKeyString), (Serializable)((Object)authzCodeDO));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authorization Code info was added to the cache for client id : " + authorizationReqDTO.getConsumerKey()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Issued Authorization Code to user : " + authorizationReqDTO.getUser() + ", Using the redirect url : " + authorizationReqDTO.getCallbackUrl() + ", Scope : " + OAuth2Util.buildScopeString(oauthAuthzMsgCtx.getApprovedScope()) + ", validity period : " + validityPeriod));
        }
        return authzCodeDO;
    }

    public static OAuth2AuthorizeRespDTO buildAuthorizationCodeResponseDTO(OAuth2AuthorizeRespDTO respDTO, AuthzCodeDO authzCodeDO) throws IdentityOAuth2Exception {
        respDTO.setAuthorizationCode(authzCodeDO.getAuthorizationCode());
        respDTO.setCodeId(authzCodeDO.getAuthzCodeId());
        return respDTO;
    }

    public static OAuth2AuthorizeRespDTO buildAccessTokenResponseDTO(OAuth2AuthorizeRespDTO respDTO, AccessTokenDO accessTokenDO) {
        long expireTime = OAuth2Util.getTokenExpireTimeMillis(accessTokenDO);
        if (log.isDebugEnabled()) {
            if (expireTime > 0L) {
                log.debug((Object)("Access Token is valid for another " + expireTime + "ms"));
            } else {
                log.debug((Object)"Infinite lifetime Access Token found in cache");
            }
        }
        respDTO.setAccessToken(accessTokenDO.getAccessToken());
        if (expireTime > 0L) {
            respDTO.setValidityPeriod(expireTime / 1000L);
        } else {
            respDTO.setValidityPeriod(9223372036854775L);
        }
        respDTO.setTokenType(accessTokenDO.getTokenType());
        return respDTO;
    }

    public static OAuth2AuthorizeRespDTO buildIDTokenResponseDTO(OAuth2AuthorizeRespDTO respDTO, AccessTokenDO accessTokenDO, OAuthAuthzReqMessageContext oauthAuthzMsgCtx) throws IdentityOAuth2Exception {
        if (ResponseTypeHandlerUtil.isOIDCRequest(oauthAuthzMsgCtx)) {
            OAuth2AuthorizeRespDTO newRespDTO = new OAuth2AuthorizeRespDTO();
            newRespDTO.setAccessToken(accessTokenDO.getAccessToken());
            newRespDTO.setAuthorizationCode(respDTO.getAuthorizationCode());
            ResponseTypeHandlerUtil.buildIdToken(oauthAuthzMsgCtx, newRespDTO);
            respDTO.setIdToken(newRespDTO.getIdToken());
        }
        return respDTO;
    }

    private static boolean isOIDCRequest(OAuthAuthzReqMessageContext msgCtx) {
        return msgCtx.getApprovedScope() != null && OAuth2Util.isOIDCAuthzRequest(msgCtx.getApprovedScope());
    }

    private static void buildIdToken(OAuthAuthzReqMessageContext msgCtx, OAuth2AuthorizeRespDTO authzRespDTO) throws IdentityOAuth2Exception {
        if (StringUtils.isNotBlank((String)authzRespDTO.getAccessToken())) {
            ResponseTypeHandlerUtil.addUserAttributesToCache(authzRespDTO.getAccessToken(), msgCtx);
        }
        if (StringUtils.contains((String)msgCtx.getAuthorizationReqDTO().getResponseType(), (String)"id_token")) {
            IDTokenBuilder builder = OAuthServerConfiguration.getInstance().getOpenIDConnectIDTokenBuilder();
            authzRespDTO.setIdToken(builder.buildIDToken(msgCtx, authzRespDTO));
        }
    }

    private static void addUserAttributesToCache(String accessToken, OAuthAuthzReqMessageContext msgCtx) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authorizeReqDTO = msgCtx.getAuthorizationReqDTO();
        Map userAttributes = authorizeReqDTO.getUser().getUserAttributes();
        AuthorizationGrantCacheKey authorizationGrantCacheKey = new AuthorizationGrantCacheKey(accessToken);
        AuthorizationGrantCacheEntry authorizationGrantCacheEntry = new AuthorizationGrantCacheEntry(userAttributes);
        if (StringUtils.isNotBlank((String)authorizeReqDTO.getEssentialClaims())) {
            authorizationGrantCacheEntry.setEssentialClaims(authorizeReqDTO.getEssentialClaims());
        }
        ClaimMapping key = new ClaimMapping();
        Claim claimOfKey = new Claim();
        claimOfKey.setClaimUri("sub");
        key.setRemoteClaim(claimOfKey);
        String sub = authorizeReqDTO.getUser().getUserName();
        AccessTokenDO accessTokenDO = ResponseTypeHandlerUtil.getAccessTokenDO(accessToken, msgCtx);
        if (accessTokenDO != null && StringUtils.isNotBlank((String)accessTokenDO.getTokenId())) {
            authorizationGrantCacheEntry.setTokenId(accessTokenDO.getTokenId());
        }
        if (StringUtils.isBlank((String)sub)) {
            sub = authorizeReqDTO.getUser().getAuthenticatedSubjectIdentifier();
        }
        if (StringUtils.isNotBlank((String)sub)) {
            userAttributes.put(key, sub);
        }
        authorizationGrantCacheEntry.setValidityPeriod(TimeUnit.MILLISECONDS.toNanos(accessTokenDO.getValidityPeriodInMillis()));
        AuthorizationGrantCache.getInstance().addToCacheByToken(authorizationGrantCacheKey, authorizationGrantCacheEntry);
    }

    private static AccessTokenDO getAccessTokenDO(String accessToken, OAuthAuthzReqMessageContext msgCtx) throws IdentityOAuth2Exception {
        Object accessTokenObject = msgCtx.getProperty("AccessTokenDo");
        if (accessTokenObject instanceof AccessTokenDO) {
            return (AccessTokenDO)((Object)accessTokenObject);
        }
        return OAuth2Util.getAccessTokenDOfromTokenIdentifier(accessToken);
    }

    private static void deactivateCurrentAuthorizationCode(String authorizationCode, String tokenId) throws IdentityOAuth2Exception {
        if (authorizationCode != null) {
            AuthzCodeDO authzCodeDO = new AuthzCodeDO();
            authzCodeDO.setAuthorizationCode(authorizationCode);
            authzCodeDO.setOauthTokenId(tokenId);
            OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().deactivateAuthorizationCode(authzCodeDO);
        }
    }

    private static AccessTokenDO getExistingToken(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, boolean cacheEnabled) throws IdentityOAuth2Exception {
        AccessTokenDO existingTokenBean = null;
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        String scope = OAuth2Util.buildScopeString(oauthAuthzMsgCtx.getApprovedScope());
        String consumerKey = authorizationReqDTO.getConsumerKey();
        String authorizedUser = authorizationReqDTO.getUser().toString();
        String authenticatedIDP = authorizationReqDTO.getUser().getFederatedIdPName();
        if (cacheEnabled) {
            existingTokenBean = ResponseTypeHandlerUtil.getExistingTokenFromCache(consumerKey, scope, authorizedUser, authenticatedIDP);
        }
        if (existingTokenBean == null) {
            existingTokenBean = ResponseTypeHandlerUtil.getExistingTokenFromDB(oauthAuthzMsgCtx, cacheEnabled);
        }
        return existingTokenBean;
    }

    private static AccessTokenDO getExistingTokenFromCache(String consumerKey, String scope, String authorizedUser, String authenticatedIDP) throws IdentityOAuth2Exception {
        AccessTokenDO existingTokenBean = null;
        OAuthCacheKey cacheKey = ResponseTypeHandlerUtil.getOAuthCacheKey(consumerKey, scope, authorizedUser, authenticatedIDP);
        CacheEntry cacheEntry = (CacheEntry)((Object)OAuthCache.getInstance().getValueFromCache(cacheKey));
        if (cacheEntry != null && cacheEntry instanceof AccessTokenDO) {
            existingTokenBean = (AccessTokenDO)cacheEntry;
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("Retrieved active access token(hashed): " + DigestUtils.sha256Hex((String)existingTokenBean.getAccessToken()) + " in state: " + existingTokenBean.getTokenState() + " for client Id: " + consumerKey + ", user: " + authorizedUser + " and scope: " + scope + " from cache."));
                } else {
                    log.debug((Object)("Retrieved active access token in state: " + existingTokenBean.getTokenState() + " for client Id: " + consumerKey + ", user: " + authorizedUser + " and scope: " + scope + " from cache."));
                }
            }
            if (ResponseTypeHandlerUtil.getAccessTokenExpiryTimeMillis(existingTokenBean) == 0L) {
                ResponseTypeHandlerUtil.removeTokenFromCache(cacheKey, existingTokenBean);
            }
        }
        return existingTokenBean;
    }

    private static AccessTokenDO getExistingTokenFromDB(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, boolean cacheEnabled) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        String scope = OAuth2Util.buildScopeString(oauthAuthzMsgCtx.getApprovedScope());
        String consumerKey = authorizationReqDTO.getConsumerKey();
        AuthenticatedUser authorizedUser = authorizationReqDTO.getUser();
        AccessTokenDO existingToken = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getLatestAccessToken(consumerKey, authorizedUser, ResponseTypeHandlerUtil.getUserStoreDomain(authorizedUser), scope, false);
        if (existingToken != null) {
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("Retrieved latest access token(hashed): " + DigestUtils.sha256Hex((String)existingToken.getAccessToken()) + " in state: " + existingToken.getTokenState() + " for client Id: " + consumerKey + " user: " + authorizedUser + " and scope: " + scope + " from db"));
                } else {
                    log.debug((Object)("Retrieved latest access token for client Id: " + consumerKey + " user: " + authorizedUser + " and scope: " + scope + " from db"));
                }
            }
            long expireTime = ResponseTypeHandlerUtil.getAccessTokenExpiryTimeMillis(existingToken);
            if ("ACTIVE".equals(existingToken.getTokenState()) && expireTime != 0L && cacheEnabled) {
                ResponseTypeHandlerUtil.addTokenToCache(ResponseTypeHandlerUtil.getOAuthCacheKey(consumerKey, scope, authorizedUser.toString(), authorizedUser.getFederatedIdPName()), existingToken);
            }
        }
        return existingToken;
    }

    private static AccessTokenDO generateNewAccessToken(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, AccessTokenDO existingTokenBean, OauthTokenIssuer oauthIssuerImpl, boolean cacheEnabled) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        String scope = OAuth2Util.buildScopeString(oauthAuthzMsgCtx.getApprovedScope());
        String consumerKey = authorizationReqDTO.getConsumerKey();
        String authorizedUser = authorizationReqDTO.getUser().toString();
        String authenticatedIDP = authorizationReqDTO.getUser().getFederatedIdPName();
        OAuthAppDO oAuthAppBean = ResponseTypeHandlerUtil.getOAuthApp(consumerKey);
        Timestamp timestamp = new Timestamp(new Date().getTime());
        long validityPeriodInMillis = ResponseTypeHandlerUtil.getConfiguredAccessTokenValidityPeriodInMillis(oauthAuthzMsgCtx, oAuthAppBean);
        oauthAuthzMsgCtx.addProperty("USER_TYPE", "APPLICATION_USER");
        AccessTokenDO newTokenBean = ResponseTypeHandlerUtil.createNewTokenBean(oauthAuthzMsgCtx, oAuthAppBean, existingTokenBean, oauthIssuerImpl, timestamp, validityPeriodInMillis);
        ResponseTypeHandlerUtil.setDetailsToMessageContext(oauthAuthzMsgCtx, newTokenBean);
        ResponseTypeHandlerUtil.persistAccessTokenInDB(oauthAuthzMsgCtx, existingTokenBean, newTokenBean);
        ResponseTypeHandlerUtil.deactivateCurrentAuthorizationCode(newTokenBean.getAuthorizationCode(), newTokenBean.getTokenId());
        if (isHashDisabled && cacheEnabled) {
            ResponseTypeHandlerUtil.addTokenToCache(ResponseTypeHandlerUtil.getOAuthCacheKey(consumerKey, scope, authorizedUser, authenticatedIDP), newTokenBean);
        }
        return newTokenBean;
    }

    private static AccessTokenDO createNewTokenBean(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, OAuthAppDO oAuthAppBean, AccessTokenDO existingTokenBean, OauthTokenIssuer oauthIssuerImpl, Timestamp timestamp, long validityPeriodInMillis) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        AccessTokenDO newTokenBean = new AccessTokenDO();
        newTokenBean.setTokenState("ACTIVE");
        newTokenBean.setConsumerKey(authorizationReqDTO.getConsumerKey());
        newTokenBean.setAuthzUser(authorizationReqDTO.getUser());
        newTokenBean.setTenantID(OAuth2Util.getTenantId(authorizationReqDTO.getTenantDomain()));
        newTokenBean.setScope(oauthAuthzMsgCtx.getApprovedScope());
        newTokenBean.setTokenId(UUID.randomUUID().toString());
        newTokenBean.setTokenType("APPLICATION_USER");
        newTokenBean.setIssuedTime(timestamp);
        newTokenBean.setValidityPeriodInMillis(validityPeriodInMillis);
        newTokenBean.setValidityPeriod(validityPeriodInMillis / 1000L);
        newTokenBean.setGrantType(ResponseTypeHandlerUtil.getGrantType(authorizationReqDTO.getResponseType()));
        newTokenBean.setAccessToken(ResponseTypeHandlerUtil.getNewAccessToken(oauthAuthzMsgCtx, oauthIssuerImpl));
        ResponseTypeHandlerUtil.setRefreshTokenDetails(oauthAuthzMsgCtx, oAuthAppBean, existingTokenBean, newTokenBean, oauthIssuerImpl, timestamp);
        return newTokenBean;
    }

    private static String getNewAccessToken(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, OauthTokenIssuer oauthIssuerImpl) throws IdentityOAuth2Exception {
        try {
            String newAccessToken = oauthIssuerImpl.accessToken(oauthAuthzMsgCtx);
            if (OAuth2Util.checkUserNameAssertionEnabled()) {
                newAccessToken = OAuth2Util.addUsernameToToken(oauthAuthzMsgCtx.getAuthorizationReqDTO().getUser(), newAccessToken);
            }
            return newAccessToken;
        }
        catch (OAuthSystemException e) {
            throw new IdentityOAuth2Exception("Error while generating new access token", e);
        }
    }

    private static String getNewRefreshToken(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, OauthTokenIssuer oauthIssuerImpl) throws IdentityOAuth2Exception {
        try {
            String refreshToken = oauthIssuerImpl.refreshToken(oauthAuthzMsgCtx);
            if (OAuth2Util.checkUserNameAssertionEnabled()) {
                refreshToken = OAuth2Util.addUsernameToToken(oauthAuthzMsgCtx.getAuthorizationReqDTO().getUser(), refreshToken);
            }
            return refreshToken;
        }
        catch (OAuthSystemException e) {
            throw new IdentityOAuth2Exception("Error while generating new refresh token", e);
        }
    }

    private static void setRefreshTokenDetails(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, OAuthAppDO oAuthAppBean, AccessTokenDO existingTokenBean, AccessTokenDO newTokenBean, OauthTokenIssuer oauthIssuerImpl, Timestamp timestamp) throws IdentityOAuth2Exception {
        if (ResponseTypeHandlerUtil.isRefreshTokenValid(existingTokenBean)) {
            ResponseTypeHandlerUtil.setRefreshTokenDetailsFromExistingToken(existingTokenBean, newTokenBean);
        } else {
            newTokenBean.setRefreshTokenIssuedTime(timestamp);
            newTokenBean.setRefreshTokenValidityPeriodInMillis(ResponseTypeHandlerUtil.getConfiguredRefreshTokenValidityPeriodInMillis(oAuthAppBean, oauthAuthzMsgCtx));
            newTokenBean.setRefreshToken(ResponseTypeHandlerUtil.getNewRefreshToken(oauthAuthzMsgCtx, oauthIssuerImpl));
        }
    }

    private static void setRefreshTokenDetailsFromExistingToken(AccessTokenDO existingTokenBean, AccessTokenDO newTokenBean) {
        newTokenBean.setRefreshToken(existingTokenBean.getRefreshToken());
        newTokenBean.setRefreshTokenIssuedTime(existingTokenBean.getRefreshTokenIssuedTime());
        newTokenBean.setRefreshTokenValidityPeriodInMillis(existingTokenBean.getRefreshTokenValidityPeriodInMillis());
    }

    private static void setDetailsToMessageContext(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, AccessTokenDO newTokenBean) {
        oauthAuthzMsgCtx.setValidityPeriod(newTokenBean.getValidityPeriodInMillis());
        oauthAuthzMsgCtx.setRefreshTokenvalidityPeriod(newTokenBean.getRefreshTokenValidityPeriodInMillis());
        oauthAuthzMsgCtx.setAccessTokenIssuedTime(newTokenBean.getIssuedTime().getTime());
        oauthAuthzMsgCtx.setRefreshTokenIssuedTime(newTokenBean.getRefreshTokenIssuedTime().getTime());
        oauthAuthzMsgCtx.addProperty("AccessTokenDo", (Object)newTokenBean);
    }

    private static void persistAccessTokenInDB(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, AccessTokenDO existingTokenBean, AccessTokenDO newTokenBean) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        ResponseTypeHandlerUtil.storeAccessToken(authorizationReqDTO, ResponseTypeHandlerUtil.getUserStoreDomain(authorizationReqDTO.getUser()), existingTokenBean, newTokenBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisted Access Token for Client ID: " + authorizationReqDTO.getConsumerKey() + ", Authorized User: " + authorizationReqDTO.getUser() + ", Is Federated User: " + authorizationReqDTO.getUser().isFederatedUser() + ", Timestamp: " + newTokenBean.getIssuedTime() + ", Validity period: " + newTokenBean.getValidityPeriod() + " s, Scope: " + OAuth2Util.buildScopeString(oauthAuthzMsgCtx.getApprovedScope()) + " and Token State: " + "ACTIVE"));
        }
    }

    private static void storeAccessToken(OAuth2AuthorizeReqDTO authorizationReqDTO, String userStoreDomain, AccessTokenDO existingTokenBean, AccessTokenDO newTokenBean) throws IdentityOAuth2Exception {
        try {
            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().insertAccessToken(newTokenBean.getAccessToken(), authorizationReqDTO.getConsumerKey(), newTokenBean, existingTokenBean, userStoreDomain);
        }
        catch (IdentityException e) {
            String errorMsg = IdentityUtil.isTokenLoggable((String)"AccessToken") ? "Error occurred while storing new access token(hashed) : " + DigestUtils.sha256Hex((String)newTokenBean.getAccessToken()) : "Error occurred while storing new access token.";
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
    }

    private static long getAccessTokenExpiryTimeMillis(AccessTokenDO tokenBean) throws IdentityOAuth2Exception {
        long expireTimeMillis = OAuth2Util.getTokenExpireTimeMillis(tokenBean);
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                if (expireTimeMillis > 0L) {
                    log.debug((Object)("Access Token(hashed): " + DigestUtils.sha256Hex((String)tokenBean.getAccessToken()) + " is still valid. Remaining time: " + expireTimeMillis + " ms"));
                } else {
                    log.debug((Object)("Infinite lifetime Access Token(hashed) " + DigestUtils.sha256Hex((String)tokenBean.getAccessToken()) + " found"));
                }
            } else if (expireTimeMillis > 0L) {
                log.debug((Object)("Valid access token is found for client: " + tokenBean.getConsumerKey() + ". Remaining time: " + expireTimeMillis + " ms"));
            } else {
                log.debug((Object)("Infinite lifetime Access Token found for client: " + tokenBean.getConsumerKey()));
            }
        }
        return expireTimeMillis;
    }

    private static long getConfiguredAccessTokenValidityPeriodInMillis(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, OAuthAppDO oAuthAppBean) throws IdentityOAuth2Exception {
        long validityPeriodInMillis;
        long callbackValidityPeriod = oauthAuthzMsgCtx.getAccessTokenValidityPeriod();
        if (callbackValidityPeriod != -1L && callbackValidityPeriod > 0L) {
            validityPeriodInMillis = callbackValidityPeriod * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + oAuthAppBean.getOauthConsumerKey() + ", using access token validity period configured from callback: " + validityPeriodInMillis + " ms"));
            }
        } else if (oAuthAppBean.getUserAccessTokenExpiryTime() != 0L) {
            validityPeriodInMillis = oAuthAppBean.getUserAccessTokenExpiryTime() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id: " + oAuthAppBean.getOauthConsumerKey() + ", using user access token validity period configured for application: " + validityPeriodInMillis + " ms"));
            }
        } else {
            validityPeriodInMillis = OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id: " + oAuthAppBean.getOauthConsumerKey() + ", using user access token validity period configured for server: " + validityPeriodInMillis + " ms"));
            }
        }
        return validityPeriodInMillis;
    }

    private static long getConfiguredRefreshTokenValidityPeriodInMillis(OAuthAppDO oAuthAppBean, OAuthAuthzReqMessageContext oauthAuthzMsgCtx) {
        long refreshTokenValidityPeriodInMillis;
        long refreshTokenValidityPeriod = oauthAuthzMsgCtx.getRefreshTokenvalidityPeriod();
        if (refreshTokenValidityPeriod != -1L && refreshTokenValidityPeriod > 0L) {
            refreshTokenValidityPeriodInMillis = oauthAuthzMsgCtx.getRefreshTokenvalidityPeriod() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + oAuthAppBean.getOauthConsumerKey() + ", using refresh token validity period configured from OAuthAuthzReqMessageContext: " + refreshTokenValidityPeriodInMillis + " ms"));
            }
        } else if (oAuthAppBean.getRefreshTokenExpiryTime() != 0L) {
            refreshTokenValidityPeriodInMillis = oAuthAppBean.getRefreshTokenExpiryTime() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + oAuthAppBean.getOauthConsumerKey() + ", using refresh token validity period configured for application: " + refreshTokenValidityPeriodInMillis + " ms"));
            }
        } else {
            refreshTokenValidityPeriodInMillis = OAuthServerConfiguration.getInstance().getRefreshTokenValidityPeriodInSeconds() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id: " + oAuthAppBean.getOauthConsumerKey() + ", using refresh token validity period configured for server: " + refreshTokenValidityPeriodInMillis + " ms"));
            }
        }
        return refreshTokenValidityPeriodInMillis;
    }

    private static boolean isAccessTokenValid(AccessTokenDO tokenBean) throws IdentityOAuth2Exception {
        if (tokenBean != null) {
            long expireTime = ResponseTypeHandlerUtil.getAccessTokenExpiryTimeMillis(tokenBean);
            if ("ACTIVE".equals(tokenBean.getTokenState()) && expireTime != 0L) {
                return true;
            }
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("Access token(hashed): " + DigestUtils.sha256Hex((String)tokenBean.getAccessToken()) + " is not valid anymore"));
                } else {
                    log.debug((Object)("Latest access token in the database for client: " + tokenBean.getConsumerKey() + " is not valid anymore"));
                }
            }
        }
        return false;
    }

    private static boolean isRefreshTokenValid(AccessTokenDO tokenBean) {
        if (tokenBean != null) {
            long refreshTokenExpireTime = OAuth2Util.getRefreshTokenExpireTimeMillis(tokenBean);
            if ("ACTIVE".equals(tokenBean.getTokenState())) {
                String consumerKey = tokenBean.getConsumerKey();
                if (!ResponseTypeHandlerUtil.isRefreshTokenExpired(tokenBean.getConsumerKey(), refreshTokenExpireTime)) {
                    if (log.isDebugEnabled()) {
                        if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                            log.debug((Object)("Existing access token(hashed): " + DigestUtils.sha256Hex((String)tokenBean.getAccessToken()) + " has expired, but refresh token(hashed):" + DigestUtils.sha256Hex((String)tokenBean.getRefreshToken()) + " is still valid for client: " + consumerKey + ". Remaining time: " + refreshTokenExpireTime + " ms. Using existing refresh token."));
                        } else {
                            log.debug((Object)("Existing access token has expired, but refresh token is still valid for client: " + consumerKey + ". Remaining time: " + refreshTokenExpireTime + "ms. Using existing refresh token."));
                        }
                    }
                    return true;
                }
                if (log.isDebugEnabled()) {
                    if (IdentityUtil.isTokenLoggable((String)"RefreshToken")) {
                        log.debug((Object)("Refresh token: " + tokenBean.getRefreshToken() + " for client: " + tokenBean.getConsumerKey() + " is expired. Issuing a new refresh token."));
                    } else {
                        log.debug((Object)("Refresh token for client: " + tokenBean.getConsumerKey() + " is expired. Issuing a new refresh token."));
                    }
                }
            }
        }
        return false;
    }

    private static boolean isRefreshTokenExpired(String consumerKey, long refreshTokenExpireTime) {
        if (refreshTokenExpireTime < 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Infinite lifetime Refresh Token found for client: " + consumerKey));
            }
            return false;
        }
        return refreshTokenExpireTime <= 0L;
    }

    private static OAuthAppDO getOAuthApp(String consumerKey) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppBean;
        try {
            oAuthAppBean = OAuth2Util.getAppInformationByClientId(consumerKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Service Provider specific expiry time enabled for application : " + consumerKey + ". Application access token expiry time : " + oAuthAppBean.getApplicationAccessTokenExpiryTime() + ", User access token expiry time : " + oAuthAppBean.getUserAccessTokenExpiryTime() + ", Refresh token expiry time : " + oAuthAppBean.getRefreshTokenExpiryTime()));
            }
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving app information for clientId : " + consumerKey, e);
        }
        return oAuthAppBean;
    }

    private static boolean isNotRenewAccessTokenPerRequest(OauthTokenIssuer oauthIssuerImpl, OAuthAuthzReqMessageContext oauthAuthzMsgCtx) {
        boolean isRenew = oauthIssuerImpl.renewAccessTokenPerRequest(oauthAuthzMsgCtx);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enable Access Token renew per request: " + isRenew));
        }
        return !isRenew;
    }

    private static String getUserStoreDomain(AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        String userStoreDomain = null;
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            try {
                userStoreDomain = OAuth2Util.getUserStoreForFederatedUser(authenticatedUser);
            }
            catch (IdentityOAuth2Exception e) {
                throw new IdentityOAuth2Exception("Error occurred while getting user store domain for user: " + authenticatedUser, (Throwable)((Object)e));
            }
        }
        return userStoreDomain;
    }

    private static String getGrantType(String responseType) {
        String grantType = StringUtils.contains((String)responseType, (String)"token") ? "implicit" : responseType;
        return grantType;
    }

    private static OAuthCacheKey getOAuthCacheKey(String consumerKey, String scope, String authorizedUser, String authenticatedIDP) {
        String cacheKeyString = OAuth2Util.buildCacheKeyStringForToken(consumerKey, scope, authorizedUser, authenticatedIDP);
        return new OAuthCacheKey(cacheKeyString);
    }

    private static void addTokenToCache(OAuthCacheKey cacheKey, AccessTokenDO tokenBean) {
        OAuthCache.getInstance().addToCache(cacheKey, (Serializable)((Object)tokenBean));
        OAuthCacheKey accessTokenCacheKey = new OAuthCacheKey(tokenBean.getAccessToken());
        OAuthCache.getInstance().addToCache(accessTokenCacheKey, (Serializable)((Object)tokenBean));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access token info was added to the cache for cache key : " + cacheKey.getCacheKeyString()));
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Access token was added to OAuthCache for cache key : " + accessTokenCacheKey.getCacheKeyString()));
            }
        }
    }

    private static void removeTokenFromCache(OAuthCacheKey cacheKey, AccessTokenDO tokenBean) {
        OAuthCache.getInstance().clearCacheEntry(cacheKey);
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Access token(hashed): " + DigestUtils.sha256Hex((String)tokenBean.getAccessToken()) + " is expired. Therefore cleared it from cache."));
            } else {
                log.debug((Object)("Existing access token for client: " + tokenBean.getConsumerKey() + " is expired. Therefore cleared it from cache."));
            }
        }
    }

    private static void revokeExistingToken(String clientId, String accessToken) throws IdentityOAuth2Exception {
        OAuthClientAuthnContext oAuthClientAuthnContext = ResponseTypeHandlerUtil.buildAuthenticatedOAuthClientAuthnContext(clientId);
        OAuthRevocationRequestDTO revocationRequestDTO = OAuth2Util.buildOAuthRevocationRequest(oAuthClientAuthnContext, accessToken);
        OAuthRevocationResponseDTO revocationResponseDTO = ResponseTypeHandlerUtil.getOauth2Service().revokeTokenByOAuthClient(revocationRequestDTO);
        if (revocationResponseDTO.isError()) {
            String msg = "Error while revoking tokens for clientId:" + clientId + " Error Message:" + revocationResponseDTO.getErrorMsg();
            log.error((Object)msg);
            throw new IdentityOAuth2Exception(msg);
        }
    }

    private static OAuth2Service getOauth2Service() {
        return (OAuth2Service)((Object)PrivilegedCarbonContext.getThreadLocalCarbonContext().getOSGiService(OAuth2Service.class, null));
    }

    private static OAuthClientAuthnContext buildAuthenticatedOAuthClientAuthnContext(String clientId) {
        OAuthClientAuthnContext oAuthClientAuthnContext = new OAuthClientAuthnContext();
        oAuthClientAuthnContext.setAuthenticated(true);
        oAuthClientAuthnContext.setClientId(clientId);
        return oAuthClientAuthnContext;
    }
}

