/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.authz.handlers;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.authz.handlers.AbstractResponseTypeHandler;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuer;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.openidconnect.IDTokenBuilder;

@Deprecated
public class TokenResponseTypeHandler
extends AbstractResponseTypeHandler {
    private static final Log log = LogFactory.getLog(TokenResponseTypeHandler.class);
    private Boolean isHashDisabled = OAuth2Util.isHashDisabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuth2AuthorizeRespDTO issue(OAuthAuthzReqMessageContext oauthAuthzMsgCtx) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO;
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            oAuthEventInterceptorProxy.onPreTokenIssue(oauthAuthzMsgCtx, paramMap);
        }
        OAuth2AuthorizeRespDTO respDTO = new OAuth2AuthorizeRespDTO();
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        String scope = OAuth2Util.buildScopeString(oauthAuthzMsgCtx.getApprovedScope());
        respDTO.setCallbackURI(authorizationReqDTO.getCallbackUrl());
        String consumerKey = authorizationReqDTO.getConsumerKey();
        String authorizedUser = authorizationReqDTO.getUser().toString();
        String responseType = oauthAuthzMsgCtx.getAuthorizationReqDTO().getResponseType();
        try {
            oAuthAppDO = OAuth2Util.getAppInformationByClientId(consumerKey);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving app information for clientId: " + consumerKey, e);
        }
        String grantType = StringUtils.contains((String)responseType, (String)"token") ? "implicit" : responseType;
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authorizedUser);
        String oAuthCacheKeyString = isUsernameCaseSensitive ? consumerKey + ":" + authorizedUser + ":" + scope : consumerKey + ":" + authorizedUser.toLowerCase() + ":" + scope;
        OAuthCacheKey cacheKey = new OAuthCacheKey(oAuthCacheKeyString);
        String userStoreDomain = null;
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            userStoreDomain = OAuth2Util.getUserStoreForFederatedUser(authorizationReqDTO.getUser());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service Provider specific expiry time enabled for application : " + consumerKey + ". Application access token expiry time : " + oAuthAppDO.getApplicationAccessTokenExpiryTime() + ", User access token expiry time : " + oAuthAppDO.getUserAccessTokenExpiryTime() + ", Refresh token expiry time : " + oAuthAppDO.getRefreshTokenExpiryTime()));
        }
        String refreshToken = null;
        Timestamp refreshTokenIssuedTime = null;
        long refreshTokenValidityPeriodInMillis = 0L;
        AccessTokenDO tokenDO = null;
        String string = (consumerKey + ":" + authorizedUser + ":" + scope).intern();
        synchronized (string) {
            String accessToken;
            long callbackValidityPeriod;
            long refreshTokenExpiryTime;
            AccessTokenDO existingAccessTokenDO = null;
            if (this.isHashDisabled.booleanValue() && this.cacheEnabled) {
                existingAccessTokenDO = (AccessTokenDO)((Object)OAuthCache.getInstance().getValueFromCache(cacheKey));
                if (existingAccessTokenDO != null) {
                    long expireTime;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Retrieved active Access Token for Client Id : " + consumerKey + ", User ID :" + authorizedUser + " and Scope : " + scope + " from cache"));
                    }
                    if ((expireTime = OAuth2Util.getTokenExpireTimeMillis(existingAccessTokenDO)) > 0L || expireTime < 0L) {
                        if (this.isNotRenewAccessTokenPerRequest(oauthAuthzMsgCtx)) {
                            if (log.isDebugEnabled()) {
                                if (expireTime > 0L) {
                                    log.debug((Object)("Access Token is valid for another " + expireTime + "ms"));
                                } else {
                                    log.debug((Object)"Infinite lifetime Access Token found in cache");
                                }
                            }
                            respDTO.setAccessToken(existingAccessTokenDO.getAccessToken());
                            if (expireTime > 0L) {
                                respDTO.setValidityPeriod(expireTime / 1000L);
                            } else {
                                respDTO.setValidityPeriod(9223372036854775L);
                            }
                            respDTO.setScope(oauthAuthzMsgCtx.getApprovedScope());
                            respDTO.setTokenType(existingAccessTokenDO.getTokenType());
                            if (this.isOIDCRequest(oauthAuthzMsgCtx)) {
                                this.buildIdToken(oauthAuthzMsgCtx, respDTO);
                            }
                            this.triggerPostListeners(oauthAuthzMsgCtx, existingAccessTokenDO, respDTO);
                            return respDTO;
                        }
                    } else {
                        refreshTokenExpiryTime = OAuth2Util.getRefreshTokenExpireTimeMillis(existingAccessTokenDO);
                        if (refreshTokenExpiryTime < 0L || refreshTokenExpiryTime > 0L) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Access token has expired, But refresh token is still valid. User existing refresh token.");
                            }
                            refreshToken = existingAccessTokenDO.getRefreshToken();
                            refreshTokenIssuedTime = existingAccessTokenDO.getRefreshTokenIssuedTime();
                            refreshTokenValidityPeriodInMillis = existingAccessTokenDO.getRefreshTokenValidityPeriodInMillis();
                        }
                        OAuthCache.getInstance().clearCacheEntry(cacheKey);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Access Token is expired. Therefore cleared it from cache and marked it as expired in database");
                        }
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("No active access token found in cache for Client ID : " + consumerKey + ", User ID : " + authorizedUser + " and Scope : " + scope));
                }
            }
            if (this.isHashDisabled.booleanValue() && existingAccessTokenDO == null) {
                existingAccessTokenDO = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getLatestAccessToken(consumerKey, authorizationReqDTO.getUser(), userStoreDomain, scope, false);
                if (existingAccessTokenDO != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Retrieved latest Access Token for Client ID : " + consumerKey + ", User ID :" + authorizedUser + " and Scope : " + scope + " from database"));
                    }
                    long expiryTime = OAuth2Util.getTokenExpireTimeMillis(existingAccessTokenDO);
                    refreshTokenExpiryTime = OAuth2Util.getRefreshTokenExpireTimeMillis(existingAccessTokenDO);
                    if ("ACTIVE".equals(existingAccessTokenDO.getTokenState()) && (expiryTime > 0L || expiryTime < 0L)) {
                        if (this.isNotRenewAccessTokenPerRequest(oauthAuthzMsgCtx)) {
                            if (log.isDebugEnabled()) {
                                if (expiryTime > 0L) {
                                    log.debug((Object)("Access token is valid for another " + expiryTime + "ms"));
                                } else {
                                    log.debug((Object)"Infinite lifetime Access Token found in cache");
                                }
                            }
                            if (this.cacheEnabled) {
                                OAuthCache.getInstance().addToCache(cacheKey, (Serializable)((Object)existingAccessTokenDO));
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Access Token was added to cache for cache key : " + cacheKey.getCacheKeyString()));
                                }
                            }
                            respDTO.setAccessToken(existingAccessTokenDO.getAccessToken());
                            if (expiryTime > 0L) {
                                respDTO.setValidityPeriod(expiryTime / 1000L);
                            } else {
                                respDTO.setValidityPeriod(9223372036854775L);
                            }
                            respDTO.setScope(oauthAuthzMsgCtx.getApprovedScope());
                            respDTO.setTokenType(existingAccessTokenDO.getTokenType());
                            if (this.isOIDCRequest(oauthAuthzMsgCtx)) {
                                this.buildIdToken(oauthAuthzMsgCtx, respDTO);
                            }
                            this.triggerPostListeners(oauthAuthzMsgCtx, existingAccessTokenDO, respDTO);
                            return respDTO;
                        }
                    } else {
                        String tokenState;
                        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                            log.debug((Object)("Access Token is " + existingAccessTokenDO.getTokenState()));
                        }
                        if ("ACTIVE".equals(tokenState = existingAccessTokenDO.getTokenState())) {
                            if (refreshTokenExpiryTime > 0L || refreshTokenExpiryTime < 0L) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Access token has expired, But refresh token is still valid. User existing refresh token.");
                                }
                                refreshToken = existingAccessTokenDO.getRefreshToken();
                                refreshTokenIssuedTime = existingAccessTokenDO.getRefreshTokenIssuedTime();
                                refreshTokenValidityPeriodInMillis = existingAccessTokenDO.getRefreshTokenValidityPeriodInMillis();
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Marked Access Token as expired");
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("Access Token is " + existingAccessTokenDO.getTokenState()));
                        }
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("No access token found in database for Client ID : " + consumerKey + ", User ID : " + authorizedUser + " and Scope : " + scope));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Issuing a new access token for client id: " + consumerKey + ", user : " + authorizedUser + "and scope : " + scope));
            }
            Timestamp timestamp = new Timestamp(new Date().getTime());
            if (refreshTokenIssuedTime == null) {
                refreshTokenIssuedTime = timestamp;
            }
            long validityPeriodInMillis = OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds() * 1000L;
            if (oAuthAppDO.getUserAccessTokenExpiryTime() != 0L) {
                validityPeriodInMillis = oAuthAppDO.getUserAccessTokenExpiryTime() * 1000L;
            }
            if ((callbackValidityPeriod = oauthAuthzMsgCtx.getValidityPeriod()) != -1L && callbackValidityPeriod > 0L) {
                validityPeriodInMillis = callbackValidityPeriod * 1000L;
            }
            if (refreshTokenValidityPeriodInMillis == 0L) {
                refreshTokenValidityPeriodInMillis = oAuthAppDO.getRefreshTokenExpiryTime() != 0L ? oAuthAppDO.getRefreshTokenExpiryTime() * 1000L : OAuthServerConfiguration.getInstance().getRefreshTokenValidityPeriodInSeconds() * 1000L;
            }
            oauthAuthzMsgCtx.setValidityPeriod(validityPeriodInMillis);
            oauthAuthzMsgCtx.setRefreshTokenvalidityPeriod(refreshTokenValidityPeriodInMillis);
            oauthAuthzMsgCtx.setAccessTokenIssuedTime(timestamp.getTime());
            oauthAuthzMsgCtx.setRefreshTokenIssuedTime(refreshTokenIssuedTime.getTime());
            try {
                OauthTokenIssuer oauthIssuerImpl = OAuth2Util.getOAuthTokenIssuerForOAuthApp(oAuthAppDO);
                accessToken = oauthIssuerImpl.accessToken(oauthAuthzMsgCtx);
                if (refreshToken == null) {
                    refreshToken = oauthIssuerImpl.refreshToken(oauthAuthzMsgCtx);
                }
            }
            catch (OAuthSystemException e) {
                throw new IdentityOAuth2Exception("Error occurred while generating access token and refresh token", e);
            }
            if (OAuth2Util.checkUserNameAssertionEnabled()) {
                accessToken = OAuth2Util.addUsernameToToken(authorizationReqDTO.getUser(), accessToken);
                refreshToken = OAuth2Util.addUsernameToToken(authorizationReqDTO.getUser(), refreshToken);
            }
            AccessTokenDO newAccessTokenDO = new AccessTokenDO(consumerKey, authorizationReqDTO.getUser(), oauthAuthzMsgCtx.getApprovedScope(), timestamp, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodInMillis, "APPLICATION_USER");
            newAccessTokenDO.setAccessToken(accessToken);
            newAccessTokenDO.setRefreshToken(refreshToken);
            newAccessTokenDO.setTokenState("ACTIVE");
            newAccessTokenDO.setGrantType(grantType);
            String tokenId = UUID.randomUUID().toString();
            newAccessTokenDO.setTokenId(tokenId);
            oauthAuthzMsgCtx.addProperty("AccessTokenDo", (Object)newAccessTokenDO);
            try {
                OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().insertAccessToken(accessToken, authorizationReqDTO.getConsumerKey(), newAccessTokenDO, existingAccessTokenDO, userStoreDomain);
                this.deactivateCurrentAuthorizationCode(newAccessTokenDO.getAuthorizationCode(), newAccessTokenDO.getTokenId());
                if (!accessToken.equals(newAccessTokenDO.getAccessToken())) {
                    accessToken = newAccessTokenDO.getAccessToken();
                    refreshToken = newAccessTokenDO.getRefreshToken();
                }
            }
            catch (IdentityException e) {
                throw new IdentityOAuth2Exception("Error occurred while storing new access token : " + accessToken, e);
            }
            tokenDO = newAccessTokenDO;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persisted Access Token for Client ID : " + authorizationReqDTO.getConsumerKey() + ", Authorized User : " + authorizationReqDTO.getUser() + ", Timestamp : " + timestamp + ", Validity period (s) : " + newAccessTokenDO.getValidityPeriod() + ", Scope : " + OAuth2Util.buildScopeString(oauthAuthzMsgCtx.getApprovedScope()) + ", Callback URL : " + authorizationReqDTO.getCallbackUrl() + ", Token State : " + "ACTIVE" + " and User Type : " + "APPLICATION_USER"));
            }
            if (this.isHashDisabled.booleanValue() && this.cacheEnabled) {
                OAuthCache.getInstance().addToCache(cacheKey, (Serializable)((Object)newAccessTokenDO));
                OAuthCacheKey accessTokenCacheKey = new OAuthCacheKey(accessToken);
                OAuthCache.getInstance().addToCache(accessTokenCacheKey, (Serializable)((Object)newAccessTokenDO));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Access Token was added to OAuthCache for cache key : " + cacheKey.getCacheKeyString()));
                    log.debug((Object)("Access Token was added to OAuthCache for cache key : " + accessTokenCacheKey.getCacheKeyString()));
                }
            }
            if (StringUtils.contains((String)responseType, (String)ResponseType.TOKEN.toString())) {
                respDTO.setAccessToken(accessToken);
                if (validityPeriodInMillis > 0L) {
                    respDTO.setValidityPeriod(newAccessTokenDO.getValidityPeriod());
                } else {
                    respDTO.setValidityPeriod(9223372036854775L);
                }
                respDTO.setScope(newAccessTokenDO.getScope());
                respDTO.setTokenType(newAccessTokenDO.getTokenType());
            }
        }
        if (this.isOIDCRequest(oauthAuthzMsgCtx)) {
            this.buildIdToken(oauthAuthzMsgCtx, respDTO);
        }
        this.triggerPostListeners(oauthAuthzMsgCtx, tokenDO, respDTO);
        return respDTO;
    }

    private void deactivateCurrentAuthorizationCode(String authorizationCode, String tokenId) throws IdentityOAuth2Exception {
        if (authorizationCode != null) {
            AuthzCodeDO authzCodeDO = new AuthzCodeDO();
            authzCodeDO.setAuthorizationCode(authorizationCode);
            authzCodeDO.setOauthTokenId(tokenId);
            OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().deactivateAuthorizationCode(authzCodeDO);
        }
    }

    private void triggerPostListeners(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, AccessTokenDO tokenDO, OAuth2AuthorizeRespDTO respDTO) {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            try {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                oAuthEventInterceptorProxy.onPostTokenIssue(oauthAuthzMsgCtx, tokenDO, respDTO, paramMap);
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)"Oauth post token issue listener ", (Throwable)((Object)e));
            }
        }
    }

    private boolean isOIDCRequest(OAuthAuthzReqMessageContext msgCtx) {
        return msgCtx.getApprovedScope() != null && OAuth2Util.isOIDCAuthzRequest(msgCtx.getApprovedScope());
    }

    private void buildIdToken(OAuthAuthzReqMessageContext msgCtx, OAuth2AuthorizeRespDTO authzRespDTO) throws IdentityOAuth2Exception {
        if (StringUtils.isNotBlank((String)authzRespDTO.getAccessToken())) {
            this.addUserAttributesToCache(authzRespDTO.getAccessToken(), msgCtx);
        }
        if (StringUtils.contains((String)msgCtx.getAuthorizationReqDTO().getResponseType(), (String)"id_token")) {
            IDTokenBuilder builder = OAuthServerConfiguration.getInstance().getOpenIDConnectIDTokenBuilder();
            authzRespDTO.setIdToken(builder.buildIDToken(msgCtx, authzRespDTO));
        }
    }

    private void addUserAttributesToCache(String accessToken, OAuthAuthzReqMessageContext msgCtx) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authorizeReqDTO = msgCtx.getAuthorizationReqDTO();
        Map userAttributes = authorizeReqDTO.getUser().getUserAttributes();
        AuthorizationGrantCacheKey authorizationGrantCacheKey = new AuthorizationGrantCacheKey(accessToken);
        AuthorizationGrantCacheEntry authorizationGrantCacheEntry = new AuthorizationGrantCacheEntry(userAttributes);
        if (StringUtils.isNotBlank((String)authorizeReqDTO.getEssentialClaims())) {
            authorizationGrantCacheEntry.setEssentialClaims(authorizeReqDTO.getEssentialClaims());
        }
        if (authorizeReqDTO.getRequestObject() != null) {
            authorizationGrantCacheEntry.setRequestObject(authorizeReqDTO.getRequestObject());
        }
        if (authorizeReqDTO.getAuthTime() != 0L) {
            authorizationGrantCacheEntry.setAuthTime(authorizeReqDTO.getAuthTime());
        }
        if (authorizeReqDTO.getMaxAge() != 0L) {
            authorizationGrantCacheEntry.setMaxAge(authorizeReqDTO.getMaxAge());
        }
        ClaimMapping key = new ClaimMapping();
        Claim claimOfKey = new Claim();
        claimOfKey.setClaimUri("sub");
        key.setRemoteClaim(claimOfKey);
        String sub = (String)userAttributes.get(key);
        AccessTokenDO accessTokenDO = TokenResponseTypeHandler.getAccessTokenDO(accessToken, msgCtx);
        if (accessTokenDO != null && StringUtils.isNotBlank((String)accessTokenDO.getTokenId())) {
            authorizationGrantCacheEntry.setTokenId(accessTokenDO.getTokenId());
            if (StringUtils.isBlank((String)sub)) {
                sub = authorizeReqDTO.getUser().getAuthenticatedSubjectIdentifier();
            }
            if (StringUtils.isNotBlank((String)sub)) {
                if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"UserClaims")) {
                    log.debug((Object)("Setting subject: " + sub + " as the sub claim in cache against the access token."));
                }
                authorizationGrantCacheEntry.setSubjectClaim(sub);
            }
            authorizationGrantCacheEntry.setValidityPeriod(TimeUnit.MILLISECONDS.toNanos(accessTokenDO.getValidityPeriodInMillis()));
            AuthorizationGrantCache.getInstance().addToCacheByToken(authorizationGrantCacheKey, authorizationGrantCacheEntry);
        }
    }

    private boolean isNotRenewAccessTokenPerRequest(OAuthAuthzReqMessageContext oauthAuthzMsgCtx) {
        boolean isRenew = this.oauthIssuerImpl.renewAccessTokenPerRequest(oauthAuthzMsgCtx);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access Token renew per request: " + isRenew));
        }
        return !isRenew;
    }

    private static AccessTokenDO getAccessTokenDO(String accessToken, OAuthAuthzReqMessageContext msgCtx) throws IdentityOAuth2Exception {
        Object accessTokenObject = msgCtx.getProperty("AccessTokenDo");
        if (accessTokenObject instanceof AccessTokenDO) {
            return (AccessTokenDO)((Object)accessTokenObject);
        }
        return OAuth2Util.getAccessTokenDOfromTokenIdentifier(accessToken);
    }
}

