/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.authz.handlers;

import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.authz.handlers.IDTokenResponseTypeHandler;
import org.wso2.carbon.identity.oauth2.authz.handlers.util.ResponseTypeHandlerUtil;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2TokenUtil;

public class IDTokenTokenResponseTypeHandler
extends IDTokenResponseTypeHandler {
    @Override
    public OAuth2AuthorizeRespDTO issue(OAuthAuthzReqMessageContext oauthAuthzMsgCtx) throws IdentityOAuth2Exception {
        ResponseTypeHandlerUtil.triggerPreListeners(oauthAuthzMsgCtx);
        AccessTokenDO accessTokenDO = ResponseTypeHandlerUtil.generateAccessToken(oauthAuthzMsgCtx, this.cacheEnabled);
        OAuth2AuthorizeRespDTO respDTO = this.buildResponseDTO(oauthAuthzMsgCtx, accessTokenDO);
        OAuth2TokenUtil.postIssueAccessToken(accessTokenDO.getTokenId(), oauthAuthzMsgCtx.getAuthorizationReqDTO().getSessionDataKey());
        ResponseTypeHandlerUtil.triggerPostListeners(oauthAuthzMsgCtx, accessTokenDO, respDTO);
        return respDTO;
    }

    private OAuth2AuthorizeRespDTO buildResponseDTO(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, AccessTokenDO accessTokenDO) throws IdentityOAuth2Exception {
        OAuth2AuthorizeRespDTO respDTO = this.initResponse(oauthAuthzMsgCtx);
        ResponseTypeHandlerUtil.buildIDTokenResponseDTO(respDTO, accessTokenDO, oauthAuthzMsgCtx);
        return ResponseTypeHandlerUtil.buildAccessTokenResponseDTO(respDTO, accessTokenDO);
    }
}

