/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.authz.handlers;

import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.authz.handlers.AbstractResponseTypeHandler;
import org.wso2.carbon.identity.oauth2.authz.handlers.util.ResponseTypeHandlerUtil;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2TokenUtil;

public class HybridResponseTypeHandler
extends AbstractResponseTypeHandler {
    @Override
    public OAuth2AuthorizeRespDTO issue(OAuthAuthzReqMessageContext oauthAuthzMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        String responseType = authorizationReqDTO.getResponseType();
        OAuth2AuthorizeRespDTO respDTO = this.initResponse(oauthAuthzMsgCtx);
        if (this.isAuthorizationCodeIssued(responseType)) {
            AuthzCodeDO authzCodeDO = ResponseTypeHandlerUtil.generateAuthorizationCode(oauthAuthzMsgCtx, this.cacheEnabled);
            String sessionDataKey = oauthAuthzMsgCtx.getAuthorizationReqDTO().getSessionDataKey();
            OAuth2TokenUtil.postIssueCode(authzCodeDO.getAuthzCodeId(), sessionDataKey);
            ResponseTypeHandlerUtil.buildAuthorizationCodeResponseDTO(respDTO, authzCodeDO);
        }
        if (this.isAccessTokenIssued(responseType) || this.isIDTokenIssued(responseType)) {
            AccessTokenDO accessTokenDO = ResponseTypeHandlerUtil.generateAccessToken(oauthAuthzMsgCtx, this.cacheEnabled);
            ResponseTypeHandlerUtil.triggerPostListeners(oauthAuthzMsgCtx, accessTokenDO, respDTO);
            if (this.isAccessTokenIssued(responseType)) {
                ResponseTypeHandlerUtil.buildAccessTokenResponseDTO(respDTO, accessTokenDO);
            }
            if (this.isIDTokenIssued(responseType)) {
                ResponseTypeHandlerUtil.buildIDTokenResponseDTO(respDTO, accessTokenDO, oauthAuthzMsgCtx);
            }
        }
        return respDTO;
    }

    private boolean isAuthorizationCodeIssued(String responseType) {
        return StringUtils.contains((String)responseType, (String)ResponseType.CODE.toString());
    }

    private boolean isAccessTokenIssued(String responseType) {
        return StringUtils.contains((String)responseType, (String)ResponseType.TOKEN.toString()) && !responseType.equalsIgnoreCase("code id_token");
    }

    private boolean isIDTokenIssued(String responseType) {
        return StringUtils.contains((String)responseType, (String)"id_token");
    }
}

