/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.authz.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.authz.handlers.AbstractResponseTypeHandler;
import org.wso2.carbon.identity.oauth2.authz.handlers.util.ResponseTypeHandlerUtil;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2TokenUtil;

public class CodeResponseTypeHandler
extends AbstractResponseTypeHandler {
    private static final Log log = LogFactory.getLog(CodeResponseTypeHandler.class);

    @Override
    public OAuth2AuthorizeRespDTO issue(OAuthAuthzReqMessageContext oauthAuthzMsgCtx) throws IdentityOAuth2Exception {
        AuthzCodeDO authorizationCode = ResponseTypeHandlerUtil.generateAuthorizationCode(oauthAuthzMsgCtx, this.cacheEnabled);
        String sessionDataKey = oauthAuthzMsgCtx.getAuthorizationReqDTO().getSessionDataKey();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Issued code: " + (Object)((Object)authorizationCode) + " for the session data key: " + sessionDataKey));
        }
        OAuth2TokenUtil.postIssueCode(authorizationCode.getAuthzCodeId(), sessionDataKey);
        return this.buildResponseDTO(oauthAuthzMsgCtx, authorizationCode);
    }

    private OAuth2AuthorizeRespDTO buildResponseDTO(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, AuthzCodeDO authzCodeDO) throws IdentityOAuth2Exception {
        OAuth2AuthorizeRespDTO respDTO = this.initResponse(oauthAuthzMsgCtx);
        return ResponseTypeHandlerUtil.buildAuthorizationCodeResponseDTO(respDTO, authzCodeDO);
    }
}

