/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.authz.handlers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.callback.OAuthCallback;
import org.wso2.carbon.identity.oauth.callback.OAuthCallbackManager;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.authz.handlers.ResponseTypeHandler;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuer;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.util.Oauth2ScopeUtils;
import org.wso2.carbon.identity.oauth2.validators.scope.ScopeValidator;

public abstract class AbstractResponseTypeHandler
implements ResponseTypeHandler {
    private static final Log log = LogFactory.getLog(AbstractResponseTypeHandler.class);
    public static final String IMPLICIT = "implicit";
    protected OauthTokenIssuer oauthIssuerImpl;
    protected boolean cacheEnabled;
    protected OAuthCache oauthCache;
    private OAuthCallbackManager callbackManager;

    @Override
    public void init() throws IdentityOAuth2Exception {
        this.callbackManager = new OAuthCallbackManager();
        this.oauthIssuerImpl = OAuthServerConfiguration.getInstance().getIdentityOauthTokenIssuer();
        this.cacheEnabled = OAuthCache.getInstance().isEnabled();
        if (this.cacheEnabled) {
            this.oauthCache = OAuthCache.getInstance();
        }
    }

    @Override
    public boolean validateAccessDelegation(OAuthAuthzReqMessageContext oauthAuthzMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        OAuthCallback authzCallback = new OAuthCallback(authorizationReqDTO.getUser(), authorizationReqDTO.getConsumerKey(), OAuthCallback.OAuthCallbackType.ACCESS_DELEGATION_AUTHZ);
        authzCallback.setRequestedScope(authorizationReqDTO.getScopes());
        authzCallback.setResponseType(authorizationReqDTO.getResponseType());
        this.callbackManager.handleCallback(authzCallback);
        oauthAuthzMsgCtx.setValidityPeriod(authzCallback.getValidityPeriod());
        oauthAuthzMsgCtx.setAuthorizationCodeValidityPeriod(authzCallback.getAuthorizationCodeValidityPeriod());
        oauthAuthzMsgCtx.setAccessTokenIssuedTime(authzCallback.getAccessTokenValidityPeriod());
        return authzCallback.isAuthorized();
    }

    @Override
    public boolean validateScope(OAuthAuthzReqMessageContext oauthAuthzMsgCtx) throws IdentityOAuth2Exception {
        if (OAuthServerConfiguration.getInstance().isScopeValidationEnabledForCodeAndImplicitGrant() && this.hasValidationByApplicationScopeValidatorsFailed(oauthAuthzMsgCtx)) {
            return false;
        }
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        OAuthCallback scopeValidationCallback = new OAuthCallback(authorizationReqDTO.getUser(), authorizationReqDTO.getConsumerKey(), OAuthCallback.OAuthCallbackType.SCOPE_VALIDATION_AUTHZ);
        scopeValidationCallback.setRequestedScope(authorizationReqDTO.getScopes());
        scopeValidationCallback.setResponseType(authorizationReqDTO.getResponseType());
        this.callbackManager.handleCallback(scopeValidationCallback);
        oauthAuthzMsgCtx.setValidityPeriod(scopeValidationCallback.getValidityPeriod());
        oauthAuthzMsgCtx.setAuthorizationCodeValidityPeriod(scopeValidationCallback.getAuthorizationCodeValidityPeriod());
        oauthAuthzMsgCtx.setAccessTokenIssuedTime(scopeValidationCallback.getAccessTokenValidityPeriod());
        oauthAuthzMsgCtx.setApprovedScope(scopeValidationCallback.getApprovedScope());
        List<ScopeValidator> globalScopeValidators = OAuthComponentServiceHolder.getInstance().getScopeValidators();
        for (ScopeValidator validator : globalScopeValidators) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Engaging global scope validator in token issuer flow : " + validator.getName()));
            }
            boolean isGlobalValidScope = validator.validateScope(oauthAuthzMsgCtx);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Scope Validation was" + isGlobalValidScope + "at the global level by : " + validator.getName()));
        }
        return scopeValidationCallback.isValidScope();
    }

    @Override
    public boolean isAuthorizedClient(OAuthAuthzReqMessageContext authzReqMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AuthorizeReqDTO authzReqDTO = authzReqMsgCtx.getAuthorizationReqDTO();
        String consumerKey = authzReqDTO.getConsumerKey();
        OAuthAppDO oAuthAppDO = (OAuthAppDO)authzReqMsgCtx.getProperty("OAuthAppDO");
        if (StringUtils.isBlank((String)oAuthAppDO.getGrantTypes())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find authorized grant types for client id: " + consumerKey));
            }
            return false;
        }
        ArrayList<String> grantTypes = new ArrayList<String>();
        String responseType = authzReqDTO.getResponseType();
        if (StringUtils.contains((String)responseType, (String)ResponseType.CODE.toString())) {
            grantTypes.add(GrantType.AUTHORIZATION_CODE.toString());
        }
        if (OAuth2Util.isImplicitResponseType(responseType)) {
            grantTypes.add(IMPLICIT.toString());
        }
        for (String grantType : grantTypes) {
            if (oAuthAppDO.getGrantTypes().contains(grantType)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported Grant Type : " + grantType + " for client id : " + consumerKey));
            }
            return false;
        }
        return true;
    }

    public OAuth2AuthorizeRespDTO initResponse(OAuthAuthzReqMessageContext oauthAuthzMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AuthorizeRespDTO respDTO = new OAuth2AuthorizeRespDTO();
        OAuth2AuthorizeReqDTO authorizationReqDTO = oauthAuthzMsgCtx.getAuthorizationReqDTO();
        respDTO.setCallbackURI(authorizationReqDTO.getCallbackUrl());
        respDTO.setScope(oauthAuthzMsgCtx.getApprovedScope());
        return respDTO;
    }

    private boolean hasValidationByApplicationScopeValidatorsFailed(OAuthAuthzReqMessageContext authzReqMessageContext) throws IdentityOAuth2Exception {
        return !Oauth2ScopeUtils.validateByApplicationScopeValidator(null, authzReqMessageContext);
    }
}

