/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.authz;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.cache.AppInfoCache;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.dto.OAuthErrorDTO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.authz.handlers.ResponseTypeHandler;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.model.OAuth2Parameters;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.JDBCPermissionBasedInternalScopeValidator;
import org.wso2.carbon.utils.CarbonUtils;

public class AuthorizationHandlerManager {
    public static final String OAUTH_APP_PROPERTY = "OAuthAppDO";
    private static final Log log = LogFactory.getLog(AuthorizationHandlerManager.class);
    private static AuthorizationHandlerManager instance;
    private Map<String, ResponseTypeHandler> responseHandlers = OAuthServerConfiguration.getInstance().getSupportedResponseTypes();

    private AuthorizationHandlerManager() throws IdentityOAuth2Exception {
        if (AppInfoCache.getInstance() != null) {
            if (log.isDebugEnabled() && AppInfoCache.getInstance().isEnabled()) {
                log.debug((Object)"Successfully enabled AppInfoCache under OAuthCacheManager");
            }
        } else {
            log.error((Object)"Error while creating AppInfoCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthorizationHandlerManager getInstance() throws IdentityOAuth2Exception {
        CarbonUtils.checkSecurity();
        if (instance != null) return instance;
        Class<AuthorizationHandlerManager> clazz = AuthorizationHandlerManager.class;
        synchronized (AuthorizationHandlerManager.class) {
            if (instance != null) return instance;
            instance = new AuthorizationHandlerManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2AuthorizeRespDTO handleAuthorization(OAuth2AuthorizeReqDTO authzReqDTO) throws IdentityOAuth2Exception, IdentityOAuthAdminException, InvalidOAuthClientException {
        ResponseTypeHandler authzHandler;
        OAuthAuthzReqMessageContext authzReqMsgCtx = this.getOAuthAuthzReqMessageContext(authzReqDTO);
        OAuth2AuthorizeRespDTO authorizeRespDTO = this.validateAuthzRequest(authzReqDTO, authzReqMsgCtx, authzHandler = this.getResponseHandler(authzReqDTO));
        if (this.isErrorResponseFound(authorizeRespDTO)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error response received for authorization request by user : " + authzReqDTO.getUser() + ", client : " + authzReqDTO.getConsumerKey() + ", scope : " + OAuth2Util.buildScopeString(authzReqDTO.getScopes())));
            }
            return authorizeRespDTO;
        }
        try {
            OAuth2Util.setAuthzRequestContext(authzReqMsgCtx);
            authorizeRespDTO = authzHandler.issue(authzReqMsgCtx);
        }
        finally {
            OAuth2Util.clearAuthzRequestContext();
        }
        return authorizeRespDTO;
    }

    private ResponseTypeHandler getResponseHandler(OAuth2AuthorizeReqDTO authzReqDTO) {
        return this.responseHandlers.get(authzReqDTO.getResponseType());
    }

    private OAuth2AuthorizeRespDTO validateAuthzRequest(OAuth2AuthorizeReqDTO authzReqDTO, OAuthAuthzReqMessageContext authzReqMsgCtx, ResponseTypeHandler authzHandler) throws IdentityOAuth2Exception {
        OAuth2AuthorizeRespDTO authorizeRespDTO = new OAuth2AuthorizeRespDTO();
        if (this.isInvalidResponseType(authzReqDTO, authorizeRespDTO)) {
            return authorizeRespDTO;
        }
        if (this.isInvalidClient(authzReqDTO, authorizeRespDTO, authzReqMsgCtx, authzHandler)) {
            return authorizeRespDTO;
        }
        if (this.isInvalidAccessDelegation(authzReqDTO, authorizeRespDTO, authzReqMsgCtx, authzHandler)) {
            return authorizeRespDTO;
        }
        List<String> allowedScopes = OAuthServerConfiguration.getInstance().getAllowedScopes();
        ArrayList<String> requestedAllowedScopes = new ArrayList<String>();
        String[] requestedScopes = authzReqMsgCtx.getAuthorizationReqDTO().getScopes();
        ArrayList<String> scopesToBeValidated = new ArrayList<String>();
        if (requestedScopes != null) {
            for (String scope : requestedScopes) {
                if (OAuth2Util.isAllowedScope(allowedScopes, scope)) {
                    requestedAllowedScopes.add(scope);
                    continue;
                }
                scopesToBeValidated.add(scope);
            }
            authzReqMsgCtx.getAuthorizationReqDTO().setScopes(scopesToBeValidated.toArray(new String[0]));
        }
        JDBCPermissionBasedInternalScopeValidator scopeValidator = new JDBCPermissionBasedInternalScopeValidator();
        String[] authorizedInternalScopes = scopeValidator.validateScope(authzReqMsgCtx);
        this.removeInternalScopes(authzReqMsgCtx);
        boolean valid = this.validateScope(authzReqDTO, authorizeRespDTO, authzReqMsgCtx, authzHandler);
        if (valid) {
            this.addAuthorizedInternalScopes(authzReqMsgCtx, authorizedInternalScopes);
            this.addAllowedScopes(authzReqMsgCtx, requestedAllowedScopes.toArray(new String[0]));
        }
        return authorizeRespDTO;
    }

    private void addAuthorizedInternalScopes(OAuthAuthzReqMessageContext authzReqMsgCtx, String[] authorizedInternalScopes) {
        Object[] scopes = authzReqMsgCtx.getApprovedScope();
        String[] scopesToReturn = (String[])ArrayUtils.addAll((Object[])scopes, (Object[])authorizedInternalScopes);
        authzReqMsgCtx.setApprovedScope(scopesToReturn);
    }

    private void addAllowedScopes(OAuthAuthzReqMessageContext authzReqMsgCtx, String[] allowedScopes) {
        Object[] scopes = authzReqMsgCtx.getApprovedScope();
        String[] scopesToReturn = (String[])ArrayUtils.addAll((Object[])scopes, (Object[])allowedScopes);
        authzReqMsgCtx.setApprovedScope(scopesToReturn);
    }

    private void removeInternalScopes(OAuthAuthzReqMessageContext authzReqMsgCtx) {
        if (authzReqMsgCtx.getAuthorizationReqDTO().getScopes() == null) {
            return;
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (String scope : authzReqMsgCtx.getAuthorizationReqDTO().getScopes()) {
            if (scope.startsWith("internal_") || scope.equalsIgnoreCase("SYSTEM")) continue;
            scopes.add(scope);
        }
        authzReqMsgCtx.getAuthorizationReqDTO().setScopes(scopes.toArray(new String[0]));
    }

    private boolean validateScope(OAuth2AuthorizeReqDTO authzReqDTO, OAuth2AuthorizeRespDTO authorizeRespDTO, OAuthAuthzReqMessageContext authzReqMsgCtx, ResponseTypeHandler authzHandler) throws IdentityOAuth2Exception {
        boolean scopeValidationStatus = authzHandler.validateScope(authzReqMsgCtx);
        if (!scopeValidationStatus) {
            this.handleErrorRequest(authorizeRespDTO, "invalid_scope", "Invalid Scope!");
            authorizeRespDTO.setCallbackURI(authzReqDTO.getCallbackUrl());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope validation failed for user : " + authzReqDTO.getUser() + ", for the scope(s) : " + OAuth2Util.buildScopeString(authzReqDTO.getScopes())));
            }
            return false;
        }
        if (this.approvedScopeNotSetByTheCallbackHandler(authzReqMsgCtx)) {
            authzReqMsgCtx.setApprovedScope(authzReqMsgCtx.getAuthorizationReqDTO().getScopes());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Approved scope(s) : " + OAuth2Util.buildScopeString(authzReqMsgCtx.getApprovedScope())));
        }
        return true;
    }

    private boolean approvedScopeNotSetByTheCallbackHandler(OAuthAuthzReqMessageContext authzReqMsgCtx) {
        return authzReqMsgCtx.getApprovedScope() == null || authzReqMsgCtx.getApprovedScope().length == 0;
    }

    private boolean isInvalidAccessDelegation(OAuth2AuthorizeReqDTO authzReqDTO, OAuth2AuthorizeRespDTO authorizeRespDTO, OAuthAuthzReqMessageContext authzReqMsgCtx, ResponseTypeHandler authzHandler) throws IdentityOAuth2Exception {
        boolean accessDelegationAuthzStatus = authzHandler.validateAccessDelegation(authzReqMsgCtx);
        if (!accessDelegationAuthzStatus) {
            this.handleErrorRequest(authorizeRespDTO, "unauthorized_client", "Authorization Failure!");
            authorizeRespDTO.setCallbackURI(authzReqDTO.getCallbackUrl());
            if (log.isDebugEnabled()) {
                log.debug((Object)("User : " + authzReqDTO.getUser() + " doesn't have necessary rights to grant access to the resource(s) : " + OAuth2Util.buildScopeString(authzReqDTO.getScopes())));
            }
            return true;
        }
        return false;
    }

    private boolean isInvalidClient(OAuth2AuthorizeReqDTO authzReqDTO, OAuth2AuthorizeRespDTO authorizeRespDTO, OAuthAuthzReqMessageContext authzReqMsgCtx, ResponseTypeHandler authzHandler) throws IdentityOAuth2Exception {
        boolean isAuthorizedClient = authzHandler.isAuthorizedClient(authzReqMsgCtx);
        if (!isAuthorizedClient) {
            this.handleErrorRequest(authorizeRespDTO, "unauthorized_client", "The authenticated client is not authorized to use this authorization grant type");
            authorizeRespDTO.setCallbackURI(authzReqDTO.getCallbackUrl());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Client validation failed for user : " + authzReqDTO.getUser() + ", for client : " + authzReqDTO.getConsumerKey()));
            }
            return true;
        }
        return false;
    }

    private OAuthAuthzReqMessageContext getOAuthAuthzReqMessageContext(OAuth2AuthorizeReqDTO authzReqDTO) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        OAuthAuthzReqMessageContext authorizeRequestMessageContext = new OAuthAuthzReqMessageContext(authzReqDTO);
        OAuthAppDO oAuthAppDO = this.getAppInformation(authzReqDTO);
        authorizeRequestMessageContext.addProperty(OAUTH_APP_PROPERTY, oAuthAppDO);
        authorizeRequestMessageContext.getAuthorizationReqDTO().setTenantDomain(OAuth2Util.getTenantDomainOfOauthApp(oAuthAppDO));
        return authorizeRequestMessageContext;
    }

    private boolean isErrorResponseFound(OAuth2AuthorizeRespDTO authorizeRespDTO) {
        return authorizeRespDTO.getErrorMsg() != null;
    }

    private boolean isInvalidResponseType(OAuth2AuthorizeReqDTO authzReqDTO, OAuth2AuthorizeRespDTO authorizeRespDTO) {
        if (!this.responseHandlers.containsKey(authzReqDTO.getResponseType())) {
            this.handleErrorRequest(authorizeRespDTO, "unsupported_response_type", "Unsupported Response Type!");
            authorizeRespDTO.setCallbackURI(authzReqDTO.getCallbackUrl());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported Response Type : " + authzReqDTO.getResponseType() + " provided for user : " + authzReqDTO.getUser() + ", for client :" + authzReqDTO.getConsumerKey()));
            }
            return true;
        }
        return false;
    }

    private OAuthAppDO getAppInformation(OAuth2AuthorizeReqDTO authzReqDTO) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        OAuthAppDO oAuthAppDO = (OAuthAppDO)AppInfoCache.getInstance().getValueFromCache((Serializable)((Object)authzReqDTO.getConsumerKey()));
        if (oAuthAppDO != null) {
            return oAuthAppDO;
        }
        oAuthAppDO = new OAuthAppDAO().getAppInformation(authzReqDTO.getConsumerKey());
        AppInfoCache.getInstance().addToCache((Serializable)((Object)authzReqDTO.getConsumerKey()), oAuthAppDO);
        return oAuthAppDO;
    }

    private void handleErrorRequest(OAuth2AuthorizeRespDTO respDTO, String errorCode, String errorMsg) {
        respDTO.setErrorCode(errorCode);
        respDTO.setErrorMsg(errorMsg);
    }

    public OAuthErrorDTO handleUserConsentDenial(OAuth2Parameters oAuth2Parameters) {
        ResponseTypeHandler responseTypeHandler = this.responseHandlers.get(oAuth2Parameters.getResponseType());
        return responseTypeHandler.handleUserConsentDenial(oAuth2Parameters);
    }

    public OAuthErrorDTO handleAuthenticationFailure(OAuth2Parameters oAuth2Parameters) {
        ResponseTypeHandler responseTypeHandler = this.responseHandlers.get(oAuth2Parameters.getResponseType());
        return responseTypeHandler.handleAuthenticationFailure(oAuth2Parameters);
    }
}

