/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.authcontext;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth.util.ClaimCache;
import org.wso2.carbon.identity.oauth.util.ClaimCacheKey;
import org.wso2.carbon.identity.oauth.util.ClaimMetaDataCache;
import org.wso2.carbon.identity.oauth.util.ClaimMetaDataCacheEntry;
import org.wso2.carbon.identity.oauth.util.ClaimMetaDataCacheKey;
import org.wso2.carbon.identity.oauth.util.UserClaims;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authcontext.AuthorizationContextTokenGenerator;
import org.wso2.carbon.identity.oauth2.authcontext.ClaimsRetriever;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidationMessageContext;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class JWTTokenGenerator
implements AuthorizationContextTokenGenerator {
    private static final Log log = LogFactory.getLog(JWTTokenGenerator.class);
    private static final String API_GATEWAY_ID = "http://wso2.org/gateway";
    private static final String NONE = "NONE";
    private static volatile long ttl = -1L;
    private ClaimsRetriever claimsRetriever;
    private JWSAlgorithm signatureAlgorithm = new JWSAlgorithm(JWSAlgorithm.RS256.getName());
    private boolean includeClaims = true;
    private boolean enableSigning = true;
    private static Map<Integer, Key> privateKeys = new ConcurrentHashMap<Integer, Key>();
    private static Map<Integer, Certificate> publicCerts = new ConcurrentHashMap<Integer, Certificate>();
    private ClaimCache claimsLocalCache;
    private String userAttributeSeparator = ",,,";
    private boolean useMultiValueSeparator = true;

    public JWTTokenGenerator() {
        this.claimsLocalCache = ClaimCache.getInstance();
    }

    public JWTTokenGenerator(boolean includeClaims, boolean enableSigning) {
        this.includeClaims = includeClaims;
        this.enableSigning = enableSigning;
        this.signatureAlgorithm = new JWSAlgorithm(JWSAlgorithm.NONE.getName());
    }

    @Override
    public void init() throws IdentityOAuth2Exception {
        if (this.includeClaims && this.enableSigning) {
            String claimsRetrieverImplClass = OAuthServerConfiguration.getInstance().getClaimsRetrieverImplClass();
            String sigAlg = OAuthServerConfiguration.getInstance().getSignatureAlgorithm();
            if (sigAlg != null && !sigAlg.trim().isEmpty()) {
                this.signatureAlgorithm = OAuth2Util.mapSignatureAlgorithmForJWSAlgorithm(sigAlg);
            }
            this.useMultiValueSeparator = OAuthServerConfiguration.getInstance().isUseMultiValueSeparatorForAuthContextToken();
            if (claimsRetrieverImplClass != null) {
                try {
                    this.claimsRetriever = (ClaimsRetriever)Class.forName(claimsRetrieverImplClass).newInstance();
                    this.claimsRetriever.init();
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Cannot find class: " + claimsRetrieverImplClass), (Throwable)e);
                }
                catch (InstantiationException e) {
                    log.error((Object)("Error instantiating " + claimsRetrieverImplClass), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Illegal access to " + claimsRetrieverImplClass), (Throwable)e);
                }
                catch (IdentityOAuth2Exception e) {
                    log.error((Object)("Error while initializing " + claimsRetrieverImplClass), (Throwable)((Object)e));
                }
            }
        }
    }

    @Override
    public void generateToken(OAuth2TokenValidationMessageContext messageContext) throws IdentityOAuth2Exception {
        OAuthAppDO appDO;
        AccessTokenDO accessTokenDO = (AccessTokenDO)((Object)messageContext.getProperty("AccessTokenDO"));
        String clientId = accessTokenDO.getConsumerKey();
        long issuedTime = accessTokenDO.getIssuedTime().getTime();
        long validityPeriodInMillis = accessTokenDO.getValidityPeriodInMillis();
        String authzUser = messageContext.getResponseDTO().getAuthorizedUser();
        int tenantId = accessTokenDO.getTenantID();
        String tenantDomain = OAuth2Util.getTenantDomain(tenantId);
        boolean isExistingUser = false;
        String tenantAwareUsername = null;
        RealmService realmService = OAuthComponentServiceHolder.getInstance().getRealmService();
        tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)authzUser);
        if (realmService != null && tenantId != -1 && (!accessTokenDO.getAuthzUser().isFederatedUser() || OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal())) {
            try {
                UserRealm userRealm = realmService.getTenantUserRealm(tenantId);
                if (userRealm != null) {
                    UserStoreManager userStoreManager = (UserStoreManager)userRealm.getUserStoreManager();
                    isExistingUser = userStoreManager.isExistingUser(tenantAwareUsername);
                }
            }
            catch (UserStoreException e) {
                log.error((Object)"Error occurred while loading the realm service", (Throwable)e);
            }
        }
        OAuthAppDAO appDAO = new OAuthAppDAO();
        try {
            appDO = appDAO.getAppInformation(clientId);
            messageContext.addProperty("OAuthAppDO", appDO);
        }
        catch (IdentityOAuth2Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)((Object)e));
            throw new IdentityOAuth2Exception(e.getMessage());
        }
        catch (InvalidOAuthClientException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new IdentityOAuth2Exception(e.getMessage());
        }
        String subscriber = appDO.getUser().toString();
        String applicationName = appDO.getApplicationName();
        long currentTime = Calendar.getInstance().getTimeInMillis();
        long expireIn = validityPeriodInMillis + issuedTime;
        JWTClaimsSet.Builder claimsSetBuilder = new JWTClaimsSet.Builder();
        claimsSetBuilder.issuer(API_GATEWAY_ID);
        claimsSetBuilder.subject(authzUser);
        claimsSetBuilder.issueTime(new Date(currentTime));
        claimsSetBuilder.expirationTime(new Date(expireIn));
        claimsSetBuilder.notBeforeTime(new Date(currentTime));
        claimsSetBuilder.claim("http://wso2.org/gateway/subscriber", (Object)subscriber);
        claimsSetBuilder.claim("http://wso2.org/gateway/applicationname", (Object)applicationName);
        claimsSetBuilder.claim("http://wso2.org/gateway/enduser", (Object)authzUser);
        if (this.claimsRetriever != null) {
            String claimSeparator;
            String[] requestedClaims = messageContext.getRequestDTO().getRequiredClaimURIs();
            if (requestedClaims == null && isExistingUser) {
                requestedClaims = this.claimsRetriever.getDefaultClaims(authzUser);
            }
            ClaimCacheKey cacheKey = null;
            UserClaims result = null;
            AuthenticatedUser authenticatedUser = new AuthenticatedUser();
            authenticatedUser.setUserName(UserCoreUtil.removeDomainFromName((String)tenantAwareUsername));
            authenticatedUser.setUserStoreDomain(IdentityUtil.extractDomainFromName((String)tenantAwareUsername));
            authenticatedUser.setTenantDomain(tenantDomain);
            if (requestedClaims != null) {
                cacheKey = new ClaimCacheKey(authenticatedUser);
                result = (UserClaims)((Object)this.claimsLocalCache.getValueFromCache(cacheKey));
            }
            SortedMap<String, String> claimValues = null;
            if (result != null) {
                claimValues = result.getClaimValues();
            } else if (isExistingUser) {
                claimValues = this.claimsRetriever.getClaims(authzUser, requestedClaims);
                UserClaims userClaims = new UserClaims(claimValues);
                this.claimsLocalCache.addToCache(cacheKey, (Serializable)((Object)userClaims));
                ClaimMetaDataCache.getInstance().addToCache(new ClaimMetaDataCacheKey(authenticatedUser), (Serializable)((Object)new ClaimMetaDataCacheEntry(cacheKey)));
            }
            if (isExistingUser && StringUtils.isNotBlank((String)(claimSeparator = this.getMultiAttributeSeparator(authzUser, tenantId)))) {
                this.userAttributeSeparator = claimSeparator;
            }
            if (claimValues != null) {
                for (String claimURI : new TreeSet<String>(claimValues.keySet())) {
                    String claimVal = (String)claimValues.get(claimURI);
                    ArrayList<String> claimList = new ArrayList<String>();
                    if (this.useMultiValueSeparator && this.userAttributeSeparator != null && claimVal.contains(this.userAttributeSeparator)) {
                        StringTokenizer st = new StringTokenizer(claimVal, this.userAttributeSeparator);
                        while (st.hasMoreElements()) {
                            String attValue = st.nextElement().toString();
                            if (!StringUtils.isNotBlank((String)attValue)) continue;
                            claimList.add(attValue);
                        }
                        claimsSetBuilder.claim(claimURI, (Object)claimList.toArray(new String[claimList.size()]));
                        continue;
                    }
                    claimsSetBuilder.claim(claimURI, (Object)claimVal);
                }
            }
        }
        JWTClaimsSet claimsSet = claimsSetBuilder.build();
        Object jwt = null;
        jwt = !JWSAlgorithm.NONE.equals((Object)this.signatureAlgorithm) ? OAuth2Util.signJWT(claimsSet, this.signatureAlgorithm, tenantDomain) : new PlainJWT(claimsSet);
        if (log.isDebugEnabled()) {
            log.debug((Object)("JWT Assertion Value : " + jwt.serialize()));
        }
        OAuth2TokenValidationResponseDTO oAuth2TokenValidationResponseDTO = messageContext.getResponseDTO();
        oAuth2TokenValidationResponseDTO.getClass();
        OAuth2TokenValidationResponseDTO.AuthorizationContextToken token = new OAuth2TokenValidationResponseDTO.AuthorizationContextToken(oAuth2TokenValidationResponseDTO, "JWT", jwt.serialize());
        messageContext.getResponseDTO().setAuthorizationContextToken(token);
    }

    @Deprecated
    protected SignedJWT signJWTWithRSA(SignedJWT signedJWT, JWSAlgorithm jwsAlgorithm, String tenantDomain, int tenantId) throws IdentityOAuth2Exception {
        try {
            Key privateKey = this.getPrivateKey(tenantDomain, tenantId);
            JWSSigner signer = OAuth2Util.createJWSSigner((RSAPrivateKey)privateKey);
            signedJWT.sign(signer);
            return signedJWT;
        }
        catch (JOSEException e) {
            log.error((Object)"Error in obtaining tenant's keystore", (Throwable)e);
            throw new IdentityOAuth2Exception("Error in obtaining tenant's keystore", e);
        }
        catch (Exception e) {
            log.error((Object)"Error in obtaining tenant's keystore", (Throwable)e);
            throw new IdentityOAuth2Exception("Error in obtaining tenant's keystore", e);
        }
    }

    @Deprecated
    protected JWT signJWT(SignedJWT signedJWT, String tenantDomain, int tenantId) throws IdentityOAuth2Exception {
        if (JWSAlgorithm.RS256.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.RS384.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.RS512.equals((Object)this.signatureAlgorithm)) {
            return this.signJWTWithRSA(signedJWT, this.signatureAlgorithm, tenantDomain, tenantId);
        }
        if (JWSAlgorithm.HS256.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.HS384.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.HS512.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.ES256.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.ES384.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.ES512.equals((Object)this.signatureAlgorithm)) {
            // empty if block
        }
        log.error((Object)"UnSupported Signature Algorithm");
        throw new IdentityOAuth2Exception("UnSupported Signature Algorithm");
    }

    @Deprecated
    protected JWSAlgorithm mapSignatureAlgorithm(String signatureAlgorithm) throws IdentityOAuth2Exception {
        return OAuth2Util.mapSignatureAlgorithmForJWSAlgorithm(signatureAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTTL() {
        if (ttl != -1L) {
            return ttl;
        }
        Class<JWTTokenGenerator> clazz = JWTTokenGenerator.class;
        synchronized (JWTTokenGenerator.class) {
            if (ttl != -1L) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ttl;
            }
            String ttlValue = OAuthServerConfiguration.getInstance().getAuthorizationContextTTL();
            ttl = ttlValue != null ? Long.parseLong(ttlValue) : 15L;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ttl;
        }
    }

    private String getThumbPrint(String tenantDomain, int tenantId) throws IdentityOAuth2Exception {
        try {
            Certificate certificate = this.getCertificate(tenantDomain, tenantId);
            MessageDigest digestValue = MessageDigest.getInstance("SHA-1");
            byte[] der = certificate.getEncoded();
            digestValue.update(der);
            byte[] digestInBytes = digestValue.digest();
            String publicCertThumbprint = this.hexify(digestInBytes);
            String base64EncodedThumbPrint = new String(new Base64(0, null, true).encode(publicCertThumbprint.getBytes(Charsets.UTF_8)), Charsets.UTF_8);
            return base64EncodedThumbPrint;
        }
        catch (Exception e) {
            String error = "Error in obtaining certificate for tenant " + tenantDomain;
            throw new IdentityOAuth2Exception(error, e);
        }
    }

    private Key getPrivateKey(String tenantDomain, int tenantId) throws IdentityOAuth2Exception {
        if (tenantDomain == null) {
            tenantDomain = "carbon.super";
        }
        if (tenantId == 0) {
            tenantId = OAuth2Util.getTenantId(tenantDomain);
        }
        Key privateKey = null;
        if (!privateKeys.containsKey(tenantId)) {
            try {
                IdentityTenantUtil.initializeRegistry((int)tenantId, (String)tenantDomain);
            }
            catch (IdentityException e) {
                throw new IdentityOAuth2Exception("Error occurred while loading registry for tenant " + tenantDomain, e);
            }
            KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
            if (!tenantDomain.equals("carbon.super")) {
                String ksName = tenantDomain.trim().replace(".", "-");
                String jksName = ksName + ".jks";
                privateKey = tenantKSM.getPrivateKey(jksName, tenantDomain);
            } else {
                try {
                    privateKey = tenantKSM.getDefaultPrivateKey();
                }
                catch (Exception e) {
                    log.error((Object)"Error while obtaining private key for super tenant", (Throwable)e);
                }
            }
            if (privateKey != null) {
                privateKeys.put(tenantId, privateKey);
            }
        } else {
            privateKey = privateKeys.get(tenantId);
        }
        return privateKey;
    }

    private Certificate getCertificate(String tenantDomain, int tenantId) throws Exception {
        if (tenantDomain == null) {
            tenantDomain = "carbon.super";
        }
        if (tenantId == 0) {
            tenantId = OAuth2Util.getTenantId(tenantDomain);
        }
        Certificate publicCert = null;
        if (!publicCerts.containsKey(tenantId)) {
            try {
                IdentityTenantUtil.initializeRegistry((int)tenantId, (String)tenantDomain);
            }
            catch (IdentityException e) {
                throw new IdentityOAuth2Exception("Error occurred while loading registry for tenant " + tenantDomain, e);
            }
            KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
            KeyStore keyStore = null;
            if (!tenantDomain.equals("carbon.super")) {
                String ksName = tenantDomain.trim().replace(".", "-");
                String jksName = ksName + ".jks";
                keyStore = tenantKSM.getKeyStore(jksName);
                publicCert = keyStore.getCertificate(tenantDomain);
            } else {
                publicCert = tenantKSM.getDefaultPrimaryCertificate();
            }
            if (publicCert != null) {
                publicCerts.put(tenantId, publicCert);
            }
        } else {
            publicCert = publicCerts.get(tenantId);
        }
        return publicCert;
    }

    private String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }

    private String getMultiAttributeSeparator(String authenticatedUser, int tenantId) {
        String claimSeparator = null;
        String userDomain = IdentityUtil.extractDomainFromName((String)authenticatedUser);
        try {
            RealmConfiguration realmConfiguration = null;
            RealmService realmService = OAuthComponentServiceHolder.getInstance().getRealmService();
            if (realmService != null && tenantId != -1) {
                UserStoreManager userStoreManager = (UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
                realmConfiguration = userStoreManager.getSecondaryUserStoreManager(userDomain).getRealmConfiguration();
            }
            if (realmConfiguration != null && (claimSeparator = realmConfiguration.getUserStoreProperty("MultiAttributeSeparator")) != null && !claimSeparator.trim().isEmpty()) {
                return claimSeparator;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error occurred while getting the realm configuration, User store properties might not be returned", (Throwable)e);
        }
        return null;
    }

    private SignedJWT getSignedJWT(String tokenIdentifier) throws ParseException {
        return SignedJWT.parse((String)tokenIdentifier);
    }
}

