/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.authcontext;

import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authcontext.ClaimsRetriever;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.user.api.ClaimManager;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DefaultClaimsRetriever
implements ClaimsRetriever {
    public static final String DEFAULT_DIALECT_URI = "http://wso2.org/claims";
    private String dialectURI;
    private Log log = LogFactory.getLog(DefaultClaimsRetriever.class);

    @Override
    public void init() {
        this.dialectURI = OAuthServerConfiguration.getInstance().getConsumerDialectURI();
        if (this.dialectURI == null) {
            this.dialectURI = DEFAULT_DIALECT_URI;
        }
    }

    @Override
    public SortedMap<String, String> getClaims(String endUserName, String[] requestedClaims) throws IdentityOAuth2Exception {
        TreeMap<String, String> claimValues;
        int tenantId = -1234;
        try {
            tenantId = OAuth2Util.getTenantIdFromUserName(endUserName);
            String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)endUserName);
            UserStoreManager userStoreManager = OAuthComponentServiceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            claimValues = new TreeMap<String, String>(userStoreManager.getUserClaimValues(tenantAwareUsername, requestedClaims, null));
        }
        catch (UserStoreException e) {
            throw new IdentityOAuth2Exception("Error while reading claims for user : " + endUserName, e);
        }
        return claimValues;
    }

    @Override
    public String[] getDefaultClaims(String endUserName) throws IdentityOAuth2Exception {
        int tenantId = -1234;
        try {
            tenantId = OAuth2Util.getTenantIdFromUserName(endUserName);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No claims set requested. Returning all claims in the dialect");
            }
            ClaimManager claimManager = OAuthComponentServiceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getClaimManager();
            ClaimMapping[] claims = claimManager.getAllClaimMappings(this.dialectURI);
            return this.claimToString(claims);
        }
        catch (UserStoreException e) {
            throw new IdentityOAuth2Exception("Error while reading default claims for user : " + endUserName, e);
        }
    }

    private String[] claimToString(ClaimMapping[] claims) {
        String[] temp = new String[claims.length];
        for (int i = 0; i < claims.length; ++i) {
            temp[i] = claims[i].getClaim().getClaimUri();
        }
        return temp;
    }
}

