/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2;

public class Oauth2ScopeConstants {
    public static final int MAX_FILTER_COUNT = 30;
    public static final int INVALID_SCOPE_ID = -1;
    public static final String SCOPE_ID = "SCOPE_ID";
    public static final String DEFAULT_SCOPE_BINDING = "DEFAULT";
    public static final String PERMISSIONS_BINDING_TYPE = "PERMISSION";
    public static final String SYSTEM_SCOPE = "SYSTEM";
    public static final String SCOPE_TYPE_OAUTH2 = "OAUTH2";
    public static final String SCOPE_TYPE_OIDC = "OIDC";

    public static final class DataBaseType {
        public static final String ORACLE = "Oracle";
    }

    public static final class SQLPlaceholders {
        public static final String TENANT_ID = "tenant_id";
        public static final String LIMIT = "limit";
        public static final String OFFSET = "offset";
        public static final String SCOPE_TYPE = "scope_type";
    }

    public static enum ErrorMessages {
        ERROR_CODE_BAD_REQUEST_SCOPE_NAME_NOT_SPECIFIED("41001", "Scope Name is not specified."),
        ERROR_CODE_BAD_REQUEST_SCOPE_DISPLAY_NAME_NOT_SPECIFIED("41002", "Scope Display Name is not specified."),
        ERROR_CODE_NOT_FOUND_SCOPE("41003", "Scope %s is not found."),
        ERROR_CODE_CONFLICT_REQUEST_EXISTING_SCOPE("41004", "Scope with the name %s already exists in the system. Please use a different scope name."),
        ERROR_CODE_CONFLICT_REQUEST_EXISTING_SCOPE_OIDC("41004", "Scope with the name %s already exists as an OIDC scope in the system. Please use a different scope name."),
        ERROR_CODE_BAD_REQUEST_SCOPE_NOT_SPECIFIED("41005", "Scope is not specified."),
        ERROR_CODE_BAD_REQUEST_SCOPE_NAME_CONTAINS_WHITESPACES("41006", "Scope name: %s contains white spaces."),
        ERROR_CODE_BAD_REQUEST("41007", "Invalid request"),
        ERROR_CODE_NOT_AUTHORIZED_ADD_INTERNAL_SCOPE("41008", "User %s is not authorized to add internal scopes"),
        ERROR_CODE_NOT_AUTHORIZED_UPDATE_INTERNAL_SCOPE("41009", "User %s is not authorized to update internal scopes"),
        ERROR_CODE_NOT_AUTHORIZED_DELETE_INTERNAL_SCOPE("41010", "User %s is not authorized to delete internal scopes"),
        ERROR_CODE_BAD_REQUEST_SCOPE_NAME_NOT_SATIFIED_THE_REGEX("41011", "Invalid scope name. Scope name %s cannot contain special characters ?,#,/,( or )"),
        ERROR_CODE_FAILED_TO_REGISTER_SCOPE("51001", "Error occurred while registering scope %s."),
        ERROR_CODE_FAILED_TO_GET_ALL_SCOPES("51002", "Error occurred while retrieving all available scopes."),
        ERROR_CODE_FAILED_TO_GET_SCOPE_BY_NAME("51003", "Error occurred while retrieving scope %s."),
        ERROR_CODE_FAILED_TO_DELETE_SCOPE_BY_NAME("51004", "Error occurred while deleting scope %s."),
        ERROR_CODE_FAILED_TO_UPDATE_SCOPE_BY_NAME("51005", "Error occurred while updating scope %s."),
        ERROR_CODE_FAILED_TO_GET_ALL_SCOPES_PAGINATION("51006", "Error occurred while retrieving scopes with pagination."),
        ERROR_CODE_UNEXPECTED("51007", "Unexpected error"),
        ERROR_CODE_FAILED_TO_GET_REQUESTED_SCOPES("51008", "Error occurred while retrieving requested scopes.");

        private final String code;
        private final String message;

        private ErrorMessages(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.code + " - " + this.message;
        }
    }
}

