/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuth2ClientApplicationDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2IntrospectionResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.TokenValidationHandler;

public class OAuth2TokenValidationService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(OAuth2TokenValidationService.class);

    public OAuth2TokenValidationResponseDTO validate(OAuth2TokenValidationRequestDTO validationReqDTO) {
        TokenValidationHandler validationHandler = TokenValidationHandler.getInstance();
        try {
            this.triggerPreValidationListeners(validationReqDTO);
        }
        catch (IdentityOAuth2Exception e) {
            OAuth2TokenValidationResponseDTO errRespDTO = new OAuth2TokenValidationResponseDTO();
            errRespDTO.setValid(false);
            errRespDTO.setErrorMsg(e.getMessage());
            return errRespDTO;
        }
        OAuth2TokenValidationResponseDTO responseDTO = null;
        try {
            responseDTO = validationHandler.validate(validationReqDTO);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)"Error occurred while validating the OAuth2 access token", (Throwable)((Object)e));
            responseDTO = new OAuth2TokenValidationResponseDTO();
            responseDTO.setValid(false);
            responseDTO.setErrorMsg("Server error occurred while validating the OAuth2 access token");
        }
        this.triggerPostValidationListeners(validationReqDTO, responseDTO);
        return responseDTO;
    }

    public OAuth2ClientApplicationDTO findOAuthConsumerIfTokenIsValid(OAuth2TokenValidationRequestDTO validationReqDTO) {
        TokenValidationHandler validationHandler = TokenValidationHandler.getInstance();
        try {
            return validationHandler.findOAuthConsumerIfTokenIsValid(validationReqDTO);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)"Error occurred while validating the OAuth2 access token", (Throwable)((Object)e));
            OAuth2ClientApplicationDTO appDTO = new OAuth2ClientApplicationDTO();
            OAuth2TokenValidationResponseDTO errRespDTO = new OAuth2TokenValidationResponseDTO();
            errRespDTO.setValid(false);
            errRespDTO.setErrorMsg(e.getMessage());
            appDTO.setAccessTokenValidationResponse(errRespDTO);
            return appDTO;
        }
    }

    public OAuth2IntrospectionResponseDTO buildIntrospectionResponse(OAuth2TokenValidationRequestDTO validationReq) {
        TokenValidationHandler validationHandler = TokenValidationHandler.getInstance();
        OAuth2IntrospectionResponseDTO oAuth2IntrospectionResponseDTO = null;
        try {
            this.triggerPreValidationListeners(validationReq);
        }
        catch (IdentityOAuth2Exception e) {
            OAuth2IntrospectionResponseDTO errRespDTO = new OAuth2IntrospectionResponseDTO();
            errRespDTO.setActive(false);
            errRespDTO.setError(e.getMessage());
            OAuth2Util.triggerOnIntrospectionExceptionListeners(validationReq, errRespDTO);
            return errRespDTO;
        }
        try {
            oAuth2IntrospectionResponseDTO = validationHandler.buildIntrospectionResponse(validationReq);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)"Error occurred while building the introspection response", (Throwable)((Object)e));
            oAuth2IntrospectionResponseDTO = new OAuth2IntrospectionResponseDTO();
            oAuth2IntrospectionResponseDTO.setActive(false);
            oAuth2IntrospectionResponseDTO.setError("Server error occurred while building the introspection response");
        }
        this.triggerPostIntrospectionValidationListeners(validationReq, oAuth2IntrospectionResponseDTO, oAuth2IntrospectionResponseDTO.getProperties());
        oAuth2IntrospectionResponseDTO.getProperties().remove("OAuth2TokenValidationMessageContext");
        return oAuth2IntrospectionResponseDTO;
    }

    private void triggerPreValidationListeners(OAuth2TokenValidationRequestDTO requestDTO) throws IdentityOAuth2Exception {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            oAuthEventInterceptorProxy.onPreTokenValidation(requestDTO, paramMap);
        }
    }

    private void triggerPostValidationListeners(OAuth2TokenValidationRequestDTO requestDTO, OAuth2TokenValidationResponseDTO responseDTO) {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            try {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                oAuthEventInterceptorProxy.onPostTokenValidation(requestDTO, responseDTO, paramMap);
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)"Oauth post validation listener failed.", (Throwable)((Object)e));
            }
        }
    }

    private void triggerPostIntrospectionValidationListeners(OAuth2TokenValidationRequestDTO requestDTO, OAuth2IntrospectionResponseDTO responseDTO, Map<String, Object> paramMap) {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            try {
                if (paramMap == null) {
                    paramMap = new HashMap<String, Object>();
                }
                oAuthEventInterceptorProxy.onPostTokenValidation(requestDTO, responseDTO, paramMap);
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)"Oauth post validation listener failed.", (Throwable)((Object)e));
            }
        }
    }
}

