/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2;

import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.owasp.encoder.Encode;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.dto.OAuthErrorDTO;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.OAuth2TokenValidationService;
import org.wso2.carbon.identity.oauth2.ResponseHeader;
import org.wso2.carbon.identity.oauth2.authz.AuthorizationHandlerManager;
import org.wso2.carbon.identity.oauth2.bean.OAuthClientAuthnContext;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2ClientValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationResponseDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.OAuth2Parameters;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.token.AccessTokenIssuer;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuth2Service
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(OAuth2Service.class);
    private static final String APP_STATE_ACTIVE = "ACTIVE";

    public OAuth2AuthorizeRespDTO authorize(OAuth2AuthorizeReqDTO oAuth2AuthorizeReqDTO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authorization Request received for user : " + oAuth2AuthorizeReqDTO.getUser() + ", Client ID : " + oAuth2AuthorizeReqDTO.getConsumerKey() + ", Authorization Response Type : " + oAuth2AuthorizeReqDTO.getResponseType() + ", Requested callback URI : " + oAuth2AuthorizeReqDTO.getCallbackUrl() + ", Requested Scope : " + OAuth2Util.buildScopeString(oAuth2AuthorizeReqDTO.getScopes())));
        }
        try {
            AuthorizationHandlerManager authzHandlerManager = AuthorizationHandlerManager.getInstance();
            return authzHandlerManager.handleAuthorization(oAuth2AuthorizeReqDTO);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred when processing the authorization request. Returning an error back to client.", (Throwable)e);
            OAuth2AuthorizeRespDTO authorizeRespDTO = new OAuth2AuthorizeRespDTO();
            authorizeRespDTO.setErrorCode("server_error");
            authorizeRespDTO.setErrorMsg("Error occurred when processing the authorization request. Returning an error back to client.");
            authorizeRespDTO.setCallbackURI(oAuth2AuthorizeReqDTO.getCallbackUrl());
            return authorizeRespDTO;
        }
    }

    public OAuth2ClientValidationResponseDTO validateClientInfo(String clientId, String callbackURI) {
        OAuth2ClientValidationResponseDTO validationResponseDTO = new OAuth2ClientValidationResponseDTO();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validate Client information request for client_id : " + clientId + " and callback_uri " + callbackURI));
        }
        try {
            String appTenantDomain = OAuth2Util.getTenantDomainOfOauthApp(clientId);
            OAuth2Util.validateRequestTenantDomain(appTenantDomain);
            if (StringUtils.isBlank((String)clientId)) {
                throw new InvalidOAuthClientException("Invalid client_id. No OAuth application has been registered with the given client_id");
            }
            OAuthAppDO appDO = OAuth2Util.getAppInformationByClientId(clientId);
            String appState = appDO.getState();
            if (StringUtils.isEmpty((String)appState)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("A valid OAuth client could not be found for client_id: " + clientId));
                }
                throw new InvalidOAuthClientException("A valid OAuth client could not be found for client_id: " + Encode.forHtml((String)clientId));
            }
            if (!appState.equalsIgnoreCase(APP_STATE_ACTIVE)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("App is not in active state in client ID: " + clientId + ". App state is: " + appState));
                }
                throw new InvalidOAuthClientException("Oauth application is not in active state");
            }
            if (StringUtils.isEmpty((String)appDO.getGrantTypes()) || StringUtils.isEmpty((String)appDO.getCallbackUrl())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registered App found for the given Client Id : " + clientId + " ,App Name : " + appDO.getApplicationName() + ", does not support the requested grant type."));
                }
                validationResponseDTO.setValidClient(false);
                validationResponseDTO.setErrorCode("unauthorized_client");
                validationResponseDTO.setErrorMsg("The authenticated client is not authorized to use this authorization grant type");
                return validationResponseDTO;
            }
            OAuth2Util.setClientTenatId(IdentityTenantUtil.getTenantId((String)appDO.getUser().getTenantDomain()));
            if (callbackURI == null) {
                validationResponseDTO.setValidClient(true);
                validationResponseDTO.setCallbackURL(appDO.getCallbackUrl());
                validationResponseDTO.setApplicationName(appDO.getApplicationName());
                validationResponseDTO.setPkceMandatory(appDO.isPkceMandatory());
                validationResponseDTO.setPkceSupportPlain(appDO.isPkceSupportPlain());
                return validationResponseDTO;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registered App found for the given Client Id : " + clientId + " ,App Name : " + appDO.getApplicationName() + ", Callback URL : " + appDO.getCallbackUrl()));
            }
            if (this.validateCallbackURI(callbackURI, appDO)) {
                validationResponseDTO.setValidClient(true);
                validationResponseDTO.setApplicationName(appDO.getApplicationName());
                validationResponseDTO.setCallbackURL(callbackURI);
                validationResponseDTO.setPkceMandatory(appDO.isPkceMandatory());
                validationResponseDTO.setPkceSupportPlain(appDO.isPkceSupportPlain());
                return validationResponseDTO;
            }
            log.warn((Object)"Provided Callback URL does not match with the provided one.");
            validationResponseDTO.setValidClient(false);
            validationResponseDTO.setErrorCode("invalid_callback");
            validationResponseDTO.setErrorMsg("Registered callback does not match with the provided url.");
            return validationResponseDTO;
        }
        catch (InvalidOAuthClientException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while retrieving the Application Information", (Throwable)e);
            }
            validationResponseDTO.setValidClient(false);
            validationResponseDTO.setErrorCode("invalid_client");
            validationResponseDTO.setErrorMsg(e.getMessage());
            return validationResponseDTO;
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)"Error when reading the Application Information.", (Throwable)((Object)e));
            validationResponseDTO.setValidClient(false);
            validationResponseDTO.setErrorCode("server_error");
            validationResponseDTO.setErrorMsg("Error when processing the authorization request.");
            return validationResponseDTO;
        }
    }

    private boolean validateCallbackURI(String callbackURI, OAuthAppDO oauthApp) {
        String regexp = null;
        String registeredCallbackUrl = oauthApp.getCallbackUrl();
        if (registeredCallbackUrl.startsWith("regexp=")) {
            regexp = registeredCallbackUrl.substring("regexp=".length());
        }
        return regexp != null && callbackURI.matches(regexp) || registeredCallbackUrl.equals(callbackURI);
    }

    public OAuth2AccessTokenRespDTO issueAccessToken(OAuth2AccessTokenReqDTO tokenReqDTO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access Token request received for Client ID " + tokenReqDTO.getClientId() + ", User ID " + tokenReqDTO.getResourceOwnerUsername() + ", Scope : " + Arrays.toString(tokenReqDTO.getScope()) + " and Grant Type : " + tokenReqDTO.getGrantType()));
        }
        try {
            AccessTokenIssuer tokenIssuer = AccessTokenIssuer.getInstance();
            return tokenIssuer.issue(tokenReqDTO);
        }
        catch (InvalidOAuthClientException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error occurred while issuing access token for Client ID : " + tokenReqDTO.getClientId() + ", User ID: " + tokenReqDTO.getResourceOwnerUsername() + ", Scope : " + Arrays.toString(tokenReqDTO.getScope()) + " and Grant Type : " + tokenReqDTO.getGrantType()), (Throwable)e);
            }
            OAuth2AccessTokenRespDTO tokenRespDTO = new OAuth2AccessTokenRespDTO();
            tokenRespDTO.setError(true);
            tokenRespDTO.setErrorCode("invalid_client");
            tokenRespDTO.setErrorMsg("Invalid Client");
            return tokenRespDTO;
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while issuing the access token for Client ID : " + tokenReqDTO.getClientId() + ", User ID " + tokenReqDTO.getResourceOwnerUsername() + ", Scope : " + Arrays.toString(tokenReqDTO.getScope()) + " and Grant Type : " + tokenReqDTO.getGrantType()), (Throwable)e);
            OAuth2AccessTokenRespDTO tokenRespDTO = new OAuth2AccessTokenRespDTO();
            tokenRespDTO.setError(true);
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof SQLIntegrityConstraintViolationException) {
                tokenRespDTO.setErrorCode("sql_error");
            } else {
                tokenRespDTO.setErrorCode("server_error");
            }
            tokenRespDTO.setErrorMsg("Server Error");
            return tokenRespDTO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuthRevocationResponseDTO revokeTokenByOAuthClient(OAuthRevocationRequestDTO revokeRequestDTO) {
        OAuthRevocationResponseDTO revokeResponseDTO = new OAuthRevocationResponseDTO();
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        OAuthClientAuthnContext oAuthClientAuthnContext = revokeRequestDTO.getoAuthClientAuthnContext();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            try {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                oAuthEventInterceptorProxy.onPreTokenRevocationByClient(revokeRequestDTO, paramMap);
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)e);
                revokeResponseDTO.setError(true);
                revokeResponseDTO.setErrorCode("server_error");
                revokeResponseDTO.setErrorMsg("Error occurred while revoking authorization grant for applications");
                return revokeResponseDTO;
            }
        }
        RefreshTokenValidationDataDO refreshTokenDO = null;
        AccessTokenDO accessTokenDO = null;
        try {
            if (StringUtils.isNotEmpty((String)revokeRequestDTO.getConsumerKey()) && StringUtils.isNotEmpty((String)revokeRequestDTO.getToken())) {
                boolean refreshTokenFirst = false;
                if (this.isRefreshTokenType(revokeRequestDTO)) {
                    refreshTokenFirst = true;
                }
                if (refreshTokenFirst) {
                    refreshTokenDO = OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().validateRefreshToken(revokeRequestDTO.getConsumerKey(), revokeRequestDTO.getToken());
                    if (refreshTokenDO == null || StringUtils.isEmpty((String)refreshTokenDO.getRefreshTokenState()) || !APP_STATE_ACTIVE.equals(refreshTokenDO.getRefreshTokenState()) && !"EXPIRED".equals(refreshTokenDO.getRefreshTokenState())) {
                        accessTokenDO = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessToken(revokeRequestDTO.getToken(), true);
                        refreshTokenDO = null;
                    }
                } else {
                    accessTokenDO = OAuth2Util.findAccessToken(revokeRequestDTO.getToken(), true);
                    if (accessTokenDO == null && ((refreshTokenDO = OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().validateRefreshToken(revokeRequestDTO.getConsumerKey(), revokeRequestDTO.getToken())) == null || StringUtils.isEmpty((String)refreshTokenDO.getRefreshTokenState()) || !APP_STATE_ACTIVE.equals(refreshTokenDO.getRefreshTokenState()) && !"EXPIRED".equals(refreshTokenDO.getRefreshTokenState()))) {
                        this.invokePostRevocationListeners(revokeRequestDTO, revokeResponseDTO, accessTokenDO, refreshTokenDO);
                        return revokeResponseDTO;
                    }
                }
                String grantType = "";
                if (accessTokenDO != null) {
                    grantType = accessTokenDO.getGrantType();
                } else if (refreshTokenDO != null) {
                    grantType = refreshTokenDO.getGrantType();
                }
                if (!this.isClientAuthenticated(oAuthClientAuthnContext, grantType)) {
                    OAuthRevocationResponseDTO revokeRespDTO = new OAuthRevocationResponseDTO();
                    revokeRespDTO.setError(true);
                    revokeRespDTO.setErrorCode(this.getErrorCode(oAuthClientAuthnContext));
                    revokeRespDTO.setErrorMsg(this.getErrorMessage(oAuthClientAuthnContext));
                    this.invokePostRevocationListeners(revokeRequestDTO, revokeRespDTO, accessTokenDO, refreshTokenDO);
                    return revokeRespDTO;
                }
                if (refreshTokenDO != null) {
                    String tokenBindingReference = "NONE";
                    if (StringUtils.isNotBlank((String)refreshTokenDO.getTokenBindingReference())) {
                        tokenBindingReference = refreshTokenDO.getTokenBindingReference();
                    }
                    OAuthUtil.clearOAuthCache(revokeRequestDTO.getConsumerKey(), (User)refreshTokenDO.getAuthorizedUser(), OAuth2Util.buildScopeString(refreshTokenDO.getScope()), tokenBindingReference);
                    OAuthUtil.clearOAuthCache(revokeRequestDTO.getConsumerKey(), (User)refreshTokenDO.getAuthorizedUser(), OAuth2Util.buildScopeString(refreshTokenDO.getScope()));
                    OAuthUtil.clearOAuthCache(revokeRequestDTO.getConsumerKey(), (User)refreshTokenDO.getAuthorizedUser());
                    OAuthUtil.clearOAuthCache(refreshTokenDO.getAccessToken());
                    OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens(new String[]{refreshTokenDO.getAccessToken()});
                    this.addRevokeResponseHeaders(revokeResponseDTO, refreshTokenDO.getAccessToken(), revokeRequestDTO.getToken(), refreshTokenDO.getAuthorizedUser().toString());
                } else if (accessTokenDO != null) {
                    if (revokeRequestDTO.getConsumerKey().equals(accessTokenDO.getConsumerKey())) {
                        if (OAuth2Util.getAppInformationByClientId(accessTokenDO.getConsumerKey()).isTokenBindingValidationEnabled() && !OAuth2Util.isValidTokenBinding(accessTokenDO.getTokenBinding(), revokeRequestDTO.getRequest())) {
                            revokeResponseDTO.setError(true);
                            revokeResponseDTO.setErrorCode("access_denied");
                            revokeResponseDTO.setErrorMsg("Valid token binding value not present in the request.");
                            return revokeResponseDTO;
                        }
                        String tokenBindingReference = "NONE";
                        if (accessTokenDO.getTokenBinding() != null && StringUtils.isNotBlank((String)accessTokenDO.getTokenBinding().getBindingReference())) {
                            tokenBindingReference = accessTokenDO.getTokenBinding().getBindingReference();
                        }
                        OAuthUtil.clearOAuthCache(revokeRequestDTO.getConsumerKey(), (User)accessTokenDO.getAuthzUser(), OAuth2Util.buildScopeString(accessTokenDO.getScope()), tokenBindingReference);
                        OAuthUtil.clearOAuthCache(revokeRequestDTO.getConsumerKey(), (User)accessTokenDO.getAuthzUser(), OAuth2Util.buildScopeString(accessTokenDO.getScope()));
                        OAuthUtil.clearOAuthCache(revokeRequestDTO.getConsumerKey(), (User)accessTokenDO.getAuthzUser());
                        OAuthUtil.clearOAuthCache(accessTokenDO.getAccessToken());
                        String scope = OAuth2Util.buildScopeString(accessTokenDO.getScope());
                        String authorizedUser = accessTokenDO.getAuthzUser().toString();
                        String string = (revokeRequestDTO.getConsumerKey() + ":" + authorizedUser + ":" + scope + ":" + tokenBindingReference).intern();
                        synchronized (string) {
                            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens(new String[]{accessTokenDO.getAccessToken()});
                        }
                        this.addRevokeResponseHeaders(revokeResponseDTO, revokeRequestDTO.getToken(), accessTokenDO.getRefreshToken(), accessTokenDO.getAuthzUser().toString());
                    } else {
                        throw new InvalidOAuthClientException("Unauthorized Client");
                    }
                }
                this.invokePostRevocationListeners(revokeRequestDTO, revokeResponseDTO, accessTokenDO, refreshTokenDO);
                return revokeResponseDTO;
            }
            revokeResponseDTO.setError(true);
            revokeResponseDTO.setErrorCode(oAuthClientAuthnContext.getErrorCode());
            revokeResponseDTO.setErrorMsg(oAuthClientAuthnContext.getErrorMessage());
            this.invokePostRevocationListeners(revokeRequestDTO, revokeResponseDTO, accessTokenDO, refreshTokenDO);
            return revokeResponseDTO;
        }
        catch (InvalidOAuthClientException e) {
            log.error((Object)"Unauthorized Client", (Throwable)e);
            OAuthRevocationResponseDTO revokeRespDTO = new OAuthRevocationResponseDTO();
            revokeRespDTO.setError(true);
            revokeRespDTO.setErrorCode("unauthorized_client");
            revokeRespDTO.setErrorMsg("Unauthorized Client");
            this.invokePostRevocationListeners(revokeRequestDTO, revokeResponseDTO, accessTokenDO, refreshTokenDO);
            return revokeRespDTO;
        }
        catch (IdentityException e) {
            log.error((Object)"Error occurred while revoking authorization grant for applications", (Throwable)e);
            OAuthRevocationResponseDTO revokeRespDTO = new OAuthRevocationResponseDTO();
            revokeRespDTO.setError(true);
            revokeRespDTO.setErrorCode("server_error");
            revokeRespDTO.setErrorMsg("Error occurred while revoking authorization grant for applications");
            this.invokePostRevocationListeners(revokeRequestDTO, revokeResponseDTO, accessTokenDO, refreshTokenDO);
            return revokeRespDTO;
        }
    }

    private boolean isRefreshTokenType(OAuthRevocationRequestDTO revokeRequestDTO) {
        return StringUtils.equals((String)GrantType.REFRESH_TOKEN.toString(), (String)revokeRequestDTO.getTokenType());
    }

    private void invokePostRevocationListeners(OAuthRevocationRequestDTO revokeRequestDTO, OAuthRevocationResponseDTO revokeResponseDTO, AccessTokenDO accessTokenDO, RefreshTokenValidationDataDO refreshTokenDO) {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            try {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                oAuthEventInterceptorProxy.onPostTokenRevocationByClient(revokeRequestDTO, revokeResponseDTO, accessTokenDO, refreshTokenDO, paramMap);
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)"Error occurred when invoking post token revoke listener ", (Throwable)((Object)e));
            }
        }
    }

    public Claim[] getUserClaims(String accessTokenIdentifier) {
        OAuth2TokenValidationRequestDTO reqDTO = new OAuth2TokenValidationRequestDTO();
        OAuth2TokenValidationRequestDTO.OAuth2AccessToken accessToken = new OAuth2TokenValidationRequestDTO.OAuth2AccessToken(reqDTO);
        accessToken.setTokenType("bearer");
        accessToken.setIdentifier(accessTokenIdentifier);
        reqDTO.setAccessToken(accessToken);
        OAuth2TokenValidationResponseDTO respDTO = new OAuth2TokenValidationService().validate(reqDTO);
        String username = respDTO.getAuthorizedUser();
        if (username == null) {
            log.debug((Object)respDTO.getErrorMsg());
            return new Claim[0];
        }
        String[] scope = respDTO.getScope();
        boolean isOICScope = false;
        for (String curScope : scope) {
            if (!"openid".equals(curScope)) continue;
            isOICScope = true;
        }
        if (!isOICScope) {
            log.error((Object)"AccessToken does not have the openid scope");
            return new Claim[0];
        }
        String profileName = "default";
        String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
        String tenatUser = MultitenantUtils.getTenantAwareUsername((String)username);
        ArrayList<Claim> claimsList = new ArrayList<Claim>();
        Claim subClaim = new Claim();
        subClaim.setClaimUri("sub");
        subClaim.setValue(username);
        claimsList.add(subClaim);
        try {
            UserStoreManager userStore = IdentityTenantUtil.getRealm((String)tenantDomain, (String)tenatUser).getUserStoreManager();
            String[] claims = OAuthServerConfiguration.getInstance().getSupportedClaims();
            if (claims != null) {
                Map extClaimsMap = userStore.getUserClaimValues(username, claims, profileName);
                for (Map.Entry entry : extClaimsMap.entrySet()) {
                    Claim curClaim = new Claim();
                    curClaim.setClaimUri((String)entry.getKey());
                    curClaim.setValue((String)entry.getValue());
                    claimsList.add(curClaim);
                }
            }
            String[] defaultClaims = new String[]{"http://wso2.org/claims/emailaddress", "http://wso2.org/claims/givenname", "http://wso2.org/claims/lastname"};
            String emailAddress = null;
            String firstName = null;
            String lastName = null;
            Map defClaimsMap = userStore.getUserClaimValues(username, defaultClaims, profileName);
            if (defClaimsMap.get(defaultClaims[0]) != null) {
                emailAddress = (String)defClaimsMap.get(defaultClaims[0]);
                Claim email = new Claim();
                email.setClaimUri("email");
                email.setValue(emailAddress);
                claimsList.add(email);
                Claim prefName = new Claim();
                prefName.setClaimUri("preferred_username");
                prefName.setValue(emailAddress.split("@")[0]);
                claimsList.add(prefName);
            }
            if (defClaimsMap.get(defaultClaims[1]) != null) {
                firstName = (String)defClaimsMap.get(defaultClaims[1]);
                Claim givenName = new Claim();
                givenName.setClaimUri("given_name");
                givenName.setValue(firstName);
                claimsList.add(givenName);
            }
            if (defClaimsMap.get(defaultClaims[2]) != null) {
                lastName = (String)defClaimsMap.get(defaultClaims[2]);
                Claim familyName = new Claim();
                familyName.setClaimUri("family_name");
                familyName.setValue(lastName);
                claimsList.add(familyName);
            }
            if (firstName != null && lastName != null) {
                Claim name = new Claim();
                name.setClaimUri("name");
                name.setValue(firstName + " " + lastName);
                claimsList.add(name);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while reading user claims ", (Throwable)e);
        }
        Claim[] allClaims = new Claim[claimsList.size()];
        for (int i = 0; i < claimsList.size(); ++i) {
            allClaims[i] = (Claim)claimsList.get(i);
        }
        return allClaims;
    }

    public String getOauthApplicationState(String consumerKey) {
        try {
            OAuthAppDO appDO = OAuth2Util.getAppInformationByClientId(consumerKey);
            return appDO.getState();
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            String msg = "Error while finding application state for application with client_id: " + consumerKey;
            log.error((Object)msg);
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            return null;
        }
    }

    public boolean isPKCESupportEnabled() {
        return OAuth2Util.isPKCESupportEnabled();
    }

    public List<TokenBinder> getSupportedTokenBinders() {
        return OAuth2ServiceComponentHolder.getInstance().getTokenBinders();
    }

    private void addRevokeResponseHeaders(OAuthRevocationResponseDTO revokeResponseDTP, String accessToken, String refreshToken, String authorizedUser) {
        if (OAuthServerConfiguration.getInstance().isRevokeResponseHeadersEnabled()) {
            ArrayList<ResponseHeader> respHeaders = new ArrayList<ResponseHeader>();
            ResponseHeader header = new ResponseHeader();
            header.setKey("RevokedAccessToken");
            header.setValue(accessToken);
            respHeaders.add(header);
            header = new ResponseHeader();
            header.setKey("AuthorizedUser");
            header.setValue(authorizedUser);
            respHeaders.add(header);
            header = new ResponseHeader();
            header.setKey("RevokedRefreshToken");
            header.setValue(refreshToken);
            respHeaders.add(header);
            revokeResponseDTP.setResponseHeaders(respHeaders.toArray(new ResponseHeader[respHeaders.size()]));
        }
    }

    private boolean isClientAuthenticated(OAuthClientAuthnContext oAuthClientAuthnContext, String grantType) {
        return oAuthClientAuthnContext != null && oAuthClientAuthnContext.isAuthenticated() && !oAuthClientAuthnContext.isMultipleAuthenticatorsEngaged() || StringUtils.equals((String)"implicit", (String)grantType);
    }

    private String getErrorMessage(OAuthClientAuthnContext oAuthClientAuthnContext) {
        String errorMessage = "Unauthorized Client";
        if (oAuthClientAuthnContext != null && StringUtils.isNotEmpty((String)oAuthClientAuthnContext.getErrorMessage())) {
            errorMessage = oAuthClientAuthnContext.getErrorMessage();
        }
        return errorMessage;
    }

    private String getErrorCode(OAuthClientAuthnContext oAuthClientAuthnContext) {
        String errorCode = "unauthorized_client";
        if (oAuthClientAuthnContext != null && StringUtils.isNotEmpty((String)oAuthClientAuthnContext.getErrorCode())) {
            errorCode = oAuthClientAuthnContext.getErrorCode();
        }
        return errorCode;
    }

    public OAuthErrorDTO handleUserConsentDenial(OAuth2Parameters oAuth2Parameters) {
        try {
            return AuthorizationHandlerManager.getInstance().handleUserConsentDenial(oAuth2Parameters);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)("Error in handling user consent denial for authentication request made by clientID: " + oAuth2Parameters.getClientId()), (Throwable)((Object)e));
            return null;
        }
    }

    public OAuthErrorDTO handleAuthenticationFailure(OAuth2Parameters oauth2Params) {
        try {
            return AuthorizationHandlerManager.getInstance().handleAuthenticationFailure(oauth2Params);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)("Error in handling authentication failure for authentication request made by clientID: " + oauth2Params.getClientId()), (Throwable)((Object)e));
            return null;
        }
    }
}

