/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.cache.OAuthScopeCache;
import org.wso2.carbon.identity.oauth.cache.OAuthScopeCacheKey;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeClientException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeServerException;
import org.wso2.carbon.identity.oauth2.Oauth2ScopeConstants;
import org.wso2.carbon.identity.oauth2.bean.Scope;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.util.Oauth2ScopeUtils;
import org.wso2.carbon.identity.openidconnect.cache.OIDCScopeClaimCache;

public class OAuth2ScopeService {
    private static final Log log = LogFactory.getLog(OAuth2ScopeService.class);
    private static final String SCOPE_VALIDATION_REGEX = "^[^?#/()]*$";

    public Scope registerScope(Scope scope) throws IdentityOAuth2ScopeException {
        this.addScopePreValidation(scope);
        boolean isScopeExists = this.isScopeExists(scope.getName(), true);
        if (isScopeExists) {
            if (this.isScopeExists(scope.getName(), false)) {
                throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_CONFLICT_REQUEST_EXISTING_SCOPE, scope.getName());
            }
            throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_CONFLICT_REQUEST_EXISTING_SCOPE_OIDC, scope.getName());
        }
        int tenantID = Oauth2ScopeUtils.getTenantID();
        try {
            OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().addScope(scope, tenantID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope is added to the database. \n" + scope.toString()));
            }
        }
        catch (IdentityOAuth2ScopeServerException e) {
            throw Oauth2ScopeUtils.generateServerException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_FAILED_TO_REGISTER_SCOPE, scope.toString(), (Throwable)((Object)e));
        }
        OAuthScopeCache.getInstance().addToCache(new OAuthScopeCacheKey(scope.getName(), Integer.toString(tenantID)), scope);
        return scope;
    }

    public Set<Scope> getScopes(Integer startIndex, Integer count) throws IdentityOAuth2ScopeServerException {
        return this.getScopes(startIndex, count, false, null);
    }

    public Set<Scope> getScopes(Integer startIndex, Integer count, Boolean includeOIDCScopes, String requestedScopes) throws IdentityOAuth2ScopeServerException {
        Set<Scope> scopes;
        boolean includeOIDCScopesState = BooleanUtils.isTrue((Boolean)includeOIDCScopes);
        if (StringUtils.isNotBlank((String)requestedScopes)) {
            try {
                scopes = OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().getRequestedScopesOnly(Oauth2ScopeUtils.getTenantID(), includeOIDCScopesState, requestedScopes);
            }
            catch (IdentityOAuth2ScopeServerException e) {
                throw Oauth2ScopeUtils.generateServerException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_REQUESTED_SCOPES, (Throwable)((Object)e));
            }
        } else if (startIndex == null && count == null) {
            try {
                scopes = OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().getAllScopes(Oauth2ScopeUtils.getTenantID(), includeOIDCScopesState);
            }
            catch (IdentityOAuth2ScopeServerException e) {
                throw Oauth2ScopeUtils.generateServerException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_ALL_SCOPES, (Throwable)((Object)e));
            }
        } else {
            scopes = this.listScopesWithPagination(startIndex, count, includeOIDCScopesState);
        }
        return scopes;
    }

    public Scope getScope(String name) throws IdentityOAuth2ScopeException {
        int tenantID = Oauth2ScopeUtils.getTenantID();
        this.validateScopeName(name);
        Scope scope = OAuthScopeCache.getInstance().getValueFromCache(new OAuthScopeCacheKey(name, Integer.toString(tenantID)));
        if (scope == null) {
            try {
                scope = OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().getScopeByName(name, tenantID);
                if (scope != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Scope is getting from the database. \n" + scope.toString()));
                    }
                    OAuthScopeCache.getInstance().addToCache(new OAuthScopeCacheKey(name, Integer.toString(tenantID)), scope);
                }
            }
            catch (IdentityOAuth2ScopeServerException e) {
                throw Oauth2ScopeUtils.generateServerException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_SCOPE_BY_NAME, name, (Throwable)((Object)e));
            }
        }
        if (scope == null) {
            throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_NOT_FOUND_SCOPE, name);
        }
        return scope;
    }

    public boolean isScopeExists(String name) throws IdentityOAuth2ScopeException {
        boolean isScopeExists;
        int tenantID = Oauth2ScopeUtils.getTenantID();
        if (name == null) {
            throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_BAD_REQUEST_SCOPE_NAME_NOT_SPECIFIED, null);
        }
        Scope scopeFromCache = OAuthScopeCache.getInstance().getValueFromCache(new OAuthScopeCacheKey(name, Integer.toString(tenantID)));
        if (scopeFromCache != null) {
            isScopeExists = true;
        } else {
            try {
                isScopeExists = OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().isScopeExists(name, tenantID);
            }
            catch (IdentityOAuth2ScopeServerException e) {
                throw Oauth2ScopeUtils.generateServerException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_SCOPE_BY_NAME, name, (Throwable)((Object)e));
            }
        }
        return isScopeExists;
    }

    public boolean isScopeExists(String name, boolean includeOIDCScopes) throws IdentityOAuth2ScopeException {
        boolean isScopeExists;
        int tenantID = Oauth2ScopeUtils.getTenantID();
        if (name == null) {
            throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_BAD_REQUEST_SCOPE_NAME_NOT_SPECIFIED, null);
        }
        Scope scopeFromCache = OAuthScopeCache.getInstance().getValueFromCache(new OAuthScopeCacheKey(name, Integer.toString(tenantID)));
        if (scopeFromCache != null) {
            isScopeExists = true;
        } else {
            try {
                isScopeExists = OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().isScopeExists(name, tenantID, includeOIDCScopes);
            }
            catch (IdentityOAuth2ScopeServerException e) {
                throw Oauth2ScopeUtils.generateServerException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_SCOPE_BY_NAME, name, (Throwable)((Object)e));
            }
        }
        return isScopeExists;
    }

    public void deleteScope(String name) throws IdentityOAuth2ScopeException {
        this.validateScopeName(name);
        this.validateScopeExistence(name);
        int tenantID = Oauth2ScopeUtils.getTenantID();
        OAuthScopeCache.getInstance().clearCacheEntry(new OAuthScopeCacheKey(name, Integer.toString(tenantID)));
        try {
            OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().deleteScopeByName(name, tenantID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope: " + name + " is deleted from the database."));
            }
        }
        catch (IdentityOAuth2ScopeServerException e) {
            throw Oauth2ScopeUtils.generateServerException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_FAILED_TO_DELETE_SCOPE_BY_NAME, name, (Throwable)((Object)e));
        }
    }

    public Scope updateScope(Scope updatedScope) throws IdentityOAuth2ScopeException {
        this.updateScopePreValidation(updatedScope);
        this.validateScopeExistence(updatedScope.getName());
        int tenantID = Oauth2ScopeUtils.getTenantID();
        try {
            OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().updateScopeByName(updatedScope, tenantID);
        }
        catch (IdentityOAuth2ScopeServerException e) {
            throw Oauth2ScopeUtils.generateServerException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_FAILED_TO_UPDATE_SCOPE_BY_NAME, updatedScope.getName(), (Throwable)((Object)e));
        }
        OAuthScopeCache.getInstance().addToCache(new OAuthScopeCacheKey(updatedScope.getName(), Integer.toString(tenantID)), updatedScope);
        OIDCScopeClaimCache.getInstance().clearScopeClaimMap(tenantID);
        return updatedScope;
    }

    private Set<Scope> listScopesWithPagination(Integer startIndex, Integer count, boolean includeOIDCScopes) throws IdentityOAuth2ScopeServerException {
        Set<Scope> scopes;
        if (count == null || count < 0) {
            count = 30;
        }
        if (startIndex == null || startIndex < 1) {
            startIndex = 1;
        }
        if (startIndex > 0) {
            Integer n = startIndex;
            Integer n2 = startIndex = Integer.valueOf(startIndex - 1);
        }
        try {
            scopes = OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().getScopesWithPagination(startIndex, count, Oauth2ScopeUtils.getTenantID(), includeOIDCScopes);
        }
        catch (IdentityOAuth2ScopeServerException e) {
            throw Oauth2ScopeUtils.generateServerException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_ALL_SCOPES_PAGINATION, (Throwable)((Object)e));
        }
        return scopes;
    }

    private void addScopePreValidation(Scope scope) throws IdentityOAuth2ScopeClientException {
        this.validateScopeName(scope.getName());
        this.validateRegex(scope.getName());
        this.validateDisplayName(scope.getDisplayName());
    }

    private void updateScopePreValidation(Scope updatedScope) throws IdentityOAuth2ScopeClientException {
        this.validateScopeName(updatedScope.getName());
        this.validateDisplayName(updatedScope.getDisplayName());
    }

    private void validateScopeName(String scopeName) throws IdentityOAuth2ScopeClientException {
        if (StringUtils.isBlank((String)scopeName)) {
            throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_BAD_REQUEST_SCOPE_NAME_NOT_SPECIFIED, null);
        }
        this.validateWhiteSpaces(scopeName);
    }

    private void validateRegex(String scopeName) throws IdentityOAuth2ScopeClientException {
        Pattern regexPattern = Pattern.compile(SCOPE_VALIDATION_REGEX);
        if (!regexPattern.matcher(scopeName).matches()) {
            throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_BAD_REQUEST_SCOPE_NAME_NOT_SATIFIED_THE_REGEX, scopeName);
        }
    }

    private void validateWhiteSpaces(String scopeName) throws IdentityOAuth2ScopeClientException {
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(scopeName);
        boolean foundWhiteSpace = matcher.find();
        if (foundWhiteSpace) {
            throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_BAD_REQUEST_SCOPE_NAME_CONTAINS_WHITESPACES, scopeName);
        }
    }

    private void validateDisplayName(String displayName) throws IdentityOAuth2ScopeClientException {
        if (StringUtils.isBlank((String)displayName)) {
            throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_BAD_REQUEST_SCOPE_DISPLAY_NAME_NOT_SPECIFIED, null);
        }
    }

    private void validateScopeExistence(String scopeName) throws IdentityOAuth2ScopeException {
        boolean isScopeExists = this.isScopeExists(scopeName);
        if (!isScopeExists) {
            throw Oauth2ScopeUtils.generateClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_NOT_FOUND_SCOPE, scopeName);
        }
    }
}

