/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.tokenprocessor;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.tokenprocessor.TokenPersistenceProcessor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;

public class HashingPersistenceProcessor
implements TokenPersistenceProcessor {
    protected static final Log LOG = LogFactory.getLog(HashingPersistenceProcessor.class);
    public static final String ALGORITHM = "algorithm";
    public static final String HASH = "hash";

    @Override
    public String getProcessedClientId(String clientId) throws IdentityOAuth2Exception {
        return clientId;
    }

    @Override
    public String getPreprocessedClientId(String processedClientId) throws IdentityOAuth2Exception {
        return processedClientId;
    }

    @Override
    public String getProcessedClientSecret(String clientSecret) throws IdentityOAuth2Exception {
        return this.hash(clientSecret);
    }

    @Override
    public String getPreprocessedClientSecret(String processedClientSecret) throws IdentityOAuth2Exception {
        throw new UnsupportedOperationException("Invalid operation on hashed client secret");
    }

    @Override
    public String getProcessedAuthzCode(String authzCode) throws IdentityOAuth2Exception {
        return this.hash(authzCode);
    }

    @Override
    public String getPreprocessedAuthzCode(String processedAuthzCode) throws IdentityOAuth2Exception {
        throw new UnsupportedOperationException("Invalid operation on hashed authorization code");
    }

    @Override
    public String getProcessedAccessTokenIdentifier(String accessTokenIdentifier) throws IdentityOAuth2Exception {
        return this.hash(accessTokenIdentifier);
    }

    @Override
    public String getPreprocessedAccessTokenIdentifier(String processedAccessTokenIdentifier) throws IdentityOAuth2Exception {
        return processedAccessTokenIdentifier;
    }

    @Override
    public String getProcessedRefreshToken(String refreshToken) throws IdentityOAuth2Exception {
        return this.hash(refreshToken);
    }

    @Override
    public String getPreprocessedRefreshToken(String processedRefreshToken) throws IdentityOAuth2Exception {
        return processedRefreshToken;
    }

    private String hash(String plainText) throws IdentityOAuth2Exception {
        if (StringUtils.isEmpty((String)plainText)) {
            throw new IdentityOAuth2Exception("plainText value is null or empty to be hash.");
        }
        MessageDigest messageDigest = null;
        byte[] hash = null;
        String hashAlgorithm = OAuthServerConfiguration.getInstance().getHashAlgorithm();
        try {
            messageDigest = MessageDigest.getInstance(hashAlgorithm);
            messageDigest.update(plainText.getBytes(StandardCharsets.UTF_8));
            hash = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IdentityOAuth2Exception("Error while retrieving MessageDigest for the provided hash algorithm: " + hashAlgorithm, e);
        }
        JSONObject object = new JSONObject();
        object.put(ALGORITHM, (Object)hashAlgorithm);
        object.put(HASH, (Object)HashingPersistenceProcessor.bytesToHex(hash));
        return object.toString();
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte byt : bytes) {
            result.append(Integer.toString((byt & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }
}

