/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.listener;

import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.listener.AbstractCacheListener;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.CacheEntry;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class OAuthCacheRemoveListener
extends AbstractCacheListener<OAuthCacheKey, CacheEntry>
implements CacheEntryRemovedListener<OAuthCacheKey, CacheEntry> {
    private static final Log log = LogFactory.getLog(OAuthCacheRemoveListener.class);

    public void entryRemoved(CacheEntryEvent<? extends OAuthCacheKey, ? extends CacheEntry> cacheEntryEvent) throws CacheEntryListenerException {
        String userName;
        boolean isUsernameCaseSensitive;
        CacheEntry cacheEntry = (CacheEntry)((Object)cacheEntryEvent.getValue());
        if (!(cacheEntry instanceof AccessTokenDO)) {
            return;
        }
        AccessTokenDO accessTokenDO = (AccessTokenDO)cacheEntry;
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth cache removed for consumer id : " + accessTokenDO.getConsumerKey()));
        }
        String cacheKeyString = (isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)(userName = accessTokenDO.getAuthzUser().toString()))) ? accessTokenDO.getConsumerKey() + ":" + userName + ":" + OAuth2Util.buildScopeString(accessTokenDO.getScope()) + ":" + accessTokenDO.getAuthzUser().getFederatedIdPName() : accessTokenDO.getConsumerKey() + ":" + userName.toLowerCase() + ":" + OAuth2Util.buildScopeString(accessTokenDO.getScope()) + ":" + accessTokenDO.getAuthzUser().getFederatedIdPName();
        OAuthCacheKey oauthcacheKey = new OAuthCacheKey(cacheKeyString);
        OAuthCache oauthCache = OAuthCache.getInstance();
        oauthCache.clearCacheEntry(oauthcacheKey);
        oauthcacheKey = new OAuthCacheKey(accessTokenDO.getAccessToken());
        oauthCache.clearCacheEntry(oauthcacheKey);
    }
}

