/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.listener;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class IdentityOauthEventHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(IdentityOauthEventHandler.class);

    public String getName() {
        return "identityOauthEventHandler";
    }

    public String getFriendlyName() {
        return "Identity Oauth Event Handler";
    }

    public void init(InitConfig configuration) throws IdentityRuntimeException {
        super.init(configuration);
    }

    public int getPriority(MessageContext messageContext) {
        int priority = super.getPriority(messageContext);
        if (priority == -1) {
            priority = 51;
        }
        return priority;
    }

    public void handleEvent(Event event) throws IdentityEventException {
        if ("POST_SET_USER_CLAIMS".equals(event.getEventName()) || "POST_SET_USER_CLAIM".equals(event.getEventName())) {
            String username = (String)event.getEventProperties().get("user-name");
            UserStoreManager userStoreManager = (UserStoreManager)event.getEventProperties().get("userStoreManager");
            try {
                this.revokeTokensOfLockedUser(username, userStoreManager);
                this.revokeTokensOfDisabledUser(username, userStoreManager);
                OAuthUtil.removeUserClaimsFromCache(username, userStoreManager);
            }
            catch (UserStoreException e) {
                String errorMsg = "Error occurred while revoking  access token for User : " + username;
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityEventException(errorMsg);
            }
        }
    }

    private void revokeTokensOfLockedUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        String errorCode = (String)((Map)IdentityUtil.threadLocalProperties.get()).get("UserAccountState");
        if ("17003".equalsIgnoreCase(errorCode)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("User %s is locked. Hence revoking user's access tokens.", userName));
            }
            OAuthUtil.revokeTokens(userName, userStoreManager);
        }
    }

    private void revokeTokensOfDisabledUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        String errorCode = (String)((Map)IdentityUtil.threadLocalProperties.get()).get("UserAccountState");
        if ("17004".equalsIgnoreCase(errorCode)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("User %s is disabled. Hence revoking user's access tokens.", userName));
            }
            OAuthUtil.revokeTokens(userName, userStoreManager);
        }
    }
}

