/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.util.ClaimCache;
import org.wso2.carbon.identity.oauth.util.ClaimMetaDataCache;
import org.wso2.carbon.identity.oauth.util.ClaimMetaDataCacheEntry;
import org.wso2.carbon.identity.oauth.util.ClaimMetaDataCacheKey;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class IdentityOathEventListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(IdentityOathEventListener.class);

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 100;
    }

    public boolean doPreDeleteUser(String username, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        this.removeClaimCacheEntry(username, userStoreManager);
        return OAuthUtil.revokeTokens(username, userStoreManager);
    }

    public boolean doPreSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        this.removeTokensFromCache(userName, userStoreManager);
        return true;
    }

    public boolean doPreSetUserClaimValues(String userName, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        this.removeTokensFromCache(userName, userStoreManager);
        return true;
    }

    public boolean doPostSetUserClaimValue(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        return true;
    }

    public boolean doPostSetUserClaimValues(String userName, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        return true;
    }

    public boolean doPostAuthenticate(String userName, boolean authenticated, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        return this.revokeTokensOfLockedUser(userName, userStoreManager) && this.revokeTokensOfDisabledUser(userName, userStoreManager);
    }

    public boolean doPostUpdateCredential(String userName, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        return OAuthUtil.revokeTokens(userName, userStoreManager);
    }

    public boolean doPostUpdateCredentialByAdmin(String userName, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        return OAuthUtil.revokeTokens(userName, userStoreManager);
    }

    public boolean doPreUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        this.removeTokensFromCache(userName, userStoreManager);
        return true;
    }

    public boolean doPostUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (ArrayUtils.isNotEmpty((Object[])deletedRoles)) {
            OAuthUtil.revokeTokens(userName, userStoreManager);
        }
        return OAuthUtil.removeUserClaimsFromCache(userName, userStoreManager);
    }

    public boolean doPreUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        ArrayList<String> userList = new ArrayList<String>();
        userList.addAll(Arrays.asList(deletedUsers));
        userList.addAll(Arrays.asList(newUsers));
        for (String username : userList) {
            this.removeTokensFromCache(username, userStoreManager);
        }
        return true;
    }

    public boolean doPostUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        ArrayList<String> userList = new ArrayList<String>();
        userList.addAll(Arrays.asList(deletedUsers));
        userList.addAll(Arrays.asList(newUsers));
        for (String username : userList) {
            OAuthUtil.removeUserClaimsFromCache(username, userStoreManager);
        }
        for (String deletedUser : deletedUsers) {
            OAuthUtil.revokeTokens(deletedUser, userStoreManager);
        }
        return true;
    }

    private boolean revokeTokensOfLockedUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        String errorCode = (String)((Map)IdentityUtil.threadLocalProperties.get()).get("UserAccountState");
        if (errorCode != null && errorCode.equalsIgnoreCase("17003")) {
            return OAuthUtil.revokeTokens(userName, userStoreManager);
        }
        return true;
    }

    private boolean revokeTokensOfDisabledUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        String errorCode = (String)((Map)IdentityUtil.threadLocalProperties.get()).get("UserAccountState");
        if (errorCode != null && errorCode.equalsIgnoreCase("17004")) {
            return OAuthUtil.revokeTokens(userName, userStoreManager);
        }
        return true;
    }

    private void removeTokensFromCache(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        String userStoreDomain = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        String tenantDomain = IdentityTenantUtil.getTenantDomain((int)userStoreManager.getTenantId());
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setUserStoreDomain(userStoreDomain);
        authenticatedUser.setTenantDomain(tenantDomain);
        authenticatedUser.setUserName(userName);
        try {
            Set<AccessTokenDO> accessTokenDOSet = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessTokensByUserForOpenidScope(authenticatedUser);
            List<AuthzCodeDO> authorizationCodeDOSet = OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().getAuthorizationCodesByUserForOpenidScope(authenticatedUser);
            this.removeAccessTokensFromCache(accessTokenDOSet);
            this.removeAuthzCodesFromCache(authorizationCodeDOSet);
        }
        catch (IdentityOAuth2Exception e) {
            String errorMsg = "Error occurred while retrieving access tokens issued for user : " + userName;
            log.error((Object)errorMsg, (Throwable)((Object)e));
        }
    }

    private void removeAuthzCodesFromCache(List<AuthzCodeDO> authorizationCodeDOSet) {
        if (CollectionUtils.isNotEmpty(authorizationCodeDOSet)) {
            for (AuthzCodeDO authorizationCodeDO : authorizationCodeDOSet) {
                String authorizationCode = authorizationCodeDO.getAuthorizationCode();
                String authzCodeId = authorizationCodeDO.getAuthzCodeId();
                AuthorizationGrantCacheKey cacheKey = new AuthorizationGrantCacheKey(authorizationCode);
                AuthorizationGrantCache.getInstance().clearCacheEntryByCodeId(cacheKey, authzCodeId);
            }
        }
    }

    private void removeAccessTokensFromCache(Set<AccessTokenDO> accessTokenDOSet) {
        if (CollectionUtils.isNotEmpty(accessTokenDOSet)) {
            for (AccessTokenDO accessTokenDO : accessTokenDOSet) {
                String accessToken = accessTokenDO.getAccessToken();
                String tokenId = accessTokenDO.getTokenId();
                AuthorizationGrantCacheKey cacheKey = new AuthorizationGrantCacheKey(accessToken);
                AuthorizationGrantCache.getInstance().clearCacheEntryByTokenId(cacheKey, tokenId);
            }
        }
    }

    private void removeClaimCacheEntry(String username, UserStoreManager userStoreManager) throws UserStoreException {
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setUserName(username);
        authenticatedUser.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)userStoreManager.getTenantId()));
        authenticatedUser.setUserStoreDomain(UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration()));
        ClaimMetaDataCacheEntry cacheEntry = (ClaimMetaDataCacheEntry)((Object)ClaimMetaDataCache.getInstance().getValueFromCache(new ClaimMetaDataCacheKey(authenticatedUser)));
        if (cacheEntry == null) {
            return;
        }
        ClaimCache.getInstance().clearCacheEntry(cacheEntry.getClaimCacheKey());
    }
}

