/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.oauth.OAuthAdminServiceImpl;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.common.token.bindings.TokenBinderInfo;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth.listener.IdentityOathEventListener;
import org.wso2.carbon.identity.oauth.listener.IdentityOauthEventHandler;
import org.wso2.carbon.identity.oauth.listener.OAuthApplicationMgtListener;
import org.wso2.carbon.identity.oauth2.OAuth2ScopeService;
import org.wso2.carbon.identity.oauth2.OAuth2Service;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.oauth.component", immediate=true)
public class OAuthServiceComponent {
    private static final Log log = LogFactory.getLog(OAuthServiceComponent.class);
    private ServiceRegistration serviceRegistration = null;

    protected void activate(ComponentContext context) {
        try {
            OAuthServerConfiguration oauthServerConfig = OAuthServerConfiguration.getInstance();
            if (OAuthCache.getInstance().isEnabled()) {
                log.debug((Object)"OAuth Caching is enabled. Initializing the cache.");
            }
            IdentityOathEventListener listener = new IdentityOathEventListener();
            this.serviceRegistration = context.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)listener, null);
            log.debug((Object)"Identity Oath Event Listener is enabled");
            context.getBundleContext().registerService(AbstractEventHandler.class.getName(), (Object)new IdentityOauthEventHandler(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Oauth Event handler is enabled");
            }
            OAuth2Service oauth2Service = new OAuth2Service();
            context.getBundleContext().registerService(OAuth2Service.class.getName(), (Object)oauth2Service, null);
            OAuthComponentServiceHolder.getInstance().setOauth2Service(oauth2Service);
            oauthServerConfig.populateOAuthTokenIssuerMap();
            OAuthAdminServiceImpl oauthAdminService = new OAuthAdminServiceImpl();
            context.getBundleContext().registerService(OAuthAdminServiceImpl.class.getName(), (Object)oauthAdminService, null);
            OAuthComponentServiceHolder.getInstance().setOAuthAdminService(oauthAdminService);
            OAuth2ServiceComponentHolder.getInstance().setOAuthAdminService(oauthAdminService);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity OAuth bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while activating OAuth Service Component", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity OAuth bundle is deactivated");
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Identity OAuth bundle");
        }
        OAuthComponentServiceHolder.getInstance().setRegistryService((org.wso2.carbon.registry.api.RegistryService)registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Identity OAuth bundle");
        }
        OAuthComponentServiceHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        OAuthComponentServiceHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service");
        }
        OAuthComponentServiceHolder.getInstance().setRealmService(null);
    }

    @Reference(name="scope.service", service=OAuth2ScopeService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetOauth2ScopeService")
    protected void setOauth2ScopeService(OAuth2ScopeService oauth2ScopeService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Scope Service");
        }
        OAuthComponentServiceHolder.getInstance().setOauth2ScopeService(oauth2ScopeService);
    }

    protected void unsetOauth2ScopeService(OAuth2ScopeService oauth2ScopeService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the Scope Service");
        }
        OAuthComponentServiceHolder.getInstance().setOauth2ScopeService(null);
    }

    @Reference(name="org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor", service=OAuthEventInterceptor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetOAuthEventInterceptor")
    protected void setOAuthEventInterceptorProxy(OAuthEventInterceptor oAuthEventInterceptor) {
        if (oAuthEventInterceptor == null) {
            log.warn((Object)"Null Oauth Event Interceptor received, hence not registering");
            return;
        }
        if (!"OauthDataInterceptorHandlerProxy".equalsIgnoreCase(oAuthEventInterceptor.getName())) {
            log.debug((Object)"Non proxy Oauth event interceptor received, hence not registering");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting oauth event interceptor proxy :" + oAuthEventInterceptor.getClass().getName()));
        }
        OAuthComponentServiceHolder.getInstance().addOauthEventInterceptorProxy(oAuthEventInterceptor);
    }

    protected void unsetOAuthEventInterceptor(OAuthEventInterceptor oAuthEventInterceptor) {
        if (oAuthEventInterceptor == null) {
            log.warn((Object)"Null oauth event interceptor received, hence not registering");
            return;
        }
        if (!"OauthDataInterceptorHandlerProxy".equalsIgnoreCase(oAuthEventInterceptor.getName())) {
            log.debug((Object)"Non proxy Oauth event interceptor received, hence not un-setting");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-setting oauth event interceptor proxy :" + oAuthEventInterceptor.getClass().getName()));
        }
        OAuthComponentServiceHolder.getInstance().addOauthEventInterceptorProxy(null);
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="identity.core.init.event.service", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="token.binding.service", service=TokenBinderInfo.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetTokenBinderInfo")
    protected void setTokenBinderInfo(TokenBinderInfo tokenBinderInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting the token binder info for: " + tokenBinderInfo.getBindingType()));
        }
        OAuthComponentServiceHolder.getInstance().addTokenBinderInfo(tokenBinderInfo);
    }

    protected void unsetTokenBinderInfo(TokenBinderInfo tokenBinderInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-setting the token binder info for: " + tokenBinderInfo.getBindingType()));
        }
        OAuthComponentServiceHolder.getInstance().removeTokenBinderInfo(tokenBinderInfo);
    }

    @Reference(name="oauth.application.mgt.listener", service=OAuthApplicationMgtListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetOAuthApplicationMgtListener")
    protected void setOAuthApplicationMgtListener(OAuthApplicationMgtListener oAuthApplicationMgtListener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding OAuthApplicationMgtListener: " + oAuthApplicationMgtListener.getClass().getName()));
        }
        OAuthComponentServiceHolder.getInstance().addOAuthApplicationMgtListener(oAuthApplicationMgtListener);
    }

    protected void unsetOAuthApplicationMgtListener(OAuthApplicationMgtListener oAuthApplicationMgtListener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing OAuthApplicationMgtListener: " + oAuthApplicationMgtListener.getClass().getName()));
        }
        OAuthComponentServiceHolder.getInstance().removeOAuthApplicationMgtListener(oAuthApplicationMgtListener);
    }
}

