/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.OAuthAdminServiceImpl;
import org.wso2.carbon.identity.oauth.common.token.bindings.TokenBinderInfo;
import org.wso2.carbon.identity.oauth.dto.TokenBindingMetaDataDTO;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.listener.OAuthApplicationMgtListener;
import org.wso2.carbon.identity.oauth2.OAuth2ScopeService;
import org.wso2.carbon.identity.oauth2.OAuth2Service;
import org.wso2.carbon.identity.oauth2.validators.scope.ScopeValidator;
import org.wso2.carbon.registry.api.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

public class OAuthComponentServiceHolder {
    private static OAuthComponentServiceHolder instance = new OAuthComponentServiceHolder();
    private RegistryService registryService;
    private RealmService realmService;
    private OAuthEventInterceptor oAuthEventInterceptorHandlerProxy;
    private OAuth2Service oauth2Service;
    private static final Log log = LogFactory.getLog(OAuthComponentServiceHolder.class);
    private OAuth2ScopeService oauth2ScopeService;
    private List<TokenBindingMetaDataDTO> tokenBindingMetaDataDTOs = new ArrayList<TokenBindingMetaDataDTO>();
    private OAuthAdminServiceImpl oAuthAdminService;
    private List<ScopeValidator> scopeValidators = new ArrayList<ScopeValidator>();
    private Map<Integer, OAuthApplicationMgtListener> oAuthApplicationMgtListeners = new TreeMap<Integer, OAuthApplicationMgtListener>();

    public List<ScopeValidator> getScopeValidators() {
        return this.scopeValidators;
    }

    public void addScopeValidator(ScopeValidator scopeValidator) {
        this.scopeValidators.add(scopeValidator);
    }

    public void removeScopeValidator(ScopeValidator scopeValidator) {
        this.scopeValidators.remove(scopeValidator);
    }

    public void setScopeValidators(List<ScopeValidator> scopeValidators) {
        this.scopeValidators = scopeValidators;
    }

    private OAuthComponentServiceHolder() {
    }

    public static OAuthComponentServiceHolder getInstance() {
        return instance;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public RealmService getRealmService() {
        return this.realmService;
    }

    public void setRealmService(RealmService realmService) {
        this.realmService = realmService;
    }

    public void addOauthEventInterceptorProxy(OAuthEventInterceptor oAuthEventInterceptorHandlerProxy) {
        this.oAuthEventInterceptorHandlerProxy = oAuthEventInterceptorHandlerProxy;
    }

    public OAuthEventInterceptor getOAuthEventInterceptorProxy() {
        return this.oAuthEventInterceptorHandlerProxy;
    }

    public OAuth2Service getOauth2Service() {
        return this.oauth2Service;
    }

    public void setOauth2Service(OAuth2Service oauth2Service) {
        this.oauth2Service = oauth2Service;
    }

    public OAuth2ScopeService getOauth2ScopeService() {
        return this.oauth2ScopeService;
    }

    public void setOauth2ScopeService(OAuth2ScopeService oauth2ScopeService) {
        this.oauth2ScopeService = oauth2ScopeService;
    }

    public List<TokenBindingMetaDataDTO> getTokenBindingMetaDataDTOs() {
        return this.tokenBindingMetaDataDTOs;
    }

    public void addTokenBinderInfo(TokenBinderInfo tokenBinderInfo) {
        this.tokenBindingMetaDataDTOs.add(new TokenBindingMetaDataDTO(tokenBinderInfo.getDisplayName(), tokenBinderInfo.getDescription(), tokenBinderInfo.getBindingType(), tokenBinderInfo.getSupportedGrantTypes()));
    }

    public void removeTokenBinderInfo(TokenBinderInfo tokenBinderInfo) {
        this.tokenBindingMetaDataDTOs.removeIf(tokenBindingMetaDataDTO -> tokenBinderInfo.getBindingType().equals(tokenBindingMetaDataDTO.getTokenBindingType()));
    }

    public OAuthAdminServiceImpl getoAuthAdminService() {
        return this.oAuthAdminService;
    }

    public void setOAuthAdminService(OAuthAdminServiceImpl oAuthAdminService) {
        this.oAuthAdminService = oAuthAdminService;
    }

    public Collection<OAuthApplicationMgtListener> getOAuthApplicationMgtListeners() {
        if (this.oAuthApplicationMgtListeners.isEmpty()) {
            return Collections.emptyList();
        }
        return this.oAuthApplicationMgtListeners.values();
    }

    public void addOAuthApplicationMgtListener(OAuthApplicationMgtListener oAuthApplicationMgtListener) {
        this.oAuthApplicationMgtListeners.put(oAuthApplicationMgtListener.getExecutionOrder(), oAuthApplicationMgtListener);
    }

    public void removeOAuthApplicationMgtListener(OAuthApplicationMgtListener oAuthApplicationMgtListener) {
        this.oAuthApplicationMgtListeners.remove(oAuthApplicationMgtListener.getExecutionOrder(), oAuthApplicationMgtListener);
    }
}

