/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dao;

public class SQLQueries {
    private SQLQueries() {
    }

    public static class OAuthConsumerDAOSQLQueries {
        public static final String GET_CONSUMER_SECRET = "SELECT CONSUMER_SECRET FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
        public static final String EXISTENCE_OF_CONSUMER_SECRET = "SELECT CONSUMER_KEY FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=? AND CONSUMER_SECRET=?";
        public static final String GET_REGISTERED_CALLBACK_URL = "SELECT CALLBACK_URL FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
        public static final String ADD_OAUTH_REQ_TOKEN = "INSERT INTO IDN_OAUTH1A_REQUEST_TOKEN (REQUEST_TOKEN, REQUEST_TOKEN_SECRET, CONSUMER_KEY_ID, CALLBACK_URL, SCOPE, AUTHORIZED) SELECT ?,?,ID,?,?,? FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
        public static final String GET_CALLBACK_URL_OF_REQ_TOKEN = "SELECT CALLBACK_URL FROM IDN_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?";
        public static final String AUTHORIZE_REQ_TOKEN = "UPDATE IDN_OAUTH1A_REQUEST_TOKEN SET AUTHORIZED=?, OAUTH_VERIFIER=?, AUTHZ_USER=? WHERE REQUEST_TOKEN=?";
        public static final String GET_REQ_TOKEN = "SELECT * FROM IDN_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?";
        public static final String GET_REQ_TOKEN_SECRET = "SELECT REQUEST_TOKEN_SECRET FROM IDN_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?";
        public static final String REMOVE_REQUEST_TOKEN = "DELETE FROM IDN_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?";
        public static final String ADD_ACCESS_TOKEN = "INSERT INTO IDN_OAUTH1A_ACCESS_TOKEN VALUES (?,?,?,?,?)";
        public static final String GET_ACCESS_TOKEN = "SELECT SCOPE, AUTHZ_USER FROM IDN_OAUTH1A_ACCESS_TOKEN WHERE ACCESS_TOKEN=?";
        public static final String GET_ACCESS_TOKEN_SECRET = "SELECT ACCESS_TOKEN_SECRET FROM IDN_OAUTH1A_ACCESS_TOKEN WHERE ACCESS_TOKEN=?";
        public static final String GET_CONSUMER_KEY_FOR_TOKEN = "SELECT CONSUMER_KEY, SCOPE FROM IDN_OAUTH_CONSUMER_APPS JOIN (SELECT CONSUMER_KEY_ID, SCOPE FROM IDN_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?) AS REQUEST_TOKEN_TABLE_SELECTED ON IDN_OAUTH_CONSUMER_APPS.ID = REQUEST_TOKEN_TABLE_SELECTED.CONSUMER_KEY_ID";
        public static final String GET_USERNAME_FOR_KEY_AND_SECRET = "SELECT USERNAME FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=? AND CONSUMER_SECRET=?";

        private OAuthConsumerDAOSQLQueries() {
        }
    }

    public static class OAuthAppDAOSQLQueries {
        public static final String ADD_OAUTH_APP = "INSERT INTO IDN_OAUTH_CONSUMER_APPS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, USER_DOMAIN, APP_NAME, OAUTH_VERSION, CALLBACK_URL, GRANT_TYPES, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?) ";
        public static final String ADD_OAUTH_APP_WITH_PKCE = "INSERT INTO IDN_OAUTH_CONSUMER_APPS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, USER_DOMAIN, APP_NAME, OAUTH_VERSION, CALLBACK_URL, GRANT_TYPES, PKCE_MANDATORY, PKCE_SUPPORT_PLAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
        public static final String ADD_SP_OIDC_PROPERTY = "INSERT INTO IDN_OIDC_PROPERTY (TENANT_ID, CONSUMER_KEY, PROPERTY_KEY, PROPERTY_VALUE) VALUES (?,?,?,?) ";
        public static final String ADD_OAUTH_CONSUMER = "INSERT INTO IDN_OAUTH_CONSUMER_APPS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, USER_DOMAIN, OAUTH_VERSION, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME) VALUES (?,?,?,?,?,?,?,?,?,?) ";
        public static final String UPDATE_OAUTH_CONSUMER = "UPDATE IDN_OAUTH_CONSUMER_APPS SET CONSUMER_SECRET=? WHERE CONSUMER_KEY=? AND USERNAME=? AND TENANT_ID=? AND USER_DOMAIN=?";
        public static final String GET_APPS_OF_USER = "SELECT CONSUMER_KEY, CONSUMER_SECRET, APP_NAME, OAUTH_VERSION, CALLBACK_URL, GRANT_TYPES, ID, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME FROM IDN_OAUTH_CONSUMER_APPS WHERE USERNAME=? AND TENANT_ID=? AND USER_DOMAIN=?";
        public static final String GET_APPS_OF_USER_WITH_TENANTAWARE_OR_TENANTUNAWARE_USERNAME = "SELECT CONSUMER_KEY, CONSUMER_SECRET, APP_NAME, OAUTH_VERSION, CALLBACK_URL, GRANT_TYPES, ID, USERNAME, TENANT_ID ,USER_DOMAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME FROM IDN_OAUTH_CONSUMER_APPS WHERE (USERNAME=? OR USERNAME=?) AND TENANT_ID=?";
        public static final String GET_APPS_OF_USER_WITH_TENANTAWARE_OR_TENANTUNAWARE_USERNAME_WITH_PKCE = "SELECT CONSUMER_KEY, CONSUMER_SECRET, APP_NAME, OAUTH_VERSION, CALLBACK_URL, GRANT_TYPES, ID, USERNAME, TENANT_ID, USER_DOMAIN, PKCE_MANDATORY, PKCE_SUPPORT_PLAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME FROM IDN_OAUTH_CONSUMER_APPS WHERE (USERNAME=? OR USERNAME=?) AND TENANT_ID=?";
        public static final String GET_CONSUMER_APPS_OF_USER = "SELECT CONSUMER_KEY, CONSUMER_SECRET, APP_NAME, OAUTH_VERSION, CALLBACK_URL, GRANT_TYPES, ID, USERNAME, TENANT_ID ,USER_DOMAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME FROM IDN_OAUTH_CONSUMER_APPS WHERE USERNAME=? AND USER_DOMAIN=? AND TENANT_ID=?";
        public static final String GET_CONSUMER_APPS_OF_USER_WITH_PKCE = "SELECT CONSUMER_KEY, CONSUMER_SECRET, APP_NAME, OAUTH_VERSION, CALLBACK_URL, GRANT_TYPES, ID, USERNAME, TENANT_ID, USER_DOMAIN, PKCE_MANDATORY, PKCE_SUPPORT_PLAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME FROM IDN_OAUTH_CONSUMER_APPS WHERE USERNAME=? AND USER_DOMAIN=? AND TENANT_ID=?";
        public static final String GET_APP_INFO = "SELECT CONSUMER_SECRET, USERNAME, APP_NAME, OAUTH_VERSION, CALLBACK_URL, TENANT_ID, USER_DOMAIN, GRANT_TYPES, ID, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME, APP_STATE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=? ";
        public static final String GET_APP_INFO_WITH_PKCE = "SELECT CONSUMER_SECRET,USERNAME,APP_NAME, OAUTH_VERSION, CALLBACK_URL,TENANT_ID, USER_DOMAIN, GRANT_TYPES, ID, PKCE_MANDATORY, PKCE_SUPPORT_PLAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME, APP_STATE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=? ";
        public static final String GET_ALL_SP_OIDC_PROPERTIES = "SELECT PROPERTY_KEY, PROPERTY_VALUE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID = ? AND CONSUMER_KEY = ?";
        public static final String GET_SP_OIDC_PROPERTY = "SELECT PROPERTY_VALUE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID = ? AND CONSUMER_KEY = ? AND PROPERTY_KEY = ?";
        public static final String GET_SP_OIDC_PROPERTY_BY_APP_NAME = "SELECT PROPERTY_VALUE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID = ? AND CONSUMER_KEY = (SELECT CONSUMER_KEY FROM IDN_OAUTH_CONSUMER_APPS WHERE TENANT_ID = ? AND APP_NAME =?) AND PROPERTY_KEY = ?";
        public static final String GET_APP_INFO_BY_APP_NAME = "SELECT CONSUMER_SECRET, USERNAME, USER_DOMAIN, CONSUMER_KEY, OAUTH_VERSION, CALLBACK_URL, GRANT_TYPES, ID, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME FROM IDN_OAUTH_CONSUMER_APPS WHERE APP_NAME=? AND TENANT_ID=? ";
        public static final String GET_APP_INFO_BY_APP_NAME_WITH_PKCE = "SELECT CONSUMER_SECRET,USERNAME,USER_DOMAIN,CONSUMER_KEY, OAUTH_VERSION, CALLBACK_URL,GRANT_TYPES, ID, PKCE_MANDATORY, PKCE_SUPPORT_PLAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME FROM IDN_OAUTH_CONSUMER_APPS WHERE APP_NAME=? AND TENANT_ID=? ";
        public static final String UPDATE_CONSUMER_APP = "UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_NAME=?, CALLBACK_URL=?, GRANT_TYPES=?, USER_ACCESS_TOKEN_EXPIRE_TIME=?, APP_ACCESS_TOKEN_EXPIRE_TIME=?, REFRESH_TOKEN_EXPIRE_TIME=?, ID_TOKEN_EXPIRE_TIME=? WHERE CONSUMER_KEY=?";
        public static final String UPDATE_CONSUMER_APP_WITH_OWNER_UPDATE = "UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_NAME=?, CALLBACK_URL=?, GRANT_TYPES=?, USER_ACCESS_TOKEN_EXPIRE_TIME=?, APP_ACCESS_TOKEN_EXPIRE_TIME=?, REFRESH_TOKEN_EXPIRE_TIME=?, ID_TOKEN_EXPIRE_TIME=?, USERNAME=?, USER_DOMAIN=? WHERE CONSUMER_KEY=?";
        public static final String UPDATE_CONSUMER_APP_WITH_PKCE = "UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_NAME=?, CALLBACK_URL=?, GRANT_TYPES=?, PKCE_MANDATORY=?, PKCE_SUPPORT_PLAIN=?, USER_ACCESS_TOKEN_EXPIRE_TIME=?, APP_ACCESS_TOKEN_EXPIRE_TIME=?, REFRESH_TOKEN_EXPIRE_TIME=?, ID_TOKEN_EXPIRE_TIME=? WHERE CONSUMER_KEY=?";
        public static final String UPDATE_CONSUMER_APP_WITH_PKCE_AND_OWNER_UPDATE = "UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_NAME=?, CALLBACK_URL=?, GRANT_TYPES=?, PKCE_MANDATORY=?, PKCE_SUPPORT_PLAIN=?, USER_ACCESS_TOKEN_EXPIRE_TIME=?, APP_ACCESS_TOKEN_EXPIRE_TIME=?, REFRESH_TOKEN_EXPIRE_TIME=?, ID_TOKEN_EXPIRE_TIME=?, USERNAME=?, USER_DOMAIN=? WHERE CONSUMER_KEY=?";
        public static final String CHECK_EXISTING_APPLICATION = "SELECT * FROM IDN_OAUTH_CONSUMER_APPS WHERE USERNAME=? AND TENANT_ID=? AND USER_DOMAIN=? AND APP_NAME=?";
        public static final String CHECK_EXISTING_CONSUMER = "SELECT * FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
        public static final String GET_APP_NAME = "SELECT APP_NAME FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
        public static final String GET_CONSUMER_KEYS_BY_TENANT_ID = "SELECT CONSUMER_KEY FROM IDN_OAUTH_CONSUMER_APPS WHERE TENANT_ID = ?";
        public static final String REMOVE_SP_ASSOCIATIONS_BY_CONSUMER_ID = "DELETE FROM SP_INBOUND_AUTH WHERE INBOUND_AUTH_KEY = ?";
        public static final String REMOVE_APPLICATION = "DELETE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
        public static final String REMOVE_APPLICATIONS_BY_TENANT_ID = "DELETE FROM IDN_OAUTH_CONSUMER_APPS WHERE TENANT_ID = ?";
        public static final String REMOVE_ALL_SP_OIDC_PROPERTIES = "DELETE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID=? AND CONSUMER_KEY=?";
        public static final String REMOVE_ALL_SP_OIDC_PROPERTIES_BY_TENANT_ID = "DELETE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID = ?";
        public static final String REMOVE_SP_OIDC_PROPERTY = "DELETE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID=? AND CONSUMER_KEY=? AND PROPERTY_KEY=? AND PROPERTY_VALUE=?";
        public static final String UPDATE_OAUTH_INFO = "UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_NAME=? WHERE CONSUMER_KEY=?";
        public static final String UPDATE_OAUTH_SECRET_KEY = "UPDATE IDN_OAUTH_CONSUMER_APPS SET CONSUMER_SECRET=? WHERE CONSUMER_KEY=?";
        public static final String UPDATE_OAUTH_SECRET_KEY_AND_STATE = "UPDATE IDN_OAUTH_CONSUMER_APPS SET CONSUMER_SECRET=?, APP_STATE=? WHERE CONSUMER_KEY=?";
        public static final String UPDATE_SP_OIDC_PROPERTY = "UPDATE IDN_OIDC_PROPERTY SET PROPERTY_VALUE=? WHERE TENANT_ID=? AND CONSUMER_KEY=? AND PROPERTY_KEY=?";
        public static final String GET_APPLICATION_STATE = "SELECT APP_STATE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
        public static final String UPDATE_APPLICATION_STATE = "UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_STATE=? WHERE CONSUMER_KEY=?";
        public static final String GET_APP_ID_BY_CONSUMER_KEY = "SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
        public static final String ADD_APP_SCOPE_VALIDATOR = "INSERT INTO IDN_OAUTH2_SCOPE_VALIDATORS (APP_ID, SCOPE_VALIDATOR) VALUES (?,?) ";
        public static final String GET_APP_SCOPE_VALIDATORS = "SELECT SCOPE_VALIDATOR FROM IDN_OAUTH2_SCOPE_VALIDATORS WHERE APP_ID=?";
        public static final String REMOVE_APP_SCOPE_VALIDATORS = "DELETE FROM IDN_OAUTH2_SCOPE_VALIDATORS WHERE APP_ID=?";

        private OAuthAppDAOSQLQueries() {
        }
    }
}

