/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.Parameters;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.tokenprocessor.PlainTextPersistenceProcessor;
import org.wso2.carbon.identity.oauth.tokenprocessor.TokenPersistenceProcessor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class OAuthConsumerDAO {
    public static final Log LOG = LogFactory.getLog(OAuthConsumerDAO.class);
    public static final String OUT_OF_BAND = "oob";
    private TokenPersistenceProcessor persistenceProcessor;
    private boolean isHashDisabled = OAuth2Util.isHashDisabled();

    public OAuthConsumerDAO() {
        try {
            this.persistenceProcessor = OAuthServerConfiguration.getInstance().getPersistenceProcessor();
        }
        catch (IdentityOAuth2Exception e) {
            LOG.error((Object)"Error retrieving TokenPersistenceProcessor. Defaulting to PlainTextProcessor", (Throwable)((Object)e));
            this.persistenceProcessor = new PlainTextPersistenceProcessor();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOAuthConsumerSecret(String consumerKey) throws IdentityOAuthAdminException {
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        String consumerSecret;
        block8: {
            consumerSecret = null;
            if (!this.isHashDisabled) {
                if (!LOG.isDebugEnabled()) return consumerSecret;
                LOG.debug((Object)"Consumer secret hashing enabled. Returning client secret as null.");
                return consumerSecret;
            }
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            try {
                prepStmt = connection.prepareStatement("SELECT CONSUMER_SECRET FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?");
                prepStmt.setString(1, this.persistenceProcessor.getProcessedClientId(consumerKey));
                resultSet = prepStmt.executeQuery();
                if (resultSet.next()) {
                    consumerSecret = this.persistenceProcessor.getPreprocessedClientSecret(resultSet.getString(1));
                    break block8;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Invalid Consumer Key : " + consumerKey));
                }
            }
            catch (SQLException e) {
                try {
                    throw new IdentityOAuthAdminException("Error when reading the consumer secret for consumer key : " + consumerKey, e);
                    catch (IdentityOAuth2Exception e2) {
                        throw new IdentityOAuthAdminException("Error occurred while processing client id and client secret by TokenPersistenceProcessor", (Throwable)((Object)e2));
                    }
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                    throw throwable;
                }
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return consumerSecret;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConsumerSecretExist(String consumerKey, String consumerSecret) throws IdentityOAuthAdminException {
        Connection connection;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        block7: {
            block6: {
                prepStmt = null;
                resultSet = null;
                connection = null;
                connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
                String consumerSecretHash = this.persistenceProcessor.getProcessedClientSecret(consumerSecret);
                prepStmt = connection.prepareStatement("SELECT CONSUMER_KEY FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=? AND CONSUMER_SECRET=?");
                prepStmt.setString(1, this.persistenceProcessor.getProcessedClientId(consumerKey));
                prepStmt.setString(2, consumerSecretHash);
                resultSet = prepStmt.executeQuery();
                if (!resultSet.next()) break block6;
                boolean bl = true;
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
                return bl;
            }
            try {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)String.format("Invalid Consumer Secret : %s for Consumer Key : %s", consumerSecret, consumerKey));
            }
            catch (SQLException e) {
                try {
                    throw new IdentityOAuthAdminException("Error when reading the consumer key for consumer secret : " + consumerSecret, e);
                    catch (IdentityOAuth2Exception e2) {
                        throw new IdentityOAuthAdminException("Error occurred while processing client secret ", (Throwable)((Object)e2));
                    }
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                    throw throwable;
                }
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return false;
    }

    public void updateSecretKey(String consumerKey, String newSecretKey) throws IdentityApplicationManagementException {
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
            statement = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET CONSUMER_SECRET=? WHERE CONSUMER_KEY=?");
            statement.setString(1, newSecretKey);
            statement.setString(2, consumerKey);
            statement.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityApplicationManagementException("Error while executing the SQL statement.", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)statement);
        }
    }

    public String getAuthenticatedUsername(String clientId, String clientSecret) throws IdentityOAuthAdminException {
        ResultSet resultSet;
        PreparedStatement prepStmt;
        Connection connection;
        String username;
        block5: {
            username = "";
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            resultSet = null;
            try {
                prepStmt = connection.prepareStatement("SELECT USERNAME FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=? AND CONSUMER_SECRET=?");
                prepStmt.setString(1, clientId);
                prepStmt.setString(2, clientSecret);
                resultSet = prepStmt.executeQuery();
                if (resultSet.next()) {
                    username = resultSet.getString(1);
                    break block5;
                }
                LOG.debug((Object)("Invalid client id : " + clientId));
            }
            catch (SQLException e) {
                try {
                    LOG.error((Object)"Error when executing the SQL : SELECT USERNAME FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=? AND CONSUMER_SECRET=?");
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    throw new IdentityOAuthAdminException("Error while reading username for client id : " + clientId + ", and consumer secret : " + clientSecret);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                    throw throwable;
                }
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return username;
    }

    public String getOAuthTokenSecret(String token, Boolean isAccessToken) throws IdentityException {
        String tokenSecret = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        String sqlStmt = isAccessToken != false ? "SELECT ACCESS_TOKEN_SECRET FROM IDN_OAUTH1A_ACCESS_TOKEN WHERE ACCESS_TOKEN=?" : "SELECT REQUEST_TOKEN_SECRET FROM IDN_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?";
        try {
            prepStmt = connection.prepareStatement(sqlStmt);
            prepStmt.setString(1, token);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) {
                throw IdentityException.error((String)("Invalid token : " + token));
            }
            tokenSecret = resultSet.getString(1);
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuthAdminException("Error when reading the token secret for token : " + token, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return tokenSecret;
    }

    public void createOAuthRequestToken(String consumerKey, String oauthToken, String oauthSecret, String userCallback, String scope) throws IdentityOAuthAdminException {
        if (userCallback == null || OUT_OF_BAND.equals(userCallback)) {
            userCallback = this.getCallbackURLOfApp(consumerKey);
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("INSERT INTO IDN_OAUTH1A_REQUEST_TOKEN (REQUEST_TOKEN, REQUEST_TOKEN_SECRET, CONSUMER_KEY_ID, CALLBACK_URL, SCOPE, AUTHORIZED) SELECT ?,?,ID,?,?,? FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?");
            prepStmt.setString(1, oauthToken);
            prepStmt.setString(2, oauthSecret);
            prepStmt.setString(3, userCallback);
            prepStmt.setString(4, scope);
            prepStmt.setString(5, Boolean.toString(false));
            prepStmt.setString(6, consumerKey);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuthAdminException("Error when creating the request token for consumer : " + consumerKey, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
    }

    public Parameters authorizeOAuthToken(String oauthToken, String userName, String oauthVerifier) throws IdentityException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH1A_REQUEST_TOKEN SET AUTHORIZED=?, OAUTH_VERIFIER=?, AUTHZ_USER=? WHERE REQUEST_TOKEN=?");
            prepStmt.setString(1, Boolean.toString(true));
            prepStmt.setString(2, oauthVerifier);
            prepStmt.setString(3, userName);
            prepStmt.setString(4, oauthToken);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuthAdminException("Error when authorizing the request token : " + oauthToken);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
        Parameters params = new Parameters();
        params.setOauthCallback(this.getCallbackURLOfReqToken(oauthToken));
        return params;
    }

    public Parameters getRequestToken(String oauthToken) throws IdentityException {
        Parameters params = new Parameters();
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            prepStmt = connection.prepareStatement("SELECT * FROM IDN_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?");
            prepStmt.setString(1, oauthToken);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) {
                throw IdentityException.error((String)("Invalid request token : " + oauthToken));
            }
            params.setOauthToken(resultSet.getString(1));
            params.setOauthTokenSecret(resultSet.getString(2));
            params.setOauthConsumerKey(resultSet.getString(3));
            params.setOauthCallback(resultSet.getString(4));
            params.setScope(resultSet.getString(5));
            params.setOauthTokenVerifier(resultSet.getString(7));
            params.setAuthorizedbyUserName(resultSet.getString(8));
        }
        catch (SQLException e) {
            try {
                throw IdentityException.error((String)("Error when retrieving request token from the persistence store : " + oauthToken));
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return params;
    }

    public void issueAccessToken(String consumerKey, String accessToken, String accessTokenSecret, String requestToken, String authorizedUser, String scope) throws IdentityOAuthAdminException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement removeReqTokStmt = null;
        PreparedStatement issueAccessTokStmt = null;
        try {
            removeReqTokStmt = connection.prepareStatement("DELETE FROM IDN_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?");
            removeReqTokStmt.setString(1, requestToken);
            removeReqTokStmt.execute();
            issueAccessTokStmt = connection.prepareStatement("INSERT INTO IDN_OAUTH1A_ACCESS_TOKEN VALUES (?,?,?,?,?)");
            issueAccessTokStmt.setString(1, accessToken);
            issueAccessTokStmt.setString(2, accessTokenSecret);
            issueAccessTokStmt.setString(3, consumerKey);
            issueAccessTokStmt.setString(4, scope);
            issueAccessTokStmt.setString(5, authorizedUser);
            issueAccessTokStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuthAdminException("Error when creating the request token for consumer : " + consumerKey, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(issueAccessTokStmt);
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)removeReqTokStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)issueAccessTokStmt);
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)removeReqTokStmt);
    }

    public String validateAccessToken(String consumerKey, String oauthToken, String reqScope) throws IdentityException {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        String scope = null;
        String authorizedUser = null;
        try {
            prepStmt = connection.prepareStatement("SELECT SCOPE, AUTHZ_USER FROM IDN_OAUTH1A_ACCESS_TOKEN WHERE ACCESS_TOKEN=?");
            prepStmt.setString(1, oauthToken);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) {
                throw IdentityException.error((String)("Invalid access token : " + oauthToken));
            }
            scope = resultSet.getString(1);
            authorizedUser = resultSet.getString(2);
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuthAdminException("Error when reading the callback url for consumer key : " + consumerKey, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        if (reqScope != null && reqScope.equals(scope)) {
            return authorizedUser;
        }
        throw IdentityException.error((String)"Scope of the access token doesn't match with the original scope");
    }

    private String getCallbackURLOfApp(String consumerKey) throws IdentityOAuthAdminException {
        String callbackURL = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            prepStmt = connection.prepareStatement("SELECT CALLBACK_URL FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?");
            prepStmt.setString(1, consumerKey);
            resultSet = prepStmt.executeQuery();
            if (resultSet.next()) {
                callbackURL = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuthAdminException("Error when reading the callback url for consumer key : " + consumerKey, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return callbackURL;
    }

    private String getCallbackURLOfReqToken(String oauthToken) throws IdentityOAuthAdminException {
        String callbackURL = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            prepStmt = connection.prepareStatement("SELECT CALLBACK_URL FROM IDN_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?");
            prepStmt.setString(1, oauthToken);
            resultSet = prepStmt.executeQuery();
            if (resultSet.next()) {
                callbackURL = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityOAuthAdminException("Error when reading the callback url for OAuth Token : " + oauthToken, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return callbackURL;
    }
}

