/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth.tokenprocessor.PlainTextPersistenceProcessor;
import org.wso2.carbon.identity.oauth.tokenprocessor.TokenPersistenceProcessor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.DBUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuthAppDAO {
    private static final Log LOG = LogFactory.getLog(OAuthAppDAO.class);
    private static final String APP_STATE = "APP_STATE";
    private static final String USERNAME = "USERNAME";
    private static final String LOWER_USERNAME = "LOWER(USERNAME)";
    private TokenPersistenceProcessor persistenceProcessor;
    private boolean isHashDisabled = OAuth2Util.isHashDisabled();

    public OAuthAppDAO() {
        try {
            this.persistenceProcessor = OAuthServerConfiguration.getInstance().getPersistenceProcessor();
        }
        catch (IdentityOAuth2Exception e) {
            LOG.error((Object)"Error retrieving TokenPersistenceProcessor. Defaulting to PlainTextPersistenceProcessor");
            this.persistenceProcessor = new PlainTextPersistenceProcessor();
        }
    }

    public void addOAuthApplication(OAuthAppDO consumerAppDO) throws IdentityOAuthAdminException {
        block47: {
            int spTenantId = IdentityTenantUtil.getTenantId((String)consumerAppDO.getUser().getTenantDomain());
            String userStoreDomain = consumerAppDO.getUser().getUserStoreDomain();
            if (!this.isDuplicateApplication(consumerAppDO.getUser().getUserName(), spTenantId, userStoreDomain, consumerAppDO)) {
                int appId = 0;
                try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
                    try {
                        String processedClientId = this.persistenceProcessor.getProcessedClientId(consumerAppDO.getOauthConsumerKey());
                        String processedClientSecret = this.persistenceProcessor.getProcessedClientSecret(consumerAppDO.getOauthConsumerSecret());
                        String dbProductName = connection.getMetaData().getDatabaseProductName();
                        try (PreparedStatement prepStmt = connection.prepareStatement("INSERT INTO IDN_OAUTH_CONSUMER_APPS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, USER_DOMAIN, APP_NAME, OAUTH_VERSION, CALLBACK_URL, GRANT_TYPES, PKCE_MANDATORY, PKCE_SUPPORT_PLAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ", new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});){
                            prepStmt.setString(1, processedClientId);
                            prepStmt.setString(2, processedClientSecret);
                            prepStmt.setString(3, consumerAppDO.getUser().getUserName());
                            prepStmt.setInt(4, spTenantId);
                            prepStmt.setString(5, userStoreDomain);
                            prepStmt.setString(6, consumerAppDO.getApplicationName());
                            prepStmt.setString(7, consumerAppDO.getOauthVersion());
                            prepStmt.setString(8, consumerAppDO.getCallbackUrl());
                            prepStmt.setString(9, consumerAppDO.getGrantTypes());
                            prepStmt.setString(10, consumerAppDO.isPkceMandatory() ? "1" : "0");
                            prepStmt.setString(11, consumerAppDO.isPkceSupportPlain() ? "1" : "0");
                            prepStmt.setLong(12, consumerAppDO.getUserAccessTokenExpiryTime());
                            prepStmt.setLong(13, consumerAppDO.getApplicationAccessTokenExpiryTime());
                            prepStmt.setLong(14, consumerAppDO.getRefreshTokenExpiryTime());
                            prepStmt.setLong(15, consumerAppDO.getIdTokenExpiryTime());
                            prepStmt.execute();
                            try (ResultSet results = prepStmt.getGeneratedKeys();){
                                if (results.next()) {
                                    appId = results.getInt(1);
                                }
                            }
                        }
                        if (appId == 0) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("JDBC Driver did not returning the app id of the newly created app " + consumerAppDO.getApplicationName() + ". So executing select operation to get the id"));
                            }
                            appId = this.getAppIdByClientId(connection, consumerAppDO.getOauthConsumerKey());
                        }
                        this.addScopeValidators(connection, appId, consumerAppDO.getScopeValidators());
                        this.addServiceProviderOIDCProperties(connection, consumerAppDO, processedClientId, spTenantId);
                        IdentityDatabaseUtil.commitTransaction((Connection)connection);
                        break block47;
                    }
                    catch (SQLException e1) {
                        IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                        throw OAuthUtil.handleError(String.format("Error when executing SQL to create OAuth app %s@%s ", consumerAppDO.getApplicationName(), consumerAppDO.getUser().getTenantDomain()), e1);
                    }
                }
                catch (SQLException e) {
                    throw OAuthUtil.handleError(String.format("Error when executing SQL to create OAuth app %s@%s ", consumerAppDO.getApplicationName(), consumerAppDO.getUser().getTenantDomain()), e);
                }
                catch (IdentityOAuth2Exception e) {
                    throw OAuthUtil.handleError("Error occurred while processing the client id and client secret by TokenPersistenceProcessor", null);
                }
                catch (InvalidOAuthClientException e) {
                    throw OAuthUtil.handleError("Error occurred while processing client id", (Exception)((Object)e));
                }
            }
            String message = "Error when adding the application. An application with the same name already exists.";
            throw OAuthUtil.handleError(message, null);
        }
    }

    public String[] addOAuthConsumer(String username, int tenantId, String userDomain) throws IdentityOAuthAdminException {
        String consumerKey;
        String consumerSecret = OAuthUtil.getRandomNumber();
        long userAccessTokenExpireTime = OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds();
        long applicationAccessTokenExpireTime = OAuthServerConfiguration.getInstance().getApplicationAccessTokenValidityPeriodInSeconds();
        long refreshTokenExpireTime = OAuthServerConfiguration.getInstance().getRefreshTokenValidityPeriodInSeconds();
        long idTokenExpireTime = OAuthServerConfiguration.getInstance().getOpenIDConnectIDTokenExpiryTimeInSeconds();
        while (this.isDuplicateConsumer(consumerKey = OAuthUtil.getRandomNumber())) {
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement prepStmt = connection.prepareStatement("INSERT INTO IDN_OAUTH_CONSUMER_APPS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, USER_DOMAIN, OAUTH_VERSION, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME) VALUES (?,?,?,?,?,?,?,?,?,?) ");){
                prepStmt.setString(1, consumerKey);
                prepStmt.setString(2, consumerSecret);
                prepStmt.setString(3, username);
                prepStmt.setInt(4, tenantId);
                prepStmt.setString(5, userDomain);
                prepStmt.setString(6, "OAuth-1.0a");
                prepStmt.setLong(7, userAccessTokenExpireTime);
                prepStmt.setLong(8, applicationAccessTokenExpireTime);
                prepStmt.setLong(9, refreshTokenExpireTime);
                prepStmt.setLong(10, idTokenExpireTime);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String sqlStmt = "INSERT INTO IDN_OAUTH_CONSUMER_APPS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, USER_DOMAIN, OAUTH_VERSION, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME) VALUES (?,?,?,?,?,?,?,?,?,?) ";
                throw OAuthUtil.handleError("Error when executing the SQL : " + sqlStmt, e1);
            }
        }
        catch (SQLException e) {
            String sqlStmt = "INSERT INTO IDN_OAUTH_CONSUMER_APPS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, USER_DOMAIN, OAUTH_VERSION, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME) VALUES (?,?,?,?,?,?,?,?,?,?) ";
            throw OAuthUtil.handleError("Error when executing the SQL : " + sqlStmt, e);
        }
        return new String[]{consumerKey, consumerSecret};
    }

    public OAuthAppDO[] getOAuthConsumerAppsOfUser(String username, int tenantId) throws IdentityOAuthAdminException {
        OAuthAppDO[] oauthAppsOfUser;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            RealmService realmService = OAuthComponentServiceHolder.getInstance().getRealmService();
            String tenantDomain = realmService.getTenantManager().getDomain(tenantId);
            String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)username);
            String tenantQualifiedUsername = UserCoreUtil.addTenantDomainToEntry((String)tenantAwareUserName, (String)tenantDomain);
            boolean isUsernameCaseSensitive = this.isUsernameCaseSensitive(tenantQualifiedUsername);
            String sql = "SELECT CONSUMER_KEY, CONSUMER_SECRET, APP_NAME, OAUTH_VERSION, CALLBACK_URL, GRANT_TYPES, ID, USERNAME, TENANT_ID, USER_DOMAIN, PKCE_MANDATORY, PKCE_SUPPORT_PLAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME FROM IDN_OAUTH_CONSUMER_APPS WHERE USERNAME=? AND USER_DOMAIN=? AND TENANT_ID=?";
            if (!isUsernameCaseSensitive) {
                sql = sql.replace(USERNAME, LOWER_USERNAME);
            }
            try (PreparedStatement prepStmt = connection.prepareStatement(sql);){
                if (isUsernameCaseSensitive) {
                    prepStmt.setString(1, UserCoreUtil.removeDomainFromName((String)tenantAwareUserName));
                } else {
                    prepStmt.setString(1, UserCoreUtil.removeDomainFromName((String)tenantAwareUserName).toLowerCase());
                }
                prepStmt.setString(2, IdentityUtil.extractDomainFromName((String)tenantAwareUserName));
                prepStmt.setInt(3, tenantId);
                try (ResultSet rSet = prepStmt.executeQuery();){
                    ArrayList<OAuthAppDO> oauthApps = new ArrayList<OAuthAppDO>();
                    while (rSet.next()) {
                        if (rSet.getString(3) == null || rSet.getString(3).length() <= 0) continue;
                        OAuthAppDO oauthApp = new OAuthAppDO();
                        String preprocessedClientId = this.persistenceProcessor.getPreprocessedClientId(rSet.getString(1));
                        oauthApp.setOauthConsumerKey(preprocessedClientId);
                        oauthApp.setOauthConsumerKey(this.persistenceProcessor.getPreprocessedClientId(rSet.getString(1)));
                        if (this.isHashDisabled) {
                            oauthApp.setOauthConsumerSecret(this.persistenceProcessor.getPreprocessedClientSecret(rSet.getString(2)));
                        }
                        oauthApp.setApplicationName(rSet.getString(3));
                        oauthApp.setOauthVersion(rSet.getString(4));
                        oauthApp.setCallbackUrl(rSet.getString(5));
                        oauthApp.setGrantTypes(rSet.getString(6));
                        oauthApp.setId(rSet.getInt(7));
                        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
                        authenticatedUser.setUserName(rSet.getString(8));
                        authenticatedUser.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)rSet.getInt(9)));
                        authenticatedUser.setUserStoreDomain(rSet.getString(10));
                        oauthApp.setPkceMandatory(!"0".equals(rSet.getString(11)));
                        oauthApp.setPkceSupportPlain(!"0".equals(rSet.getString(12)));
                        oauthApp.setUserAccessTokenExpiryTime(rSet.getLong(13));
                        oauthApp.setApplicationAccessTokenExpiryTime(rSet.getLong(14));
                        oauthApp.setRefreshTokenExpiryTime(rSet.getLong(15));
                        oauthApp.setIdTokenExpiryTime(rSet.getLong(16));
                        oauthApp.setUser(authenticatedUser);
                        String spTenantDomain = authenticatedUser.getTenantDomain();
                        this.handleSpOIDCProperties(connection, preprocessedClientId, spTenantDomain, oauthApp);
                        oauthApp.setScopeValidators(this.getScopeValidators(connection, oauthApp.getId()));
                        oauthApps.add(oauthApp);
                    }
                    oauthAppsOfUser = oauthApps.toArray(new OAuthAppDO[oauthApps.size()]);
                }
            }
        }
        catch (SQLException e) {
            throw OAuthUtil.handleError("Error occurred while retrieving OAuth consumer apps of user", e);
        }
        catch (UserStoreException e) {
            throw OAuthUtil.handleError("Error while retrieving Tenant Domain for tenant ID : " + tenantId, (Exception)((Object)e));
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error occurred while processing client id and client secret by TokenPersistenceProcessor", (Exception)((Object)e));
        }
        return oauthAppsOfUser;
    }

    public OAuthAppDO getAppInformation(String consumerKey) throws InvalidOAuthClientException, IdentityOAuth2Exception {
        OAuthAppDO oauthApp = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            String sqlQuery = "SELECT CONSUMER_SECRET,USERNAME,APP_NAME, OAUTH_VERSION, CALLBACK_URL,TENANT_ID, USER_DOMAIN, GRANT_TYPES, ID, PKCE_MANDATORY, PKCE_SUPPORT_PLAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME, APP_STATE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=? ";
            try (PreparedStatement prepStmt = connection.prepareStatement(sqlQuery);){
                String preprocessedClientId = this.persistenceProcessor.getProcessedClientId(consumerKey);
                prepStmt.setString(1, preprocessedClientId);
                try (ResultSet rSet = prepStmt.executeQuery();){
                    boolean appExists = false;
                    while (rSet.next()) {
                        appExists = true;
                        if (rSet.getString(4) == null || rSet.getString(4).length() <= 0) continue;
                        oauthApp = new OAuthAppDO();
                        oauthApp.setOauthConsumerKey(consumerKey);
                        if (this.isHashDisabled) {
                            oauthApp.setOauthConsumerSecret(this.persistenceProcessor.getPreprocessedClientSecret(rSet.getString(1)));
                        } else {
                            oauthApp.setOauthConsumerSecret(rSet.getString(1));
                        }
                        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
                        authenticatedUser.setUserName(rSet.getString(2));
                        oauthApp.setApplicationName(rSet.getString(3));
                        oauthApp.setOauthVersion(rSet.getString(4));
                        oauthApp.setCallbackUrl(rSet.getString(5));
                        authenticatedUser.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)rSet.getInt(6)));
                        authenticatedUser.setUserStoreDomain(rSet.getString(7));
                        oauthApp.setUser(authenticatedUser);
                        oauthApp.setGrantTypes(rSet.getString(8));
                        oauthApp.setId(rSet.getInt(9));
                        oauthApp.setPkceMandatory(!"0".equals(rSet.getString(10)));
                        oauthApp.setPkceSupportPlain(!"0".equals(rSet.getString(11)));
                        oauthApp.setUserAccessTokenExpiryTime(rSet.getLong(12));
                        oauthApp.setApplicationAccessTokenExpiryTime(rSet.getLong(13));
                        oauthApp.setRefreshTokenExpiryTime(rSet.getLong(14));
                        oauthApp.setIdTokenExpiryTime(rSet.getLong(15));
                        oauthApp.setState(rSet.getString(16));
                        String spTenantDomain = authenticatedUser.getTenantDomain();
                        this.handleSpOIDCProperties(connection, preprocessedClientId, spTenantDomain, oauthApp);
                        oauthApp.setScopeValidators(this.getScopeValidators(connection, oauthApp.getId()));
                    }
                    if (!appExists) {
                        this.handleRequestForANonExistingConsumerKey(consumerKey);
                    }
                    connection.commit();
                }
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error while retrieving the app information", e);
        }
        return oauthApp;
    }

    public OAuthAppDO getAppInformationByAppName(String appName) throws InvalidOAuthClientException, IdentityOAuth2Exception {
        OAuthAppDO oauthApp;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            String sqlQuery = "SELECT CONSUMER_SECRET,USERNAME,USER_DOMAIN,CONSUMER_KEY, OAUTH_VERSION, CALLBACK_URL,GRANT_TYPES, ID, PKCE_MANDATORY, PKCE_SUPPORT_PLAIN, USER_ACCESS_TOKEN_EXPIRE_TIME, APP_ACCESS_TOKEN_EXPIRE_TIME, REFRESH_TOKEN_EXPIRE_TIME, ID_TOKEN_EXPIRE_TIME FROM IDN_OAUTH_CONSUMER_APPS WHERE APP_NAME=? AND TENANT_ID=? ";
            try (PreparedStatement prepStmt = connection.prepareStatement(sqlQuery);){
                prepStmt.setString(1, appName);
                prepStmt.setInt(2, tenantID);
                try (ResultSet rSet = prepStmt.executeQuery();){
                    oauthApp = new OAuthAppDO();
                    oauthApp.setApplicationName(appName);
                    AuthenticatedUser user = new AuthenticatedUser();
                    user.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)tenantID));
                    boolean appExists = false;
                    while (rSet.next()) {
                        appExists = true;
                        if (rSet.getString(4) == null || rSet.getString(4).length() <= 0) continue;
                        if (this.isHashDisabled) {
                            oauthApp.setOauthConsumerSecret(this.persistenceProcessor.getPreprocessedClientSecret(rSet.getString(1)));
                        } else {
                            oauthApp.setOauthConsumerSecret(rSet.getString(1));
                        }
                        user.setUserName(rSet.getString(2));
                        user.setUserStoreDomain(rSet.getString(3));
                        oauthApp.setUser(user);
                        String preprocessedClientId = this.persistenceProcessor.getPreprocessedClientId(rSet.getString(4));
                        oauthApp.setOauthConsumerKey(preprocessedClientId);
                        oauthApp.setOauthVersion(rSet.getString(5));
                        oauthApp.setCallbackUrl(rSet.getString(6));
                        oauthApp.setGrantTypes(rSet.getString(7));
                        oauthApp.setId(rSet.getInt(8));
                        oauthApp.setPkceMandatory(!"0".equals(rSet.getString(9)));
                        oauthApp.setPkceSupportPlain(!"0".equals(rSet.getString(10)));
                        oauthApp.setUserAccessTokenExpiryTime(rSet.getLong(11));
                        oauthApp.setApplicationAccessTokenExpiryTime(rSet.getLong(12));
                        oauthApp.setRefreshTokenExpiryTime(rSet.getLong(13));
                        oauthApp.setIdTokenExpiryTime(rSet.getLong(14));
                        String spTenantDomain = user.getTenantDomain();
                        this.handleSpOIDCProperties(connection, preprocessedClientId, spTenantDomain, oauthApp);
                        oauthApp.setScopeValidators(this.getScopeValidators(connection, oauthApp.getId()));
                    }
                    if (!appExists) {
                        this.handleRequestForANonExistingApp(appName);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error while retrieving the app information", e);
        }
        return oauthApp;
    }

    public void updateConsumerApplication(OAuthAppDO oauthAppDO) throws IdentityOAuthAdminException {
        boolean isUserValidForOwnerUpdate = this.validateUserForOwnerUpdate(oauthAppDO);
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            String sqlQuery = this.getSqlQuery(isUserValidForOwnerUpdate);
            try (PreparedStatement prepStmt = connection.prepareStatement(sqlQuery);){
                prepStmt.setString(1, oauthAppDO.getApplicationName());
                prepStmt.setString(2, oauthAppDO.getCallbackUrl());
                prepStmt.setString(3, oauthAppDO.getGrantTypes());
                if (isUserValidForOwnerUpdate) {
                    this.setValuesToStatementWithPKCEAndOwnerUpdate(oauthAppDO, prepStmt);
                } else {
                    this.setValuesToStatementWithPKCENoOwnerUpdate(oauthAppDO, prepStmt);
                }
                int count = prepStmt.executeUpdate();
                this.updateScopeValidators(connection, oauthAppDO.getId(), oauthAppDO.getScopeValidators());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No. of records updated for updating consumer application. : " + count));
                }
                this.addOrUpdateOIDCSpProperty(oauthAppDO, connection);
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw OAuthUtil.handleError("Error when updating OAuth application", e1);
            }
        }
        catch (SQLException e) {
            throw OAuthUtil.handleError("Error when updating OAuth application", e);
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error occurred while processing client id and client secret by TokenPersistenceProcessor", (Exception)((Object)e));
        }
    }

    private boolean validateUserForOwnerUpdate(OAuthAppDO oAuthAppDO) throws IdentityOAuthAdminException {
        try {
            UserRealm realm;
            String userName = null;
            String usernameWithDomain = null;
            if (oAuthAppDO.getAppOwner() != null) {
                userName = oAuthAppDO.getAppOwner().getUserName();
                if (StringUtils.isEmpty((String)userName) || "wso2.system.user".equals(userName)) {
                    return false;
                }
                String domainName = oAuthAppDO.getAppOwner().getUserStoreDomain();
                usernameWithDomain = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
            }
            if ((realm = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUserRealm()) == null || StringUtils.isEmpty(usernameWithDomain)) {
                return false;
            }
            boolean isUserExist = realm.getUserStoreManager().isExistingUser(usernameWithDomain);
            if (!isUserExist) {
                throw new IdentityOAuthAdminException("User validation failed for owner update in the application: " + oAuthAppDO.getApplicationName() + " as user is not existing.");
            }
        }
        catch (UserStoreException e) {
            throw OAuthUtil.handleError("User validation failed for owner update in the application: " + oAuthAppDO.getApplicationName(), (Exception)((Object)e));
        }
        return true;
    }

    private String getSqlQuery(boolean isUserValidForOwnerUpdate) {
        String sqlQuery = isUserValidForOwnerUpdate ? "UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_NAME=?, CALLBACK_URL=?, GRANT_TYPES=?, PKCE_MANDATORY=?, PKCE_SUPPORT_PLAIN=?, USER_ACCESS_TOKEN_EXPIRE_TIME=?, APP_ACCESS_TOKEN_EXPIRE_TIME=?, REFRESH_TOKEN_EXPIRE_TIME=?, ID_TOKEN_EXPIRE_TIME=?, USERNAME=?, USER_DOMAIN=? WHERE CONSUMER_KEY=?" : "UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_NAME=?, CALLBACK_URL=?, GRANT_TYPES=?, PKCE_MANDATORY=?, PKCE_SUPPORT_PLAIN=?, USER_ACCESS_TOKEN_EXPIRE_TIME=?, APP_ACCESS_TOKEN_EXPIRE_TIME=?, REFRESH_TOKEN_EXPIRE_TIME=?, ID_TOKEN_EXPIRE_TIME=? WHERE CONSUMER_KEY=?";
        return sqlQuery;
    }

    private void setValuesToStatementWithPKCEAndOwnerUpdate(OAuthAppDO oauthAppDO, PreparedStatement prepStmt) throws SQLException, IdentityOAuth2Exception {
        prepStmt.setString(4, oauthAppDO.isPkceMandatory() ? "1" : "0");
        prepStmt.setString(5, oauthAppDO.isPkceSupportPlain() ? "1" : "0");
        prepStmt.setLong(6, oauthAppDO.getUserAccessTokenExpiryTime());
        prepStmt.setLong(7, oauthAppDO.getApplicationAccessTokenExpiryTime());
        prepStmt.setLong(8, oauthAppDO.getRefreshTokenExpiryTime());
        prepStmt.setLong(9, oauthAppDO.getIdTokenExpiryTime());
        prepStmt.setString(10, oauthAppDO.getAppOwner().getUserName());
        prepStmt.setString(11, oauthAppDO.getAppOwner().getUserStoreDomain());
        prepStmt.setString(12, this.persistenceProcessor.getProcessedClientId(oauthAppDO.getOauthConsumerKey()));
    }

    private void setValuesToStatementWithPKCENoOwnerUpdate(OAuthAppDO oauthAppDO, PreparedStatement prepStmt) throws SQLException, IdentityOAuth2Exception {
        prepStmt.setString(4, oauthAppDO.isPkceMandatory() ? "1" : "0");
        prepStmt.setString(5, oauthAppDO.isPkceSupportPlain() ? "1" : "0");
        prepStmt.setLong(6, oauthAppDO.getUserAccessTokenExpiryTime());
        prepStmt.setLong(7, oauthAppDO.getApplicationAccessTokenExpiryTime());
        prepStmt.setLong(8, oauthAppDO.getRefreshTokenExpiryTime());
        prepStmt.setLong(9, oauthAppDO.getIdTokenExpiryTime());
        prepStmt.setString(10, this.persistenceProcessor.getProcessedClientId(oauthAppDO.getOauthConsumerKey()));
    }

    private void addOrUpdateOIDCSpProperty(OAuthAppDO oauthAppDO, Connection connection) throws IdentityOAuth2Exception, SQLException {
        String preprocessedClientId = this.persistenceProcessor.getPreprocessedClientId(oauthAppDO.getOauthConsumerKey());
        String spTenantDomain = oauthAppDO.getUser().getTenantDomain();
        int spTenantId = IdentityTenantUtil.getTenantId((String)spTenantDomain);
        Map<String, List<String>> spOIDCProperties = this.getSpOIDCProperties(connection, preprocessedClientId, spTenantDomain);
        PreparedStatement prepStatementForPropertyAdd = connection.prepareStatement("INSERT INTO IDN_OIDC_PROPERTY (TENANT_ID, CONSUMER_KEY, PROPERTY_KEY, PROPERTY_VALUE) VALUES (?,?,?,?) ");
        PreparedStatement preparedStatementForPropertyUpdate = connection.prepareStatement("UPDATE IDN_OIDC_PROPERTY SET PROPERTY_VALUE=? WHERE TENANT_ID=? AND CONSUMER_KEY=? AND PROPERTY_KEY=?");
        PreparedStatement prepStatementForPropertyDelete = connection.prepareStatement("DELETE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID=? AND CONSUMER_KEY=? AND PROPERTY_KEY=? AND PROPERTY_VALUE=?");
        if (this.isOIDCAudienceEnabled()) {
            String[] audiences = oauthAppDO.getAudiences();
            HashSet newAudiences = audiences == null ? new HashSet() : new HashSet<String>(Arrays.asList(audiences));
            List<String> oidcAudienceList = this.getOIDCAudiences(spTenantDomain, oauthAppDO.getOauthConsumerKey());
            HashSet currentAudiences = oidcAudienceList == null ? new HashSet() : new HashSet<String>(oidcAudienceList);
            HashSet newAudienceClone = (HashSet)newAudiences.clone();
            newAudiences.removeAll(currentAudiences);
            currentAudiences.removeAll(newAudienceClone);
            for (String deletedAudience : currentAudiences) {
                this.addToBatchForOIDCPropertyDelete(preprocessedClientId, spTenantId, prepStatementForPropertyDelete, "audience", deletedAudience);
            }
            for (String addedAudience : newAudiences) {
                this.addToBatchForOIDCPropertyAdd(preprocessedClientId, spTenantId, prepStatementForPropertyAdd, "audience", addedAudience);
            }
        }
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "requestObjectSigned", String.valueOf(oauthAppDO.isRequestObjectSignatureValidationEnabled()), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "idTokenEncrypted", String.valueOf(oauthAppDO.isIdTokenEncryptionEnabled()), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "idTokenEncryptionAlgorithm", String.valueOf(oauthAppDO.getIdTokenEncryptionAlgorithm()), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "idTokenEncryptionMethod", String.valueOf(oauthAppDO.getIdTokenEncryptionMethod()), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "backChannelLogoutURL", oauthAppDO.getBackChannelLogoutUrl(), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "frontchannelLogoutURL", oauthAppDO.getFrontchannelLogoutUrl(), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "tokenType", oauthAppDO.getTokenType(), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "bypassClientCredentials", String.valueOf(oauthAppDO.isBypassClientCredentials()), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "renewRefreshToken", oauthAppDO.getRenewRefreshTokenEnabled(), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        if ("None".equalsIgnoreCase(oauthAppDO.getTokenBindingType())) {
            oauthAppDO.setTokenType(null);
        }
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "tokenBindingType", oauthAppDO.getTokenBindingType(), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        if (oauthAppDO.getTokenBindingType() == null) {
            oauthAppDO.setTokenRevocationWithIDPSessionTerminationEnabled(false);
            oauthAppDO.setTokenBindingValidationEnabled(false);
        }
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "tokenRevocationWithIDPSessionTermination", String.valueOf(oauthAppDO.isTokenRevocationWithIDPSessionTerminationEnabled()), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        this.addOrUpdateOIDCSpProperty(preprocessedClientId, spTenantId, spOIDCProperties, "tokenBindingValidation", String.valueOf(oauthAppDO.isTokenBindingValidationEnabled()), prepStatementForPropertyAdd, preparedStatementForPropertyUpdate);
        prepStatementForPropertyAdd.executeBatch();
        preparedStatementForPropertyUpdate.executeBatch();
        prepStatementForPropertyDelete.executeBatch();
    }

    private void addOrUpdateOIDCSpProperty(String preprocessedClientId, int spTenantId, Map<String, List<String>> spOIDCProperties, String propertyKey, String propertyValue, PreparedStatement preparedStatementForPropertyAdd, PreparedStatement preparedStatementForPropertyUpdate) throws SQLException {
        if (this.propertyAlreadyExists(spOIDCProperties, propertyKey)) {
            this.addToBatchForOIDCPropertyUpdate(preprocessedClientId, spTenantId, preparedStatementForPropertyUpdate, propertyKey, propertyValue);
        } else {
            this.addToBatchForOIDCPropertyAdd(preprocessedClientId, spTenantId, preparedStatementForPropertyAdd, propertyKey, propertyValue);
        }
    }

    private void addToBatchForOIDCPropertyAdd(String consumerKey, int tenantId, PreparedStatement preparedStatement, String propertyKey, String propertyValue) throws SQLException {
        preparedStatement.setInt(1, tenantId);
        preparedStatement.setString(2, consumerKey);
        preparedStatement.setString(3, propertyKey);
        preparedStatement.setString(4, propertyValue);
        preparedStatement.addBatch();
    }

    private void addToBatchForOIDCPropertyDelete(String consumerKey, int tenantId, PreparedStatement preparedStatement, String propertyKey, String propertyValue) throws SQLException {
        preparedStatement.setInt(1, tenantId);
        preparedStatement.setString(2, consumerKey);
        preparedStatement.setString(3, propertyKey);
        preparedStatement.setString(4, propertyValue);
        preparedStatement.addBatch();
    }

    private void addToBatchForOIDCPropertyUpdate(String consumerKey, int tenantId, PreparedStatement preparedStatement, String propertyKey, String propertyValue) throws SQLException {
        preparedStatement.setString(1, propertyValue);
        preparedStatement.setInt(2, tenantId);
        preparedStatement.setString(3, consumerKey);
        preparedStatement.setString(4, propertyKey);
        preparedStatement.addBatch();
    }

    private boolean propertyAlreadyExists(Map<String, List<String>> spOIDCProperties, String propertyKey) {
        return spOIDCProperties.containsKey(propertyKey);
    }

    public void removeConsumerApplication(String consumerKey) throws IdentityOAuthAdminException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();
             PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?");){
            prepStmt.setString(1, consumerKey);
            prepStmt.execute();
            if (this.isOIDCAudienceEnabled()) {
                String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                this.removeOauthOIDCPropertyTable(connection, tenantDomain, consumerKey);
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            throw OAuthUtil.handleError("Error when executing the SQL : DELETE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?", e);
        }
    }

    public void removeConsumerApplicationsByTenantId(int tenantId) throws IdentityOAuthAdminException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            this.removeSPAssociations(tenantId, connection);
            try (PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_OAUTH_CONSUMER_APPS WHERE TENANT_ID = ?");){
                prepStmt.setInt(1, tenantId);
                prepStmt.execute();
            }
            if (this.isOIDCAudienceEnabled()) {
                this.removeOAuthOIDCPropertiesByTenantId(connection, tenantId);
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            throw OAuthUtil.handleError("Error when deleting consumer apps of the tenant: " + tenantId, e);
        }
    }

    public void updateOAuthConsumerApp(String appName, String consumerKey) throws IdentityApplicationManagementException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement statement = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_NAME=? WHERE CONSUMER_KEY=?");){
                statement.setString(1, appName);
                statement.setString(2, consumerKey);
                statement.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityApplicationManagementException("Error while executing the SQL statement.", (Throwable)e1);
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementException("Error while executing the SQL statement.", (Throwable)e);
        }
    }

    public String getConsumerAppState(String consumerKey) throws IdentityOAuthAdminException {
        String consumerAppState = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("SELECT APP_STATE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?");){
            prepStmt.setString(1, consumerKey);
            try (ResultSet rSet = prepStmt.executeQuery();){
                if (rSet.next()) {
                    consumerAppState = rSet.getString(APP_STATE);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No App found for the consumerKey: " + consumerKey));
                }
            }
        }
        catch (SQLException e) {
            throw OAuthUtil.handleError("Error while executing the SQL prepStmt.", e);
        }
        return consumerAppState;
    }

    public void updateConsumerAppState(String consumerKey, String state) throws IdentityApplicationManagementException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement statement = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET APP_STATE=? WHERE CONSUMER_KEY=?");){
                statement.setString(1, state);
                statement.setString(2, consumerKey);
                statement.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityApplicationManagementException("Error while executing the SQL statement.", (Throwable)e1);
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementException("Error while executing the SQL statement.", (Throwable)e);
        }
    }

    public boolean isDuplicateApplication(String username, int tenantId, String userDomain, OAuthAppDO consumerAppDTO) throws IdentityOAuthAdminException {
        boolean isDuplicateApp = false;
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)username, (int)tenantId);
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            String sql = "SELECT * FROM IDN_OAUTH_CONSUMER_APPS WHERE USERNAME=? AND TENANT_ID=? AND USER_DOMAIN=? AND APP_NAME=?";
            if (!isUsernameCaseSensitive) {
                sql = sql.replace(USERNAME, LOWER_USERNAME);
            }
            try (PreparedStatement prepStmt = connection.prepareStatement(sql);){
                if (isUsernameCaseSensitive) {
                    prepStmt.setString(1, username);
                } else {
                    prepStmt.setString(1, username.toLowerCase());
                }
                prepStmt.setInt(2, tenantId);
                prepStmt.setString(3, userDomain);
                prepStmt.setString(4, consumerAppDTO.getApplicationName());
                try (ResultSet rSet = prepStmt.executeQuery();){
                    if (rSet.next()) {
                        isDuplicateApp = true;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw OAuthUtil.handleError("Error when executing the SQL : SELECT * FROM IDN_OAUTH_CONSUMER_APPS WHERE USERNAME=? AND TENANT_ID=? AND USER_DOMAIN=? AND APP_NAME=?", e);
        }
        return isDuplicateApp;
    }

    public boolean isDuplicateConsumer(String consumerKey) throws IdentityOAuthAdminException {
        boolean isDuplicateConsumer = false;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("SELECT * FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?");){
            prepStmt.setString(1, this.persistenceProcessor.getProcessedClientId(consumerKey));
            try (ResultSet rSet = prepStmt.executeQuery();){
                if (rSet.next()) {
                    isDuplicateConsumer = true;
                }
            }
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error occurred while processing the client id by TokenPersistenceProcessor", null);
        }
        catch (SQLException e) {
            throw OAuthUtil.handleError("Error when executing the SQL: SELECT * FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?", e);
        }
        return isDuplicateConsumer;
    }

    private boolean isUsernameCaseSensitive(String tenantQualifiedUsername) {
        return IdentityUtil.isUserStoreInUsernameCaseSensitive((String)tenantQualifiedUsername);
    }

    public List<String> getOIDCAudiences(String tenantDomain, String consumerKey) throws IdentityOAuth2Exception {
        ArrayList<String> audiences = new ArrayList<String>();
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet rSetAudiences = null;
        try {
            prepStmt = connection.prepareStatement("SELECT PROPERTY_VALUE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID = ? AND CONSUMER_KEY = ? AND PROPERTY_KEY = ?");
            prepStmt.setInt(1, IdentityTenantUtil.getTenantId((String)tenantDomain));
            prepStmt.setString(2, consumerKey);
            prepStmt.setString(3, "audience");
            rSetAudiences = prepStmt.executeQuery();
            while (rSetAudiences.next()) {
                String audience = rSetAudiences.getString(1);
                if (audience == null) continue;
                audiences.add(rSetAudiences.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving OIDC audiences for client ID: " + consumerKey + " and tenant domain: " + tenantDomain;
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rSetAudiences, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rSetAudiences, (PreparedStatement)prepStmt);
        return audiences;
    }

    public void removeOIDCProperties(String tenantDomain, String consumerKey) throws IdentityOAuthAdminException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        try {
            this.removeOauthOIDCPropertyTable(connection, tenantDomain, consumerKey);
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            String errorMsg = "Error removing OIDC properties for client ID: " + consumerKey + " and tenant domain: " + tenantDomain;
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuthAdminException(errorMsg, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, null);
        }
    }

    private void removeOauthOIDCPropertyTable(Connection connection, String tenantDomain, String consumerKey) throws SQLException {
        try (PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID=? AND CONSUMER_KEY=?");){
            prepStmt.setInt(1, IdentityTenantUtil.getTenantId((String)tenantDomain));
            prepStmt.setString(2, consumerKey);
            prepStmt.execute();
        }
    }

    private void removeOAuthOIDCPropertiesByTenantId(Connection connection, int tenantId) throws SQLException {
        try (PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID = ?");){
            prepStmt.setInt(1, tenantId);
            prepStmt.execute();
        }
    }

    private void removeSPAssociations(int tenantId, Connection connection) throws SQLException {
        for (String consumerKey : this.getOAuthConsumerKeysByTenantId(tenantId, connection)) {
            PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM SP_INBOUND_AUTH WHERE INBOUND_AUTH_KEY = ?");
            Throwable throwable = null;
            try {
                prepStmt.setString(1, consumerKey);
                prepStmt.execute();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (prepStmt == null) continue;
                if (throwable != null) {
                    try {
                        prepStmt.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                prepStmt.close();
            }
        }
    }

    private List<String> getOAuthConsumerKeysByTenantId(int tenantId, Connection connection) throws SQLException {
        ArrayList<String> oauthConsumerKeys = new ArrayList<String>();
        try (PreparedStatement prepStmt = connection.prepareStatement("SELECT CONSUMER_KEY FROM IDN_OAUTH_CONSUMER_APPS WHERE TENANT_ID = ?");){
            prepStmt.setInt(1, tenantId);
            try (ResultSet rSet = prepStmt.executeQuery();){
                while (rSet.next()) {
                    oauthConsumerKeys.add(rSet.getString(1));
                }
            }
        }
        return oauthConsumerKeys;
    }

    private void addScopeValidators(Connection connection, int appId, String[] scopeValidators) throws SQLException {
        if (scopeValidators != null && scopeValidators.length > 0) {
            LOG.debug((Object)String.format("Adding %d Scope validators registered for OAuth appId %d", scopeValidators.length, appId));
            try (PreparedStatement stmt = connection.prepareStatement("INSERT INTO IDN_OAUTH2_SCOPE_VALIDATORS (APP_ID, SCOPE_VALIDATOR) VALUES (?,?) ");){
                for (String scopeValidator : scopeValidators) {
                    stmt.setInt(1, appId);
                    stmt.setString(2, scopeValidator);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
        }
    }

    private String[] getScopeValidators(Connection connection, int id) throws SQLException {
        ArrayList<String> scopeValidators = new ArrayList<String>();
        try (PreparedStatement stmt = connection.prepareStatement("SELECT SCOPE_VALIDATOR FROM IDN_OAUTH2_SCOPE_VALIDATORS WHERE APP_ID=?");){
            stmt.setInt(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    scopeValidators.add(rs.getString(1));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Retrieving %d Scope validators registered for OAuth appId %d", scopeValidators.size(), id));
        }
        return scopeValidators.toArray(new String[0]);
    }

    private void updateScopeValidators(Connection connection, int appId, String[] scopeValidators) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Removing  Scope validators registered for OAuth appId %d", appId));
        }
        try (PreparedStatement stmt = connection.prepareStatement("DELETE FROM IDN_OAUTH2_SCOPE_VALIDATORS WHERE APP_ID=?");){
            stmt.setInt(1, appId);
            stmt.execute();
        }
        this.addScopeValidators(connection, appId, scopeValidators);
    }

    private int getAppIdByClientId(Connection connection, String clientId) throws SQLException, InvalidOAuthClientException, IdentityOAuth2Exception {
        int appId = 0;
        try (PreparedStatement prepStmt = connection.prepareStatement("SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?");){
            prepStmt.setString(1, this.persistenceProcessor.getProcessedClientId(clientId));
            try (ResultSet rSet = prepStmt.executeQuery();){
                boolean rSetHasRows = false;
                while (rSet.next()) {
                    rSetHasRows = true;
                    appId = rSet.getInt(1);
                }
                if (!rSetHasRows) {
                    String message = "Cannot find an application associated with the given consumer key : " + clientId;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message);
                    }
                    throw new InvalidOAuthClientException(message);
                }
            }
        }
        return appId;
    }

    private void addServiceProviderOIDCProperties(Connection connection, OAuthAppDO consumerAppDO, String processedClientId, int spTenantId) throws SQLException {
        try (PreparedStatement prepStmtAddOIDCProperty = connection.prepareStatement("INSERT INTO IDN_OIDC_PROPERTY (TENANT_ID, CONSUMER_KEY, PROPERTY_KEY, PROPERTY_VALUE) VALUES (?,?,?,?) ");){
            if (this.isOIDCAudienceEnabled() && consumerAppDO.getAudiences() != null) {
                String[] audiences;
                for (String audience : audiences = consumerAppDO.getAudiences()) {
                    this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "audience", audience);
                }
            }
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "requestObjectSigned", String.valueOf(consumerAppDO.isRequestObjectSignatureValidationEnabled()));
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "idTokenEncrypted", String.valueOf(consumerAppDO.isIdTokenEncryptionEnabled()));
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "idTokenEncryptionAlgorithm", String.valueOf(consumerAppDO.getIdTokenEncryptionAlgorithm()));
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "idTokenEncryptionMethod", String.valueOf(consumerAppDO.getIdTokenEncryptionMethod()));
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "backChannelLogoutURL", consumerAppDO.getBackChannelLogoutUrl());
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "frontchannelLogoutURL", consumerAppDO.getFrontchannelLogoutUrl());
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "tokenType", consumerAppDO.getTokenType());
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "bypassClientCredentials", String.valueOf(consumerAppDO.isBypassClientCredentials()));
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "renewRefreshToken", consumerAppDO.getRenewRefreshTokenEnabled());
            if ("None".equalsIgnoreCase(consumerAppDO.getTokenBindingType())) {
                consumerAppDO.setTokenType(null);
            }
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "tokenBindingType", consumerAppDO.getTokenBindingType());
            if (consumerAppDO.getTokenBindingType() == null) {
                consumerAppDO.setTokenRevocationWithIDPSessionTerminationEnabled(false);
                consumerAppDO.setTokenBindingValidationEnabled(false);
            }
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "tokenRevocationWithIDPSessionTermination", String.valueOf(consumerAppDO.isTokenRevocationWithIDPSessionTerminationEnabled()));
            this.addToBatchForOIDCPropertyAdd(processedClientId, spTenantId, prepStmtAddOIDCProperty, "tokenBindingValidation", String.valueOf(consumerAppDO.isTokenBindingValidationEnabled()));
            prepStmtAddOIDCProperty.executeBatch();
        }
    }

    private void handleSpOIDCProperties(Connection connection, String preprocessedClientId, String spTenantDomain, OAuthAppDO oauthApp) throws IdentityOAuth2Exception {
        Map<String, List<String>> spOIDCProperties = this.getSpOIDCProperties(connection, preprocessedClientId, spTenantDomain);
        this.setSpOIDCProperties(spOIDCProperties, oauthApp);
    }

    private Map<String, List<String>> getSpOIDCProperties(Connection connection, String consumerKey, String spTenantDomain) throws IdentityOAuth2Exception {
        HashMap<String, List<String>> spOIDCProperties = new HashMap<String, List<String>>();
        PreparedStatement prepStatement = null;
        ResultSet spOIDCPropertyResultSet = null;
        try {
            prepStatement = connection.prepareStatement("SELECT PROPERTY_KEY, PROPERTY_VALUE FROM IDN_OIDC_PROPERTY WHERE TENANT_ID = ? AND CONSUMER_KEY = ?");
            prepStatement.setInt(1, IdentityTenantUtil.getTenantId((String)spTenantDomain));
            prepStatement.setString(2, consumerKey);
            spOIDCPropertyResultSet = prepStatement.executeQuery();
            while (spOIDCPropertyResultSet.next()) {
                String propertyKey = spOIDCPropertyResultSet.getString(1);
                String propertyValue = spOIDCPropertyResultSet.getString(2);
                spOIDCProperties.computeIfAbsent(propertyKey, k -> new ArrayList()).add(propertyValue);
            }
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving OIDC properties for client ID: " + consumerKey + " and tenant domain: " + spTenantDomain;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections(null, spOIDCPropertyResultSet, (PreparedStatement)prepStatement);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)spOIDCPropertyResultSet, (PreparedStatement)prepStatement);
        return spOIDCProperties;
    }

    private void setSpOIDCProperties(Map<String, List<String>> spOIDCProperties, OAuthAppDO oauthApp) {
        if (this.isOIDCAudienceEnabled() && CollectionUtils.isNotEmpty((Collection)spOIDCProperties.get("audience"))) {
            ArrayList oidcAudience = new ArrayList(spOIDCProperties.get("audience"));
            oauthApp.setAudiences(oidcAudience.toArray(new String[oidcAudience.size()]));
        }
        boolean isRequestObjectSigned = Boolean.parseBoolean(this.getFirstPropertyValue(spOIDCProperties, "requestObjectSigned"));
        oauthApp.setRequestObjectSignatureValidationEnabled(isRequestObjectSigned);
        boolean isIdTokenEncrypted = Boolean.parseBoolean(this.getFirstPropertyValue(spOIDCProperties, "idTokenEncrypted"));
        oauthApp.setIdTokenEncryptionEnabled(isIdTokenEncrypted);
        String idTokenEncryptionAlgorithm = this.getFirstPropertyValue(spOIDCProperties, "idTokenEncryptionAlgorithm");
        oauthApp.setIdTokenEncryptionAlgorithm(idTokenEncryptionAlgorithm);
        String idTokenEncryptionMethod = this.getFirstPropertyValue(spOIDCProperties, "idTokenEncryptionMethod");
        oauthApp.setIdTokenEncryptionMethod(idTokenEncryptionMethod);
        String backChannelLogoutUrl = this.getFirstPropertyValue(spOIDCProperties, "backChannelLogoutURL");
        oauthApp.setBackChannelLogoutUrl(backChannelLogoutUrl);
        String frontchannelLogoutUrl = this.getFirstPropertyValue(spOIDCProperties, "frontchannelLogoutURL");
        oauthApp.setFrontchannelLogoutUrl(frontchannelLogoutUrl);
        String tokenType = this.getFirstPropertyValue(spOIDCProperties, "tokenType");
        oauthApp.setTokenType(tokenType);
        boolean bypassClientCreds = Boolean.parseBoolean(this.getFirstPropertyValue(spOIDCProperties, "bypassClientCredentials"));
        oauthApp.setBypassClientCredentials(bypassClientCreds);
        String tokenBindingType = this.getFirstPropertyValue(spOIDCProperties, "tokenBindingType");
        if ("None".equalsIgnoreCase(tokenBindingType)) {
            tokenBindingType = null;
        }
        oauthApp.setTokenBindingType(tokenBindingType);
        if (tokenBindingType == null) {
            oauthApp.setTokenRevocationWithIDPSessionTerminationEnabled(false);
            oauthApp.setTokenBindingValidationEnabled(false);
        } else {
            boolean isTokenRevocationEnabled = Boolean.parseBoolean(this.getFirstPropertyValue(spOIDCProperties, "tokenRevocationWithIDPSessionTermination"));
            oauthApp.setTokenRevocationWithIDPSessionTerminationEnabled(isTokenRevocationEnabled);
            boolean isTokenBindingValidationEnabled = Boolean.parseBoolean(this.getFirstPropertyValue(spOIDCProperties, "tokenBindingValidation"));
            oauthApp.setTokenBindingValidationEnabled(isTokenBindingValidationEnabled);
        }
        String renewRefreshToken = this.getFirstPropertyValue(spOIDCProperties, "renewRefreshToken");
        oauthApp.setRenewRefreshTokenEnabled(renewRefreshToken);
    }

    private String getFirstPropertyValue(Map<String, List<String>> propertyMap, String key) {
        return CollectionUtils.isNotEmpty((Collection)propertyMap.get(key)) ? propertyMap.get(key).get(0) : null;
    }

    private boolean isOIDCAudienceEnabled() {
        return OAuth2ServiceComponentHolder.isAudienceEnabled();
    }

    private void handleRequestForANonExistingConsumerKey(String consumerKey) throws InvalidOAuthClientException {
        String message = "Cannot find an application associated with the given consumer key : " + consumerKey;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message);
        }
        throw new InvalidOAuthClientException(message);
    }

    private void handleRequestForANonExistingApp(String appName) throws InvalidOAuthClientException {
        String message = "Cannot find an application associated with the given appName : " + appName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message);
        }
        throw new InvalidOAuthClientException(message);
    }
}

