/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuer;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.oltu.oauth2.as.issuer.UUIDValueGenerator;
import org.apache.oltu.oauth2.as.issuer.ValueGenerator;
import org.apache.oltu.oauth2.as.validator.CodeValidator;
import org.apache.oltu.oauth2.as.validator.TokenValidator;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.apache.oltu.oauth2.common.validators.OAuthValidator;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.common.CodeTokenResponseValidator;
import org.wso2.carbon.identity.oauth.common.GrantType;
import org.wso2.carbon.identity.oauth.common.IDTokenResponseValidator;
import org.wso2.carbon.identity.oauth.common.IDTokenTokenResponseValidator;
import org.wso2.carbon.identity.oauth.common.SAML2GrantValidator;
import org.wso2.carbon.identity.oauth.config.OAuthCallbackHandlerMetaData;
import org.wso2.carbon.identity.oauth.tokenprocessor.HashingPersistenceProcessor;
import org.wso2.carbon.identity.oauth.tokenprocessor.PlainTextPersistenceProcessor;
import org.wso2.carbon.identity.oauth.tokenprocessor.TokenPersistenceProcessor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.handlers.ResponseTypeHandler;
import org.wso2.carbon.identity.oauth2.model.TokenIssuerDO;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuer;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuerImpl;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.saml.SAML2TokenCallbackHandler;
import org.wso2.carbon.identity.oauth2.validators.OAuth2ScopeHandler;
import org.wso2.carbon.identity.oauth2.validators.OAuth2ScopeValidator;
import org.wso2.carbon.identity.oauth2.validators.grant.AuthorizationCodeGrantValidator;
import org.wso2.carbon.identity.oauth2.validators.grant.ClientCredentialGrantValidator;
import org.wso2.carbon.identity.oauth2.validators.grant.PasswordGrantValidator;
import org.wso2.carbon.identity.oauth2.validators.grant.RefreshTokenGrantValidator;
import org.wso2.carbon.identity.openidconnect.CustomClaimsCallbackHandler;
import org.wso2.carbon.identity.openidconnect.IDTokenBuilder;
import org.wso2.carbon.identity.openidconnect.RequestObjectBuilder;
import org.wso2.carbon.identity.openidconnect.RequestObjectValidator;
import org.wso2.carbon.identity.openidconnect.RequestObjectValidatorImpl;
import org.wso2.carbon.utils.CarbonUtils;

public class OAuthServerConfiguration {
    private static final String CONFIG_ELEM_OAUTH = "OAuth";
    private static final String AUTHORIZATION_CODE_GRANT_HANDLER_CLASS = "org.wso2.carbon.identity.oauth2.token.handlers.grant.AuthorizationCodeGrantHandler";
    private static final String CLIENT_CREDENTIALS_GRANT_HANDLER_CLASS = "org.wso2.carbon.identity.oauth2.token.handlers.grant.ClientCredentialsGrantHandler";
    private static final String PASSWORD_GRANT_HANDLER_CLASS = "org.wso2.carbon.identity.oauth2.token.handlers.grant.PasswordGrantHandler";
    private static final String REFRESH_TOKEN_GRANT_HANDLER_CLASS = "org.wso2.carbon.identity.oauth2.token.handlers.grant.RefreshGrantHandler";
    private static final String SAML20_BEARER_GRANT_HANDLER_CLASS = "org.wso2.carbon.identity.oauth2.token.handlers.grant.saml.SAML2BearerGrantHandler";
    private static final String IWA_NTLM_BEARER_GRANT_HANDLER_CLASS = "org.wso2.carbon.identity.oauth2.token.handlers.grant.iwa.ntlm.NTLMAuthenticationGrantHandler";
    private static final String REQUEST_PARAM_VALUE_BUILDER_CLASS = "org.wso2.carbon.identity.openidconnect.RequestParamRequestObjectBuilder";
    private static final String DEFAULT_OAUTH_TOKEN_ISSUER_CLASS = "org.wso2.carbon.identity.oauth2.token.OauthTokenIssuerImpl";
    private static final String JWT_TOKEN_ISSUER_CLASS = "org.wso2.carbon.identity.oauth2.token.JWTTokenIssuer";
    private static final String REQUEST_PARAM_VALUE_BUILDER = "request_param_value_builder";
    private static final Log log = LogFactory.getLog(OAuthServerConfiguration.class);
    private static OAuthServerConfiguration instance;
    private static String oauth1RequestTokenUrl;
    private static String oauth1AuthorizeUrl;
    private static String oauth1AccessTokenUrl;
    private static String oauth2AuthzEPUrl;
    private static String oauth2TokenEPUrl;
    private static String oauth2UserInfoEPUrl;
    private static String oauth2RevocationEPUrl;
    private static String oauth2IntrospectionEPUrl;
    private static String oidcConsentPageUrl;
    private static String oauth2DCREPUrl;
    private static String oauth2JWKSPageUrl;
    private static String oidcWebFingerEPUrl;
    private static String oidcDiscoveryUrl;
    private static String oauth2ConsentPageUrl;
    private static String oauth2ErrorPageUrl;
    private long authorizationCodeValidityPeriodInSeconds = 300L;
    private long userAccessTokenValidityPeriodInSeconds = 3600L;
    private long applicationAccessTokenValidityPeriodInSeconds = 3600L;
    private long refreshTokenValidityPeriodInSeconds = 86400L;
    private long timeStampSkewInSeconds = 300L;
    private String tokenPersistenceProcessorClassName = "org.wso2.carbon.identity.oauth.tokenprocessor.PlainTextPersistenceProcessor";
    private String oauthTokenGeneratorClassName;
    private OAuthIssuer oauthTokenGenerator;
    private String oauthIdentityTokenGeneratorClassName;
    private String clientIdValidationRegex = "[a-zA-Z0-9_]{15,30}";
    private String persistAccessTokenAlias;
    private String retainOldAccessTokens;
    private String tokenCleanupFeatureEnable;
    private OauthTokenIssuer oauthIdentityTokenGenerator;
    private boolean scopeValidationConfigValue = true;
    private boolean cacheEnabled = false;
    private boolean isTokenRenewalPerRequestEnabled = false;
    private boolean isRefreshTokenRenewalEnabled = true;
    private boolean isExtendRenewedTokenExpiryTimeEnabled = false;
    private boolean assertionsUserNameEnabled = false;
    private boolean accessTokenPartitioningEnabled = false;
    private boolean redirectToRequestedRedirectUriEnabled = true;
    private String accessTokenPartitioningDomains = null;
    private TokenPersistenceProcessor persistenceProcessor = null;
    private Set<OAuthCallbackHandlerMetaData> callbackHandlerMetaData = new HashSet<OAuthCallbackHandlerMetaData>();
    private Map<String, String> supportedGrantTypeClassNames = new HashMap<String, String>();
    private Map<String, Boolean> refreshTokenAllowedGrantTypes = new HashMap<String, Boolean>();
    private Map<String, String> idTokenAllowedForGrantTypesMap = new HashMap<String, String>();
    private Set<String> idTokenNotAllowedGrantTypesSet = new HashSet<String>();
    private Set<String> userConsentEnabledGrantTypes = new HashSet<String>();
    private Map<String, AuthorizationGrantHandler> supportedGrantTypes;
    private Map<String, RequestObjectBuilder> requestObjectBuilder;
    private Map<String, String> supportedGrantTypeValidatorNames = new HashMap<String, String>();
    private Map<String, Class<? extends OAuthValidator<HttpServletRequest>>> supportedGrantTypeValidators;
    private Map<String, String> supportedResponseTypeClassNames = new HashMap<String, String>();
    private Map<String, ResponseTypeHandler> supportedResponseTypes;
    private Map<String, String> supportedResponseTypeValidatorNames = new HashMap<String, String>();
    private Map<String, Class<? extends OAuthValidator<HttpServletRequest>>> supportedResponseTypeValidators;
    private Map<String, TokenIssuerDO> supportedTokenIssuers = new HashMap<String, TokenIssuerDO>();
    private List<String> supportedTokenTypes = new ArrayList<String>();
    private Map<String, OauthTokenIssuer> oauthTokenIssuerMap = new HashMap<String, OauthTokenIssuer>();
    private String[] supportedClaims = null;
    private Map<String, Properties> supportedClientAuthHandlerData = new HashMap<String, Properties>();
    private String saml2TokenCallbackHandlerName = null;
    private String saml2BearerTokenUserType;
    private boolean saml2UserIdFromClaims = false;
    private boolean mapFederatedUsersToLocal = false;
    private SAML2TokenCallbackHandler saml2TokenCallbackHandler = null;
    private Map<String, String> tokenValidatorClassNames = new HashMap<String, String>();
    private boolean isAuthContextTokGenEnabled = false;
    private String tokenGeneratorImplClass = "org.wso2.carbon.identity.oauth2.token.JWTTokenGenerator";
    private String claimsRetrieverImplClass = "org.wso2.carbon.identity.oauth2.authcontext.DefaultClaimsRetriever";
    private String consumerDialectURI = "http://wso2.org/claims";
    private String signatureAlgorithm = "SHA256withRSA";
    private String idTokenSignatureAlgorithm = "SHA256withRSA";
    private String defaultIdTokenEncryptionAlgorithm = "RSA-OAEP";
    private List<String> supportedIdTokenEncryptionAlgorithms = new ArrayList<String>();
    private String defaultIdTokenEncryptionMethod = "A128GCM";
    private List<String> supportedIdTokenEncryptionMethods = new ArrayList<String>();
    private String userInfoJWTSignatureAlgorithm = "SHA256withRSA";
    private String authContextTTL = "15L";
    private boolean useMultiValueSeparatorForAuthContextToken = true;
    private boolean addTenantDomainToIdTokenEnabled = false;
    private boolean addUserstoreDomainToIdTokenEnabled = false;
    public static final String DEFAULT_TOKEN_TYPE = "Default";
    public static final String JWT_TOKEN_TYPE = "JWT";
    private String openIDConnectIDTokenBuilderClassName = "org.wso2.carbon.identity.openidconnect.DefaultIDTokenBuilder";
    private String defaultRequestValidatorClassName = "org.wso2.carbon.identity.openidconnect.RequestObjectValidatorImpl";
    private String openIDConnectIDTokenCustomClaimsHanlderClassName = "org.wso2.carbon.identity.openidconnect.SAMLAssertionClaimsCallback";
    private IDTokenBuilder openIDConnectIDTokenBuilder = null;
    private Map<String, String> requestObjectBuilderClassNames = new HashMap<String, String>();
    private volatile RequestObjectValidator requestObjectValidator = null;
    private CustomClaimsCallbackHandler openidConnectIDTokenCustomClaimsCallbackHandler = null;
    private String openIDConnectIDTokenIssuerIdentifier = null;
    private String openIDConnectIDTokenSubClaim = "http://wso2.org/claims/fullname";
    private Boolean openIDConnectSkipUserConsent = true;
    private Boolean openIDConnectSkipLoginConsent;
    private Boolean openIDConnectSkipLogoutConsent;
    private String openIDConnectIDTokenExpiration = "3600";
    private long openIDConnectIDTokenExpiryTimeInSeconds = 3600L;
    private String openIDConnectUserInfoEndpointClaimDialect = "http://wso2.org/claims";
    private String openIDConnectUserInfoEndpointClaimRetriever = "org.wso2.carbon.identity.oauth.endpoint.user.impl.UserInfoUserStoreClaimRetriever";
    private String openIDConnectUserInfoEndpointRequestValidator = "org.wso2.carbon.identity.oauth.endpoint.user.impl.UserInforRequestDefaultValidator";
    private String openIDConnectUserInfoEndpointAccessTokenValidator = "org.wso2.carbon.identity.oauth.endpoint.user.impl.UserInfoISAccessTokenValidator";
    private String openIDConnectUserInfoEndpointResponseBuilder = "org.wso2.carbon.identity.oauth.endpoint.user.impl.UserInfoJSONResponseBuilder";
    private boolean convertOriginalClaimsFromAssertionsToOIDCDialect = false;
    private boolean returnOnlyMappedLocalRoles = false;
    private boolean addUnmappedUserAttributes = false;
    private OAuth2ScopeValidator oAuth2ScopeValidator;
    private Set<OAuth2ScopeValidator> oAuth2ScopeValidators = new HashSet<OAuth2ScopeValidator>();
    private Set<OAuth2ScopeHandler> oAuth2ScopeHandlers = new HashSet<OAuth2ScopeHandler>();
    private boolean isJWTSignedWithSPKey = true;
    private boolean isImplicitErrorFragment = true;
    private boolean isRevokeResponseHeadersEnabled = true;
    private boolean showDisplayNameInConsentPage = false;
    private boolean useSPTenantDomainValue;
    private ValueGenerator tokenValueGenerator;
    private String tokenValueGeneratorClassName;
    private String hashAlgorithm = "SHA-256";
    private boolean isClientSecretHashEnabled = false;
    private String openIDConnectBCLogoutTokenExpiryInSeconds = "120";
    private boolean enableIntrospectionDataProviders = false;
    private List<String> allowedScopes = new ArrayList<String>();

    private OAuthServerConfiguration() {
        this.buildOAuthServerConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OAuthServerConfiguration getInstance() {
        CarbonUtils.checkSecurity();
        if (instance != null) return instance;
        Class<OAuthServerConfiguration> clazz = OAuthServerConfiguration.class;
        synchronized (OAuthServerConfiguration.class) {
            if (instance != null) return instance;
            instance = new OAuthServerConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void buildOAuthServerConfiguration() {
        IdentityConfigParser configParser = IdentityConfigParser.getInstance();
        OMElement oauthElem = configParser.getConfigElement(CONFIG_ELEM_OAUTH);
        if (oauthElem == null) {
            this.warnOnFaultyConfiguration("OAuth element is not available.");
            return;
        }
        this.parseOAuthCallbackHandlers(oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuthCallbackHandlers")));
        this.parseTokenValidators(oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("TokenValidators")));
        OMElement scopeValidatorElem = oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuthScopeValidator"));
        OMElement scopeValidatorsElem = oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("ScopeValidators"));
        OMElement scopeValidationElem = oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("ScopeValidationEnabledForAuthzCodeAndImplicitGrant"));
        if (scopeValidationElem != null) {
            this.scopeValidationConfigValue = Boolean.parseBoolean(scopeValidationElem.getText());
        }
        if (scopeValidatorElem != null) {
            this.parseScopeValidator(scopeValidatorElem);
        } else if (scopeValidatorsElem != null) {
            this.parseScopeValidator(scopeValidatorsElem);
        }
        OMElement scopeHandlersElem = oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("ScopeHandlers"));
        if (scopeHandlersElem != null) {
            this.parseScopeHandlers(scopeHandlersElem);
        }
        this.parseDefaultValidityPeriods(oauthElem);
        this.parseOAuthURLs(oauthElem);
        this.parseTokenRenewalPerRequestConfiguration(oauthElem);
        this.parseRefreshTokenRenewalConfiguration(oauthElem);
        this.parseTokenPersistenceProcessorConfig(oauthElem);
        this.parseSupportedGrantTypesConfig(oauthElem);
        this.parseUserConsentEnabledGrantTypesConfig(oauthElem);
        this.parseSupportedResponseTypesConfig(oauthElem);
        this.parseSupportedClientAuthHandlersConfig(oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("ClientAuthHandlers")));
        this.parseSAML2GrantConfig(oauthElem);
        this.parseAuthorizationContextTokenGeneratorConfig(oauthElem);
        this.parseEnableAssertionsUserNameConfig(oauthElem);
        this.parseAccessTokenPartitioningConfig(oauthElem);
        this.parseAccessTokenPartitioningDomainsConfig(oauthElem);
        this.parseOpenIDConnectConfig(oauthElem);
        this.parseOAuthTokenGeneratorConfig(oauthElem);
        this.parseImplicitErrorFragment(oauthElem);
        this.parseOAuthTokenIssuerConfig(oauthElem);
        this.parseClientIdValidationRegex(oauthElem);
        this.parsePersistAccessTokenAliasConfig(oauthElem);
        this.parseSupportedTokenTypesConfig(oauthElem);
        this.parseOAuthTokenValueGenerator(oauthElem);
        this.parseUseSPTenantDomainConfig(oauthElem);
        this.parseRevokeResponseHeadersEnableConfig(oauthElem);
        this.parseShowDisplayNameInConsentPage(oauthElem);
        this.parseHashAlgorithm(oauthElem);
        this.parseEnableHashMode(oauthElem);
        this.parseRetainOldAccessTokensConfig(oauthElem);
        this.tokenCleanupFeatureConfig(oauthElem);
        this.parseTokenIntrospectionConfig(oauthElem);
        this.parseRedirectToOAuthErrorPageConfig(oauthElem);
        this.parseAllowedScopesConfiguration(oauthElem);
    }

    private void parseAllowedScopesConfiguration(OMElement oauthConfigElem) {
        OMElement allowedScopesElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AllowedScopes"));
        if (allowedScopesElem != null) {
            Iterator scopeIterator = allowedScopesElem.getChildrenWithName(this.getQNameWithIdentityNS("Scope"));
            while (scopeIterator.hasNext()) {
                OMElement scopeElement = (OMElement)scopeIterator.next();
                this.allowedScopes.add(scopeElement.getText());
            }
        }
    }

    private void parseTokenIntrospectionConfig(OMElement oauthElem) {
        OMElement enableDataProvidersElem;
        OMElement introspectionElem = oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("Introspection"));
        if (introspectionElem != null && (enableDataProvidersElem = introspectionElem.getFirstChildWithName(this.getQNameWithIdentityNS("EnableDataProviders"))) != null) {
            this.enableIntrospectionDataProviders = Boolean.parseBoolean(enableDataProvidersElem.getText().trim());
        }
    }

    private void parseShowDisplayNameInConsentPage(OMElement oauthElem) {
        OMElement showApplicationNameInConsentPageElement = oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("ShowDisplayNameInConsentPage"));
        if (showApplicationNameInConsentPageElement != null) {
            this.showDisplayNameInConsentPage = Boolean.parseBoolean(showApplicationNameInConsentPageElement.getText());
        }
    }

    public Set<OAuthCallbackHandlerMetaData> getCallbackHandlerMetaData() {
        return this.callbackHandlerMetaData;
    }

    public boolean isShowDisplayNameInConsentPage() {
        return this.showDisplayNameInConsentPage;
    }

    public List<String> getAllowedScopes() {
        return this.allowedScopes;
    }

    public String getOAuth1RequestTokenUrl() {
        return oauth1RequestTokenUrl;
    }

    public String getOAuth1AuthorizeUrl() {
        return oauth1AuthorizeUrl;
    }

    public String getOAuth1AccessTokenUrl() {
        return oauth1AccessTokenUrl;
    }

    public String getOAuth2AuthzEPUrl() {
        return oauth2AuthzEPUrl;
    }

    public String getOAuth2TokenEPUrl() {
        return oauth2TokenEPUrl;
    }

    public String getOAuth2DCREPUrl() {
        return oauth2DCREPUrl;
    }

    public String getOAuth2JWKSPageUrl() {
        return oauth2JWKSPageUrl;
    }

    public String getOidcDiscoveryUrl() {
        return oidcDiscoveryUrl;
    }

    public String getOidcWebFingerEPUrl() {
        return oidcWebFingerEPUrl;
    }

    public String getOauth2UserInfoEPUrl() {
        return oauth2UserInfoEPUrl;
    }

    public String getOauth2RevocationEPUrl() {
        return oauth2RevocationEPUrl;
    }

    public String getOauth2IntrospectionEPUrl() {
        return oauth2IntrospectionEPUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuthIssuer getOAuthTokenGenerator() {
        if (this.oauthTokenGenerator == null) {
            OAuthServerConfiguration oAuthServerConfiguration = this;
            synchronized (oAuthServerConfiguration) {
                if (this.oauthTokenGenerator == null) {
                    try {
                        if (this.oauthTokenGeneratorClassName != null) {
                            Class<?> clazz = this.getClass().getClassLoader().loadClass(this.oauthTokenGeneratorClassName);
                            this.oauthTokenGenerator = (OAuthIssuer)clazz.newInstance();
                            log.info((Object)("An instance of " + this.oauthTokenGeneratorClassName + " is created for OAuth token generation."));
                        } else {
                            this.oauthTokenGenerator = new OAuthIssuerImpl(this.getTokenValueGenerator());
                            log.info((Object)"The default OAuth token issuer will be used. No custom token generator is set.");
                        }
                    }
                    catch (Exception e) {
                        String errorMsg = "Error when instantiating the OAuthIssuer : " + this.tokenPersistenceProcessorClassName + ". Defaulting to OAuthIssuerImpl";
                        log.error((Object)errorMsg, (Throwable)e);
                        this.oauthTokenGenerator = new OAuthIssuerImpl(this.getTokenValueGenerator());
                    }
                }
            }
        }
        return this.oauthTokenGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueGenerator getTokenValueGenerator() {
        if (this.tokenValueGenerator == null) {
            OAuthServerConfiguration oAuthServerConfiguration = this;
            synchronized (oAuthServerConfiguration) {
                if (this.tokenValueGenerator == null) {
                    try {
                        if (this.tokenValueGeneratorClassName != null) {
                            Class<?> clazz = this.getClass().getClassLoader().loadClass(this.tokenValueGeneratorClassName);
                            this.tokenValueGenerator = (ValueGenerator)clazz.newInstance();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("An instance of " + this.tokenValueGeneratorClassName + " is created."));
                            }
                        } else {
                            this.tokenValueGenerator = new UUIDValueGenerator();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Default token value generator UUIDValueGenerator will be used.");
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while initiating the token value generator :" + this.tokenValueGeneratorClassName + ". Defaulting to UUIDValueGenerator."), (Throwable)e);
                        this.tokenValueGenerator = new UUIDValueGenerator();
                    }
                }
            }
        }
        return this.tokenValueGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OauthTokenIssuer getIdentityOauthTokenIssuer() {
        if (this.oauthIdentityTokenGenerator == null) {
            OAuthServerConfiguration oAuthServerConfiguration = this;
            synchronized (oAuthServerConfiguration) {
                if (this.oauthIdentityTokenGenerator == null) {
                    try {
                        if (this.oauthIdentityTokenGeneratorClassName != null) {
                            Class<?> clazz = this.getClass().getClassLoader().loadClass(this.oauthIdentityTokenGeneratorClassName);
                            this.oauthIdentityTokenGenerator = (OauthTokenIssuer)clazz.newInstance();
                            log.info((Object)("An instance of " + this.oauthIdentityTokenGeneratorClassName + " is created for Identity OAuth token generation."));
                        } else {
                            this.oauthIdentityTokenGenerator = new OauthTokenIssuerImpl();
                            log.info((Object)"The default Identity OAuth token issuer will be used. No custom token generator is set.");
                        }
                    }
                    catch (Exception e) {
                        String errorMsg = "Error when instantiating the OAuthIssuer : " + this.tokenPersistenceProcessorClassName + ". Defaulting to OAuthIssuerImpl";
                        log.error((Object)errorMsg, (Throwable)e);
                        this.oauthIdentityTokenGenerator = new OauthTokenIssuerImpl();
                    }
                }
            }
        }
        return this.oauthIdentityTokenGenerator;
    }

    public boolean usePersistedAccessTokenAlias() {
        if (this.persistAccessTokenAlias != null) {
            return Boolean.TRUE.toString().equalsIgnoreCase(this.persistAccessTokenAlias);
        }
        return true;
    }

    public boolean useRetainOldAccessTokens() {
        return Boolean.TRUE.toString().equalsIgnoreCase(this.retainOldAccessTokens);
    }

    public boolean isTokenCleanupEnabled() {
        return Boolean.TRUE.toString().equalsIgnoreCase(this.tokenCleanupFeatureEnable);
    }

    public String getOIDCConsentPageUrl() {
        return oidcConsentPageUrl;
    }

    public String getOauth2ConsentPageUrl() {
        return oauth2ConsentPageUrl;
    }

    public String getOauth2ErrorPageUrl() {
        return oauth2ErrorPageUrl;
    }

    public long getAuthorizationCodeValidityPeriodInSeconds() {
        return this.authorizationCodeValidityPeriodInSeconds;
    }

    public long getUserAccessTokenValidityPeriodInSeconds() {
        return this.userAccessTokenValidityPeriodInSeconds;
    }

    public long getApplicationAccessTokenValidityPeriodInSeconds() {
        return this.applicationAccessTokenValidityPeriodInSeconds;
    }

    public long getRefreshTokenValidityPeriodInSeconds() {
        return this.refreshTokenValidityPeriodInSeconds;
    }

    public long getTimeStampSkewInSeconds() {
        return this.timeStampSkewInSeconds;
    }

    public String getClientIdValidationRegex() {
        return this.clientIdValidationRegex;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public boolean isRefreshTokenRenewalEnabled() {
        return this.isRefreshTokenRenewalEnabled;
    }

    public boolean isExtendRenewedTokenExpiryTimeEnabled() {
        return this.isExtendRenewedTokenExpiryTimeEnabled;
    }

    public Map<String, OauthTokenIssuer> getOauthTokenIssuerMap() {
        return this.oauthTokenIssuerMap;
    }

    public boolean isTokenRenewalPerRequestEnabled() {
        return this.isTokenRenewalPerRequestEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AuthorizationGrantHandler> getSupportedGrantTypes() {
        if (this.supportedGrantTypes == null) {
            OAuthServerConfiguration oAuthServerConfiguration = this;
            synchronized (oAuthServerConfiguration) {
                if (this.supportedGrantTypes == null) {
                    HashMap<String, AuthorizationGrantHandler> supportedGrantTypesTemp = new HashMap<String, AuthorizationGrantHandler>();
                    for (Map.Entry<String, String> entry : this.supportedGrantTypeClassNames.entrySet()) {
                        AuthorizationGrantHandler authzGrantHandler = null;
                        try {
                            authzGrantHandler = (AuthorizationGrantHandler)Class.forName(entry.getValue()).newInstance();
                            authzGrantHandler.init();
                        }
                        catch (InstantiationException e) {
                            log.error((Object)("Error instantiating " + entry.getValue()), (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            log.error((Object)("Illegal access to " + entry.getValue()), (Throwable)e);
                        }
                        catch (ClassNotFoundException e) {
                            log.error((Object)("Cannot find class: " + entry.getValue()), (Throwable)e);
                        }
                        catch (IdentityOAuth2Exception e) {
                            log.error((Object)("Error while initializing " + entry.getValue()), (Throwable)((Object)e));
                        }
                        if (authzGrantHandler != null) {
                            supportedGrantTypesTemp.put(entry.getKey(), authzGrantHandler);
                            continue;
                        }
                        log.warn((Object)("Grant type : " + entry.getKey() + ", is not added as a supported grant type. Relevant grant handler failed to initiate properly."));
                    }
                    this.supportedGrantTypes = supportedGrantTypesTemp;
                }
            }
        }
        return this.supportedGrantTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<? extends OAuthValidator<HttpServletRequest>>> getSupportedGrantTypeValidators() {
        if (this.supportedGrantTypeValidators == null) {
            OAuthServerConfiguration oAuthServerConfiguration = this;
            synchronized (oAuthServerConfiguration) {
                if (this.supportedGrantTypeValidators == null) {
                    Hashtable<String, Class<? extends OAuthValidator<HttpServletRequest>>> supportedGrantTypeValidatorsTemp = new Hashtable<String, Class<? extends OAuthValidator<HttpServletRequest>>>();
                    supportedGrantTypeValidatorsTemp.put(org.apache.oltu.oauth2.common.message.types.GrantType.PASSWORD.toString(), PasswordGrantValidator.class);
                    supportedGrantTypeValidatorsTemp.put(org.apache.oltu.oauth2.common.message.types.GrantType.CLIENT_CREDENTIALS.toString(), ClientCredentialGrantValidator.class);
                    supportedGrantTypeValidatorsTemp.put(org.apache.oltu.oauth2.common.message.types.GrantType.AUTHORIZATION_CODE.toString(), AuthorizationCodeGrantValidator.class);
                    supportedGrantTypeValidatorsTemp.put(org.apache.oltu.oauth2.common.message.types.GrantType.REFRESH_TOKEN.toString(), RefreshTokenGrantValidator.class);
                    supportedGrantTypeValidatorsTemp.put(GrantType.SAML20_BEARER.toString(), SAML2GrantValidator.class);
                    if (this.supportedGrantTypeValidatorNames != null) {
                        for (Map.Entry<String, String> entry : this.supportedGrantTypeValidatorNames.entrySet()) {
                            try {
                                Class<?> oauthValidatorClass = Class.forName(entry.getValue());
                                supportedGrantTypeValidatorsTemp.put(entry.getKey(), oauthValidatorClass);
                            }
                            catch (ClassNotFoundException e) {
                                log.error((Object)("Cannot find class: " + entry.getValue()), (Throwable)e);
                            }
                            catch (ClassCastException e) {
                                log.error((Object)("Cannot cast class: " + entry.getValue()), (Throwable)e);
                            }
                        }
                    }
                    this.supportedGrantTypeValidators = supportedGrantTypeValidatorsTemp;
                }
            }
        }
        return this.supportedGrantTypeValidators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<? extends OAuthValidator<HttpServletRequest>>> getSupportedResponseTypeValidators() {
        if (this.supportedResponseTypeValidators == null) {
            OAuthServerConfiguration oAuthServerConfiguration = this;
            synchronized (oAuthServerConfiguration) {
                if (this.supportedResponseTypeValidators == null) {
                    Hashtable<String, Class<? extends OAuthValidator<HttpServletRequest>>> supportedResponseTypeValidatorsTemp = new Hashtable<String, Class<? extends OAuthValidator<HttpServletRequest>>>();
                    supportedResponseTypeValidatorsTemp.put(ResponseType.CODE.toString(), CodeValidator.class);
                    supportedResponseTypeValidatorsTemp.put(ResponseType.TOKEN.toString(), TokenValidator.class);
                    supportedResponseTypeValidatorsTemp.put("id_token", IDTokenResponseValidator.class);
                    supportedResponseTypeValidatorsTemp.put("id_token token", IDTokenTokenResponseValidator.class);
                    supportedResponseTypeValidatorsTemp.put("code token", CodeTokenResponseValidator.class);
                    supportedResponseTypeValidatorsTemp.put("code id_token", CodeTokenResponseValidator.class);
                    supportedResponseTypeValidatorsTemp.put("code id_token token", CodeTokenResponseValidator.class);
                    if (this.supportedResponseTypeValidatorNames != null) {
                        for (Map.Entry<String, String> entry : this.supportedResponseTypeValidatorNames.entrySet()) {
                            try {
                                Class<?> oauthValidatorClass = Class.forName(entry.getValue());
                                supportedResponseTypeValidatorsTemp.put(entry.getKey(), oauthValidatorClass);
                            }
                            catch (ClassNotFoundException e) {
                                log.error((Object)("Cannot find class: " + entry.getValue()), (Throwable)e);
                            }
                            catch (ClassCastException e) {
                                log.error((Object)("Cannot cast class: " + entry.getValue()), (Throwable)e);
                            }
                        }
                        this.supportedResponseTypeValidators = supportedResponseTypeValidatorsTemp;
                    }
                }
            }
        }
        return this.supportedResponseTypeValidators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ResponseTypeHandler> getSupportedResponseTypes() {
        if (this.supportedResponseTypes == null) {
            OAuthServerConfiguration oAuthServerConfiguration = this;
            synchronized (oAuthServerConfiguration) {
                if (this.supportedResponseTypes == null) {
                    Hashtable<String, ResponseTypeHandler> supportedResponseTypesTemp = new Hashtable<String, ResponseTypeHandler>();
                    for (Map.Entry<String, String> entry : this.supportedResponseTypeClassNames.entrySet()) {
                        ResponseTypeHandler responseTypeHandler = null;
                        try {
                            responseTypeHandler = (ResponseTypeHandler)Class.forName(entry.getValue()).newInstance();
                            responseTypeHandler.init();
                        }
                        catch (InstantiationException e) {
                            log.error((Object)("Error instantiating " + entry.getValue()), (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            log.error((Object)("Illegal access to " + entry.getValue()), (Throwable)e);
                        }
                        catch (ClassNotFoundException e) {
                            log.error((Object)("Cannot find class: " + entry.getValue()), (Throwable)e);
                        }
                        catch (IdentityOAuth2Exception e) {
                            log.error((Object)("Error while initializing " + entry.getValue()), (Throwable)((Object)e));
                        }
                        supportedResponseTypesTemp.put(entry.getKey(), responseTypeHandler);
                    }
                    this.supportedResponseTypes = supportedResponseTypesTemp;
                }
            }
        }
        return this.supportedResponseTypes;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public boolean isClientSecretHashEnabled() {
        return this.isClientSecretHashEnabled;
    }

    private void parseRequestObjectConfig(OMElement requestObjectBuildersElem) {
        if (requestObjectBuildersElem != null) {
            Iterator iterator = requestObjectBuildersElem.getChildrenWithName(this.getQNameWithIdentityNS("RequestObjectBuilder"));
            while (iterator.hasNext()) {
                OMElement requestObjectBuildersElement = (OMElement)iterator.next();
                OMElement builderTypeElement = requestObjectBuildersElement.getFirstChildWithName(this.getQNameWithIdentityNS("Type"));
                OMElement requestObjectImplClassElement = requestObjectBuildersElement.getFirstChildWithName(this.getQNameWithIdentityNS("ClassName"));
                if (builderTypeElement == null) {
                    log.warn((Object)"Empty configuration element for <Type> under <RequestObjectBuilder> configuration.");
                    continue;
                }
                if (requestObjectImplClassElement == null) {
                    log.warn((Object)"No <ClassName> tag to define RequestObjectBuilder implementation found under <RequestObjectBuilder> configuration.");
                    continue;
                }
                String builderType = builderTypeElement.getText();
                String requestObjectImplClass = requestObjectImplClassElement.getText();
                this.requestObjectBuilderClassNames.put(builderType, requestObjectImplClass);
            }
        }
        this.setDefaultRequestObjectBuilderClasses();
        if (log.isDebugEnabled()) {
            for (Map.Entry<String, String> entry : this.requestObjectBuilderClassNames.entrySet()) {
                String builderName = entry.getKey().toString();
                String requestObjectBuilderImplClass = entry.getValue().toString();
                log.debug((Object)(builderName + " is associated with " + requestObjectBuilderImplClass));
            }
        }
    }

    private void setDefaultRequestObjectBuilderClasses() {
        if (this.requestObjectBuilderClassNames.get(REQUEST_PARAM_VALUE_BUILDER) == null) {
            log.info((Object)"'RequestObjectBuilder' element for Type: request_param_value_builderis not configured in identity.xml. Therefore instantiating default request object builder: org.wso2.carbon.identity.openidconnect.RequestParamRequestObjectBuilder");
            this.requestObjectBuilderClassNames.put(REQUEST_PARAM_VALUE_BUILDER, REQUEST_PARAM_VALUE_BUILDER_CLASS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RequestObjectValidator getRequestObjectValidator() {
        if (this.requestObjectValidator != null) return this.requestObjectValidator;
        Class<RequestObjectValidator> clazz = RequestObjectValidator.class;
        synchronized (RequestObjectValidator.class) {
            if (this.requestObjectValidator != null) return this.requestObjectValidator;
            try {
                Class<?> clazz2 = Thread.currentThread().getContextClassLoader().loadClass(this.defaultRequestValidatorClassName);
                this.requestObjectValidator = (RequestObjectValidator)clazz2.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.warn((Object)"Failed to initiate RequestObjectValidator from identity.xml. Hence initiating the default implementation");
                this.requestObjectValidator = new RequestObjectValidatorImpl();
            }
            return this.requestObjectValidator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RequestObjectBuilder> getRequestObjectBuilders() {
        if (this.requestObjectBuilder == null) {
            OAuthServerConfiguration oAuthServerConfiguration = this;
            synchronized (oAuthServerConfiguration) {
                if (this.requestObjectBuilder == null) {
                    HashMap<String, RequestObjectBuilder> requestBuilderTemp = new HashMap<String, RequestObjectBuilder>();
                    for (Map.Entry<String, String> entry : this.requestObjectBuilderClassNames.entrySet()) {
                        RequestObjectBuilder requestObjectBuilder = null;
                        try {
                            requestObjectBuilder = (RequestObjectBuilder)Class.forName(entry.getValue()).newInstance();
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                            log.error((Object)("Error instantiating " + entry.getValue()), (Throwable)e);
                        }
                        if (requestObjectBuilder != null) {
                            requestBuilderTemp.put(entry.getKey(), requestObjectBuilder);
                            continue;
                        }
                        log.warn((Object)("Failed to initiate request object builder class which is associated with the builder " + entry.getKey()));
                    }
                    this.requestObjectBuilder = requestBuilderTemp;
                }
            }
        }
        return this.requestObjectBuilder;
    }

    public Set<String> getSupportedResponseTypeNames() {
        return this.supportedResponseTypeClassNames.keySet();
    }

    public String[] getSupportedClaims() {
        return this.supportedClaims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SAML2TokenCallbackHandler getSAML2TokenCallbackHandler() {
        if (StringUtils.isBlank((String)this.saml2TokenCallbackHandlerName)) {
            return null;
        }
        if (this.saml2TokenCallbackHandler != null) return this.saml2TokenCallbackHandler;
        Class<SAML2TokenCallbackHandler> clazz = SAML2TokenCallbackHandler.class;
        synchronized (SAML2TokenCallbackHandler.class) {
            if (this.saml2TokenCallbackHandler != null) return this.saml2TokenCallbackHandler;
            try {
                Class<?> clazz2 = Thread.currentThread().getContextClassLoader().loadClass(this.saml2TokenCallbackHandlerName);
                this.saml2TokenCallbackHandler = (SAML2TokenCallbackHandler)clazz2.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while instantiating the SAML2TokenCallbackHandler ", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)"Error while instantiating the SAML2TokenCallbackHandler ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Error while instantiating the SAML2TokenCallbackHandler ", (Throwable)e);
            }
            return this.saml2TokenCallbackHandler;
        }
    }

    public Map<String, String> getTokenValidatorClassNames() {
        return this.tokenValidatorClassNames;
    }

    public boolean isAccessTokenPartitioningEnabled() {
        return this.accessTokenPartitioningEnabled;
    }

    public Map<String, String> getIdTokenAllowedForGrantTypesMap() {
        return this.idTokenAllowedForGrantTypesMap;
    }

    public Set<String> getIdTokenNotAllowedGrantTypesSet() {
        return this.idTokenNotAllowedGrantTypesSet;
    }

    public boolean isRedirectToRequestedRedirectUriEnabled() {
        return this.redirectToRequestedRedirectUriEnabled;
    }

    public boolean isUserNameAssertionEnabled() {
        return this.assertionsUserNameEnabled;
    }

    public String getAccessTokenPartitioningDomains() {
        return this.accessTokenPartitioningDomains;
    }

    private QName getQNameWithIdentityNS(String localPart) {
        return new QName("http://wso2.org/projects/carbon/carbon.xml", localPart);
    }

    public boolean isAuthContextTokGenEnabled() {
        return this.isAuthContextTokGenEnabled;
    }

    public String getTokenGeneratorImplClass() {
        return this.tokenGeneratorImplClass;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getIdTokenSignatureAlgorithm() {
        return this.idTokenSignatureAlgorithm;
    }

    public String getDefaultIdTokenEncryptionAlgorithm() {
        return this.defaultIdTokenEncryptionAlgorithm;
    }

    public List<String> getSupportedIdTokenEncryptionAlgorithm() {
        return this.supportedIdTokenEncryptionAlgorithms;
    }

    public String getDefaultIdTokenEncryptionMethod() {
        return this.defaultIdTokenEncryptionMethod;
    }

    public List<String> getSupportedIdTokenEncryptionMethods() {
        return this.supportedIdTokenEncryptionMethods;
    }

    public String getUserInfoJWTSignatureAlgorithm() {
        return this.userInfoJWTSignatureAlgorithm;
    }

    public String getConsumerDialectURI() {
        return this.consumerDialectURI;
    }

    public String getClaimsRetrieverImplClass() {
        return this.claimsRetrieverImplClass;
    }

    public String getAuthorizationContextTTL() {
        return this.authContextTTL;
    }

    public boolean isUseMultiValueSeparatorForAuthContextToken() {
        return this.useMultiValueSeparatorForAuthContextToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenPersistenceProcessor getPersistenceProcessor() throws IdentityOAuth2Exception {
        if (this.persistenceProcessor == null) {
            OAuthServerConfiguration oAuthServerConfiguration = this;
            synchronized (oAuthServerConfiguration) {
                if (this.persistenceProcessor == null) {
                    try {
                        Class<?> clazz = this.getClass().getClassLoader().loadClass(this.tokenPersistenceProcessorClassName);
                        this.persistenceProcessor = (TokenPersistenceProcessor)clazz.newInstance();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("An instance of " + this.tokenPersistenceProcessorClassName + " is created for OAuthServerConfiguration."));
                        }
                    }
                    catch (Exception e) {
                        String errorMsg = "Error when instantiating the TokenPersistenceProcessor : " + this.tokenPersistenceProcessorClassName + ". Defaulting to PlainTextPersistenceProcessor";
                        log.error((Object)errorMsg, (Throwable)e);
                        this.persistenceProcessor = new PlainTextPersistenceProcessor();
                    }
                }
            }
        }
        return this.persistenceProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IDTokenBuilder getOpenIDConnectIDTokenBuilder() {
        if (this.openIDConnectIDTokenBuilder != null) return this.openIDConnectIDTokenBuilder;
        Class<IDTokenBuilder> clazz = IDTokenBuilder.class;
        synchronized (IDTokenBuilder.class) {
            if (this.openIDConnectIDTokenBuilder != null) return this.openIDConnectIDTokenBuilder;
            try {
                Class<?> clazz2 = Thread.currentThread().getContextClassLoader().loadClass(this.openIDConnectIDTokenBuilderClassName);
                this.openIDConnectIDTokenBuilder = (IDTokenBuilder)clazz2.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while instantiating the IDTokenBuilder ", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)"Error while instantiating the IDTokenBuilder ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Error while instantiating the IDTokenBuilder ", (Throwable)e);
            }
            return this.openIDConnectIDTokenBuilder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CustomClaimsCallbackHandler getOpenIDConnectCustomClaimsCallbackHandler() {
        if (this.openidConnectIDTokenCustomClaimsCallbackHandler != null) return this.openidConnectIDTokenCustomClaimsCallbackHandler;
        Class<CustomClaimsCallbackHandler> clazz = CustomClaimsCallbackHandler.class;
        synchronized (CustomClaimsCallbackHandler.class) {
            if (this.openidConnectIDTokenCustomClaimsCallbackHandler != null) return this.openidConnectIDTokenCustomClaimsCallbackHandler;
            try {
                Class<?> clazz2 = Thread.currentThread().getContextClassLoader().loadClass(this.openIDConnectIDTokenCustomClaimsHanlderClassName);
                this.openidConnectIDTokenCustomClaimsCallbackHandler = (CustomClaimsCallbackHandler)clazz2.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error((Object)"Error while instantiating the IDTokenBuilder ", (Throwable)e);
            }
            return this.openidConnectIDTokenCustomClaimsCallbackHandler;
        }
    }

    public String getOpenIDConnectIDTokenIssuerIdentifier() {
        return this.openIDConnectIDTokenIssuerIdentifier;
    }

    public String getOpenIDConnectIDTokenSubjectClaim() {
        return this.openIDConnectIDTokenSubClaim;
    }

    public boolean getOpenIDConnectSkipeUserConsentConfig() {
        if (this.openIDConnectSkipLoginConsent == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The SkipLoginConsent property is not configured. So retrieving the SkipUserConsent value.");
            }
            return this.openIDConnectSkipUserConsent;
        }
        return this.openIDConnectSkipLoginConsent;
    }

    public boolean getOpenIDConnectSkipLogoutConsentConfig() {
        if (this.openIDConnectSkipLogoutConsent == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The SkipLogoutConsent property is not configured. So retrieving the SkipUserConsent value.");
            }
            return this.openIDConnectSkipUserConsent;
        }
        return this.openIDConnectSkipLogoutConsent;
    }

    public String getOpenIDConnectIDTokenExpiration() {
        return this.openIDConnectIDTokenExpiration;
    }

    public long getOpenIDConnectIDTokenExpiryTimeInSeconds() {
        return this.openIDConnectIDTokenExpiryTimeInSeconds;
    }

    public String getOpenIDConnectBCLogoutTokenExpiration() {
        return this.openIDConnectBCLogoutTokenExpiryInSeconds;
    }

    public String getOpenIDConnectUserInfoEndpointClaimDialect() {
        return this.openIDConnectUserInfoEndpointClaimDialect;
    }

    public String getOpenIDConnectUserInfoEndpointClaimRetriever() {
        return this.openIDConnectUserInfoEndpointClaimRetriever;
    }

    public String getOpenIDConnectUserInfoEndpointRequestValidator() {
        return this.openIDConnectUserInfoEndpointRequestValidator;
    }

    public String getOpenIDConnectUserInfoEndpointAccessTokenValidator() {
        return this.openIDConnectUserInfoEndpointAccessTokenValidator;
    }

    public String getOpenIDConnectUserInfoEndpointResponseBuilder() {
        return this.openIDConnectUserInfoEndpointResponseBuilder;
    }

    public boolean isJWTSignedWithSPKey() {
        return this.isJWTSignedWithSPKey;
    }

    public boolean isImplicitErrorFragment() {
        return this.isImplicitErrorFragment;
    }

    public boolean isRevokeResponseHeadersEnabled() {
        return this.isRevokeResponseHeadersEnabled;
    }

    public boolean isEnableIntrospectionDataProviders() {
        return this.enableIntrospectionDataProviders;
    }

    public boolean getValueForIsRefreshTokenAllowed(String grantType) {
        Boolean isRefreshTokenAllowed = this.refreshTokenAllowedGrantTypes.get(grantType);
        return isRefreshTokenAllowed == null ? true : isRefreshTokenAllowed;
    }

    public boolean isUserConsentRequiredForClaims(String grantType) {
        return this.userConsentEnabledGrantTypes.contains(grantType);
    }

    public boolean getUseSPTenantDomainValue() {
        return this.useSPTenantDomainValue;
    }

    public String getSaml2BearerTokenUserType() {
        return this.saml2BearerTokenUserType;
    }

    public boolean getSaml2UserIdFromClaims() {
        return this.saml2UserIdFromClaims;
    }

    public boolean isConvertOriginalClaimsFromAssertionsToOIDCDialect() {
        return this.convertOriginalClaimsFromAssertionsToOIDCDialect;
    }

    public boolean isReturnOnlyMappedLocalRoles() {
        return this.returnOnlyMappedLocalRoles;
    }

    public boolean isAddUnmappedUserAttributes() {
        return this.addUnmappedUserAttributes;
    }

    public boolean isMapFederatedUsersToLocal() {
        return this.mapFederatedUsersToLocal;
    }

    public boolean isAddTenantDomainToIdTokenEnabled() {
        return this.addTenantDomainToIdTokenEnabled;
    }

    public boolean isAddUserstoreDomainToIdTokenEnabled() {
        return this.addUserstoreDomainToIdTokenEnabled;
    }

    private void parseOAuthCallbackHandlers(OMElement callbackHandlersElem) {
        if (callbackHandlersElem == null) {
            this.warnOnFaultyConfiguration("OAuthCallbackHandlers element is not available.");
            return;
        }
        Iterator callbackHandlers = callbackHandlersElem.getChildrenWithLocalName("OAuthCallbackHandler");
        int callbackHandlerCount = 0;
        if (callbackHandlers != null) {
            while (callbackHandlers.hasNext()) {
                OAuthCallbackHandlerMetaData cbHandlerMetadata = this.buildAuthzCallbackHandlerMetadata((OMElement)callbackHandlers.next());
                if (cbHandlerMetadata == null) continue;
                this.callbackHandlerMetaData.add(cbHandlerMetadata);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OAuthCallbackHandlerMetadata was added. Class : " + cbHandlerMetadata.getClassName()));
                }
                ++callbackHandlerCount;
            }
        }
        if (callbackHandlerCount <= 0) {
            this.warnOnFaultyConfiguration("No OAuthCallbackHandler elements were found.");
        }
    }

    private void parseTokenValidators(OMElement tokenValidators) {
        if (tokenValidators == null) {
            return;
        }
        Iterator validators = tokenValidators.getChildrenWithLocalName("TokenValidator");
        if (validators != null) {
            while (validators.hasNext()) {
                OMElement validator = (OMElement)validators.next();
                if (validator == null) continue;
                String clazzName = validator.getAttributeValue(new QName("class"));
                String type = validator.getAttributeValue(new QName("type"));
                this.tokenValidatorClassNames.put(type, clazzName);
            }
        }
    }

    private void parseScopeValidator(OMElement scopeValidatorElem) {
        HashSet<OAuth2ScopeValidator> scopeValidators = new HashSet<OAuth2ScopeValidator>();
        if ("ScopeValidators".equals(scopeValidatorElem.getLocalName())) {
            Iterator scopeIterator = scopeValidatorElem.getChildrenWithName(this.getQNameWithIdentityNS("ScopeValidator"));
            while (scopeIterator.hasNext()) {
                OAuth2ScopeValidator scopeValidator;
                OMElement scopeValidatorElement = (OMElement)scopeIterator.next();
                String validatorClazz = scopeValidatorElement.getAttributeValue(new QName("class"));
                if (validatorClazz == null || (scopeValidator = this.getClassInstance(validatorClazz, OAuth2ScopeValidator.class)) == null) continue;
                String scopesToSkipAttr = scopeValidatorElement.getAttributeValue(new QName("scopesToSkip"));
                scopeValidator.setScopesToSkip(this.getScopesToSkipSet(scopesToSkipAttr));
                Iterator propertyIterator = scopeValidatorElement.getChildrenWithName(this.getQNameWithIdentityNS("Property"));
                HashMap<String, String> properties = new HashMap<String, String>();
                while (propertyIterator.hasNext()) {
                    OMElement propertyElement = (OMElement)propertyIterator.next();
                    String paramName = propertyElement.getAttributeValue(new QName("name"));
                    String paramValue = propertyElement.getText();
                    properties.put(paramName, paramValue);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Property: %s with value: %s is set to ScopeValidator: %s.", paramName, paramValue, validatorClazz));
                }
                scopeValidator.setProperties(properties);
                scopeValidators.add(scopeValidator);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("ScopeValidator: %s is added to ScopeValidators list.", scopeValidator.getClass().getCanonicalName()));
            }
        } else {
            String scopeValidatorClazz = scopeValidatorElem.getAttributeValue(new QName("class"));
            String scopesToSkipAttr = scopeValidatorElem.getAttributeValue(new QName("scopesToSkip"));
            if (scopeValidatorClazz != null) {
                OAuth2ScopeValidator scopeValidator = this.getClassInstance(scopeValidatorClazz, OAuth2ScopeValidator.class);
                if (scopeValidator != null) {
                    scopeValidator.setScopesToSkip(this.getScopesToSkipSet(scopesToSkipAttr));
                }
                scopeValidators.add(scopeValidator);
            }
        }
        this.setOAuth2ScopeValidators(scopeValidators);
    }

    private void parseScopeHandlers(OMElement scopeHandlersElem) {
        HashSet<OAuth2ScopeHandler> scopeHandlers = new HashSet<OAuth2ScopeHandler>();
        Iterator scopeHandlerIterator = scopeHandlersElem.getChildrenWithName(this.getQNameWithIdentityNS("ScopeHandler"));
        if (scopeHandlerIterator == null) {
            return;
        }
        while (scopeHandlerIterator.hasNext()) {
            OAuth2ScopeHandler scopeHandler;
            OMElement scopeHandlerElem = (OMElement)scopeHandlerIterator.next();
            String scopeHandlerClazz = scopeHandlerElem.getAttributeValue(new QName("class"));
            if (scopeHandlerClazz == null || (scopeHandler = this.getClassInstance(scopeHandlerClazz, OAuth2ScopeHandler.class)) == null) continue;
            Iterator propertyIterator = scopeHandlerElem.getChildrenWithName(this.getQNameWithIdentityNS("Property"));
            HashMap<String, String> properties = new HashMap<String, String>();
            while (propertyIterator.hasNext()) {
                OMElement propertyElement = (OMElement)propertyIterator.next();
                String paramName = propertyElement.getAttributeValue(new QName("name"));
                String paramValue = propertyElement.getText();
                properties.put(paramName, paramValue);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Property: %s with value: %s is set to ScopeHandler: %s.", paramName, paramValue, scopeHandlerClazz));
            }
            scopeHandler.setProperties(properties);
            scopeHandlers.add(scopeHandler);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("ScopeHandler: %s is added to ScopeHandler list.", scopeHandler.getClass().getCanonicalName()));
        }
        this.setOAuth2ScopeHandlers(scopeHandlers);
    }

    private <T> T getClassInstance(String scopeValidatorClazz, Class<T> type) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(scopeValidatorClazz);
            return type.cast(clazz.newInstance());
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Class not found in build path " + scopeValidatorClazz), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)("Class initialization error " + scopeValidatorClazz), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Class access error " + scopeValidatorClazz), (Throwable)e);
        }
        catch (ClassCastException e) {
            log.error((Object)("Cannot cast the class: " + scopeValidatorClazz + " to type: " + type.getCanonicalName()), (Throwable)e);
        }
        return null;
    }

    private Set<String> getScopesToSkipSet(String scopesToSkip) {
        HashSet<String> scopes = new HashSet<String>();
        if (StringUtils.isNotEmpty((String)scopesToSkip)) {
            scopes = new HashSet<String>(Arrays.asList(scopesToSkip.trim().split("\\s+")));
        }
        return scopes;
    }

    private void warnOnFaultyConfiguration(String logMsg) {
        log.warn((Object)("Error in OAuth Configuration. " + logMsg));
    }

    private OAuthCallbackHandlerMetaData buildAuthzCallbackHandlerMetadata(OMElement omElement) {
        String className = omElement.getAttributeValue(new QName("Class"));
        if (className == null) {
            log.error((Object)"Mandatory attribute \"Class\" is not present in the AuthorizationCallbackHandler element. AuthorizationCallbackHandler will not be registered.");
            return null;
        }
        int priority = 1;
        OMElement priorityElem = omElement.getFirstChildWithName(this.getQNameWithIdentityNS("Priority"));
        if (priorityElem != null) {
            priority = Integer.parseInt(priorityElem.getText());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Priority level of : " + priority + " is set for the AuthorizationCallbackHandler with the class : " + className));
        }
        OMElement paramsElem = omElement.getFirstChildWithName(this.getQNameWithIdentityNS("Properties"));
        Properties properties = null;
        if (paramsElem != null) {
            Iterator paramItr = paramsElem.getChildrenWithLocalName("Property");
            properties = new Properties();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registering Properties for AuthorizationCallbackHandler class : " + className));
            }
            while (paramItr.hasNext()) {
                OMElement paramElem = (OMElement)paramItr.next();
                String paramName = paramElem.getAttributeValue(new QName("Name"));
                String paramValue = paramElem.getText();
                properties.put(paramName, paramValue);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Property name : " + paramName + ", Property Value : " + paramValue));
            }
        }
        return new OAuthCallbackHandlerMetaData(className, properties, priority);
    }

    private void parseDefaultValidityPeriods(OMElement oauthConfigElem) {
        OMElement timeStampSkewElem;
        OMElement refreshTokenTimeoutElem;
        OMElement applicationAccessTokTimeoutElem;
        OMElement accessTokTimeoutElem;
        OMElement authzCodeTimeoutElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AuthorizationCodeDefaultValidityPeriod"));
        if (authzCodeTimeoutElem != null) {
            this.authorizationCodeValidityPeriodInSeconds = Long.parseLong(authzCodeTimeoutElem.getText());
        }
        if ((accessTokTimeoutElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserAccessTokenDefaultValidityPeriod"))) != null) {
            this.userAccessTokenValidityPeriodInSeconds = Long.parseLong(accessTokTimeoutElem.getText());
        }
        if ((applicationAccessTokTimeoutElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AccessTokenDefaultValidityPeriod"))) != null) {
            this.applicationAccessTokenValidityPeriodInSeconds = Long.parseLong(applicationAccessTokTimeoutElem.getText());
        }
        if ((refreshTokenTimeoutElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("RefreshTokenValidityPeriod"))) != null) {
            this.refreshTokenValidityPeriodInSeconds = Long.parseLong(refreshTokenTimeoutElem.getText().trim());
        }
        if ((timeStampSkewElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("TimestampSkew"))) != null) {
            this.timeStampSkewInSeconds = Long.parseLong(timeStampSkewElem.getText());
        }
        if (log.isDebugEnabled()) {
            if (authzCodeTimeoutElem == null) {
                log.debug((Object)"\"Authorization Code Default Timeout\" element was not available in identity.xml. Continuing with the default value.");
            }
            if (accessTokTimeoutElem == null) {
                log.debug((Object)"\"Access Token Default Timeout\" element was not available in from identity.xml. Continuing with the default value.");
            }
            if (refreshTokenTimeoutElem == null) {
                log.debug((Object)"\"Refresh Token Default Timeout\" element was not available in from identity.xml. Continuing with the default value.");
            }
            if (timeStampSkewElem == null) {
                log.debug((Object)"\"Default Timestamp Skew\" element was not available in from identity.xml. Continuing with the default value.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authorization Code Default Timeout is set to : " + this.authorizationCodeValidityPeriodInSeconds + "ms."));
                log.debug((Object)("User Access Token Default Timeout is set to " + this.userAccessTokenValidityPeriodInSeconds + "ms."));
                log.debug((Object)("Application Access Token Default Timeout is set to " + this.applicationAccessTokenValidityPeriodInSeconds + "ms."));
                log.debug((Object)("Refresh Token validity period is set to " + this.refreshTokenValidityPeriodInSeconds + "s."));
                log.debug((Object)("Default TimestampSkew is set to " + this.timeStampSkewInSeconds + "ms."));
            }
        }
    }

    private void parseOAuthURLs(OMElement oauthConfigElem) {
        OMElement elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth1RequestTokenUrl"));
        if (elem != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth1RequestTokenUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth1AuthorizeUrl"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth1AuthorizeUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth1AccessTokenUrl"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth1AccessTokenUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth2AuthzEPUrl"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth2AuthzEPUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth2TokenEPUrl"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth2TokenEPUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth2UserInfoEPUrl"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth2UserInfoEPUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth2RevokeEPUrl"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth2RevocationEPUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth2IntrospectEPUrl"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth2IntrospectionEPUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth2ConsentPage"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth2ConsentPageUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth2DCREPUrl"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth2DCREPUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth2JWKSPage"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth2JWKSPageUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OIDCDiscoveryEPUrl"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oidcDiscoveryUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OIDCWebFingerEPUrl"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oidcWebFingerEPUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OIDCConsentPage"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oidcConsentPageUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
        if ((elem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuth2ErrorPage"))) != null && StringUtils.isNotBlank((String)elem.getText())) {
            oauth2ErrorPageUrl = IdentityUtil.fillURLPlaceholders((String)elem.getText());
        }
    }

    private void parseRefreshTokenRenewalConfiguration(OMElement oauthConfigElem) {
        OMElement enableExtendRenewedTokenExpTimeElem;
        OMElement enableRefreshTokenRenewalElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("RenewRefreshTokenForRefreshGrant"));
        if (enableRefreshTokenRenewalElem != null) {
            this.isRefreshTokenRenewalEnabled = Boolean.parseBoolean(enableRefreshTokenRenewalElem.getText());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("RenewRefreshTokenForRefreshGrant was set to : " + this.isRefreshTokenRenewalEnabled));
        }
        if ((enableExtendRenewedTokenExpTimeElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("ExtendRenewedRefreshTokenExpiryTime"))) != null) {
            this.isExtendRenewedTokenExpiryTimeEnabled = Boolean.parseBoolean(enableExtendRenewedTokenExpTimeElem.getText());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ExtendRenewedRefreshTokenExpiryTime was set to : " + this.isExtendRenewedTokenExpiryTimeEnabled));
        }
    }

    private void parseAccessTokenPartitioningConfig(OMElement oauthConfigElem) {
        OMElement enableAccessTokenPartitioningElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("EnableAccessTokenPartitioning"));
        if (enableAccessTokenPartitioningElem != null) {
            this.accessTokenPartitioningEnabled = Boolean.parseBoolean(enableAccessTokenPartitioningElem.getText());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enable OAuth Access Token Partitioning was set to : " + this.accessTokenPartitioningEnabled));
        }
    }

    private void parseAccessTokenPartitioningDomainsConfig(OMElement oauthConfigElem) {
        OMElement enableAccessTokenPartitioningElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AccessTokenPartitioningDomains"));
        if (enableAccessTokenPartitioningElem != null) {
            this.accessTokenPartitioningDomains = enableAccessTokenPartitioningElem.getText();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enable OAuth Access Token Partitioning Domains was set to : " + this.accessTokenPartitioningDomains));
        }
    }

    private void parseEnableAssertionsUserNameConfig(OMElement oauthConfigElem) {
        OMElement enableAssertionsUserNameElem;
        OMElement enableAssertionsElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("EnableAssertions"));
        if (enableAssertionsElem != null && (enableAssertionsUserNameElem = enableAssertionsElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserName"))) != null) {
            this.assertionsUserNameEnabled = Boolean.parseBoolean(enableAssertionsUserNameElem.getText());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enable Assertions-UserName was set to : " + this.assertionsUserNameEnabled));
        }
    }

    private void parseTokenPersistenceProcessorConfig(OMElement oauthConfigElem) {
        OMElement persistenceprocessorConfigElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("TokenPersistenceProcessor"));
        if (persistenceprocessorConfigElem != null && StringUtils.isNotBlank((String)persistenceprocessorConfigElem.getText())) {
            this.tokenPersistenceProcessorClassName = persistenceprocessorConfigElem.getText().trim();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Token Persistence Processor was set to : " + this.tokenPersistenceProcessorClassName));
        }
    }

    private void parseOAuthTokenGeneratorConfig(OMElement oauthConfigElem) {
        OMElement tokenGeneratorClassConfigElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OAuthTokenGenerator"));
        if (tokenGeneratorClassConfigElem != null && !"".equals(tokenGeneratorClassConfigElem.getText().trim())) {
            this.oauthTokenGeneratorClassName = tokenGeneratorClassConfigElem.getText().trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth token generator is set to : " + this.oauthTokenGeneratorClassName));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"The default OAuth token issuer will be used. No custom token generator is set.");
        }
    }

    private void parseOAuthTokenIssuerConfig(OMElement oauthConfigElem) {
        OMElement tokenIssuerClassConfigElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IdentityOAuthTokenGenerator"));
        if (tokenIssuerClassConfigElem != null && !"".equals(tokenIssuerClassConfigElem.getText().trim())) {
            this.oauthIdentityTokenGeneratorClassName = tokenIssuerClassConfigElem.getText().trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Identity OAuth token generator is set to : " + this.oauthIdentityTokenGeneratorClassName));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"The default Identity OAuth token issuer will be used. No custom token generator is set.");
        }
    }

    private void parseClientIdValidationRegex(OMElement oauthConfigElem) {
        OMElement clientIdValidationRegexConfigElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("ClientIdValidationRegex"));
        if (clientIdValidationRegexConfigElem != null && !"".equals(clientIdValidationRegexConfigElem.getText().trim())) {
            this.clientIdValidationRegex = clientIdValidationRegexConfigElem.getText().trim();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Client id validation regex is set to: " + this.clientIdValidationRegex));
        }
    }

    private void parsePersistAccessTokenAliasConfig(OMElement oauthConfigElem) {
        OMElement tokenIssuerClassConfigElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("PersistAccessTokenAlias"));
        if (tokenIssuerClassConfigElem != null && !"".equals(tokenIssuerClassConfigElem.getText().trim())) {
            this.persistAccessTokenAlias = tokenIssuerClassConfigElem.getText().trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Identity OAuth persist access token alias is set to : " + this.persistAccessTokenAlias));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"PersistAccessTokenAlias is not defiled. Default config will be used.");
        }
    }

    private void parseRetainOldAccessTokensConfig(OMElement oauthCleanupConfigElem) {
        OMElement tokenCleanElem = oauthCleanupConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("TokenCleanup"));
        if (tokenCleanElem != null) {
            OMElement oldTokenRetainConfigElem = tokenCleanElem.getFirstChildWithName(this.getQNameWithIdentityNS("RetainOldAccessToken"));
            if (oldTokenRetainConfigElem != null && !"".equals(oldTokenRetainConfigElem.getText().trim())) {
                this.retainOldAccessTokens = oldTokenRetainConfigElem.getText().trim();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Retain old access token is set to : " + this.retainOldAccessTokens));
                }
            } else {
                this.retainOldAccessTokens = "false";
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Retain old access token  is not defined.Default config will be used");
                }
            }
        } else {
            this.tokenCleanupFeatureEnable = "false";
        }
    }

    private void tokenCleanupFeatureConfig(OMElement oauthCleanupConfigElem) {
        OMElement tokenCleanElem = oauthCleanupConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("TokenCleanup"));
        if (tokenCleanElem != null) {
            OMElement tokenCleanupConfigElem = tokenCleanElem.getFirstChildWithName(this.getQNameWithIdentityNS("EnableTokenCleanup"));
            if (tokenCleanupConfigElem != null && StringUtils.isNotBlank((String)tokenCleanupConfigElem.getText())) {
                this.tokenCleanupFeatureEnable = tokenCleanupConfigElem.getText().trim();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Old token cleanup process enable is set to : " + this.tokenCleanupFeatureEnable));
                }
            } else {
                this.tokenCleanupFeatureEnable = "false";
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Old token cleanup process enable  is not defined. Default config will be used");
                }
            }
        } else {
            this.tokenCleanupFeatureEnable = "false";
        }
    }

    private void parseSupportedGrantTypesConfig(OMElement oauthConfigElem) {
        OMElement supportedGrantTypesElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SupportedGrantTypes"));
        if (supportedGrantTypesElem != null) {
            Iterator iterator = supportedGrantTypesElem.getChildrenWithName(this.getQNameWithIdentityNS("SupportedGrantType"));
            while (iterator.hasNext()) {
                OMElement refreshTokenAllowed;
                OMElement supportedGrantTypeElement = (OMElement)iterator.next();
                OMElement grantTypeNameElement = supportedGrantTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("GrantTypeName"));
                String grantTypeName = null;
                if (grantTypeNameElement != null) {
                    grantTypeName = grantTypeNameElement.getText();
                }
                OMElement authzGrantHandlerClassNameElement = supportedGrantTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("GrantTypeHandlerImplClass"));
                String authzGrantHandlerImplClass = null;
                if (authzGrantHandlerClassNameElement != null) {
                    authzGrantHandlerImplClass = authzGrantHandlerClassNameElement.getText();
                }
                OMElement idTokenAllowedElement = supportedGrantTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("IdTokenAllowed"));
                String idTokenAllowed = null;
                if (idTokenAllowedElement != null) {
                    idTokenAllowed = idTokenAllowedElement.getText();
                }
                if (StringUtils.isNotEmpty((String)grantTypeName) && StringUtils.isNotEmpty((String)idTokenAllowed)) {
                    this.idTokenAllowedForGrantTypesMap.put(grantTypeName, idTokenAllowed);
                    if (!Boolean.parseBoolean(idTokenAllowed)) {
                        this.idTokenNotAllowedGrantTypesSet.add(grantTypeName);
                    }
                }
                if (!StringUtils.isNotEmpty((String)grantTypeName) || !StringUtils.isNotEmpty((String)authzGrantHandlerImplClass)) continue;
                this.supportedGrantTypeClassNames.put(grantTypeName, authzGrantHandlerImplClass);
                OMElement authzGrantValidatorClassNameElement = supportedGrantTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("GrantTypeValidatorImplClass"));
                String authzGrantValidatorImplClass = null;
                if (authzGrantValidatorClassNameElement != null) {
                    authzGrantValidatorImplClass = authzGrantValidatorClassNameElement.getText();
                }
                if (StringUtils.isNotEmpty(authzGrantValidatorImplClass)) {
                    this.supportedGrantTypeValidatorNames.put(grantTypeName, authzGrantValidatorImplClass);
                }
                if ((refreshTokenAllowed = supportedGrantTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("IsRefreshTokenAllowed"))) == null || !StringUtils.isNotBlank((String)refreshTokenAllowed.getText())) continue;
                boolean isRefreshAllowed = Boolean.parseBoolean(refreshTokenAllowed.getText());
                this.refreshTokenAllowedGrantTypes.put(grantTypeName, isRefreshAllowed);
            }
        } else {
            log.warn((Object)"'SupportedGrantTypes' element not configured in identity.xml. Therefore instantiating default grant type handlers");
            HashMap<String, String> defaultGrantTypes = new HashMap<String, String>(5);
            defaultGrantTypes.put(org.apache.oltu.oauth2.common.message.types.GrantType.AUTHORIZATION_CODE.toString(), AUTHORIZATION_CODE_GRANT_HANDLER_CLASS);
            defaultGrantTypes.put(org.apache.oltu.oauth2.common.message.types.GrantType.CLIENT_CREDENTIALS.toString(), CLIENT_CREDENTIALS_GRANT_HANDLER_CLASS);
            defaultGrantTypes.put(org.apache.oltu.oauth2.common.message.types.GrantType.PASSWORD.toString(), PASSWORD_GRANT_HANDLER_CLASS);
            defaultGrantTypes.put(org.apache.oltu.oauth2.common.message.types.GrantType.REFRESH_TOKEN.toString(), REFRESH_TOKEN_GRANT_HANDLER_CLASS);
            defaultGrantTypes.put(GrantType.SAML20_BEARER.toString(), SAML20_BEARER_GRANT_HANDLER_CLASS);
            defaultGrantTypes.put(GrantType.IWA_NTLM.toString(), IWA_NTLM_BEARER_GRANT_HANDLER_CLASS);
            this.supportedGrantTypeClassNames.putAll(defaultGrantTypes);
        }
        if (log.isDebugEnabled()) {
            for (Map.Entry<String, String> entry : this.supportedGrantTypeClassNames.entrySet()) {
                String grantTypeName = entry.getKey().toString();
                String authzGrantHandlerImplClass = entry.getValue().toString();
                log.debug((Object)(grantTypeName + "supported by" + authzGrantHandlerImplClass));
            }
        }
    }

    private void parseSupportedTokenTypesConfig(OMElement oauthConfigElem) {
        OMElement supportedTokenTypesElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SupportedTokenTypes"));
        if (supportedTokenTypesElem != null) {
            Iterator iterator = supportedTokenTypesElem.getChildrenWithName(this.getQNameWithIdentityNS("SupportedTokenType"));
            while (iterator.hasNext()) {
                OMElement supportedTokenTypeElement = (OMElement)iterator.next();
                OMElement tokenTypeNameElement = supportedTokenTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("TokenTypeName"));
                String tokenTypeName = null;
                if (tokenTypeNameElement != null) {
                    tokenTypeName = tokenTypeNameElement.getText();
                }
                OMElement tokenTypeImplClassElement = supportedTokenTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("TokenTypeImplClass"));
                String tokenTypeImplClass = null;
                if (tokenTypeImplClassElement != null) {
                    tokenTypeImplClass = tokenTypeImplClassElement.getText();
                }
                OMElement persistAccessTokenAliasElement = supportedTokenTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("PersistAccessTokenAlias"));
                String persistAccessTokenAlias = null;
                if (persistAccessTokenAliasElement != null) {
                    persistAccessTokenAlias = persistAccessTokenAliasElement.getText();
                }
                if (!StringUtils.isNotEmpty((String)tokenTypeName)) continue;
                TokenIssuerDO tokenIssuerDO = new TokenIssuerDO();
                if (StringUtils.isNotEmpty((String)tokenTypeImplClass)) {
                    tokenIssuerDO.setTokenType(tokenTypeName);
                    tokenIssuerDO.setTokenImplClass(tokenTypeImplClass);
                }
                if (StringUtils.isNotEmpty((String)persistAccessTokenAlias)) {
                    tokenIssuerDO.setPersistAccessTokenAlias(Boolean.valueOf(persistAccessTokenAlias));
                } else {
                    tokenIssuerDO.setPersistAccessTokenAlias(true);
                }
                this.supportedTokenIssuers.put(tokenTypeName, tokenIssuerDO);
            }
        }
        boolean isRegistered = false;
        for (Map.Entry<String, TokenIssuerDO> entry : this.supportedTokenIssuers.entrySet()) {
            TokenIssuerDO issuerDO = entry.getValue();
            if (this.oauthIdentityTokenGeneratorClassName == null || !this.oauthIdentityTokenGeneratorClassName.equals(issuerDO.getTokenImplClass())) continue;
            isRegistered = true;
            break;
        }
        if (!isRegistered && this.oauthIdentityTokenGeneratorClassName != null) {
            boolean isPersistTokenAlias = true;
            if (this.persistAccessTokenAlias != null) {
                isPersistTokenAlias = Boolean.parseBoolean(this.persistAccessTokenAlias);
            }
            this.supportedTokenIssuers.put(DEFAULT_TOKEN_TYPE, new TokenIssuerDO(DEFAULT_TOKEN_TYPE, this.oauthIdentityTokenGeneratorClassName, isPersistTokenAlias));
        }
        if (!this.supportedTokenIssuers.containsKey(DEFAULT_TOKEN_TYPE)) {
            this.supportedTokenIssuers.put(DEFAULT_TOKEN_TYPE, new TokenIssuerDO(DEFAULT_TOKEN_TYPE, DEFAULT_OAUTH_TOKEN_ISSUER_CLASS, true));
        }
        if (!this.supportedTokenIssuers.containsKey(JWT_TOKEN_TYPE)) {
            this.supportedTokenIssuers.put(JWT_TOKEN_TYPE, new TokenIssuerDO(JWT_TOKEN_TYPE, JWT_TOKEN_ISSUER_CLASS, true));
        }
        this.supportedTokenTypes.addAll(this.supportedTokenIssuers.keySet());
    }

    public List<String> getSupportedTokenTypes() {
        return Collections.unmodifiableList(this.supportedTokenTypes);
    }

    public OauthTokenIssuer addAndReturnTokenIssuerInstance(String tokenType) throws IdentityOAuth2Exception {
        TokenIssuerDO tokenIssuerDO = this.supportedTokenIssuers.get(tokenType);
        OauthTokenIssuer oauthTokenIssuer = null;
        if (tokenIssuerDO != null && tokenIssuerDO.getTokenImplClass() != null) {
            try {
                if (this.oauthTokenIssuerMap.get(tokenType) == null) {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(tokenIssuerDO.getTokenImplClass());
                    oauthTokenIssuer = (OauthTokenIssuer)clazz.newInstance();
                    oauthTokenIssuer.setPersistAccessTokenAlias(this.supportedTokenIssuers.get(tokenType).isPersistAccessTokenAlias());
                    this.oauthTokenIssuerMap.put(tokenType, oauthTokenIssuer);
                    log.info((Object)("An instance of " + tokenIssuerDO.getTokenImplClass() + " is created for Identity OAuth token generation."));
                } else {
                    oauthTokenIssuer = this.oauthTokenIssuerMap.get(tokenType);
                }
            }
            catch (Exception e) {
                String errorMsg = "Error when instantiating the OAuthIssuer : " + tokenIssuerDO.getTokenImplClass() + ". Defaulting to OAuthIssuerImpl";
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
        }
        return oauthTokenIssuer;
    }

    private void parseUserConsentEnabledGrantTypesConfig(OMElement oauthConfigElem) {
        OMElement userConsentEnabledGrantTypesElement = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserConsentEnabledGrantTypes"));
        if (userConsentEnabledGrantTypesElement != null) {
            Iterator iterator = userConsentEnabledGrantTypesElement.getChildrenWithName(this.getQNameWithIdentityNS("UserConsentEnabledGrantType"));
            while (iterator.hasNext()) {
                OMElement supportedGrantTypeElement = (OMElement)iterator.next();
                OMElement grantTypeNameElement = supportedGrantTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("GrantTypeName"));
                String grantTypeName = null;
                if (grantTypeNameElement != null) {
                    grantTypeName = grantTypeNameElement.getText();
                }
                if (StringUtils.isNotEmpty(grantTypeName)) {
                    this.userConsentEnabledGrantTypes.add(grantTypeName);
                    continue;
                }
                log.warn((Object)("Grant Type: " + grantTypeName + " is not a supported grant type. Therefore skipping it from user consent enabled grant type list."));
            }
        } else {
            log.warn((Object)"<UserConsentEnabledGrantTypes> element in not found in identity.xml. Adding 'authorization_code' and 'implicit' grant types as default user consent enabled grant types.");
            this.userConsentEnabledGrantTypes.add("authorization_code");
            this.userConsentEnabledGrantTypes.add("implicit");
        }
    }

    private void parseSupportedResponseTypesConfig(OMElement oauthConfigElem) {
        OMElement supportedRespTypesElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SupportedResponseTypes"));
        if (supportedRespTypesElem != null) {
            Iterator iterator = supportedRespTypesElem.getChildrenWithName(this.getQNameWithIdentityNS("SupportedResponseType"));
            while (iterator.hasNext()) {
                OMElement supportedResponseTypeElement = (OMElement)iterator.next();
                OMElement responseTypeNameElement = supportedResponseTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("ResponseTypeName"));
                String responseTypeName = null;
                if (responseTypeNameElement != null) {
                    responseTypeName = responseTypeNameElement.getText();
                }
                OMElement responseTypeHandlerImplClassElement = supportedResponseTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("ResponseTypeHandlerImplClass"));
                String responseTypeHandlerImplClass = null;
                if (responseTypeHandlerImplClassElement != null) {
                    responseTypeHandlerImplClass = responseTypeHandlerImplClassElement.getText();
                }
                if (responseTypeName == null || "".equals(responseTypeName) || responseTypeHandlerImplClass == null || "".equals(responseTypeHandlerImplClass)) continue;
                this.supportedResponseTypeClassNames.put(responseTypeName, responseTypeHandlerImplClass);
                OMElement responseTypeValidatorClassNameElement = supportedResponseTypeElement.getFirstChildWithName(this.getQNameWithIdentityNS("ResponseTypeValidatorImplClass"));
                String responseTypeValidatorImplClass = null;
                if (responseTypeValidatorClassNameElement != null) {
                    responseTypeValidatorImplClass = responseTypeValidatorClassNameElement.getText();
                }
                if (StringUtils.isEmpty(responseTypeValidatorImplClass)) continue;
                this.supportedResponseTypeValidatorNames.put(responseTypeName, responseTypeValidatorImplClass);
            }
        } else {
            log.warn((Object)"'SupportedResponseTypes' element not configured in identity.xml. Therefore instantiating default response type handlers");
            HashMap<String, String> defaultResponseTypes = new HashMap<String, String>();
            defaultResponseTypes.put(ResponseType.CODE.toString(), "org.wso2.carbon.identity.oauth2.authz.handlers.CodeResponseTypeHandler");
            defaultResponseTypes.put(ResponseType.TOKEN.toString(), "org.wso2.carbon.identity.oauth2.authz.handlers.AccessTokenResponseTypeHandler");
            defaultResponseTypes.put("id_token", "org.wso2.carbon.identity.oauth2.authz.handlers.IDTokenResponseTypeHandler");
            defaultResponseTypes.put("id_token token", "org.wso2.carbon.identity.oauth2.authz.handlers.IDTokenTokenResponseTypeHandler");
            defaultResponseTypes.put("code token", "org.wso2.carbon.identity.oauth2.authz.handlers.HybridResponseTypeHandler");
            defaultResponseTypes.put("code id_token", "org.wso2.carbon.identity.oauth2.authz.handlers.HybridResponseTypeHandler");
            defaultResponseTypes.put("code id_token token", "org.wso2.carbon.identity.oauth2.authz.handlers.HybridResponseTypeHandler");
            this.supportedResponseTypeClassNames.putAll(defaultResponseTypes);
        }
        if (log.isDebugEnabled()) {
            for (Map.Entry<String, String> entry : this.supportedResponseTypeClassNames.entrySet()) {
                String responseTypeName = entry.getKey().toString();
                String authzHandlerImplClass = entry.getValue().toString();
                log.debug((Object)(responseTypeName + "supported by" + authzHandlerImplClass));
            }
        }
    }

    private void parseSupportedClientAuthHandlersConfig(OMElement clientAuthElement) {
        if (clientAuthElement != null) {
            log.warn((Object)"'SupportedClientAuthMethods' is no longer supported (ClientAuthHandler in identity.xml). If you have customized ClientAuthHandler implementations migrate them");
            Iterator iterator = clientAuthElement.getChildrenWithLocalName("ClientAuthHandler");
            while (iterator.hasNext()) {
                OMElement supportedClientAuthHandler = (OMElement)iterator.next();
                Iterator confProperties = supportedClientAuthHandler.getChildrenWithLocalName("Property");
                Properties properties = new Properties();
                while (confProperties.hasNext()) {
                    OMElement paramElem = (OMElement)confProperties.next();
                    String paramName = paramElem.getAttributeValue(new QName("Name"));
                    String paramValue = paramElem.getText();
                    properties.put(paramName, paramValue);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Property name : " + paramName + ", Property Value : " + paramValue));
                }
                String clientAuthHandlerImplClass = supportedClientAuthHandler.getAttributeValue(new QName("Class"));
                if (StringUtils.isEmpty((String)clientAuthHandlerImplClass)) {
                    log.error((Object)"Mandatory attribute \"Class\" is not present in the ClientAuthHandler element. ");
                    return;
                }
                this.supportedClientAuthHandlerData.put(clientAuthHandlerImplClass, properties);
            }
        } else {
            HashMap<String, Properties> defaultClientAuthHandlers = new HashMap<String, Properties>(1);
            defaultClientAuthHandlers.put("org.wso2.carbon.identity.oauth2.token.handlers.clientauth.BasicAuthClientAuthHandler", new Properties());
            this.supportedClientAuthHandlerData.putAll(defaultClientAuthHandlers);
        }
        if (log.isDebugEnabled()) {
            for (Map.Entry<String, Properties> clazz : this.supportedClientAuthHandlerData.entrySet()) {
                log.debug((Object)("Supported client authentication method " + clazz.getKey()));
            }
        }
    }

    private void parseSAML2GrantConfig(OMElement oauthConfigElem) {
        OMElement saml2GrantElement = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SAML2Grant"));
        OMElement saml2BearerUserTypeElement = null;
        OMElement saml2TokenHandlerElement = null;
        OMElement saml2UserIdFromClaimElement = null;
        if (saml2GrantElement != null) {
            saml2BearerUserTypeElement = saml2GrantElement.getFirstChildWithName(this.getQNameWithIdentityNS("UserType"));
            saml2TokenHandlerElement = saml2GrantElement.getFirstChildWithName(this.getQNameWithIdentityNS("SAML2TokenHandler"));
            saml2UserIdFromClaimElement = saml2GrantElement.getFirstChildWithName(this.getQNameWithIdentityNS("UseUserIdFromClaims"));
        }
        if (saml2TokenHandlerElement != null && StringUtils.isNotBlank((String)saml2TokenHandlerElement.getText())) {
            this.saml2TokenCallbackHandlerName = saml2TokenHandlerElement.getText().trim();
        }
        if (saml2BearerUserTypeElement != null && StringUtils.isNotBlank((String)saml2BearerUserTypeElement.getText())) {
            this.saml2BearerTokenUserType = saml2BearerUserTypeElement.getText().trim();
        }
        if (saml2UserIdFromClaimElement != null && StringUtils.isNotBlank((String)saml2UserIdFromClaimElement.getText())) {
            this.saml2UserIdFromClaims = Boolean.parseBoolean(saml2UserIdFromClaimElement.getText().trim());
        }
    }

    private void parseAuthorizationContextTokenGeneratorConfig(OMElement oauthConfigElem) {
        String enableJWTGeneration;
        OMElement enableJWTGenerationConfigElem;
        OMElement authContextTokGenConfigElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AuthorizationContextTokenGeneration"));
        if (authContextTokGenConfigElem != null && (enableJWTGenerationConfigElem = authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("Enabled"))) != null && (enableJWTGeneration = enableJWTGenerationConfigElem.getText().trim()) != null && JavaUtils.isTrueExplicitly((String)enableJWTGeneration)) {
            this.isAuthContextTokGenEnabled = true;
            if (authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("TokenGeneratorImplClass")) != null) {
                this.tokenGeneratorImplClass = authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("TokenGeneratorImplClass")).getText().trim();
            }
            if (authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("ClaimsRetrieverImplClass")) != null) {
                this.claimsRetrieverImplClass = authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("ClaimsRetrieverImplClass")).getText().trim();
            }
            if (authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("ConsumerDialectURI")) != null) {
                this.consumerDialectURI = authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("ConsumerDialectURI")).getText().trim();
            }
            if (authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SignatureAlgorithm")) != null) {
                this.signatureAlgorithm = authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SignatureAlgorithm")).getText().trim();
            }
            if (authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AuthorizationContextTTL")) != null) {
                this.authContextTTL = authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AuthorizationContextTTL")).getText().trim();
            }
            if (authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UseMultiValueSeparator")) != null) {
                this.useMultiValueSeparatorForAuthContextToken = Boolean.parseBoolean(authContextTokGenConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UseMultiValueSeparator")).getText().trim());
            }
        }
        if (log.isDebugEnabled()) {
            if (this.isAuthContextTokGenEnabled) {
                log.debug((Object)"JWT Generation is enabled");
            } else {
                log.debug((Object)"JWT Generation is disabled");
            }
        }
    }

    private void parseImplicitErrorFragment(OMElement oauthConfigElem) {
        OMElement implicitErrorFragmentElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("ImplicitErrorFragment"));
        if (implicitErrorFragmentElem != null) {
            this.isImplicitErrorFragment = Boolean.parseBoolean(implicitErrorFragmentElem.getText());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ImplicitErrorFragment was set to : " + this.isImplicitErrorFragment));
        }
    }

    private void parseRevokeResponseHeadersEnableConfig(OMElement oauthConfigElem) {
        OMElement enableRevokeResponseHeadersElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("EnableRevokeResponseHeaders"));
        if (enableRevokeResponseHeadersElem != null) {
            this.isRevokeResponseHeadersEnabled = Boolean.parseBoolean(enableRevokeResponseHeadersElem.getText());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enable revoke response headers : " + this.isRevokeResponseHeadersEnabled));
        }
    }

    private void parseOAuthTokenValueGenerator(OMElement oauthElem) {
        OMElement oauthTokenValueGeneratorElement = oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("AccessTokenValueGenerator"));
        if (oauthTokenValueGeneratorElement != null) {
            this.tokenValueGeneratorClassName = oauthTokenValueGeneratorElement.getText().trim();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Oauth token value generator class is set to: " + this.oauthTokenGeneratorClassName));
        }
    }

    private void parseOpenIDConnectConfig(OMElement oauthConfigElem) {
        OMElement openIDConnectConfigElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OpenIDConnect"));
        if (openIDConnectConfigElem != null) {
            OMElement addUnmappedUserAttributesElement;
            OMElement convertOriginalClaimsFromAssertionsToOIDCDialectElement;
            this.parseRequestObjectConfig(openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("RequestObjectBuilders")));
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("RequestObjectValidator")) != null) {
                this.defaultRequestValidatorClassName = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("RequestObjectValidator")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenBuilder")) != null) {
                this.openIDConnectIDTokenBuilderClassName = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenBuilder")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SignatureAlgorithm")) != null) {
                this.idTokenSignatureAlgorithm = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SignatureAlgorithm")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenEncryptionAlgorithm")) != null) {
                this.defaultIdTokenEncryptionAlgorithm = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenEncryptionAlgorithm")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SupportedIDTokenEncryptionAlgorithms")) != null) {
                this.parseSupportedIdTokenEncryptionAlgorithms(openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SupportedIDTokenEncryptionAlgorithms")));
            } else {
                this.supportedIdTokenEncryptionAlgorithms.add("RSA1_5");
                this.supportedIdTokenEncryptionAlgorithms.add("RSA-OAEP");
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenEncryptionMethod")) != null) {
                this.defaultIdTokenEncryptionMethod = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenEncryptionMethod")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SupportedIDTokenEncryptionMethods")) != null) {
                this.parseSupportedIdTokenEncryptionMethods(openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SupportedIDTokenEncryptionMethods")));
            } else {
                this.supportedIdTokenEncryptionMethods.add("A128GCM");
                this.supportedIdTokenEncryptionMethods.add("A192GCM");
                this.supportedIdTokenEncryptionMethods.add("A256GCM");
                this.supportedIdTokenEncryptionMethods.add("A128CBC-HS256");
                this.supportedIdTokenEncryptionMethods.add("A128CBC+HS256");
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenCustomClaimsCallBackHandler")) != null) {
                this.openIDConnectIDTokenCustomClaimsHanlderClassName = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenCustomClaimsCallBackHandler")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenSubjectClaim")) != null) {
                this.openIDConnectIDTokenSubClaim = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenSubjectClaim")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SkipUserConsent")) != null) {
                this.openIDConnectSkipUserConsent = Boolean.parseBoolean(openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SkipUserConsent")).getText().trim());
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SkipLoginConsent")) != null) {
                this.openIDConnectSkipLoginConsent = Boolean.parseBoolean(openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SkipLoginConsent")).getText().trim());
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SkipLogoutConsent")) != null) {
                this.openIDConnectSkipLogoutConsent = Boolean.parseBoolean(openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SkipLogoutConsent")).getText().trim());
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenIssuerID")) != null) {
                this.openIDConnectIDTokenIssuerIdentifier = IdentityUtil.fillURLPlaceholders((String)openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenIssuerID")).getText().trim());
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenExpiration")) != null) {
                this.openIDConnectIDTokenExpiration = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("IDTokenExpiration")).getText().trim();
                try {
                    this.openIDConnectIDTokenExpiryTimeInSeconds = Long.parseLong(this.openIDConnectIDTokenExpiration);
                }
                catch (NumberFormatException ex) {
                    log.warn((Object)("Invalid value: '" + this.openIDConnectIDTokenExpiration + "' set for ID Token Expiry Time in Seconds. Value should be an integer. Setting expiry time to default value: " + this.openIDConnectIDTokenExpiryTimeInSeconds + " seconds."));
                }
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoEndpointClaimDialect")) != null) {
                this.openIDConnectUserInfoEndpointClaimDialect = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoEndpointClaimDialect")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoEndpointClaimRetriever")) != null) {
                this.openIDConnectUserInfoEndpointClaimRetriever = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoEndpointClaimRetriever")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoEndpointRequestValidator")) != null) {
                this.openIDConnectUserInfoEndpointRequestValidator = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoEndpointRequestValidator")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoEndpointAccessTokenValidator")) != null) {
                this.openIDConnectUserInfoEndpointAccessTokenValidator = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoEndpointAccessTokenValidator")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoEndpointResponseBuilder")) != null) {
                this.openIDConnectUserInfoEndpointResponseBuilder = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoEndpointResponseBuilder")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoJWTSignatureAlgorithm")) != null) {
                this.userInfoJWTSignatureAlgorithm = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("UserInfoJWTSignatureAlgorithm")).getText().trim();
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SignJWTWithSPKey")) != null) {
                this.isJWTSignedWithSPKey = Boolean.parseBoolean(openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("SignJWTWithSPKey")).getText().trim());
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OpenIDConnectClaims")) != null) {
                String supportedClaimStr = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("OpenIDConnectClaims")).getText().trim();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Supported Claims : " + supportedClaimStr));
                }
                if (StringUtils.isNotEmpty((String)supportedClaimStr)) {
                    this.supportedClaims = supportedClaimStr.split(",");
                }
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("LogoutTokenExpiration")) != null) {
                this.openIDConnectBCLogoutTokenExpiryInSeconds = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("LogoutTokenExpiration")).getText().trim();
            }
            if ((convertOriginalClaimsFromAssertionsToOIDCDialectElement = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("ConvertOriginalClaimsFromAssertionsToOIDCDialect"))) != null) {
                this.convertOriginalClaimsFromAssertionsToOIDCDialect = Boolean.parseBoolean(convertOriginalClaimsFromAssertionsToOIDCDialectElement.getText().trim());
            }
            if ((addUnmappedUserAttributesElement = openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AddUnmappedUserAttributes"))) != null) {
                this.addUnmappedUserAttributes = Boolean.parseBoolean(addUnmappedUserAttributesElement.getText().trim());
            }
            if (IdentityUtil.getProperty((String)"FederatedRoleManagement.ReturnOnlyMappedLocalRoles") != null) {
                this.returnOnlyMappedLocalRoles = Boolean.parseBoolean(IdentityUtil.getProperty((String)"FederatedRoleManagement.ReturnOnlyMappedLocalRoles"));
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AddTenantDomainToIdToken")) != null) {
                this.addTenantDomainToIdTokenEnabled = Boolean.parseBoolean(openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AddTenantDomainToIdToken")).getText().trim());
            }
            if (openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AddUserstoreDomainToIdToken")) != null) {
                this.addUserstoreDomainToIdTokenEnabled = Boolean.parseBoolean(openIDConnectConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("AddUserstoreDomainToIdToken")).getText().trim());
            }
        }
    }

    private void parseSupportedIdTokenEncryptionAlgorithms(OMElement algorithms) {
        if (algorithms == null) {
            return;
        }
        Iterator iterator = algorithms.getChildrenWithLocalName("SupportedIDTokenEncryptionAlgorithm");
        if (iterator != null) {
            while (iterator.hasNext()) {
                OMElement algorithm = (OMElement)iterator.next();
                if (algorithm == null) continue;
                this.supportedIdTokenEncryptionAlgorithms.add(algorithm.getText());
            }
        }
    }

    private void parseSupportedIdTokenEncryptionMethods(OMElement methods) {
        if (methods == null) {
            return;
        }
        Iterator iterator = methods.getChildrenWithLocalName("SupportedIDTokenEncryptionMethod");
        if (iterator != null) {
            while (iterator.hasNext()) {
                OMElement method = (OMElement)iterator.next();
                if (method == null) continue;
                this.supportedIdTokenEncryptionMethods.add(method.getText());
            }
        }
    }

    private void parseHashAlgorithm(OMElement oauthConfigElem) {
        OMElement hashingAlgorithmElement = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("HashAlgorithm"));
        if (hashingAlgorithmElement != null) {
            this.hashAlgorithm = hashingAlgorithmElement.getText();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Hash algorithm was set to : " + this.hashAlgorithm));
        }
    }

    private void parseEnableHashMode(OMElement oauthConfigElem) {
        try {
            this.persistenceProcessor = this.getPersistenceProcessor();
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)"Error while getting an instance of TokenPersistenceProcessor.");
        }
        if (this.persistenceProcessor instanceof HashingPersistenceProcessor) {
            OMElement hashModeElement = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("EnableClientSecretHash"));
            if (hashModeElement != null) {
                this.isClientSecretHashEnabled = Boolean.parseBoolean(hashModeElement.getText());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Is client secret hashing enabled: " + this.isClientSecretHashEnabled));
            }
        }
    }

    private void parseRedirectToOAuthErrorPageConfig(OMElement oauthConfigElem) {
        OMElement redirectToOAuthErrorPageElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("RedirectToRequestedRedirectUri"));
        if (redirectToOAuthErrorPageElem != null) {
            this.redirectToRequestedRedirectUriEnabled = Boolean.parseBoolean(redirectToOAuthErrorPageElem.getText());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting to OAuth2 Error page is set to : " + redirectToOAuthErrorPageElem));
        }
    }

    public OAuth2ScopeValidator getoAuth2ScopeValidator() {
        return this.oAuth2ScopeValidator;
    }

    public void setoAuth2ScopeValidator(OAuth2ScopeValidator oAuth2ScopeValidator) {
        this.oAuth2ScopeValidator = oAuth2ScopeValidator;
    }

    public Set<OAuth2ScopeValidator> getOAuth2ScopeValidators() {
        return this.oAuth2ScopeValidators;
    }

    public Map<String, TokenIssuerDO> getSupportedTokenIssuers() {
        return this.supportedTokenIssuers;
    }

    public void setOAuth2ScopeValidators(Set<OAuth2ScopeValidator> oAuth2ScopeValidators) {
        this.oAuth2ScopeValidators = oAuth2ScopeValidators;
    }

    public Set<OAuth2ScopeHandler> getOAuth2ScopeHandlers() {
        return this.oAuth2ScopeHandlers;
    }

    public void setOAuth2ScopeHandlers(Set<OAuth2ScopeHandler> oAuth2ScopeHandlers) {
        this.oAuth2ScopeHandlers = oAuth2ScopeHandlers;
    }

    private void parseUseSPTenantDomainConfig(OMElement oauthElem) {
        OMElement useSPTenantDomainValueElement = oauthElem.getFirstChildWithName(this.getQNameWithIdentityNS("UseSPTenantDomain"));
        if (useSPTenantDomainValueElement != null) {
            this.useSPTenantDomainValue = Boolean.parseBoolean(useSPTenantDomainValueElement.getText().trim());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Use SP tenant domain value is set to: " + this.useSPTenantDomainValue));
        }
    }

    private void parseTokenRenewalPerRequestConfiguration(OMElement oauthConfigElem) {
        OMElement enableTokenRenewalElem = oauthConfigElem.getFirstChildWithName(this.getQNameWithIdentityNS("RenewTokenPerRequest"));
        if (enableTokenRenewalElem != null) {
            this.isTokenRenewalPerRequestEnabled = Boolean.parseBoolean(enableTokenRenewalElem.getText());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("RenewTokenPerRequest was set to : " + this.isTokenRenewalPerRequestEnabled));
        }
    }

    public void populateOAuthTokenIssuerMap() throws IdentityOAuth2Exception {
        if (this.supportedTokenIssuers != null) {
            for (Map.Entry<String, TokenIssuerDO> tokenIssuerDO : this.supportedTokenIssuers.entrySet()) {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(tokenIssuerDO.getValue().getTokenImplClass());
                    OauthTokenIssuer oauthTokenIssuer = (OauthTokenIssuer)clazz.newInstance();
                    oauthTokenIssuer.setPersistAccessTokenAlias(tokenIssuerDO.getValue().isPersistAccessTokenAlias());
                    this.oauthTokenIssuerMap.put(tokenIssuerDO.getKey(), oauthTokenIssuer);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IdentityOAuth2Exception("Error while populating OAuth Token Issuer Map. Issuer key: " + tokenIssuerDO.getKey() + ", Issuer value: " + tokenIssuerDO.getValue(), e);
                }
            }
        } else {
            throw new IdentityOAuth2Exception("supportedTokenIssuers map returned null when populating the oauthTokenIssuerMap object.");
        }
    }

    public boolean isScopeValidationEnabledForCodeAndImplicitGrant() {
        return this.scopeValidationConfigValue;
    }

    static {
        oauth1RequestTokenUrl = null;
        oauth1AuthorizeUrl = null;
        oauth1AccessTokenUrl = null;
        oauth2AuthzEPUrl = null;
        oauth2TokenEPUrl = null;
        oauth2UserInfoEPUrl = null;
        oauth2RevocationEPUrl = null;
        oauth2IntrospectionEPUrl = null;
        oidcConsentPageUrl = null;
        oauth2DCREPUrl = null;
        oauth2JWKSPageUrl = null;
        oidcWebFingerEPUrl = null;
        oidcDiscoveryUrl = null;
        oauth2ConsentPageUrl = null;
        oauth2ErrorPageUrl = null;
    }

    private class ConfigElements {
        public static final String OAUTH1_REQUEST_TOKEN_URL = "OAuth1RequestTokenUrl";
        public static final String OAUTH1_AUTHORIZE_URL = "OAuth1AuthorizeUrl";
        public static final String OAUTH1_ACCESS_TOKEN_URL = "OAuth1AccessTokenUrl";
        public static final String OAUTH2_AUTHZ_EP_URL = "OAuth2AuthzEPUrl";
        public static final String OAUTH2_TOKEN_EP_URL = "OAuth2TokenEPUrl";
        public static final String OAUTH2_USERINFO_EP_URL = "OAuth2UserInfoEPUrl";
        public static final String OAUTH2_REVOCATION_EP_URL = "OAuth2RevokeEPUrl";
        public static final String OAUTH2_INTROSPECTION_EP_URL = "OAuth2IntrospectEPUrl";
        public static final String OAUTH2_CONSENT_PAGE_URL = "OAuth2ConsentPage";
        public static final String OAUTH2_DCR_EP_URL = "OAuth2DCREPUrl";
        public static final String OAUTH2_JWKS_PAGE_URL = "OAuth2JWKSPage";
        public static final String OIDC_WEB_FINGER_EP_URL = "OIDCWebFingerEPUrl";
        public static final String OIDC_DISCOVERY_EP_URL = "OIDCDiscoveryEPUrl";
        public static final String OAUTH2_ERROR_PAGE_URL = "OAuth2ErrorPage";
        public static final String OIDC_CONSENT_PAGE_URL = "OIDCConsentPage";
        public static final String AUTHORIZATION_CONTEXT_TOKEN_GENERATION = "AuthorizationContextTokenGeneration";
        public static final String ENABLED = "Enabled";
        public static final String TOKEN_GENERATOR_IMPL_CLASS = "TokenGeneratorImplClass";
        public static final String CLAIMS_RETRIEVER_IMPL_CLASS = "ClaimsRetrieverImplClass";
        public static final String CONSUMER_DIALECT_URI = "ConsumerDialectURI";
        public static final String SIGNATURE_ALGORITHM = "SignatureAlgorithm";
        public static final String ID_TOKEN_ENCRYPTION_ALGORITHM = "IDTokenEncryptionAlgorithm";
        public static final String SUPPORTED_ID_TOKEN_ENCRYPTION_ALGORITHMS = "SupportedIDTokenEncryptionAlgorithms";
        public static final String SUPPORTED_ID_TOKEN_ENCRYPTION_ALGORITHM = "SupportedIDTokenEncryptionAlgorithm";
        public static final String ID_TOKEN_ENCRYPTION_METHOD = "IDTokenEncryptionMethod";
        public static final String SUPPORTED_ID_TOKEN_ENCRYPTION_METHODS = "SupportedIDTokenEncryptionMethods";
        public static final String SUPPORTED_ID_TOKEN_ENCRYPTION_METHOD = "SupportedIDTokenEncryptionMethod";
        public static final String SECURITY_CONTEXT_TTL = "AuthorizationContextTTL";
        private static final String AUTH_CONTEXT_TOKEN_USE_MULTIVALUE_SEPARATOR = "UseMultiValueSeparator";
        public static final String ENABLE_ASSERTIONS = "EnableAssertions";
        public static final String ENABLE_ASSERTIONS_USERNAME = "UserName";
        public static final String ENABLE_ACCESS_TOKEN_PARTITIONING = "EnableAccessTokenPartitioning";
        public static final String REDIRECT_TO_REQUESTED_REDIRECT_URI = "RedirectToRequestedRedirectUri";
        public static final String ACCESS_TOKEN_PARTITIONING_DOMAINS = "AccessTokenPartitioningDomains";
        public static final String OPENID_CONNECT = "OpenIDConnect";
        public static final String OPENID_CONNECT_IDTOKEN_BUILDER = "IDTokenBuilder";
        public static final String OPENID_CONNECT_IDTOKEN_SUB_CLAIM = "IDTokenSubjectClaim";
        public static final String OPENID_CONNECT_IDTOKEN_ISSUER_ID = "IDTokenIssuerID";
        public static final String OPENID_CONNECT_IDTOKEN_EXPIRATION = "IDTokenExpiration";
        public static final String OPENID_CONNECT_SKIP_USER_CONSENT = "SkipUserConsent";
        public static final String OPENID_CONNECT_SKIP_LOGIN_CONSENT = "SkipLoginConsent";
        public static final String OPENID_CONNECT_SKIP_LOGOUT_CONSENT = "SkipLogoutConsent";
        public static final String OPENID_CONNECT_USERINFO_ENDPOINT_CLAIM_DIALECT = "UserInfoEndpointClaimDialect";
        public static final String OPENID_CONNECT_USERINFO_ENDPOINT_CLAIM_RETRIEVER = "UserInfoEndpointClaimRetriever";
        public static final String OPENID_CONNECT_USERINFO_ENDPOINT_REQUEST_VALIDATOR = "UserInfoEndpointRequestValidator";
        public static final String OPENID_CONNECT_USERINFO_ENDPOINT_ACCESS_TOKEN_VALIDATOR = "UserInfoEndpointAccessTokenValidator";
        public static final String OPENID_CONNECT_USERINFO_ENDPOINT_RESPONSE_BUILDER = "UserInfoEndpointResponseBuilder";
        public static final String OPENID_CONNECT_USERINFO_JWT_SIGNATURE_ALGORITHM = "UserInfoJWTSignatureAlgorithm";
        public static final String OPENID_CONNECT_SIGN_JWT_WITH_SP_KEY = "SignJWTWithSPKey";
        public static final String OPENID_CONNECT_IDTOKEN_CUSTOM_CLAIM_CALLBACK_HANDLER = "IDTokenCustomClaimsCallBackHandler";
        public static final String OPENID_CONNECT_CONVERT_ORIGINAL_CLAIMS_FROM_ASSERTIONS_TO_OIDCDIALECT = "ConvertOriginalClaimsFromAssertionsToOIDCDialect";
        private static final String OPENID_CONNECT_ADD_TENANT_DOMAIN_TO_ID_TOKEN = "AddTenantDomainToIdToken";
        private static final String OPENID_CONNECT_ADD_USERSTORE_DOMAIN_TO_ID_TOKEN = "AddUserstoreDomainToIdToken";
        public static final String SEND_ONLY_LOCALLY_MAPPED_ROLES_OF_IDP = "FederatedRoleManagement.ReturnOnlyMappedLocalRoles";
        public static final String OPENID_CONNECT_ADD_UN_MAPPED_USER_ATTRIBUTES = "AddUnmappedUserAttributes";
        public static final String SUPPORTED_CLAIMS = "OpenIDConnectClaims";
        public static final String REQUEST_OBJECT = "RequestObject";
        public static final String REQUEST_OBJECT_VALIDATOR = "RequestObjectValidator";
        public static final String OPENID_CONNECT_BACK_CHANNEL_LOGOUT_TOKEN_EXPIRATION = "LogoutTokenExpiration";
        private static final String OAUTH_CALLBACK_HANDLERS = "OAuthCallbackHandlers";
        private static final String OAUTH_CALLBACK_HANDLER = "OAuthCallbackHandler";
        private static final String CALLBACK_CLASS = "Class";
        private static final String CALLBACK_PRIORITY = "Priority";
        private static final String CALLBACK_PROPERTIES = "Properties";
        private static final String CALLBACK_PROPERTY = "Property";
        private static final String CALLBACK_ATTR_NAME = "Name";
        private static final String TOKEN_VALIDATORS = "TokenValidators";
        private static final String TOKEN_VALIDATOR = "TokenValidator";
        private static final String TOKEN_TYPE_ATTR = "type";
        private static final String TOKEN_CLASS_ATTR = "class";
        private static final String SCOPE_HANDLERS = "ScopeHandlers";
        private static final String SCOPE_HANDLER = "ScopeHandler";
        private static final String SCOPE_HANDLER_CLASS_ATTR = "class";
        private static final String SCOPE_HANDLER_PROPERTY = "Property";
        private static final String SCOPE_HANDLER_PROPERTY_NAME_ATTR = "name";
        private static final String SCOPE_VALIDATOR = "OAuthScopeValidator";
        private static final String SCOPE_VALIDATORS = "ScopeValidators";
        private static final String SCOPE_VALIDATOR_ELEM = "ScopeValidator";
        private static final String SCOPE_VALIDATOR_PROPERTY = "Property";
        private static final String SCOPE_VALIDATOR_PROPERTY_NAME_ATTR = "name";
        private static final String SCOPE_CLASS_ATTR = "class";
        private static final String SKIP_SCOPE_ATTR = "scopesToSkip";
        private static final String IMPLICIT_ERROR_FRAGMENT = "ImplicitErrorFragment";
        private static final String SCOPE_VALIDATION_FOR_AUTHZ_CODE_AND_IMPLICIT = "ScopeValidationEnabledForAuthzCodeAndImplicitGrant";
        private static final String TIMESTAMP_SKEW = "TimestampSkew";
        private static final String AUTHORIZATION_CODE_DEFAULT_VALIDITY_PERIOD = "AuthorizationCodeDefaultValidityPeriod";
        private static final String USER_ACCESS_TOKEN_DEFAULT_VALIDITY_PERIOD = "UserAccessTokenDefaultValidityPeriod";
        private static final String APPLICATION_ACCESS_TOKEN_VALIDATION_PERIOD = "AccessTokenDefaultValidityPeriod";
        private static final String REFRESH_TOKEN_VALIDITY_PERIOD = "RefreshTokenValidityPeriod";
        private static final String ENABLE_CACHE = "EnableOAuthCache";
        private static final String RENEW_REFRESH_TOKEN_FOR_REFRESH_GRANT = "RenewRefreshTokenForRefreshGrant";
        private static final String EXTEND_RENEWED_REFRESH_TOKEN_EXPIRY_TIME = "ExtendRenewedRefreshTokenExpiryTime";
        private static final String TOKEN_PERSISTENCE_PROCESSOR = "TokenPersistenceProcessor";
        private static final String OAUTH_TOKEN_GENERATOR = "OAuthTokenGenerator";
        private static final String IDENTITY_OAUTH_TOKEN_GENERATOR = "IdentityOAuthTokenGenerator";
        private static final String CLIENT_ID_VALIDATE_REGEX = "ClientIdValidationRegex";
        private static final String IDENTITY_OAUTH_PERSIST_TOKEN_ALIAS = "PersistAccessTokenAlias";
        private static final String OAUTH2_TOKEN_CLEAN_ELEM = "TokenCleanup";
        private static final String TOKEN_CLEANUP_FEATURE = "EnableTokenCleanup";
        private static final String RETAIN_OLD_ACCESS_TOKENS = "RetainOldAccessToken";
        private static final String SUPPORTED_GRANT_TYPES = "SupportedGrantTypes";
        private static final String SUPPORTED_GRANT_TYPE = "SupportedGrantType";
        private static final String GRANT_TYPE_NAME = "GrantTypeName";
        private static final String SUPPORTED_TOKEN_TYPES = "SupportedTokenTypes";
        private static final String SUPPORTED_TOKEN_TYPE = "SupportedTokenType";
        private static final String TOKEN_TYPE_NAME = "TokenTypeName";
        private static final String USER_CONSENT_ENABLED_GRANT_TYPES = "UserConsentEnabledGrantTypes";
        private static final String USER_CONSENT_ENABLED_GRANT_TYPE = "UserConsentEnabledGrantType";
        private static final String USER_CONSENT_ENABLED_GRANT_TYPE_NAME = "GrantTypeName";
        private static final String ID_TOKEN_ALLOWED = "IdTokenAllowed";
        private static final String GRANT_TYPE_HANDLER_IMPL_CLASS = "GrantTypeHandlerImplClass";
        private static final String GRANT_TYPE_VALIDATOR_IMPL_CLASS = "GrantTypeValidatorImplClass";
        private static final String RESPONSE_TYPE_VALIDATOR_IMPL_CLASS = "ResponseTypeValidatorImplClass";
        private static final String TOKEN_TYPE_IMPL_CLASS = "TokenTypeImplClass";
        private static final String CLIENT_AUTH_HANDLERS = "ClientAuthHandlers";
        private static final String CLIENT_AUTH_HANDLER_IMPL_CLASS = "ClientAuthHandler";
        private static final String CLIENT_AUTH_CLASS = "Class";
        private static final String DEFAULT_CLIENT_AUTHENTICATOR = "org.wso2.carbon.identity.oauth2.token.handlers.clientauth.BasicAuthClientAuthHandler";
        private static final String CLIENT_AUTH_PROPERTY = "Property";
        private static final String CLIENT_AUTH_NAME = "Name";
        private static final String SUPPORTED_RESP_TYPES = "SupportedResponseTypes";
        private static final String SUPPORTED_RESP_TYPE = "SupportedResponseType";
        private static final String RESP_TYPE_NAME = "ResponseTypeName";
        private static final String RESP_TYPE_HANDLER_IMPL_CLASS = "ResponseTypeHandlerImplClass";
        private static final String SAML2_GRANT = "SAML2Grant";
        private static final String SAML2_TOKEN_HANDLER = "SAML2TokenHandler";
        private static final String SAML2_BEARER_USER_TYPE = "UserType";
        private static final String SAML2_USER_ID_FROM_CLAIMS = "UseUserIdFromClaims";
        private static final String ENABLE_REVOKE_RESPONSE_HEADERS = "EnableRevokeResponseHeaders";
        private static final String IDENTITY_OAUTH_SHOW_DISPLAY_NAME_IN_CONSENT_PAGE = "ShowDisplayNameInConsentPage";
        private static final String REFRESH_TOKEN_ALLOWED = "IsRefreshTokenAllowed";
        private static final String OAUTH_TOKEN_VALUE_GENERATOR = "AccessTokenValueGenerator";
        private static final String OAUTH_USE_SP_TENANT_DOMAIN = "UseSPTenantDomain";
        private static final String MAP_FED_USERS_TO_LOCAL = "MapFederatedUsersToLocal";
        private static final String REQUEST_OBJECT_BUILDERS = "RequestObjectBuilders";
        private static final String REQUEST_OBJECT_BUILDER = "RequestObjectBuilder";
        private static final String BUILDER_TYPE = "Type";
        private static final String REQUEST_OBJECT_IMPL_CLASS = "ClassName";
        private static final String HASH_ALGORITHM = "HashAlgorithm";
        private static final String ENABLE_CLIENT_SECRET_HASH = "EnableClientSecretHash";
        private static final String INTROSPECTION_CONFIG = "Introspection";
        private static final String ENABLE_DATA_PROVIDERS_CONFIG = "EnableDataProviders";
        private static final String RENEW_TOKEN_PER_REQUEST = "RenewTokenPerRequest";
        private static final String ALLOWED_SCOPES_ELEMENT = "AllowedScopes";
        private static final String SCOPES_ELEMENT = "Scope";

        private ConfigElements() {
        }
    }
}

