/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.callback;

import javax.security.auth.callback.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.callback.OAuthCallback;
import org.wso2.carbon.identity.oauth.callback.OAuthCallbackHandler;
import org.wso2.carbon.identity.oauth.callback.OAuthCallbackHandlerRegistry;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;

public class OAuthCallbackManager {
    private static final Log log = LogFactory.getLog(OAuthCallbackManager.class);
    private OAuthCallbackHandlerRegistry callbackHandlerRegistry = OAuthCallbackHandlerRegistry.getInstance();

    public void handleCallback(OAuthCallback authzCallback) throws IdentityOAuth2Exception {
        try {
            OAuthCallbackHandler authzCbHandler = this.callbackHandlerRegistry.getOAuthAuthzHandler(authzCallback);
            if (authzCbHandler != null) {
                authzCbHandler.handle(new Callback[]{authzCallback});
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while calling OAuthAuthorization Handler. ", (Throwable)e);
            throw new IdentityOAuth2Exception("Error while calling OAuthAuthorization Handler. ", e);
        }
    }
}

