/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.callback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.callback.OAuthCallback;
import org.wso2.carbon.identity.oauth.callback.OAuthCallbackHandler;
import org.wso2.carbon.identity.oauth.config.OAuthCallbackHandlerMetaData;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.utils.CarbonUtils;

public class OAuthCallbackHandlerRegistry {
    private static final Log log = LogFactory.getLog(OAuthCallbackHandlerRegistry.class);
    private static OAuthCallbackHandlerRegistry instance;
    private transient boolean initAuthzHandlers = false;
    private OAuthCallbackHandler[] authzCallbackHandlers;

    private OAuthCallbackHandlerRegistry() throws IdentityOAuth2Exception {
        this.initAuthzCallbackHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OAuthCallbackHandlerRegistry getInstance() throws IdentityOAuth2Exception {
        CarbonUtils.checkSecurity();
        if (instance != null) return instance;
        Class<OAuthCallbackHandlerRegistry> clazz = OAuthCallbackHandlerRegistry.class;
        synchronized (OAuthCallbackHandlerRegistry.class) {
            if (instance != null) return instance;
            instance = new OAuthCallbackHandlerRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAuthzCallbackHandlers() throws IdentityOAuth2Exception {
        if (!this.initAuthzHandlers) {
            OAuthCallbackHandlerRegistry oAuthCallbackHandlerRegistry = this;
            synchronized (oAuthCallbackHandlerRegistry) {
                if (!this.initAuthzHandlers) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"initializing the OAuth Authorization Callback Handlers.");
                    }
                    ArrayList<OAuthCallbackHandler> oauthAuthzHandlers = new ArrayList<OAuthCallbackHandler>();
                    Set<OAuthCallbackHandlerMetaData> callbackHandlerMetaData = OAuthServerConfiguration.getInstance().getCallbackHandlerMetaData();
                    for (OAuthCallbackHandlerMetaData metaData : callbackHandlerMetaData) {
                        String className = metaData.getClassName();
                        try {
                            Class<?> clazz = this.getClass().getClassLoader().loadClass(metaData.getClassName());
                            OAuthCallbackHandler callbackHandler = (OAuthCallbackHandler)clazz.newInstance();
                            callbackHandler.setPriority(metaData.getPriority());
                            callbackHandler.setProperties(metaData.getProperties());
                            oauthAuthzHandlers.add(callbackHandler);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Instantiated an OAuth Authorization Callback Handler. Class : " + clazz.getName()));
                        }
                        catch (ClassNotFoundException e) {
                            throw new IdentityOAuth2Exception("Error when loading the OAuthCallbackHandler : " + className, e);
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            throw new IdentityOAuth2Exception("Error when instantiating the OAuthCallbackHandler : " + className, e);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Finished initializing OAuth Authorization Callback Handlers. No. of Authz Handlers registered : " + oauthAuthzHandlers.size()));
                    }
                    this.authzCallbackHandlers = oauthAuthzHandlers.toArray(new OAuthCallbackHandler[oauthAuthzHandlers.size()]);
                    Arrays.sort(this.authzCallbackHandlers, new OAuthAuthzCbHandlerComparator());
                    this.initAuthzHandlers = true;
                }
            }
        }
    }

    public OAuthCallbackHandler getOAuthAuthzHandler(OAuthCallback authzCallback) throws IdentityOAuth2Exception {
        for (OAuthCallbackHandler oauthAuthzCbHandler : this.authzCallbackHandlers) {
            if (!oauthAuthzCbHandler.canHandle(new Callback[]{authzCallback})) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuthCallbackHandler was found for the callback. Class Name : " + oauthAuthzCbHandler.getClass().getName() + " Resource Owner : " + authzCallback.getResourceOwner() + " Client Id : " + authzCallback.getClient() + " Scope : " + OAuth2Util.buildScopeString(authzCallback.getRequestedScope())));
            }
            return oauthAuthzCbHandler;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No OAuthAuthorizationCallbackHandlers were found for the callback. Resource Owner : " + authzCallback.getResourceOwner() + " Client Id : " + authzCallback.getClient() + " Scope : " + OAuth2Util.buildScopeString(authzCallback.getRequestedScope())));
        }
        return null;
    }

    private class OAuthAuthzCbHandlerComparator
    implements Comparator<OAuthCallbackHandler> {
        private OAuthAuthzCbHandlerComparator() {
        }

        @Override
        public int compare(OAuthCallbackHandler o1, OAuthCallbackHandler o2) {
            return o1.getPriority() - o2.getPriority();
        }
    }
}

