/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.callback;

import javax.security.auth.callback.Callback;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.oauth.common.GrantType;

public class OAuthCallback
implements Callback {
    private OAuthCallbackType callbackType;
    private AuthenticatedUser resourceOwner;
    private String responseType;
    private String grantType;
    private GrantType carbonGrantType;
    private String client;
    private String[] requestedScope;
    private String[] approvedScope;
    private boolean authorized;
    private boolean validScope;
    private long validityPeriod = -1L;
    private long authorizationCodeValidityPeriod = -1L;
    private long accessTokenValidityPeriod = -1L;

    public OAuthCallback(AuthenticatedUser resourceOwner, String client, OAuthCallbackType callbackType) {
        this.resourceOwner = resourceOwner;
        this.client = client;
        this.callbackType = callbackType;
    }

    public AuthenticatedUser getResourceOwner() {
        return this.resourceOwner;
    }

    public String getClient() {
        return this.client;
    }

    public OAuthCallbackType getCallbackType() {
        return this.callbackType;
    }

    public String[] getRequestedScope() {
        return this.requestedScope;
    }

    public void setRequestedScope(String[] requestedScope) {
        this.requestedScope = requestedScope;
    }

    public String[] getApprovedScope() {
        return this.approvedScope;
    }

    public void setApprovedScope(String[] approvedScope) {
        this.approvedScope = approvedScope;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public void setAuthorized(boolean authorized) {
        this.authorized = authorized;
    }

    public boolean isValidScope() {
        return this.validScope;
    }

    public void setValidScope(boolean invalidScope) {
        this.validScope = invalidScope;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public GrantType getCarbonGrantType() {
        return this.carbonGrantType;
    }

    public void setCarbonGrantType(GrantType carbonGrantType) {
        this.carbonGrantType = carbonGrantType;
    }

    public long getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(long validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public long getAuthorizationCodeValidityPeriod() {
        return this.authorizationCodeValidityPeriod;
    }

    public void setAuthorizationCodeValidityPeriod(long oauthoizationCodeValidityPeriod) {
        this.authorizationCodeValidityPeriod = oauthoizationCodeValidityPeriod;
    }

    public long getAccessTokenValidityPeriod() {
        return this.accessTokenValidityPeriod;
    }

    public void setAccessTokenValidityPeriod(long accessTokenValidityPeriod) {
        this.accessTokenValidityPeriod = accessTokenValidityPeriod;
    }

    public static enum OAuthCallbackType {
        ACCESS_DELEGATION_AUTHZ,
        SCOPE_VALIDATION_AUTHZ,
        ACCESS_DELEGATION_TOKEN,
        SCOPE_VALIDATION_TOKEN;

    }
}

