/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.cache;

import java.io.Serializable;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.SessionDataCacheEntry;
import org.wso2.carbon.identity.oauth.cache.SessionDataCacheKey;
import org.wso2.carbon.utils.CarbonUtils;

public class SessionDataCache
extends BaseCache<SessionDataCacheKey, SessionDataCacheEntry> {
    private static final String SESSION_DATA_CACHE_NAME = "OAuthSessionDataCache";
    private static volatile SessionDataCache instance;
    private boolean isTemporarySessionDataPersistEnabled = false;

    private SessionDataCache() {
        super(SESSION_DATA_CACHE_NAME, true);
        if (IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Temporary") != null) {
            this.isTemporarySessionDataPersistEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Temporary"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionDataCache getInstance() {
        CarbonUtils.checkSecurity();
        if (instance != null) return instance;
        Class<SessionDataCache> clazz = SessionDataCache.class;
        synchronized (SessionDataCache.class) {
            if (instance != null) return instance;
            instance = new SessionDataCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCache(SessionDataCacheKey key, SessionDataCacheEntry entry) {
        super.addToCache((Serializable)key, (Serializable)((Object)entry));
        if (this.isTemporarySessionDataPersistEnabled) {
            SessionDataStore.getInstance().storeSessionData(key.getSessionDataId(), SESSION_DATA_CACHE_NAME, (Object)entry);
        }
    }

    public SessionDataCacheEntry getValueFromCache(SessionDataCacheKey key) {
        SessionDataCacheEntry cacheEntry = (SessionDataCacheEntry)((Object)super.getValueFromCache((Serializable)key));
        if (cacheEntry == null && this.isTemporarySessionDataPersistEnabled) {
            cacheEntry = (SessionDataCacheEntry)((Object)SessionDataStore.getInstance().getSessionData(key.getSessionDataId(), SESSION_DATA_CACHE_NAME));
        }
        return cacheEntry;
    }

    public void clearCacheEntry(SessionDataCacheKey key) {
        super.clearCacheEntry((Serializable)key);
        if (this.isTemporarySessionDataPersistEnabled) {
            SessionDataStore.getInstance().clearSessionData(key.getSessionDataId(), SESSION_DATA_CACHE_NAME);
        }
    }
}

