/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.cache;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.OAuthScopeBindingCache;
import org.wso2.carbon.identity.oauth.cache.OAuthScopeBindingCacheKey;
import org.wso2.carbon.identity.oauth.cache.OAuthScopeCacheKey;
import org.wso2.carbon.identity.oauth2.bean.Scope;
import org.wso2.carbon.identity.oauth2.bean.ScopeBinding;

public class OAuthScopeCache
extends BaseCache<OAuthScopeCacheKey, Scope> {
    private static final Log log = LogFactory.getLog(OAuthScopeCache.class);
    private static final String OAUTH_SCOPE_CACHE_NAME = "OAuthScopeCache";
    private static final String IDENTITY_CACHE_MANAGER = "IdentityApplicationManagementCacheManager";
    private static volatile OAuthScopeCache instance;

    private OAuthScopeCache() {
        super(OAUTH_SCOPE_CACHE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OAuthScopeCache getInstance() {
        if (instance != null) return instance;
        Class<OAuthScopeCache> clazz = OAuthScopeCache.class;
        synchronized (OAuthScopeCache.class) {
            if (instance != null) return instance;
            instance = new OAuthScopeCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCache(OAuthScopeCacheKey key, Scope entry) {
        if (IdentityUtil.getIdentityCacheConfig((String)IDENTITY_CACHE_MANAGER, (String)OAUTH_SCOPE_CACHE_NAME).isEnabled()) {
            super.addToCache((Serializable)key, (Serializable)entry);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope is added to the cache. \n" + entry.toString()));
            }
        }
        for (ScopeBinding scopeBinding : entry.getScopeBindings()) {
            OAuthScopeBindingCache.getInstance().clearCacheEntry(new OAuthScopeBindingCacheKey(scopeBinding.getBindingType(), Integer.parseInt(key.getTenantID())));
        }
    }

    public Scope getValueFromCache(OAuthScopeCacheKey key) {
        Scope entry = null;
        if (IdentityUtil.getIdentityCacheConfig((String)IDENTITY_CACHE_MANAGER, (String)OAUTH_SCOPE_CACHE_NAME).isEnabled()) {
            entry = (Scope)super.getValueFromCache((Serializable)key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope is getting from the cache. \n" + String.valueOf(entry)));
            }
        }
        return entry;
    }

    public void clearCacheEntry(OAuthScopeCacheKey key) {
        if (IdentityUtil.getIdentityCacheConfig((String)IDENTITY_CACHE_MANAGER, (String)OAUTH_SCOPE_CACHE_NAME).isEnabled()) {
            super.clearCacheEntry((Serializable)key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope: " + key.getScopeName() + " is removed from the cache."));
            }
        }
        OAuthScopeBindingCache.getInstance().clear();
    }

    public void clear() {
        super.clear();
        OAuthScopeBindingCache.getInstance().clear();
    }
}

