/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.cache;

import java.io.Serializable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.oauth.cache.OAuthScopeBindingCacheKey;
import org.wso2.carbon.identity.oauth2.bean.Scope;

public class OAuthScopeBindingCache
extends BaseCache<OAuthScopeBindingCacheKey, Scope[]> {
    private static final Log log = LogFactory.getLog(OAuthScopeBindingCache.class);
    private static final String OAUTH_SCOPE_BINDING_CACHE = "OAuthScopeBindingCache";
    private static volatile OAuthScopeBindingCache instance;

    private OAuthScopeBindingCache() {
        super(OAUTH_SCOPE_BINDING_CACHE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OAuthScopeBindingCache getInstance() {
        if (instance != null) return instance;
        Class<OAuthScopeBindingCache> clazz = OAuthScopeBindingCache.class;
        synchronized (OAuthScopeBindingCache.class) {
            if (instance != null) return instance;
            instance = new OAuthScopeBindingCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCache(OAuthScopeBindingCacheKey key, Scope[] entry) {
        super.addToCache((Serializable)key, (Serializable)entry);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scope bindings are added to the cache. \n" + ArrayUtils.toString((Object)entry)));
        }
    }

    public Scope[] getValueFromCache(OAuthScopeBindingCacheKey key) {
        Scope[] entry = (Scope[])super.getValueFromCache((Serializable)key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scopes are getting from the cache. \n" + ArrayUtils.toString((Object)entry)));
        }
        return entry;
    }

    public void clearCacheEntry(OAuthScopeBindingCacheKey key) {
        super.clearCacheEntry((Serializable)key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scope bindings type : " + key.getBindingType() + "is removed from the cache in tenant: " + key.getTenantID()));
        }
    }
}

