/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.oauth.cache.CacheEntry;
import org.wso2.carbon.identity.openidconnect.model.RequestObject;

public class AuthorizationGrantCacheEntry
extends CacheEntry {
    private static final long serialVersionUID = -3043225645166013281L;
    private String codeId;
    private String tokenId;
    private Map<ClaimMapping, String> userAttributes;
    private String nonceValue;
    private String pkceCodeChallenge;
    private String pkceCodeChallengeMethod;
    private LinkedHashSet acrValue;
    private String selectedAcrValue;
    private List<String> amrList = new ArrayList<String>();
    private String essentialClaims;
    private long authTime;
    private long maxAge;
    private RequestObject requestObject;
    private boolean hasNonOIDCClaims;
    private String subjectClaim;
    private String tokenBindingValue;

    public String getSubjectClaim() {
        return this.subjectClaim;
    }

    public void setSubjectClaim(String subjectClaim) {
        this.subjectClaim = subjectClaim;
    }

    public RequestObject getRequestObject() {
        return this.requestObject;
    }

    public void setRequestObject(RequestObject requestObject) {
        this.requestObject = requestObject;
    }

    public String getEssentialClaims() {
        return this.essentialClaims;
    }

    public void setEssentialClaims(String essentialClaims) {
        this.essentialClaims = essentialClaims;
    }

    public LinkedHashSet getAcrValue() {
        return this.acrValue;
    }

    public void setAcrValue(LinkedHashSet acrValue) {
        this.acrValue = acrValue;
    }

    public String getSelectedAcrValue() {
        return this.selectedAcrValue;
    }

    public void setSelectedAcrValue(String selectedAcrValue) {
        this.selectedAcrValue = selectedAcrValue;
    }

    public long getAuthTime() {
        return this.authTime;
    }

    public void setAuthTime(long authTime) {
        this.authTime = authTime;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public AuthorizationGrantCacheEntry(Map<ClaimMapping, String> userAttributes) {
        this.userAttributes = userAttributes;
    }

    public String getNonceValue() {
        return this.nonceValue;
    }

    public void setNonceValue(String nonceValue) {
        this.nonceValue = nonceValue;
    }

    public Map<ClaimMapping, String> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Map<ClaimMapping, String> userAttributes) {
        this.userAttributes = userAttributes;
    }

    public String getCodeId() {
        return this.codeId;
    }

    public void setCodeId(String codeId) {
        this.codeId = codeId;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getPkceCodeChallenge() {
        return this.pkceCodeChallenge;
    }

    public void setPkceCodeChallenge(String pkceCodeChallenge) {
        this.pkceCodeChallenge = pkceCodeChallenge;
    }

    public String getPkceCodeChallengeMethod() {
        return this.pkceCodeChallengeMethod;
    }

    public void setPkceCodeChallengeMethod(String pkceCodeChallengeMethod) {
        this.pkceCodeChallengeMethod = pkceCodeChallengeMethod;
    }

    public boolean isHasNonOIDCClaims() {
        return this.hasNonOIDCClaims;
    }

    public void setHasNonOIDCClaims(boolean hasNonOIDCClaims) {
        this.hasNonOIDCClaims = hasNonOIDCClaims;
    }

    public void addAmr(String reference) {
        this.amrList.add(reference);
    }

    public List<String> getAmrList() {
        return Collections.unmodifiableList(this.amrList);
    }

    public String getTokenBindingValue() {
        return this.tokenBindingValue;
    }

    public void setTokenBindingValue(String tokenBindingValue) {
        this.tokenBindingValue = tokenBindingValue;
    }
}

