/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.cache;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.utils.CarbonUtils;

public class AuthorizationGrantCache
extends BaseCache<AuthorizationGrantCacheKey, AuthorizationGrantCacheEntry> {
    private static final String AUTHORIZATION_GRANT_CACHE_NAME = "AuthorizationGrantCache";
    private static volatile AuthorizationGrantCache instance;
    private static final Log log;

    private AuthorizationGrantCache() {
        super(AUTHORIZATION_GRANT_CACHE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthorizationGrantCache getInstance() {
        CarbonUtils.checkSecurity();
        if (instance != null) return instance;
        Class<AuthorizationGrantCache> clazz = AuthorizationGrantCache.class;
        synchronized (AuthorizationGrantCache.class) {
            if (instance != null) return instance;
            instance = new AuthorizationGrantCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCacheByToken(AuthorizationGrantCacheKey key, AuthorizationGrantCacheEntry entry) {
        super.addToCache((Serializable)key, (Serializable)((Object)entry));
        String tokenId = entry.getTokenId();
        if (tokenId == null) {
            tokenId = this.replaceFromTokenId(key.getUserAttributesId());
            entry.setTokenId(tokenId);
        }
        this.storeToSessionStore(tokenId, entry);
    }

    public AuthorizationGrantCacheEntry getValueFromCacheByTokenId(AuthorizationGrantCacheKey key, String tokenId) {
        AuthorizationGrantCacheEntry cacheEntry = (AuthorizationGrantCacheEntry)((Object)super.getValueFromCache((Serializable)key));
        if (cacheEntry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting cache entry from session store using tokenId: " + tokenId));
            }
            cacheEntry = this.getFromSessionStore(tokenId);
        }
        return cacheEntry;
    }

    public AuthorizationGrantCacheEntry getValueFromCacheByToken(AuthorizationGrantCacheKey key) {
        AuthorizationGrantCacheEntry cacheEntry = (AuthorizationGrantCacheEntry)((Object)super.getValueFromCache((Serializable)key));
        if (cacheEntry == null) {
            cacheEntry = this.getFromSessionStore(this.replaceFromTokenId(key.getUserAttributesId()));
        }
        return cacheEntry;
    }

    public void clearCacheEntryByToken(AuthorizationGrantCacheKey key) {
        super.clearCacheEntry((Serializable)key);
        this.clearFromSessionStore(this.replaceFromTokenId(key.getUserAttributesId()));
    }

    public void clearCacheEntryByTokenId(AuthorizationGrantCacheKey key, String tokenId) {
        super.clearCacheEntry((Serializable)key);
        this.clearFromSessionStore(tokenId);
    }

    public void addToCacheByCode(AuthorizationGrantCacheKey key, AuthorizationGrantCacheEntry entry) {
        super.addToCache((Serializable)key, (Serializable)((Object)entry));
        long validityPeriodNano = TimeUnit.SECONDS.toNanos(OAuthServerConfiguration.getInstance().getAuthorizationCodeValidityPeriodInSeconds());
        entry.setValidityPeriod(validityPeriodNano);
        this.storeToSessionStore(entry.getCodeId(), entry);
    }

    public AuthorizationGrantCacheEntry getValueFromCacheByCode(AuthorizationGrantCacheKey key) {
        AuthorizationGrantCacheEntry cacheEntry = (AuthorizationGrantCacheEntry)((Object)super.getValueFromCache((Serializable)key));
        if (cacheEntry == null) {
            cacheEntry = this.getFromSessionStore(this.replaceFromCodeId(key.getUserAttributesId()));
        }
        return cacheEntry;
    }

    public void clearCacheEntryByCode(AuthorizationGrantCacheKey key) {
        super.clearCacheEntry((Serializable)key);
        this.clearFromSessionStore(this.replaceFromCodeId(key.getUserAttributesId()));
    }

    public void clearCacheEntryByCodeId(AuthorizationGrantCacheKey key, String authzCodeId) {
        super.clearCacheEntry((Serializable)key);
        this.clearFromSessionStore(authzCodeId);
    }

    private String replaceFromCodeId(String authzCode) {
        try {
            return OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().getCodeIdByAuthorizationCode(authzCode);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)("Failed to retrieve authorization code id by authorization code from store for - ." + authzCode), (Throwable)((Object)e));
            return authzCode;
        }
    }

    private String replaceFromTokenId(String keyValue) {
        try {
            return OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getTokenIdByAccessToken(keyValue);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)("Failed to retrieve token id by token from store for - ." + keyValue), (Throwable)((Object)e));
            return keyValue;
        }
    }

    private void clearFromSessionStore(String id) {
        SessionDataStore.getInstance().clearSessionData(id, AUTHORIZATION_GRANT_CACHE_NAME);
    }

    private AuthorizationGrantCacheEntry getFromSessionStore(String id) {
        return (AuthorizationGrantCacheEntry)((Object)SessionDataStore.getInstance().getSessionData(id, AUTHORIZATION_GRANT_CACHE_NAME));
    }

    private void storeToSessionStore(String id, AuthorizationGrantCacheEntry entry) {
        SessionDataStore.getInstance().storeSessionData(id, AUTHORIZATION_GRANT_CACHE_NAME, (Object)entry);
    }

    static {
        log = LogFactory.getLog(AuthorizationGrantCache.class);
    }
}

