/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.Base64;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.Error;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.IdentityOAuthClientException;
import org.wso2.carbon.identity.oauth.IdentityOAuthServerException;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth.util.ClaimCache;
import org.wso2.carbon.identity.oauth.util.ClaimCacheKey;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ClientException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ServerException;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public final class OAuthUtil {
    public static final Log LOG = LogFactory.getLog(OAuthUtil.class);
    private static final String ALGORITHM = "HmacSHA1";

    private OAuthUtil() {
    }

    public static String getRandomNumber() throws IdentityOAuthAdminException {
        try {
            String secretKey = UUIDGenerator.generateUUID();
            String baseString = UUIDGenerator.generateUUID();
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(Charsets.UTF_8), ALGORITHM);
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(key);
            byte[] rawHmac = mac.doFinal(baseString.getBytes(Charsets.UTF_8));
            String random = Base64.encode((byte[])rawHmac);
            random = random.replace("/", "_");
            random = random.replace("=", "a");
            random = random.replace("+", "f");
            return random;
        }
        catch (Exception e) {
            throw new IdentityOAuthAdminException("Error when generating a random number.", e);
        }
    }

    public static void clearOAuthCache(String consumerKey, User authorizedUser) {
        String authenticatedIDP;
        String user = UserCoreUtil.addDomainToName((String)authorizedUser.getUserName(), (String)authorizedUser.getUserStoreDomain());
        user = UserCoreUtil.addTenantDomainToEntry((String)user, (String)authorizedUser.getTenantDomain());
        if (authorizedUser instanceof AuthenticatedUser) {
            authenticatedIDP = ((AuthenticatedUser)authorizedUser).getFederatedIdPName();
        } else {
            authenticatedIDP = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"User object is not an instance of AuthenticatedUser therefore cannot resolve authenticatedIDP name.");
            }
            OAuthUtil.clearOAuthCache(consumerKey, user);
        }
        OAuthUtil.clearOAuthCacheWithAuthenticatedIDP(consumerKey, user, authenticatedIDP);
    }

    public static void clearOAuthCache(String consumerKey, User authorizedUser, String scope) {
        String authenticatedIDP;
        String user = UserCoreUtil.addDomainToName((String)authorizedUser.getUserName(), (String)authorizedUser.getUserStoreDomain());
        user = UserCoreUtil.addTenantDomainToEntry((String)user, (String)authorizedUser.getTenantDomain());
        if (authorizedUser instanceof AuthenticatedUser) {
            authenticatedIDP = ((AuthenticatedUser)authorizedUser).getFederatedIdPName();
        } else {
            authenticatedIDP = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"User object is not an instance of AuthenticatedUser therefore cannot resolve authenticatedIDP name.");
            }
            OAuthUtil.clearOAuthCache(consumerKey, user, scope);
        }
        OAuthUtil.clearOAuthCacheWithAuthenticatedIDP(consumerKey, user, scope, authenticatedIDP);
    }

    public static void clearOAuthCache(String consumerKey, User authorizedUser, String scope, String tokenBindingReference) {
        String authenticatedIDP;
        String user = UserCoreUtil.addDomainToName((String)authorizedUser.getUserName(), (String)authorizedUser.getUserStoreDomain());
        user = UserCoreUtil.addTenantDomainToEntry((String)user, (String)authorizedUser.getTenantDomain());
        if (authorizedUser instanceof AuthenticatedUser) {
            authenticatedIDP = ((AuthenticatedUser)authorizedUser).getFederatedIdPName();
        } else {
            authenticatedIDP = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"User is not an instance of AuthenticatedUser therefore cannot resolve authenticatedIDP name");
            }
            OAuthUtil.clearOAuthCache(consumerKey, user, scope);
        }
        OAuthUtil.clearOAuthCache(OAuthUtil.buildCacheKeyStringForToken(consumerKey, scope, user, authenticatedIDP, tokenBindingReference));
    }

    @Deprecated
    public static void clearOAuthCache(String consumerKey, String authorizedUser) {
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authorizedUser);
        if (!isUsernameCaseSensitive) {
            authorizedUser = authorizedUser.toLowerCase();
        }
        OAuthUtil.clearOAuthCache(consumerKey + ":" + authorizedUser);
    }

    private static void clearOAuthCacheWithAuthenticatedIDP(String consumerKey, String authorizedUser, String authenticatedIDP) {
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authorizedUser);
        if (!isUsernameCaseSensitive) {
            authorizedUser = authorizedUser.toLowerCase();
        }
        OAuthUtil.clearOAuthCache(consumerKey + ":" + authorizedUser + ":" + authenticatedIDP);
    }

    @Deprecated
    public static void clearOAuthCache(String consumerKey, String authorizedUser, String scope) {
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authorizedUser);
        if (!isUsernameCaseSensitive) {
            authorizedUser = authorizedUser.toLowerCase();
        }
        OAuthUtil.clearOAuthCache(consumerKey + ":" + authorizedUser + ":" + scope);
    }

    private static void clearOAuthCacheWithAuthenticatedIDP(String consumerKey, String authorizedUser, String scope, String authenticatedIDP) {
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authorizedUser);
        if (!isUsernameCaseSensitive) {
            authorizedUser = authorizedUser.toLowerCase();
        }
        OAuthUtil.clearOAuthCache(consumerKey + ":" + authorizedUser + ":" + scope + ":" + authenticatedIDP);
    }

    public static String buildCacheKeyStringForToken(String clientId, String scope, String authorizedUser, String authenticatedIDP, String tokenBindingReference) {
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authorizedUser);
        if (isUsernameCaseSensitive) {
            return clientId + ":" + authorizedUser + ":" + scope + ":" + authenticatedIDP + ":" + tokenBindingReference;
        }
        return clientId + ":" + authorizedUser.toLowerCase() + ":" + scope + ":" + authenticatedIDP + ":" + tokenBindingReference;
    }

    public static void clearOAuthCache(String oauthCacheKey) {
        OAuthCacheKey cacheKey = new OAuthCacheKey(oauthCacheKey);
        OAuthCache.getInstance().clearCacheEntry(cacheKey);
    }

    public static AuthenticatedUser getAuthenticatedUser(String fullyQualifiedUserName) {
        if (StringUtils.isBlank((String)fullyQualifiedUserName)) {
            throw new RuntimeException("Invalid username.");
        }
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setUserStoreDomain(IdentityUtil.extractDomainFromName((String)fullyQualifiedUserName));
        authenticatedUser.setTenantDomain(MultitenantUtils.getTenantDomain((String)fullyQualifiedUserName));
        String username = fullyQualifiedUserName;
        if (fullyQualifiedUserName.startsWith(authenticatedUser.getUserStoreDomain())) {
            username = UserCoreUtil.removeDomainFromName((String)fullyQualifiedUserName);
        }
        authenticatedUser.setUserName(MultitenantUtils.getTenantAwareUsername((String)username));
        return authenticatedUser;
    }

    public static IdentityOAuthAdminException handleError(String message, Exception exception) {
        if (exception == null) {
            return new IdentityOAuthAdminException(message);
        }
        String errorCode = Error.UNEXPECTED_SERVER_ERROR.getErrorCode();
        return new IdentityOAuthAdminException(errorCode, message, exception);
    }

    public static IdentityOAuthAdminException handleErrorWithExceptionType(String message, IdentityOAuth2Exception exception) {
        if (exception == null) {
            return new IdentityOAuthAdminException(message);
        }
        if (StringUtils.isBlank((String)exception.getErrorCode())) {
            OAuthUtil.handleError(message, (Exception)((Object)exception));
        }
        if (exception instanceof IdentityOAuth2ClientException) {
            return new IdentityOAuthClientException(exception.getErrorCode(), message, (Throwable)((Object)exception));
        }
        if (exception instanceof IdentityOAuth2ServerException) {
            return new IdentityOAuthServerException(exception.getErrorCode(), message, (Throwable)((Object)exception));
        }
        return new IdentityOAuthAdminException(exception.getErrorCode(), message, (Throwable)((Object)exception));
    }

    public static OAuthConsumerAppDTO buildConsumerAppDTO(OAuthAppDO appDO) {
        OAuthConsumerAppDTO dto = new OAuthConsumerAppDTO();
        dto.setApplicationName(appDO.getApplicationName());
        dto.setCallbackUrl(appDO.getCallbackUrl());
        dto.setOauthConsumerKey(appDO.getOauthConsumerKey());
        dto.setOauthConsumerSecret(appDO.getOauthConsumerSecret());
        dto.setOAuthVersion(appDO.getOauthVersion());
        dto.setGrantTypes(appDO.getGrantTypes());
        dto.setScopeValidators(appDO.getScopeValidators());
        dto.setUsername(appDO.getUser().toFullQualifiedUsername());
        dto.setState(appDO.getState());
        dto.setPkceMandatory(appDO.isPkceMandatory());
        dto.setPkceSupportPlain(appDO.isPkceSupportPlain());
        dto.setUserAccessTokenExpiryTime(appDO.getUserAccessTokenExpiryTime());
        dto.setApplicationAccessTokenExpiryTime(appDO.getApplicationAccessTokenExpiryTime());
        dto.setRefreshTokenExpiryTime(appDO.getRefreshTokenExpiryTime());
        dto.setIdTokenExpiryTime(appDO.getIdTokenExpiryTime());
        dto.setAudiences(appDO.getAudiences());
        dto.setRequestObjectSignatureValidationEnabled(appDO.isRequestObjectSignatureValidationEnabled());
        dto.setIdTokenEncryptionEnabled(appDO.isIdTokenEncryptionEnabled());
        dto.setIdTokenEncryptionAlgorithm(appDO.getIdTokenEncryptionAlgorithm());
        dto.setIdTokenEncryptionMethod(appDO.getIdTokenEncryptionMethod());
        dto.setBackChannelLogoutUrl(appDO.getBackChannelLogoutUrl());
        dto.setFrontchannelLogoutUrl(appDO.getFrontchannelLogoutUrl());
        dto.setTokenType(appDO.getTokenType());
        dto.setBypassClientCredentials(appDO.isBypassClientCredentials());
        dto.setRenewRefreshTokenEnabled(appDO.getRenewRefreshTokenEnabled());
        dto.setTokenBindingType(appDO.getTokenBindingType());
        dto.setTokenRevocationWithIDPSessionTerminationEnabled(appDO.isTokenRevocationWithIDPSessionTerminationEnabled());
        dto.setTokenBindingValidationEnabled(appDO.isTokenBindingValidationEnabled());
        return dto;
    }

    public static void invokePostRevocationBySystemListeners(AccessTokenDO accessTokenDO, Map<String, Object> params) {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            try {
                oAuthEventInterceptorProxy.onPostTokenRevocationBySystem(accessTokenDO, params);
            }
            catch (IdentityOAuth2Exception e) {
                LOG.error((Object)"Error while triggering listener for post token revocation by system.", (Throwable)((Object)e));
            }
        }
    }

    public static void invokePreRevocationBySystemListeners(AccessTokenDO accessTokenDO, Map<String, Object> params) {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            try {
                oAuthEventInterceptorProxy.onPreTokenRevocationBySystem(accessTokenDO, params);
            }
            catch (IdentityOAuth2Exception e) {
                LOG.error((Object)"Error while triggering listener for pre token revocation by system.", (Throwable)((Object)e));
            }
        }
    }

    public static boolean removeUserClaimsFromCache(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        ClaimCache claimCache = ClaimCache.getInstance();
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setUserName(userName);
        authenticatedUser.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)userStoreManager.getTenantId()));
        authenticatedUser.setUserStoreDomain(UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration()));
        ClaimCacheKey cacheKey = new ClaimCacheKey(authenticatedUser);
        if (cacheKey != null) {
            claimCache.clearCacheEntry(cacheKey);
        }
        return true;
    }

    public static boolean revokeTokens(String username, UserStoreManager userStoreManager) throws UserStoreException {
        Set<String> clientIds;
        String userStoreDomain = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        String tenantDomain = IdentityTenantUtil.getTenantDomain((int)userStoreManager.getTenantId());
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setUserStoreDomain(userStoreDomain);
        authenticatedUser.setTenantDomain(tenantDomain);
        authenticatedUser.setUserName(username);
        userStoreDomain = null;
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            try {
                userStoreDomain = OAuth2Util.getUserStoreForFederatedUser(authenticatedUser);
            }
            catch (IdentityOAuth2Exception e) {
                LOG.error((Object)("Error occurred while getting user store domain for User ID : " + authenticatedUser), (Throwable)((Object)e));
                throw new UserStoreException((Throwable)((Object)e));
            }
        }
        try {
            clientIds = OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().getAllTimeAuthorizedClientIds(authenticatedUser);
        }
        catch (IdentityOAuth2Exception e) {
            LOG.error((Object)("Error occurred while retrieving apps authorized by User ID : " + authenticatedUser), (Throwable)((Object)e));
            throw new UserStoreException((Throwable)((Object)e));
        }
        Iterator<String> iterator = clientIds.iterator();
        if (iterator.hasNext()) {
            Set<AccessTokenDO> accessTokenDOs;
            String clientId = iterator.next();
            try {
                accessTokenDOs = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessTokens(clientId, authenticatedUser, userStoreDomain, true);
            }
            catch (IdentityOAuth2Exception e) {
                String errorMsg = "Error occurred while retrieving access tokens issued for Client ID : " + clientId + ", User ID : " + authenticatedUser;
                LOG.error((Object)errorMsg, (Throwable)((Object)e));
                throw new UserStoreException((Throwable)((Object)e));
            }
            boolean isTokenPreservingAtPasswordUpdateEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"PasswordUpdate.PreserveLoggedInSession"));
            String currentTokenBindingReference = "";
            if (isTokenPreservingAtPasswordUpdateEnabled && ((Map)IdentityUtil.threadLocalProperties.get()).get("currentSessionIdentifier") != null) {
                currentTokenBindingReference = (String)((Map)IdentityUtil.threadLocalProperties.get()).get("currentSessionIdentifier");
            }
            HashSet<String> scopes = new HashSet<String>();
            ArrayList<AccessTokenDO> accessTokens = new ArrayList<AccessTokenDO>();
            boolean tokenBindingEnabled = false;
            for (AccessTokenDO accessTokenDO : accessTokenDOs) {
                String tokenBindingReference = "NONE";
                if (accessTokenDO.getTokenBinding() != null && StringUtils.isNotBlank((String)accessTokenDO.getTokenBinding().getBindingReference())) {
                    tokenBindingReference = accessTokenDO.getTokenBinding().getBindingReference();
                    tokenBindingEnabled = true;
                    if (StringUtils.equals((String)accessTokenDO.getTokenBinding().getBindingValue(), (String)currentTokenBindingReference)) continue;
                }
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser(), OAuth2Util.buildScopeString(accessTokenDO.getScope()), tokenBindingReference);
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser(), OAuth2Util.buildScopeString(accessTokenDO.getScope()));
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser());
                OAuthUtil.clearOAuthCache(accessTokenDO.getAccessToken());
                scopes.add(OAuth2Util.buildScopeString(accessTokenDO.getScope()));
                accessTokens.add(accessTokenDO);
            }
            if (!tokenBindingEnabled && OAuth2Util.isHashDisabled()) {
                return OAuthUtil.revokeLatestTokensWithScopes(scopes, clientId, authenticatedUser);
            }
            try {
                return OAuthUtil.revokeTokens(accessTokens);
            }
            catch (IdentityOAuth2Exception e) {
                String errorMsg = "Error occurred while revoking Access Token";
                LOG.error((Object)errorMsg, (Throwable)((Object)e));
                throw new UserStoreException((Throwable)((Object)e));
            }
        }
        return true;
    }

    private static boolean revokeTokens(List<AccessTokenDO> accessTokens) throws IdentityOAuth2Exception {
        if (!accessTokens.isEmpty()) {
            for (AccessTokenDO accessToken : accessTokens) {
                OAuthUtil.invokePreRevocationBySystemListeners(accessToken, Collections.emptyMap());
                OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens(new String[]{accessToken.getAccessToken()}, OAuth2Util.isHashEnabled());
                OAuthUtil.invokePostRevocationBySystemListeners(accessToken, Collections.emptyMap());
            }
        }
        return true;
    }

    private static boolean revokeLatestTokensWithScopes(Set<String> scopes, String clientId, AuthenticatedUser authenticatedUser) throws UserStoreException {
        for (String scope : scopes) {
            AccessTokenDO scopedToken = null;
            try {
                scopedToken = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getLatestAccessToken(clientId, authenticatedUser, authenticatedUser.getUserStoreDomain(), scope, true);
            }
            catch (IdentityOAuth2Exception e) {
                String errorMsg = "Error occurred while retrieving latest access token issued for Client ID : " + clientId + ", User ID : " + authenticatedUser + " and Scope : " + scope;
                LOG.error((Object)errorMsg, (Throwable)((Object)e));
                throw new UserStoreException((Throwable)((Object)e));
            }
            if (scopedToken == null) continue;
            try {
                OAuthUtil.revokeTokens(Collections.singletonList(scopedToken));
            }
            catch (IdentityOAuth2Exception e) {
                String errorMsg = "Error occurred while revoking Access Token : " + scopedToken.getAccessToken() + " for user " + authenticatedUser;
                LOG.error((Object)errorMsg, (Throwable)((Object)e));
                throw new UserStoreException((Throwable)((Object)e));
            }
        }
        return true;
    }
}

