/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth;

import com.google.gdata.client.authn.oauth.GoogleOAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthException;
import com.google.gdata.client.authn.oauth.OAuthHmacSha1Signer;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.Parameters;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.dao.OAuthConsumerDAO;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerDTO;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuthService {
    private static final String OAUTH_LATEST_TIMESTAMP = "OAUTH_LATEST_TIMESTAMP";
    private static final String OAUTH_NONCE_STORE = "OAUTH_NONCE_STORE";
    private static final Log LOG = LogFactory.getLog(OAuthService.class);

    public boolean isOAuthConsumerValid(OAuthConsumerDTO oauthConsumer) throws IdentityException {
        String oAuthSecretKey = this.getOAuthSecretKey(oauthConsumer.getOauthConsumerKey());
        if (oAuthSecretKey == null) {
            LOG.debug((Object)"Invalid Consumer Key.");
            throw IdentityException.error((String)"Invalid Consumer Key");
        }
        try {
            return this.validateOauthSignature(oauthConsumer, oAuthSecretKey);
        }
        catch (AuthenticationException e) {
            throw IdentityException.error((String)e.getMessage(), (Throwable)e);
        }
    }

    public Parameters getOauthRequestToken(Parameters params) throws AuthenticationException, IdentityOAuthAdminException {
        this.validateTimestampAndNonce(params.getOauthTimeStamp(), params.getOauthNonce());
        OAuthConsumerDAO dao = new OAuthConsumerDAO();
        String secretkey = dao.getOAuthConsumerSecret(params.getOauthConsumerKey());
        if (secretkey == null) {
            LOG.debug((Object)"Invalid Credentials.");
            throw new AuthenticationException("Invalid Credentials.");
        }
        boolean isValidSignature = this.validateOauthSignature(params, secretkey, null);
        if (!isValidSignature) {
            throw new AuthenticationException("Invalid Signature");
        }
        return this.generateOauthToken(params);
    }

    public Parameters authorizeOauthRequestToken(Parameters params) throws IdentityException, AuthenticationException {
        String tenantUser = MultitenantUtils.getTenantAwareUsername((String)params.getAuthorizedbyUserName());
        String domainName = MultitenantUtils.getTenantDomain((String)params.getAuthorizedbyUserName());
        boolean isAuthenticated = false;
        try {
            isAuthenticated = IdentityTenantUtil.getRealm((String)domainName, (String)params.getAuthorizedbyUserName()).getUserStoreManager().authenticate(tenantUser, (Object)params.getAuthorizedbyUserPassword());
        }
        catch (UserStoreException e) {
            LOG.error((Object)"Error while authenticating the user", (Throwable)e);
            throw IdentityException.error((String)"Error while authenticating the user");
        }
        if (isAuthenticated) {
            OAuthConsumerDAO dao = new OAuthConsumerDAO();
            String oauthVerifier = OAuthUtil.getRandomNumber();
            Parameters token = dao.authorizeOAuthToken(params.getOauthToken(), tenantUser, oauthVerifier);
            token.setOauthToken(params.getOauthToken());
            token.setOauthTokenVerifier(oauthVerifier);
            return token;
        }
        throw new AuthenticationException("User Authentication Failed");
    }

    public Parameters getAccessToken(Parameters params) throws IdentityOAuthAdminException, AuthenticationException, IdentityException {
        boolean isValidSignature = false;
        String secretKey = null;
        OAuthConsumerDAO dao = new OAuthConsumerDAO();
        secretKey = dao.getOAuthConsumerSecret(params.getOauthConsumerKey());
        if (secretKey == null) {
            LOG.debug((Object)"Invalid Credentials.");
            throw new AuthenticationException("Invalid Credentials.");
        }
        String tokenSecret = dao.getOAuthTokenSecret(params.getOauthToken(), false);
        isValidSignature = this.validateOauthSignature(params, secretKey, tokenSecret);
        if (!isValidSignature) {
            throw new AuthenticationException("Invalid Signature");
        }
        Parameters resp = dao.getRequestToken(params.getOauthToken());
        if (resp.getOauthTokenVerifier() == null || !resp.getOauthTokenVerifier().equals(params.getOauthTokenVerifier()) || resp.getAuthorizedbyUserName() == null) {
            throw new AuthenticationException("Invalid request for OAuth access token");
        }
        String oauthToken = OAuthUtil.getRandomNumber();
        String oauthSecret = OAuthUtil.getRandomNumber();
        dao.issueAccessToken(params.getOauthConsumerKey(), oauthToken, oauthSecret, params.getOauthToken(), resp.getAuthorizedbyUserName(), resp.getScope());
        resp.setOauthToken(oauthToken);
        resp.setOauthTokenSecret(oauthSecret);
        return resp;
    }

    public Parameters getScopeAndAppName(String oauthToken) throws Exception {
        OAuthConsumerDAO consumerDAO = new OAuthConsumerDAO();
        Parameters params = consumerDAO.getRequestToken(oauthToken);
        OAuthAppDAO appDAO = new OAuthAppDAO();
        OAuthAppDO oauthAppDO = appDAO.getAppInformation(params.getOauthConsumerKey());
        Parameters resp = new Parameters();
        resp.setScope(params.getScope());
        resp.setAppName(oauthAppDO.getApplicationName());
        return resp;
    }

    public Parameters validateAuthenticationRequest(Parameters params) throws AuthenticationException, IdentityException {
        boolean isAuthenticated = false;
        String secretKey = null;
        this.validateTimestampAndNonce(params.getOauthTimeStamp(), params.getOauthNonce());
        OAuthConsumerDAO dao = new OAuthConsumerDAO();
        secretKey = dao.getOAuthConsumerSecret(params.getOauthConsumerKey());
        if (secretKey == null) {
            LOG.debug((Object)"Invalid Credentials.");
            throw new AuthenticationException("Invalid Credentials.");
        }
        String tokenSecret = dao.getOAuthTokenSecret(params.getOauthToken(), true);
        isAuthenticated = this.validateOauthSignature(params, secretKey, tokenSecret);
        if (isAuthenticated) {
            String subject = dao.validateAccessToken(params.getOauthConsumerKey(), params.getOauthToken(), params.getScope());
            Parameters returnParams = new Parameters();
            returnParams.setAuthorizedbyUserName(subject);
            returnParams.setScope(params.getScope());
            return returnParams;
        }
        throw new AuthenticationException("Invalid Signature.");
    }

    private Parameters generateOauthToken(Parameters oauthParams) throws IdentityOAuthAdminException {
        OAuthConsumerDAO dao = new OAuthConsumerDAO();
        String oauthToken = OAuthUtil.getRandomNumber();
        String oauthSecret = OAuthUtil.getRandomNumber();
        dao.createOAuthRequestToken(oauthParams.getOauthConsumerKey(), oauthToken, oauthSecret, oauthParams.getOauthCallback(), oauthParams.getScope());
        Parameters params = new Parameters();
        params.setOauthConsumerKey(oauthParams.getOauthConsumerKey());
        params.setOauthToken(oauthToken);
        params.setOauthTokenSecret(oauthSecret);
        return params;
    }

    private boolean validateOauthSignature(OAuthConsumerDTO oauthParams, String secretKey) throws AuthenticationException {
        String signature;
        GoogleOAuthParameters oauthParameters = new GoogleOAuthParameters();
        oauthParameters.setOAuthConsumerKey(oauthParams.getOauthConsumerKey());
        oauthParameters.setOAuthConsumerSecret(secretKey);
        oauthParameters.setOAuthNonce(oauthParams.getOauthNonce());
        oauthParameters.setOAuthTimestamp(oauthParams.getOauthTimeStamp());
        oauthParameters.setOAuthSignatureMethod(oauthParams.getOauthSignatureMethod());
        this.validateTimestampAndNonce(oauthParams.getOauthTimeStamp(), oauthParams.getOauthNonce());
        OAuthHmacSha1Signer signer = new OAuthHmacSha1Signer();
        try {
            String baseString = com.google.gdata.client.authn.oauth.OAuthUtil.getSignatureBaseString((String)oauthParams.getBaseString(), (String)oauthParams.getHttpMethod(), (Map)oauthParameters.getBaseParameters());
            signature = signer.getSignature(baseString, (OAuthParameters)oauthParameters);
        }
        catch (OAuthException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        if (signature != null && URLEncoder.encode(signature).equals(oauthParams.getOauthSignature())) {
            return true;
        }
        return signature != null && signature.equals(oauthParams.getOauthSignature());
    }

    private boolean validateOauthSignature(Parameters oauthParams, String secretKey, String tokenSecret) throws AuthenticationException {
        String signature;
        GoogleOAuthParameters oauthParameters = new GoogleOAuthParameters();
        oauthParameters.setOAuthConsumerKey(oauthParams.getOauthConsumerKey());
        oauthParameters.setOAuthConsumerSecret(secretKey);
        oauthParameters.setOAuthNonce(oauthParams.getOauthNonce());
        oauthParameters.setOAuthTimestamp(oauthParams.getOauthTimeStamp());
        oauthParameters.setOAuthSignatureMethod(oauthParams.getOauthSignatureMethod());
        if (oauthParams.getOauthToken() != null) {
            oauthParameters.setOAuthToken(oauthParams.getOauthToken());
        }
        if (oauthParams.getOauthTokenVerifier() != null) {
            oauthParameters.setOAuthVerifier(oauthParams.getOauthTokenVerifier());
        }
        if (tokenSecret != null) {
            oauthParameters.setOAuthTokenSecret(tokenSecret);
        }
        OAuthHmacSha1Signer signer = new OAuthHmacSha1Signer();
        try {
            String baseString = com.google.gdata.client.authn.oauth.OAuthUtil.getSignatureBaseString((String)oauthParams.getBaseString(), (String)oauthParams.getHttpMethod(), (Map)oauthParameters.getBaseParameters());
            signature = signer.getSignature(baseString, (OAuthParameters)oauthParameters);
        }
        catch (OAuthException e) {
            throw new AuthenticationException("Error while validating signature");
        }
        if (signature != null && URLEncoder.encode(signature).equals(oauthParams.getOauthSignature())) {
            return true;
        }
        return signature != null && signature.equals(oauthParams.getOauthSignature());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateTimestampAndNonce(String timestamp, String nonce) throws AuthenticationException {
        if (timestamp == null || nonce == null || nonce.trim().length() == 0) {
            throw new AuthenticationException("Invalid request for OAuth access token");
        }
        long time = Long.parseLong(timestamp);
        OAuthService oAuthService = this;
        synchronized (oAuthService) {
            long latestTimeStamp = 0L;
            ServiceContext context = MessageContext.getCurrentMessageContext().getServiceContext();
            String strTimestamp = (String)context.getProperty(OAUTH_LATEST_TIMESTAMP);
            if (strTimestamp != null) {
                latestTimeStamp = Long.parseLong(strTimestamp);
            }
            if (time < 0L || time < latestTimeStamp) {
                throw new AuthenticationException("Invalid timestamp");
            }
            context.setProperty(OAUTH_LATEST_TIMESTAMP, (Object)String.valueOf(time));
            ArrayList<String> nonceStore = null;
            nonceStore = (ArrayList<String>)context.getProperty(OAUTH_NONCE_STORE);
            if (nonceStore != null) {
                if (nonceStore.contains(nonce)) {
                    throw new AuthenticationException("Invalid request for OAuth access token");
                }
                nonceStore.add(nonce);
            } else {
                nonceStore = new ArrayList<String>();
                nonceStore.add(nonce);
                context.setProperty(OAUTH_NONCE_STORE, nonceStore);
            }
        }
    }

    private String getOAuthSecretKey(String consumerKey) throws IdentityOAuthAdminException {
        OAuthConsumerDAO dao = new OAuthConsumerDAO();
        return dao.getOAuthConsumerSecret(consumerKey);
    }
}

