/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.Error;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.IdentityOAuthClientException;
import org.wso2.carbon.identity.oauth.OAuthAdminService;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.cache.AppInfoCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.identity.oauth.dto.OAuthIDTokenAlgorithmDTO;
import org.wso2.carbon.identity.oauth.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth.dto.OAuthRevocationResponseDTO;
import org.wso2.carbon.identity.oauth.dto.OAuthTokenExpiryTimeDTO;
import org.wso2.carbon.identity.oauth.dto.ScopeDTO;
import org.wso2.carbon.identity.oauth.dto.TokenBindingMetaDataDTO;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth.listener.OAuthApplicationMgtListener;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.OAuth2Service;
import org.wso2.carbon.identity.oauth2.Oauth2ScopeConstants;
import org.wso2.carbon.identity.oauth2.authz.handlers.ResponseTypeHandler;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.OAuth2ScopeValidator;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuthAdminServiceImpl {
    public static final String IMPLICIT = "implicit";
    public static final String AUTHORIZATION_CODE = "authorization_code";
    static final String RESPONSE_TYPE_TOKEN = "token";
    static final String RESPONSE_TYPE_ID_TOKEN = "id_token";
    static List<String> allowedGrants = null;
    static String[] allowedScopeValidators = null;
    protected static final Log LOG = LogFactory.getLog(OAuthAdminServiceImpl.class);
    private static final String SCOPE_VALIDATION_REGEX = "^[^?#/()]*$";

    public String[] registerOAuthConsumer() throws IdentityOAuthAdminException {
        String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding a consumer secret for the logged in user:" + loggedInUser));
        }
        String tenantUser = MultitenantUtils.getTenantAwareUsername((String)loggedInUser);
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String userDomain = IdentityUtil.extractDomainFromName((String)loggedInUser);
        OAuthAppDAO dao = new OAuthAppDAO();
        return dao.addOAuthConsumer(UserCoreUtil.removeDomainFromName((String)tenantUser), tenantId, userDomain);
    }

    public OAuthConsumerAppDTO[] getAllOAuthApplicationData() throws IdentityOAuthAdminException {
        String userName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        OAuthConsumerAppDTO[] dtos = new OAuthConsumerAppDTO[]{};
        if (userName == null) {
            String msg = "User not logged in to get all registered OAuth Applications.";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)msg);
            }
            throw this.handleClientError(Error.AUTHENTICATED_USER_NOT_FOUND, msg);
        }
        OAuthAppDAO dao = new OAuthAppDAO();
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        OAuthAppDO[] apps = dao.getOAuthConsumerAppsOfUser(userName, tenantId);
        if (apps != null && apps.length > 0) {
            dtos = new OAuthConsumerAppDTO[apps.length];
            for (int i = 0; i < apps.length; ++i) {
                OAuthAppDO app = apps[i];
                dtos[i] = OAuthUtil.buildConsumerAppDTO(app);
            }
        }
        return dtos;
    }

    public OAuthConsumerAppDTO getOAuthApplicationData(String consumerKey) throws IdentityOAuthAdminException {
        try {
            OAuthConsumerAppDTO dto;
            OAuthAppDO app = this.getOAuthApp(consumerKey);
            if (app != null) {
                dto = OAuthUtil.buildConsumerAppDTO(app);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found App :" + dto.getApplicationName() + " for consumerKey: " + consumerKey));
                }
            } else {
                dto = new OAuthConsumerAppDTO();
            }
            return dto;
        }
        catch (InvalidOAuthClientException e) {
            String msg = "Cannot find a valid OAuth client for consumerKey: " + consumerKey;
            throw this.handleClientError(Error.INVALID_OAUTH_CLIENT, msg, (Exception)((Object)e));
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error while retrieving the app information using consumerKey: " + consumerKey, (Exception)((Object)e));
        }
    }

    public OAuthConsumerAppDTO getOAuthApplicationDataByAppName(String appName) throws IdentityOAuthAdminException {
        OAuthAppDAO dao = new OAuthAppDAO();
        try {
            OAuthAppDO app = dao.getAppInformationByAppName(appName);
            OAuthConsumerAppDTO dto = app != null ? OAuthUtil.buildConsumerAppDTO(app) : new OAuthConsumerAppDTO();
            return dto;
        }
        catch (InvalidOAuthClientException e) {
            String msg = "Cannot find a valid OAuth client with application name: " + appName;
            throw this.handleClientError(Error.INVALID_OAUTH_CLIENT, msg);
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error while retrieving the app information by app name: " + appName, (Exception)((Object)e));
        }
    }

    public void registerOAuthApplicationData(OAuthConsumerAppDTO application) throws IdentityOAuthAdminException {
        this.registerAndRetrieveOAuthApplicationData(application);
    }

    /*
     * Enabled aggressive block sorting
     */
    public OAuthConsumerAppDTO registerAndRetrieveOAuthApplicationData(OAuthConsumerAppDTO application) throws IdentityOAuthAdminException {
        String tenantAwareLoggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
        OAuthAppDO app = new OAuthAppDO();
        if (tenantAwareLoggedInUser != null) {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            OAuthAppDAO dao = new OAuthAppDAO();
            if (application == null) {
                String message = "No application details in the request. Failed to register OAuth App.";
                if (!LOG.isDebugEnabled()) throw this.handleClientError(Error.INVALID_REQUEST, message);
                LOG.debug((Object)message);
                throw this.handleClientError(Error.INVALID_REQUEST, message);
            }
            app.setApplicationName(application.getApplicationName());
            this.validateCallbackURI(application);
            app.setCallbackUrl(application.getCallbackUrl());
            app.setState("ACTIVE");
            if (StringUtils.isEmpty((String)application.getOauthConsumerKey())) {
                app.setOauthConsumerKey(OAuthUtil.getRandomNumber());
                app.setOauthConsumerSecret(OAuthUtil.getRandomNumber());
            } else {
                app.setOauthConsumerKey(application.getOauthConsumerKey());
                if (StringUtils.isEmpty((String)application.getOauthConsumerSecret())) {
                    app.setOauthConsumerSecret(OAuthUtil.getRandomNumber());
                } else {
                    app.setOauthConsumerSecret(application.getOauthConsumerSecret());
                }
            }
            AuthenticatedUser defaultAppOwner = this.buildAuthenticatedUser(tenantAwareLoggedInUser, tenantDomain);
            AuthenticatedUser appOwner = this.getAppOwner(application, defaultAppOwner);
            app.setAppOwner(appOwner);
            if (application.getOAuthVersion() != null) {
                app.setOauthVersion(application.getOAuthVersion());
            } else {
                app.setOauthVersion("OAuth-2.0");
            }
            if ("OAuth-2.0".equals(app.getOauthVersion())) {
                this.validateGrantTypes(application);
                app.setGrantTypes(application.getGrantTypes());
                app.setScopeValidators(this.filterScopeValidators(application));
                app.setAudiences(application.getAudiences());
                app.setPkceMandatory(application.getPkceMandatory());
                app.setPkceSupportPlain(application.getPkceSupportPlain());
                this.validateTokenExpiryConfigurations(application);
                app.setUserAccessTokenExpiryTime(application.getUserAccessTokenExpiryTime());
                app.setApplicationAccessTokenExpiryTime(application.getApplicationAccessTokenExpiryTime());
                app.setRefreshTokenExpiryTime(application.getRefreshTokenExpiryTime());
                app.setIdTokenExpiryTime(application.getIdTokenExpiryTime());
                app.setRequestObjectSignatureValidationEnabled(application.isRequestObjectSignatureValidationEnabled());
                app.setIdTokenEncryptionEnabled(application.isIdTokenEncryptionEnabled());
                if (application.isIdTokenEncryptionEnabled()) {
                    app.setIdTokenEncryptionAlgorithm(this.filterIdTokenEncryptionAlgorithm(application));
                    app.setIdTokenEncryptionMethod(this.filterIdTokenEncryptionMethod(application));
                }
                app.setBackChannelLogoutUrl(application.getBackChannelLogoutUrl());
                app.setFrontchannelLogoutUrl(application.getFrontchannelLogoutUrl());
                if (application.getTokenType() != null) {
                    app.setTokenType(application.getTokenType());
                } else {
                    app.setTokenType(this.getDefaultTokenType());
                }
                app.setBypassClientCredentials(application.isBypassClientCredentials());
                app.setRenewRefreshTokenEnabled(application.getRenewRefreshTokenEnabled());
                app.setTokenBindingType(application.getTokenBindingType());
                app.setTokenBindingValidationEnabled(application.isTokenBindingValidationEnabled());
                app.setTokenRevocationWithIDPSessionTerminationEnabled(application.isTokenRevocationWithIDPSessionTerminationEnabled());
            }
            dao.addOAuthApplication(app);
            AppInfoCache.getInstance().addToCache((Serializable)((Object)app.getOauthConsumerKey()), app);
            if (!LOG.isDebugEnabled()) return OAuthUtil.buildConsumerAppDTO(app);
            LOG.debug((Object)("Oauth Application registration success : " + application.getApplicationName() + " in tenant domain: " + tenantDomain));
            return OAuthUtil.buildConsumerAppDTO(app);
        }
        if (LOG.isDebugEnabled()) {
            if (application != null) {
                LOG.debug((Object)("No authenticated user found. Failed to register OAuth App: " + application.getApplicationName()));
            } else {
                LOG.debug((Object)"No authenticated user found. Failed to register OAuth App");
            }
        }
        String message = "No authenticated user found. Failed to register OAuth App.";
        throw this.handleClientError(Error.AUTHENTICATED_USER_NOT_FOUND, message);
    }

    private void validateGrantTypes(OAuthConsumerAppDTO application) throws IdentityOAuthClientException {
        String[] requestGrants = application.getGrantTypes().split("\\s");
        ArrayList<String> allowedGrantTypes = new ArrayList<String>(Arrays.asList(this.getAllowedGrantTypes()));
        for (String requestedGrant : requestGrants) {
            if (StringUtils.isBlank((String)requestedGrant) || allowedGrantTypes.contains(requestedGrant)) continue;
            String msg = String.format("'%s' grant type is not allowed.", requestedGrant);
            throw this.handleClientError(Error.INVALID_REQUEST, msg);
        }
    }

    private IdentityOAuthClientException handleClientError(Error errorMessage, String msg) {
        return new IdentityOAuthClientException(errorMessage.getErrorCode(), msg);
    }

    private IdentityOAuthClientException handleClientError(Oauth2ScopeConstants.ErrorMessages errorMessage, String msg) {
        return new IdentityOAuthClientException(errorMessage.getCode(), msg);
    }

    private IdentityOAuthClientException handleClientError(Error errorMessage, String msg, Exception ex) {
        return new IdentityOAuthClientException(errorMessage.getErrorCode(), msg, ex);
    }

    private void validateCallbackURI(OAuthConsumerAppDTO application) throws IdentityOAuthClientException {
        boolean isCallbackUriRequired;
        boolean bl = isCallbackUriRequired = application.getGrantTypes().contains(AUTHORIZATION_CODE) || application.getGrantTypes().contains(IMPLICIT);
        if (isCallbackUriRequired && StringUtils.isEmpty((String)application.getCallbackUrl())) {
            throw this.handleClientError(Error.INVALID_REQUEST, "Callback URI is mandatory for Code or Implicit grant types");
        }
    }

    public void updateConsumerApplication(OAuthConsumerAppDTO consumerAppDTO) throws IdentityOAuthAdminException {
        OAuthAppDO oauthappdo;
        for (OAuthApplicationMgtListener oAuthApplicationMgtListener : OAuthComponentServiceHolder.getInstance().getOAuthApplicationMgtListeners()) {
            oAuthApplicationMgtListener.doPreUpdateConsumerApplication(consumerAppDTO);
        }
        String errorMessage = "Error while updating the app information.";
        String oauthConsumerKey = consumerAppDTO.getOauthConsumerKey();
        if (StringUtils.isEmpty((String)oauthConsumerKey) || StringUtils.isEmpty((String)consumerAppDTO.getOauthConsumerSecret())) {
            errorMessage = "ConsumerKey or ConsumerSecret is not provided for updating the OAuth application.";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)errorMessage);
            }
            throw this.handleClientError(Error.INVALID_REQUEST, errorMessage);
        }
        String loggedInUserName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        String tenantAwareLoggedInUserName = MultitenantUtils.getTenantAwareUsername((String)loggedInUserName);
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        OAuthAppDAO dao = new OAuthAppDAO();
        try {
            oauthappdo = this.getOAuthApp(oauthConsumerKey);
            if (oauthappdo == null) {
                String msg = "OAuth application cannot be found for consumerKey: " + oauthConsumerKey;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)msg);
                }
                throw this.handleClientError(Error.INVALID_OAUTH_CLIENT, msg);
            }
            if (!StringUtils.equals((String)consumerAppDTO.getOauthConsumerSecret(), (String)oauthappdo.getOauthConsumerSecret())) {
                errorMessage = "Invalid ConsumerSecret is provided for updating the OAuth application with consumerKey: " + oauthConsumerKey;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)errorMessage);
                }
                throw this.handleClientError(Error.INVALID_REQUEST, errorMessage);
            }
        }
        catch (InvalidOAuthClientException e) {
            String msg = "Cannot find a valid OAuth client for consumerKey: " + oauthConsumerKey;
            throw this.handleClientError(Error.INVALID_OAUTH_CLIENT, msg, (Exception)((Object)e));
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error while updating the app information.", (Exception)((Object)e));
        }
        AuthenticatedUser defaultAppOwner = oauthappdo.getAppOwner();
        AuthenticatedUser appOwner = this.getAppOwner(consumerAppDTO, defaultAppOwner);
        oauthappdo.setAppOwner(appOwner);
        oauthappdo.setOauthConsumerKey(oauthConsumerKey);
        oauthappdo.setOauthConsumerSecret(consumerAppDTO.getOauthConsumerSecret());
        this.validateCallbackURI(consumerAppDTO);
        oauthappdo.setCallbackUrl(consumerAppDTO.getCallbackUrl());
        oauthappdo.setApplicationName(consumerAppDTO.getApplicationName());
        oauthappdo.setPkceMandatory(consumerAppDTO.getPkceMandatory());
        oauthappdo.setPkceSupportPlain(consumerAppDTO.getPkceSupportPlain());
        this.validateTokenExpiryConfigurations(consumerAppDTO);
        oauthappdo.setUserAccessTokenExpiryTime(consumerAppDTO.getUserAccessTokenExpiryTime());
        oauthappdo.setApplicationAccessTokenExpiryTime(consumerAppDTO.getApplicationAccessTokenExpiryTime());
        oauthappdo.setRefreshTokenExpiryTime(consumerAppDTO.getRefreshTokenExpiryTime());
        oauthappdo.setIdTokenExpiryTime(consumerAppDTO.getIdTokenExpiryTime());
        oauthappdo.setTokenType(consumerAppDTO.getTokenType());
        oauthappdo.setBypassClientCredentials(consumerAppDTO.isBypassClientCredentials());
        if ("OAuth-2.0".equals(consumerAppDTO.getOAuthVersion())) {
            this.validateGrantTypes(consumerAppDTO);
            oauthappdo.setGrantTypes(consumerAppDTO.getGrantTypes());
            oauthappdo.setAudiences(consumerAppDTO.getAudiences());
            oauthappdo.setScopeValidators(this.filterScopeValidators(consumerAppDTO));
            oauthappdo.setRequestObjectSignatureValidationEnabled(consumerAppDTO.isRequestObjectSignatureValidationEnabled());
            oauthappdo.setIdTokenEncryptionEnabled(consumerAppDTO.isIdTokenEncryptionEnabled());
            if (consumerAppDTO.isIdTokenEncryptionEnabled()) {
                oauthappdo.setIdTokenEncryptionAlgorithm(this.filterIdTokenEncryptionAlgorithm(consumerAppDTO));
                oauthappdo.setIdTokenEncryptionMethod(this.filterIdTokenEncryptionMethod(consumerAppDTO));
            }
            oauthappdo.setBackChannelLogoutUrl(consumerAppDTO.getBackChannelLogoutUrl());
            oauthappdo.setFrontchannelLogoutUrl(consumerAppDTO.getFrontchannelLogoutUrl());
            oauthappdo.setRenewRefreshTokenEnabled(consumerAppDTO.getRenewRefreshTokenEnabled());
            oauthappdo.setTokenBindingType(consumerAppDTO.getTokenBindingType());
            oauthappdo.setTokenRevocationWithIDPSessionTerminationEnabled(consumerAppDTO.isTokenRevocationWithIDPSessionTerminationEnabled());
            oauthappdo.setTokenBindingValidationEnabled(consumerAppDTO.isTokenBindingValidationEnabled());
        }
        dao.updateConsumerApplication(oauthappdo);
        AppInfoCache.getInstance().addToCache((Serializable)((Object)oauthappdo.getOauthConsumerKey()), oauthappdo);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Oauth Application update success : " + consumerAppDTO.getApplicationName() + " in tenant domain: " + tenantDomain));
        }
    }

    public String getOauthApplicationState(String consumerKey) throws IdentityOAuthAdminException {
        return this.getOAuth2Service().getOauthApplicationState(consumerKey);
    }

    @Deprecated
    public void addScope(String scope, String[] claims) throws IdentityOAuthAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            if (!StringUtils.isNotEmpty((String)scope)) {
                throw this.handleClientError(Error.INVALID_REQUEST, "The scope can not be empty.");
            }
            this.validateRegex(scope);
            OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().addScope(tenantId, scope, claims);
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error while inserting OIDC scopes and claims.", (Exception)((Object)e));
        }
    }

    public void addScope(ScopeDTO scope) throws IdentityOAuthAdminException {
        this.addScopePreValidation(scope);
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().addScope(scope, tenantId);
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleErrorWithExceptionType(String.format("Error while inserting OIDC scope: %s, %s", scope.getName(), e.getMessage()), e);
        }
    }

    public ScopeDTO[] getScopes() throws IdentityOAuthAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            List<ScopeDTO> scopeDTOList = OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().getScopes(tenantId);
            if (CollectionUtils.isNotEmpty(scopeDTOList)) {
                return scopeDTOList.toArray(new ScopeDTO[scopeDTOList.size()]);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Could not find scope claim mapping. Hence returning an empty array.");
            }
            return new ScopeDTO[0];
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error while loading OIDC scopes and claims for tenant: " + tenantId, (Exception)((Object)e));
        }
    }

    public ScopeDTO getScope(String scopeName) throws IdentityOAuthAdminException {
        this.validateScopeName(scopeName);
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            ScopeDTO scopeDTO = OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().getScope(scopeName, tenantId);
            if (scopeDTO == null) {
                throw this.handleClientError(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_NOT_FOUND_SCOPE, String.format(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_NOT_FOUND_SCOPE.getMessage(), scopeName));
            }
            return scopeDTO;
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleErrorWithExceptionType(String.format("Error while loading OIDC scope: %s for tenant %s", scopeName, tenantId), e);
        }
    }

    public void deleteScope(String scope) throws IdentityOAuthAdminException {
        this.validateScopeName(scope);
        this.validateScopeExistence(scope);
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().deleteScope(scope, tenantId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scope: " + scope + " is deleted from the database."));
            }
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleErrorWithExceptionType("Error while deleting OIDC scope: " + scope, e);
        }
    }

    public String[] getScopeNames() throws IdentityOAuthAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            List<String> scopeDTOList = OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().getScopeNames(tenantId);
            if (CollectionUtils.isNotEmpty(scopeDTOList)) {
                return scopeDTOList.toArray(new String[scopeDTOList.size()]);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Could not load oidc scopes. Hence returning an empty array.");
            }
            return new String[0];
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error while loading OIDC scopes and claims for tenant: " + tenantId, (Exception)((Object)e));
        }
    }

    public String[] getClaims(String scope) throws IdentityOAuthAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            ScopeDTO scopeDTO = OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().getClaims(scope, tenantId);
            if (scopeDTO != null && ArrayUtils.isNotEmpty((Object[])scopeDTO.getClaim())) {
                return scopeDTO.getClaim();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Could not load oidc claims. Hence returning an empty array.");
            }
            return new String[0];
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error while loading OIDC claims for the scope: " + scope + " in tenant: " + tenantId, (Exception)((Object)e));
        }
    }

    @Deprecated
    public void updateScope(String scope, String[] addClaims, String[] deleteClaims) throws IdentityOAuthAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().updateScope(scope, tenantId, Arrays.asList(addClaims), Arrays.asList(deleteClaims));
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error while updating OIDC claims for the scope: " + scope + " in tenant: " + tenantId, (Exception)((Object)e));
        }
    }

    public void updateScope(ScopeDTO updatedScope) throws IdentityOAuthAdminException {
        this.updateScopePreValidation(updatedScope);
        this.validateScopeExistence(updatedScope.getName());
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().updateScope(updatedScope, tenantId);
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleErrorWithExceptionType(String.format("Error while updating the scope: %s in tenant: %s", updatedScope.getName(), tenantId), e);
        }
    }

    public boolean isScopeExist(String scope) throws IdentityOAuthAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            return OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().isScopeExist(scope, tenantId);
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error while inserting the scopes.", (Exception)((Object)e));
        }
    }

    public void updateConsumerAppState(String consumerKey, String newState) throws IdentityOAuthAdminException {
        for (OAuthApplicationMgtListener oAuthApplicationMgtListener : OAuthComponentServiceHolder.getInstance().getOAuthApplicationMgtListeners()) {
            oAuthApplicationMgtListener.doPreUpdateConsumerApplicationState(consumerKey, newState);
        }
        try {
            OAuthAppDO oAuthAppDO = this.getOAuthApp(consumerKey);
            oAuthAppDO.setState(newState);
            Properties properties = new Properties();
            properties.setProperty("new_state", newState);
            properties.setProperty("action", "revoke");
            AppInfoCache.getInstance().clearCacheEntry((Serializable)((Object)consumerKey));
            this.updateAppAndRevokeTokensAndAuthzCodes(consumerKey, properties);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("App state is updated to:" + newState + " in the AppInfoCache for OAuth App with consumerKey: " + consumerKey));
            }
        }
        catch (InvalidOAuthClientException e) {
            String msg = "Error while updating state of OAuth app with consumerKey: " + consumerKey;
            throw this.handleClientError(Error.INVALID_OAUTH_CLIENT, msg, (Exception)((Object)e));
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error while updating state of OAuth app with consumerKey: " + consumerKey, (Exception)((Object)e));
        }
    }

    public void updateOauthSecretKey(String consumerKey) throws IdentityOAuthAdminException {
        this.updateAndRetrieveOauthSecretKey(consumerKey);
    }

    public OAuthConsumerAppDTO updateAndRetrieveOauthSecretKey(String consumerKey) throws IdentityOAuthAdminException {
        Properties properties = new Properties();
        String newSecret = OAuthUtil.getRandomNumber();
        properties.setProperty("new_secretKey", newSecret);
        properties.setProperty("action", "regenerate");
        properties.setProperty("new_state", "ACTIVE");
        AppInfoCache.getInstance().clearCacheEntry((Serializable)((Object)consumerKey));
        this.updateAppAndRevokeTokensAndAuthzCodes(consumerKey, properties);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Client Secret for OAuth app with consumerKey: " + consumerKey + " updated in OAuthCache."));
        }
        OAuthConsumerAppDTO updatedApplication = this.getOAuthApplicationData(consumerKey);
        updatedApplication.setOauthConsumerSecret(newSecret);
        return updatedApplication;
    }

    void updateAppAndRevokeTokensAndAuthzCodes(String consumerKey, Properties properties) throws IdentityOAuthAdminException {
        int countToken = 0;
        try {
            Set<AccessTokenDO> activeDetailedTokens = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getActiveAcessTokenDataByConsumerKey(consumerKey);
            String[] accessTokens = new String[activeDetailedTokens.size()];
            for (AccessTokenDO detailToken : activeDetailedTokens) {
                String token;
                accessTokens[countToken] = token = detailToken.getAccessToken();
                ++countToken;
                OAuthCacheKey cacheKeyToken = new OAuthCacheKey(token);
                OAuthCache.getInstance().clearCacheEntry(cacheKeyToken);
                String scope = OAuth2Util.buildScopeString(detailToken.getScope());
                String authorizedUser = detailToken.getAuthzUser().toString();
                String authenticatedIDP = detailToken.getAuthzUser().getFederatedIdPName();
                boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authorizedUser);
                String cacheKeyString = isUsernameCaseSensitive ? consumerKey + ":" + authorizedUser + ":" + scope + ":" + authenticatedIDP : consumerKey + ":" + authorizedUser.toLowerCase() + ":" + scope + ":" + authenticatedIDP;
                OAuthCacheKey cacheKeyUser = new OAuthCacheKey(cacheKeyString);
                OAuthCache.getInstance().clearCacheEntry(cacheKeyUser);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Access tokens and token of users are removed from the cache for OAuth App with consumerKey: " + consumerKey));
            }
            Set<String> authorizationCodes = OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().getActiveAuthorizationCodesByConsumerKey(consumerKey);
            for (String authorizationCode : authorizationCodes) {
                OAuthCacheKey cacheKey = new OAuthCacheKey(authorizationCode);
                OAuthCache.getInstance().clearCacheEntry(cacheKey);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Access tokens are removed from the cache for OAuth App with consumerKey: " + consumerKey));
            }
            OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().updateAppAndRevokeTokensAndAuthzCodes(consumerKey, properties, authorizationCodes.toArray(new String[authorizationCodes.size()]), accessTokens);
        }
        catch (IdentityApplicationManagementException | IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error in updating oauth app & revoking access tokens and authz codes for OAuth App with consumerKey: " + consumerKey, (Exception)e);
        }
    }

    public void removeOAuthApplicationData(String consumerKey) throws IdentityOAuthAdminException {
        for (OAuthApplicationMgtListener oAuthApplicationMgtListener : OAuthComponentServiceHolder.getInstance().getOAuthApplicationMgtListeners()) {
            oAuthApplicationMgtListener.doPreRemoveOAuthApplicationData(consumerKey);
        }
        OAuthAppDAO dao = new OAuthAppDAO();
        dao.removeConsumerApplication(consumerKey);
        OAuthCache.getInstance().clearCacheEntry(new OAuthCacheKey(consumerKey));
        AppInfoCache.getInstance().clearCacheEntry((Serializable)((Object)consumerKey));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Client credentials are removed from the cache for OAuth App with consumerKey: " + consumerKey));
        }
    }

    public void removeAllOAuthApplicationData(int tenantId) throws IdentityOAuthAdminException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting all OAuth Application data of the tenant: " + tenantId));
        }
        OAuthAppDAO dao = new OAuthAppDAO();
        dao.removeConsumerApplicationsByTenantId(tenantId);
    }

    public OAuthConsumerAppDTO[] getAppsAuthorizedByUser() throws IdentityOAuthAdminException {
        Set<String> clientIds;
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String tenantAwareLoggedInUserName = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        AuthenticatedUser loggedInUser = this.buildAuthenticatedUser(tenantAwareLoggedInUserName, tenantDomain);
        String username = UserCoreUtil.addTenantDomainToEntry((String)tenantAwareLoggedInUserName, (String)tenantDomain);
        String userStoreDomain = null;
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            try {
                userStoreDomain = OAuth2Util.getUserStoreForFederatedUser(loggedInUser);
            }
            catch (IdentityOAuth2Exception e) {
                String errorMsg = "Error occurred while getting user store domain for User ID : " + loggedInUser;
                throw OAuthUtil.handleError(errorMsg, (Exception)((Object)e));
            }
        }
        try {
            clientIds = OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().getAllTimeAuthorizedClientIds(loggedInUser);
        }
        catch (IdentityOAuth2Exception e) {
            String errorMsg = "Error occurred while retrieving apps authorized by User ID : " + username;
            throw OAuthUtil.handleError(errorMsg, (Exception)((Object)e));
        }
        HashSet<OAuthConsumerAppDTO> appDTOs = new HashSet<OAuthConsumerAppDTO>();
        for (String clientId : clientIds) {
            Set<AccessTokenDO> accessTokenDOs;
            try {
                accessTokenDOs = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessTokens(clientId, loggedInUser, userStoreDomain, true);
            }
            catch (IdentityOAuth2Exception e) {
                String errorMsg = "Error occurred while retrieving access tokens issued for Client ID : " + clientId + ", User ID : " + username;
                throw OAuthUtil.handleError(errorMsg, (Exception)((Object)e));
            }
            if (accessTokenDOs.isEmpty()) continue;
            HashSet<String> distinctClientUserScopeCombo = new HashSet<String>();
            for (AccessTokenDO accessTokenDO : accessTokenDOs) {
                String scopeString = OAuth2Util.buildScopeString(accessTokenDO.getScope());
                try {
                    AccessTokenDO scopedToken = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getLatestAccessToken(clientId, loggedInUser, userStoreDomain, scopeString, true);
                    if (scopedToken == null || distinctClientUserScopeCombo.contains(clientId + ":" + username)) continue;
                    OAuthAppDO appDO = this.getOAuthAppDO(scopedToken.getConsumerKey());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Found App: " + appDO.getApplicationName() + " for user: " + username));
                    }
                    appDTOs.add(OAuthUtil.buildConsumerAppDTO(appDO));
                    distinctClientUserScopeCombo.add(clientId + ":" + username);
                }
                catch (IdentityOAuth2Exception e) {
                    String errorMsg = "Error occurred while retrieving latest access token issued for Client ID : " + clientId + ", User ID : " + username + " and Scope : " + scopeString;
                    throw OAuthUtil.handleError(errorMsg, (Exception)((Object)e));
                }
            }
        }
        return appDTOs.toArray(new OAuthConsumerAppDTO[0]);
    }

    private OAuthAppDO getOAuthAppDO(String consumerKey) throws IdentityOAuthAdminException {
        OAuthAppDO appDO;
        try {
            appDO = this.getOAuthApp(consumerKey);
        }
        catch (InvalidOAuthClientException e) {
            throw this.handleClientError(Error.INVALID_OAUTH_CLIENT, "Invalid ConsumerKey: " + consumerKey, (Exception)((Object)e));
        }
        catch (IdentityOAuth2Exception e) {
            throw OAuthUtil.handleError("Error occurred while retrieving app information for Client ID : " + consumerKey, (Exception)((Object)e));
        }
        return appDO;
    }

    public OAuthRevocationResponseDTO revokeAuthzForAppsByResourceOwner(OAuthRevocationRequestDTO revokeRequestDTO) throws IdentityOAuthAdminException {
        this.triggerPreRevokeListeners(revokeRequestDTO);
        if (revokeRequestDTO.getApps() != null && revokeRequestDTO.getApps().length > 0) {
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            String tenantAwareLoggedInUserName = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
            AuthenticatedUser user = this.buildAuthenticatedUser(tenantAwareLoggedInUserName, tenantDomain);
            String userName = UserCoreUtil.addTenantDomainToEntry((String)tenantAwareLoggedInUserName, (String)tenantDomain);
            String userStoreDomain = null;
            if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
                try {
                    userStoreDomain = OAuth2Util.getUserStoreForFederatedUser(user);
                }
                catch (IdentityOAuth2Exception e) {
                    throw OAuthUtil.handleError("Error occurred while getting user store domain from User ID : " + user, (Exception)((Object)e));
                }
            }
            OAuthConsumerAppDTO[] appDTOs = this.getAppsAuthorizedByUser();
            for (String appName : revokeRequestDTO.getApps()) {
                for (OAuthConsumerAppDTO appDTO : appDTOs) {
                    Set<AccessTokenDO> accessTokenDOs;
                    if (!appDTO.getApplicationName().equals(appName)) continue;
                    try {
                        accessTokenDOs = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessTokens(appDTO.getOauthConsumerKey(), user, userStoreDomain, true);
                    }
                    catch (IdentityOAuth2Exception e) {
                        String errorMsg = "Error occurred while retrieving access tokens issued for Client ID : " + appDTO.getOauthConsumerKey() + ", User ID : " + userName;
                        throw OAuthUtil.handleError(errorMsg, (Exception)((Object)e));
                    }
                    for (AccessTokenDO accessTokenDO : accessTokenDOs) {
                        AccessTokenDO scopedToken;
                        AuthenticatedUser authzUser = accessTokenDO.getAuthzUser();
                        String tokenBindingReference = "NONE";
                        if (accessTokenDO.getTokenBinding() != null && StringUtils.isNotBlank((String)accessTokenDO.getTokenBinding().getBindingReference())) {
                            tokenBindingReference = accessTokenDO.getTokenBinding().getBindingReference();
                        }
                        OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)authzUser, OAuth2Util.buildScopeString(accessTokenDO.getScope()), tokenBindingReference);
                        OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)authzUser, OAuth2Util.buildScopeString(accessTokenDO.getScope()));
                        OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)authzUser);
                        OAuthUtil.clearOAuthCache(accessTokenDO.getAccessToken());
                        try {
                            scopedToken = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getLatestAccessToken(appDTO.getOauthConsumerKey(), user, userStoreDomain, OAuth2Util.buildScopeString(accessTokenDO.getScope()), true);
                        }
                        catch (IdentityOAuth2Exception e) {
                            String errorMsg = "Error occurred while retrieving latest access token issued for Client ID : " + appDTO.getOauthConsumerKey() + ", User ID : " + userName + " and Scope : " + OAuth2Util.buildScopeString(accessTokenDO.getScope());
                            throw OAuthUtil.handleError(errorMsg, (Exception)((Object)e));
                        }
                        if (scopedToken != null) {
                            try {
                                OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens(new String[]{scopedToken.getAccessToken()});
                            }
                            catch (IdentityOAuth2Exception e) {
                                String errorMsg = "Error occurred while revoking Access Token : " + scopedToken.getAccessToken();
                                throw OAuthUtil.handleError(errorMsg, (Exception)((Object)e));
                            }
                            try {
                                OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().revokeOAuthConsentByApplicationAndUser(authzUser.getAuthenticatedSubjectIdentifier(), tenantDomain, appName);
                            }
                            catch (IdentityOAuth2Exception e) {
                                String errorMsg = "Error occurred while removing OAuth Consent of Application: " + appName + " of user: " + userName;
                                throw OAuthUtil.handleError(errorMsg, (Exception)((Object)e));
                            }
                        }
                        this.triggerPostRevokeListeners(revokeRequestDTO, new OAuthRevocationResponseDTO(), accessTokenDOs.toArray(new AccessTokenDO[0]));
                    }
                }
            }
        } else {
            OAuthRevocationResponseDTO revokeRespDTO = new OAuthRevocationResponseDTO();
            revokeRespDTO.setError(true);
            revokeRespDTO.setErrorCode("invalid_request");
            revokeRespDTO.setErrorMsg("Invalid revocation request");
            this.triggerPostRevokeListeners(revokeRequestDTO, revokeRespDTO, new AccessTokenDO[]{null});
            return revokeRespDTO;
        }
        return new OAuthRevocationResponseDTO();
    }

    public OAuthRevocationResponseDTO updateApproveAlwaysForAppConsentByResourceOwner(String appName, String state) throws IdentityOAuthAdminException {
        OAuthRevocationResponseDTO revokeRespDTO = new OAuthRevocationResponseDTO();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String tenantAwareUserName = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        try {
            OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().updateApproveAlwaysForAppConsentByResourceOwner(tenantAwareUserName, tenantDomain, appName, state);
        }
        catch (IdentityOAuth2Exception e) {
            String errorMsg = "Error occurred while revoking OAuth Consent approve always of Application " + appName + " of user " + tenantAwareUserName;
            LOG.error((Object)errorMsg, (Throwable)((Object)e));
            revokeRespDTO.setError(true);
            revokeRespDTO.setErrorCode("invalid_request");
            revokeRespDTO.setErrorMsg("Invalid revocation request");
        }
        return revokeRespDTO;
    }

    void triggerPreRevokeListeners(OAuthRevocationRequestDTO revokeRequestDTO) throws IdentityOAuthAdminException {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            try {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                oAuthEventInterceptorProxy.onPreTokenRevocationByResourceOwner(revokeRequestDTO, paramMap);
            }
            catch (IdentityOAuth2Exception e) {
                throw OAuthUtil.handleError("Error occurred with Oauth pre-revoke listener ", (Exception)((Object)e));
            }
        }
    }

    void triggerPostRevokeListeners(OAuthRevocationRequestDTO revokeRequestDTO, OAuthRevocationResponseDTO revokeRespDTO, AccessTokenDO[] accessTokenDOs) {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        for (AccessTokenDO accessTokenDO : accessTokenDOs) {
            if (oAuthEventInterceptorProxy == null || !oAuthEventInterceptorProxy.isEnabled()) continue;
            try {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                oAuthEventInterceptorProxy.onPostTokenRevocationByResourceOwner(revokeRequestDTO, revokeRespDTO, accessTokenDO, paramMap);
            }
            catch (IdentityOAuth2Exception e) {
                LOG.error((Object)"Error occurred with post revocation listener.", (Throwable)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getAllowedGrantTypes() {
        if (allowedGrants != null) return allowedGrants.toArray(new String[allowedGrants.size()]);
        Class<OAuthAdminService> clazz = OAuthAdminService.class;
        synchronized (OAuthAdminService.class) {
            if (allowedGrants != null) return allowedGrants.toArray(new String[allowedGrants.size()]);
            Set<String> allowedGrantSet = OAuthServerConfiguration.getInstance().getSupportedGrantTypes().keySet();
            HashSet<String> modifiableGrantSet = new HashSet<String>(allowedGrantSet);
            if (this.isImplicitGrantEnabled()) {
                modifiableGrantSet.add(IMPLICIT);
            }
            allowedGrants = new ArrayList<String>(modifiableGrantSet);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return allowedGrants.toArray(new String[allowedGrants.size()]);
        }
    }

    boolean isImplicitGrantEnabled() {
        Map<String, ResponseTypeHandler> responseTypeHandlers = OAuthServerConfiguration.getInstance().getSupportedResponseTypes();
        for (String responseType : responseTypeHandlers.keySet()) {
            if (!responseType.contains(RESPONSE_TYPE_TOKEN) && !responseType.contains(RESPONSE_TYPE_ID_TOKEN)) continue;
            return true;
        }
        return false;
    }

    public String[] getAllowedScopeValidators() {
        if (allowedScopeValidators == null) {
            Set<OAuth2ScopeValidator> oAuth2ScopeValidators = OAuthServerConfiguration.getInstance().getOAuth2ScopeValidators();
            ArrayList<String> validators = new ArrayList<String>();
            for (OAuth2ScopeValidator validator : oAuth2ScopeValidators) {
                validators.add(validator.getValidatorName());
            }
            allowedScopeValidators = validators.toArray(new String[validators.size()]);
        }
        return allowedScopeValidators;
    }

    public List<String> getSupportedTokenTypes() {
        return OAuthServerConfiguration.getInstance().getSupportedTokenTypes();
    }

    public String getDefaultTokenType() {
        return "Default";
    }

    public boolean isRefreshTokenRenewalEnabled() {
        return OAuthServerConfiguration.getInstance().isRefreshTokenRenewalEnabled();
    }

    public boolean isPKCESupportEnabled() {
        return OAuth2Util.isPKCESupportEnabled();
    }

    public List<TokenBindingMetaDataDTO> getSupportedTokenBindingsMetaData() {
        return OAuthComponentServiceHolder.getInstance().getTokenBindingMetaDataDTOs();
    }

    public OAuthTokenExpiryTimeDTO getTokenExpiryTimes() {
        OAuthTokenExpiryTimeDTO tokenExpiryTime = new OAuthTokenExpiryTimeDTO();
        tokenExpiryTime.setUserAccessTokenExpiryTime(OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds());
        tokenExpiryTime.setApplicationAccessTokenExpiryTime(OAuthServerConfiguration.getInstance().getApplicationAccessTokenValidityPeriodInSeconds());
        tokenExpiryTime.setRefreshTokenExpiryTime(OAuthServerConfiguration.getInstance().getRefreshTokenValidityPeriodInSeconds());
        tokenExpiryTime.setIdTokenExpiryTime(OAuthServerConfiguration.getInstance().getOpenIDConnectIDTokenExpiryTimeInSeconds());
        return tokenExpiryTime;
    }

    AuthenticatedUser buildAuthenticatedUser(String tenantAwareUser, String tenantDomain) {
        AuthenticatedUser user = new AuthenticatedUser();
        user.setUserName(UserCoreUtil.removeDomainFromName((String)tenantAwareUser));
        user.setTenantDomain(tenantDomain);
        user.setUserStoreDomain(IdentityUtil.extractDomainFromName((String)tenantAwareUser));
        return user;
    }

    void validateTokenExpiryConfigurations(OAuthConsumerAppDTO oAuthConsumerAppDTO) {
        if (oAuthConsumerAppDTO.getUserAccessTokenExpiryTime() == 0L) {
            oAuthConsumerAppDTO.setUserAccessTokenExpiryTime(OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds());
            this.logOnInvalidConfig(oAuthConsumerAppDTO.getApplicationName(), "user access token", oAuthConsumerAppDTO.getUserAccessTokenExpiryTime());
        }
        if (oAuthConsumerAppDTO.getApplicationAccessTokenExpiryTime() == 0L) {
            oAuthConsumerAppDTO.setApplicationAccessTokenExpiryTime(OAuthServerConfiguration.getInstance().getApplicationAccessTokenValidityPeriodInSeconds());
            this.logOnInvalidConfig(oAuthConsumerAppDTO.getApplicationName(), "application access token", oAuthConsumerAppDTO.getApplicationAccessTokenExpiryTime());
        }
        if (oAuthConsumerAppDTO.getRefreshTokenExpiryTime() == 0L) {
            oAuthConsumerAppDTO.setRefreshTokenExpiryTime(OAuthServerConfiguration.getInstance().getRefreshTokenValidityPeriodInSeconds());
            this.logOnInvalidConfig(oAuthConsumerAppDTO.getApplicationName(), "refresh token", oAuthConsumerAppDTO.getRefreshTokenExpiryTime());
        }
        if (oAuthConsumerAppDTO.getIdTokenExpiryTime() == 0L) {
            oAuthConsumerAppDTO.setIdTokenExpiryTime(OAuthServerConfiguration.getInstance().getOpenIDConnectIDTokenExpiryTimeInSeconds());
            this.logOnInvalidConfig(oAuthConsumerAppDTO.getApplicationName(), "id token", oAuthConsumerAppDTO.getIdTokenExpiryTime());
        }
    }

    void logOnInvalidConfig(String appName, String tokenType, long defaultValue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Invalid expiry time value '0' set for token type: " + tokenType + " in ServiceProvider: " + appName + ". Defaulting to expiry value: " + defaultValue + " seconds."));
        }
    }

    String[] filterScopeValidators(OAuthConsumerAppDTO application) throws IdentityOAuthAdminException {
        ArrayList<String> scopeValidators = new ArrayList<String>(Arrays.asList(this.getAllowedScopeValidators()));
        String[] requestedScopeValidators = application.getScopeValidators();
        if (requestedScopeValidators == null) {
            requestedScopeValidators = new String[]{};
        }
        for (String requestedScopeValidator : requestedScopeValidators) {
            if (scopeValidators.contains(requestedScopeValidator)) continue;
            String msg = String.format("'%s' scope validator is not allowed.", requestedScopeValidator);
            throw this.handleClientError(Error.INVALID_REQUEST, msg);
        }
        return requestedScopeValidators;
    }

    private String filterIdTokenEncryptionMethod(OAuthConsumerAppDTO application) throws IdentityOAuthAdminException {
        String idTokenEncryptionMethod;
        List<String> supportedIdTokenEncryptionMethods = OAuthServerConfiguration.getInstance().getSupportedIdTokenEncryptionMethods();
        if (!supportedIdTokenEncryptionMethods.contains(idTokenEncryptionMethod = application.getIdTokenEncryptionMethod())) {
            String msg = String.format("'%s' IdToken Encryption Method is not allowed.", idTokenEncryptionMethod);
            throw this.handleClientError(Error.INVALID_REQUEST, msg);
        }
        return idTokenEncryptionMethod;
    }

    private String filterIdTokenEncryptionAlgorithm(OAuthConsumerAppDTO application) throws IdentityOAuthAdminException {
        String idTokenEncryptionAlgorithm;
        List<String> supportedIdTokenEncryptionAlgorithms = OAuthServerConfiguration.getInstance().getSupportedIdTokenEncryptionAlgorithm();
        if (!supportedIdTokenEncryptionAlgorithms.contains(idTokenEncryptionAlgorithm = application.getIdTokenEncryptionAlgorithm())) {
            String msg = String.format("'%s' IdToken Encryption Method is not allowed.", idTokenEncryptionAlgorithm);
            throw this.handleClientError(Error.INVALID_REQUEST, msg);
        }
        return idTokenEncryptionAlgorithm;
    }

    public OAuthIDTokenAlgorithmDTO getSupportedIDTokenAlgorithms() {
        OAuthIDTokenAlgorithmDTO oAuthIDTokenAlgorithmDTO = new OAuthIDTokenAlgorithmDTO();
        oAuthIDTokenAlgorithmDTO.setDefaultIdTokenEncryptionAlgorithm(OAuthServerConfiguration.getInstance().getDefaultIdTokenEncryptionAlgorithm());
        oAuthIDTokenAlgorithmDTO.setDefaultIdTokenEncryptionMethod(OAuthServerConfiguration.getInstance().getDefaultIdTokenEncryptionMethod());
        oAuthIDTokenAlgorithmDTO.setSupportedIdTokenEncryptionAlgorithms(OAuthServerConfiguration.getInstance().getSupportedIdTokenEncryptionAlgorithm());
        oAuthIDTokenAlgorithmDTO.setSupportedIdTokenEncryptionMethods(OAuthServerConfiguration.getInstance().getSupportedIdTokenEncryptionMethods());
        return oAuthIDTokenAlgorithmDTO;
    }

    public boolean isHashDisabled() {
        return OAuth2Util.isHashDisabled();
    }

    AuthenticatedUser getAppOwner(OAuthConsumerAppDTO application, AuthenticatedUser defaultAppOwner) throws IdentityOAuthAdminException {
        AuthenticatedUser appOwner = defaultAppOwner;
        String applicationOwnerInRequest = application.getUsername();
        if (StringUtils.isNotBlank((String)applicationOwnerInRequest)) {
            String tenantAwareAppOwnerInRequest = MultitenantUtils.getTenantAwareUsername((String)applicationOwnerInRequest);
            try {
                if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager().isExistingUser(tenantAwareAppOwnerInRequest)) {
                    String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                    appOwner = this.buildAuthenticatedUser(tenantAwareAppOwnerInRequest, tenantDomain);
                } else {
                    LOG.warn((Object)("OAuth application owner user name " + applicationOwnerInRequest + " does not exist in the user store. Using user: " + defaultAppOwner.toFullQualifiedUsername() + " as app owner."));
                }
            }
            catch (UserStoreException e) {
                throw OAuthUtil.handleError("Error while retrieving the user store manager for user: " + applicationOwnerInRequest, (Exception)((Object)e));
            }
        }
        return appOwner;
    }

    OAuth2Service getOAuth2Service() {
        return OAuthComponentServiceHolder.getInstance().getOauth2Service();
    }

    OAuthAppDO getOAuthApp(String consumerKey) throws InvalidOAuthClientException, IdentityOAuth2Exception {
        OAuthAppDO oauthApp = (OAuthAppDO)AppInfoCache.getInstance().getValueFromCache((Serializable)((Object)consumerKey));
        if (oauthApp != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OAuth app with consumerKey: " + consumerKey + " retrieved from AppInfoCache."));
            }
            return oauthApp;
        }
        OAuthAppDAO dao = new OAuthAppDAO();
        oauthApp = dao.getAppInformation(consumerKey);
        if (oauthApp != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OAuth app with consumerKey: " + consumerKey + " retrieved from database."));
            }
            AppInfoCache.getInstance().addToCache((Serializable)((Object)consumerKey), oauthApp);
        }
        return oauthApp;
    }

    private void addScopePreValidation(ScopeDTO scope) throws IdentityOAuthClientException {
        this.validateScopeName(scope.getName());
        this.validateRegex(scope.getName());
        this.validateDisplayName(scope.getDisplayName());
    }

    private void updateScopePreValidation(ScopeDTO updatedScope) throws IdentityOAuthClientException {
        this.validateScopeName(updatedScope.getName());
        this.validateDisplayName(updatedScope.getDisplayName());
    }

    private void validateScopeName(String scopeName) throws IdentityOAuthClientException {
        if (StringUtils.isBlank((String)scopeName)) {
            throw this.handleClientError(Error.INVALID_REQUEST, Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_BAD_REQUEST_SCOPE_NAME_NOT_SPECIFIED.getMessage());
        }
        this.validateWhiteSpaces(scopeName);
    }

    private void validateRegex(String scopeName) throws IdentityOAuthClientException {
        Pattern regexPattern = Pattern.compile(SCOPE_VALIDATION_REGEX);
        if (!regexPattern.matcher(scopeName).matches()) {
            String message = "Invalid scope name. Scope name : " + scopeName + " cannot contain special characters ?,#,/,( or )";
            throw this.handleClientError(Error.INVALID_REQUEST, message);
        }
    }

    private void validateWhiteSpaces(String scopeName) throws IdentityOAuthClientException {
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(scopeName);
        boolean foundWhiteSpace = matcher.find();
        if (foundWhiteSpace) {
            throw this.handleClientError(Error.INVALID_REQUEST, String.format(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_BAD_REQUEST_SCOPE_NAME_CONTAINS_WHITESPACES.getMessage(), scopeName));
        }
    }

    private void validateDisplayName(String displayName) throws IdentityOAuthClientException {
        if (StringUtils.isBlank((String)displayName)) {
            throw this.handleClientError(Error.INVALID_REQUEST, Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_BAD_REQUEST_SCOPE_DISPLAY_NAME_NOT_SPECIFIED.getMessage());
        }
    }

    private void validateScopeExistence(String scopeName) throws IdentityOAuthAdminException {
        boolean isScopeExists = this.isScopeExist(scopeName);
        if (!isScopeExists) {
            throw this.handleClientError(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_NOT_FOUND_SCOPE, String.format(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_NOT_FOUND_SCOPE.getMessage(), scopeName));
        }
    }
}

