/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.IdentityOAuthClientException;
import org.wso2.carbon.identity.oauth.OAuthAdminServiceImpl;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.identity.oauth.dto.OAuthIDTokenAlgorithmDTO;
import org.wso2.carbon.identity.oauth.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth.dto.OAuthRevocationResponseDTO;
import org.wso2.carbon.identity.oauth.dto.OAuthTokenExpiryTimeDTO;
import org.wso2.carbon.identity.oauth.dto.ScopeDTO;
import org.wso2.carbon.identity.oauth.dto.TokenBindingMetaDataDTO;

public class OAuthAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(OAuthAdminService.class);
    protected final OAuthAdminServiceImpl oAuthAdminServiceImpl = new OAuthAdminServiceImpl();

    public String[] registerOAuthConsumer() throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.registerOAuthConsumer();
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public OAuthConsumerAppDTO[] getAllOAuthApplicationData() throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.getAllOAuthApplicationData();
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public OAuthConsumerAppDTO getOAuthApplicationData(String consumerKey) throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.getOAuthApplicationData(consumerKey);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public OAuthConsumerAppDTO getOAuthApplicationDataByAppName(String appName) throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.getOAuthApplicationDataByAppName(appName);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public void registerOAuthApplicationData(OAuthConsumerAppDTO application) throws IdentityOAuthAdminException {
        try {
            this.oAuthAdminServiceImpl.registerOAuthApplicationData(application);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public OAuthConsumerAppDTO registerAndRetrieveOAuthApplicationData(OAuthConsumerAppDTO application) throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.registerAndRetrieveOAuthApplicationData(application);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public void updateConsumerApplication(OAuthConsumerAppDTO consumerAppDTO) throws IdentityOAuthAdminException {
        try {
            this.oAuthAdminServiceImpl.updateConsumerApplication(consumerAppDTO);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public String getOauthApplicationState(String consumerKey) throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.getOauthApplicationState(consumerKey);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public void addScope(String scope, String[] claims) throws IdentityOAuthAdminException {
        try {
            this.oAuthAdminServiceImpl.addScope(scope, claims);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public ScopeDTO[] getScopes() throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.getScopes();
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public void deleteScope(String scope) throws IdentityOAuthAdminException {
        try {
            this.oAuthAdminServiceImpl.deleteScope(scope);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public String[] getScopeNames() throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.getScopeNames();
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public String[] getClaims(String scope) throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.getClaims(scope);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public void updateScope(String scope, String[] addClaims, String[] deleteClaims) throws IdentityOAuthAdminException {
        try {
            this.oAuthAdminServiceImpl.updateScope(scope, addClaims, deleteClaims);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public boolean isScopeExist(String scope) throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.isScopeExist(scope);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public void updateConsumerAppState(String consumerKey, String newState) throws IdentityOAuthAdminException {
        try {
            this.oAuthAdminServiceImpl.updateConsumerAppState(consumerKey, newState);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public void updateOauthSecretKey(String consumerKey) throws IdentityOAuthAdminException {
        try {
            this.oAuthAdminServiceImpl.updateOauthSecretKey(consumerKey);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public OAuthConsumerAppDTO updateAndRetrieveOauthSecretKey(String consumerKey) throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.updateAndRetrieveOauthSecretKey(consumerKey);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public void removeOAuthApplicationData(String consumerKey) throws IdentityOAuthAdminException {
        try {
            this.oAuthAdminServiceImpl.removeOAuthApplicationData(consumerKey);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public OAuthConsumerAppDTO[] getAppsAuthorizedByUser() throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.getAppsAuthorizedByUser();
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public OAuthRevocationResponseDTO revokeAuthzForAppsByResoureOwner(OAuthRevocationRequestDTO revokeRequestDTO) throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.revokeAuthzForAppsByResourceOwner(revokeRequestDTO);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public OAuthRevocationResponseDTO updateApproveAlwaysForAppConsentByResourceOwner(String appName, String state) throws IdentityOAuthAdminException {
        try {
            return this.oAuthAdminServiceImpl.updateApproveAlwaysForAppConsentByResourceOwner(appName, state);
        }
        catch (IdentityOAuthAdminException ex) {
            throw this.handleError(ex);
        }
    }

    public String[] getAllowedGrantTypes() {
        return this.oAuthAdminServiceImpl.getAllowedGrantTypes();
    }

    public String[] getAllowedScopeValidators() {
        return this.oAuthAdminServiceImpl.getAllowedScopeValidators();
    }

    public List<String> getSupportedTokenTypes() {
        return this.oAuthAdminServiceImpl.getSupportedTokenTypes();
    }

    public boolean isRefreshTokenRenewalEnabled() {
        return this.oAuthAdminServiceImpl.isRefreshTokenRenewalEnabled();
    }

    public boolean isPKCESupportEnabled() {
        return this.oAuthAdminServiceImpl.isPKCESupportEnabled();
    }

    public OAuthTokenExpiryTimeDTO getTokenExpiryTimes() {
        return this.oAuthAdminServiceImpl.getTokenExpiryTimes();
    }

    public List<TokenBindingMetaDataDTO> getSupportedTokenBindingsMetaData() {
        return this.oAuthAdminServiceImpl.getSupportedTokenBindingsMetaData();
    }

    public OAuthIDTokenAlgorithmDTO getSupportedIDTokenAlgorithms() {
        return this.oAuthAdminServiceImpl.getSupportedIDTokenAlgorithms();
    }

    public boolean isHashDisabled() {
        return this.oAuthAdminServiceImpl.isHashDisabled();
    }

    private IdentityOAuthAdminException handleError(IdentityOAuthAdminException ex) {
        if (ex instanceof IdentityOAuthClientException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)ex);
            }
        } else {
            log.error((Object)ex);
        }
        return ex;
    }
}

